// hottopics.js
// NLS_CHARSET=UTF-8
//
// (C) Copyright IBM Corporation, 2003, 2005                        //
// All rights reserved. Licensed Materials Property of IBM          //
// US Government Users Restricted Rights                            //
// Use, duplication or disclosure restricted by                     //
// GSA ADP Schedule Contract with IBM Corp.                         //

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// define simple object.
function hotTopic() {
	args=hotTopic.arguments;
	this.text = args[0];
	this.stext = args[1] || "intentionally blank";
	this.url = args[2] || "";

   this.getText = getText;
   this.getBlurb = getBlurb;
   this.getURL = getURL;
}

function getText() {
	return this.text;
}
function getBlurb(){
	return this.stext;
}
function getURL(){
	return this.url;
}
//
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// redefine the 'push' function for all browsers.
//if (Array.prototype.push && ([0].push(true)==true))
//        Array.prototype.push = null;

if(!Array.prototype.push) {
    function array_push() {
        for(i=0;i<arguments.length;i++){
            this[this.length] = arguments[i];
        }
        return this.length;
    }

    Array.prototype.push = array_push;

}
//
//////////////////////////////////////////////////////////////////////
//END NON-TRANSLATABLE

//////////////////////////////////////////////////////////////////////
// initialize an array of objects.
var quotes = new Array;
//START QUOTE TRANSLATABLE 1 2
quotes.push(new hotTopic("ガイド付きセットアップ・ウィザードを使用してハードウェア管理コンソールを構成することができます。", "ガイド付きセットアップ・ウィザードを使用した HMC の構成", "./iphai/confighmcgs.htm"));
quotes.push(new hotTopic("お客様の要件にあわせてカスタマイズされた、サーバーのセットアップ・チェックリストを作成することができます。", "カスタマイズされたサーバーの初期セットアップ・チェックリストの作成", "./iphaf/issintwelcome.htm"));
quotes.push(new hotTopic("ご使用のサーバーまたは拡張装置に各種のハードウェア・フィーチャーを取り付けたり、多くのパーツを取り替えることができます。", "フィーチャーの取り付け", "./iphaj/installcifcio.htm"));
quotes.push(new hotTopic("読みやすい図表を使用して、eServer ハードウェア Information Center で現在提供されている pSeries 資料を検索することができます。", "Information Center への pSeries ブックのマップ", "./icpserieslist.htm"));
quotes.push(new hotTopic("ツールバーを使用してナビゲーションのカスタマイズ、言語の変更、その他のことが行えます。", "ツールバーの使用方法", "./icfaq.htm#usetoolbar"));
quotes.push(new hotTopic("特定のページにブックマークを付けることができます。", "ブックマーク付け", "./ichelp.htm#bookmark"));
quotes.push(new hotTopic("ナビゲーション追跡を使用してサイト内の位置を確認することができます。", "ナビゲーション追跡", "./icfaq.htm#navtrail"));
quotes.push(new hotTopic("ご使用のオペレーティング・システム用に Information Center がサポートするブラウザーおよび J2RE を調べることができます。", "サポートされる環境", "./ichelp.htm#browser"));
quotes.push(new hotTopic("各主要トピックとそのサブトピックを印刷することができます。", "印刷", "./ichelp.htm#print"));
//END QUOTE TRANSLATABLE
// end array of objects
//////////////////////////////////////////////////////////////////////

//START QUOTE TRANSLATABLE
var strDidYouKnowHeader = "<H2>ご存じでしたか?</H2>";
var sDidYouKnow = "&nbsp;&nbsp;ご存じでしたか?";
var sSeeAllTips = "すべてのヒントを参照する";
//END QUOTE TRANSLATABLE

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// begin execution path
var HTid=top.getHTvalue(quotes);
// end execution path
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// suport functions
//////////////////////////////////////////////////////////////////////
// functions to create formatted strings and write to document.
function getHotTopic(){
	result = '<A class="fbox" href="'+quotes[HTid].getURL()+'" target="text">'+quotes[HTid].getText()+'</A>';
	return result;
}
function getHotTopic2(){
	result = '<A class="fbox" href="'+quotes[HTid].getURL()+'" target="text"><IMG src="./images/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""/></A>';
	return result;

}
function getHotTopic3(){
	result = '<A class="fbox" href="'+quotes[HTid].getURL()+'" target="text">'+quotes[HTid].getBlurb()+'</A>';
	return result;

}
function dumpHotTopics(){
	document.writeln(strDidYouKnowHeader);
	document.writeln('<BLOCKQUOTE>');
	for ( ht in quotes ) {
		result = '<P class="hilightbarlink" style="width: 100%;"><A href="'+quotes[ht].url+'" target="text">'+quotes[ht].stext+'</A></P>';
		result += '<P>'+quotes[ht].text+'</P>';
		document.writeln(result);
	}
	document.writeln('</BLOCKQUOTE>');
}
//////////////////////////////////////////////////////////////////////
// This hideous function is a work around for Netscape 4.x.  The function 
// creates the WHOLE callout box. Since, we cannot call a function from within
// a TD in Netscape 4.x, we cannot do the getHotTopic() calls in a callout box
// within the HTML.  That would result in an empty callout box. So we have a
// 'parent' function call in the HTML that creates the whole callout box.
// This function is not executed in Netscape 4.x, so there is no empty calloutbox.  QED.
function doDidYouKnow(){
var result='<TABLE width="150px" border="0" cellspacing="0" cellpadding="0">';
	result+=' <TR><TD height="18" class="tblue">'+sDidYouKnow+'</TD></TR>';
	result+='</TABLE>';
	result+='<TABLE cellspacing="0" cellpadding="0" border="0" width="150px">';
	result+=' <TR><TD valign="top" class="tblue">';
	result+=' <TABLE cellspacing="1px" cellpadding="0px" border="0px" width="150px">';
	result+='  <TR><TD>';
	result+='    <TABLE width="100%" border="0px" cellspacing="0px" cellpadding="5px">';
	result+='     <TR valign="middle" align="left">';
	result+='      <TD height="100px" bgcolor="#FFFFFF">';
	result+=getHotTopic();
	result+='      </TD></TR></TABLE></TD></TR>';
	result+='   <TR bgcolor="#FFFFFF"><TD>';
	result+='     <TABLE width="100%" border="0" cellspacing="0" cellpadding="0">';
	result+='      <TR colspan="3">';
	result+='       <TD colspan="3" valign="top" align="right"><IMG src="./images/c.gif" width="1" height="6" alt=""></TD>';
	result+='      </TR>';
	result+='      <TR colspan="3">';
	result+='       <TD width="20" valign="top" align="right">';
	result+=getHotTopic2();
	result+='       </TD><TD width="3">&nbsp;</TD><TD width="127">';
	result+=getHotTopic3();
	result+='       </TD></TR>';
	result+='      <TR colspan="3">';
	result+='       <TD width="20" valign="top" align="right"><A href="./hottopics.htm"><IMG src="./images/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""></A></TD>';
	result+='       <TD width="3">&nbsp;</TD>';
	result+='       <TD width="127"><A href="./hottopics.htm" target="text" class="fbox">'+sSeeAllTips+'</A></TD>';
	result+='      </TR><TR colspan="3"><TD colspan="3" valign="top" align="right"><IMG src="./images/c.gif" width="1" height="6" alt=""></TD>';
	result+='      </TR></TABLE></TD></TR></TABLE></TD></TR></TABLE>';

	document.open();
	document.write(result);
	document.close();

}

//END NON-TRANSLATABLE

