// synch.js
// NLS_CHARSET=UTF-8

// (C) Copyright IBM Corporation, 2002, 2005                              
// All rights reserved. Licensed Materials Property of IBM          
// US Government Users Restricted Rights                            
// Use, duplication or disclosure restricted by                     
// GSA ADP Schedule Contract with IBM Corp.                         

// This is the synchronization file for the Information Center
// This file contains code that needs to be executed once for 
// each content page that is loaded:
// * it looks for a specific frameset to verify that the pages aren't being 'framed' by someone else.
// * if the page needs to be 'reframed' within our frameset, it calls the appropriate index file.
// * calls the functions to update the navapplet, breadcrumbs, and Confidential division
// * has onLoad handler code to identify links to PDF books and redefine their onClick events.
//

/* TRNOTE - BEGIN TRANSLATABLE TEXT.  */
// the following text is used to dynamically display the "IBM Confidential" message on the pages before the content it made available to customers.  Once the content is generally available, this message is no longer displayed.
var DOMCreateDivDefault='<div ALIGN="right" id="waterMark" style="Z-INDEX: 20; POSITION: absolute; Right: 20px; Top: 0px; visibility: visible; width: 80%;" title="IBM Confidential Watermark"><font color="#999999" size="+2"><strong>IBM Confidential<\/strong><\/font><\/div>';
var DOMCreateDivBlank='<div ALIGN="right" id="waterMark" style="Z-INDEX: 20; POSITION: absolute; Right: 1px; Top: 0px; width: 0px;" visibility: visible; title="IBM Watermark"><\/div>';

var DOMDivisionStringBase='<font color="#999999" size="+1"><strong>IBM Confidential<\/strong><\/font><BR>';
var DOMDivisionStringAddn1='<font color="#999999" size="-2">最終変更日時 ';
var DOMDivisionStringAddn2='<\/font>';

var NS4DivisionString="<table width=\"100%\"><tr align=\"right\"><td><font color=\"#999999\" size=\"+1\"><strong>IBM Confidential<\/strong><\/font><\/td><\/tr><\/table>";

// the following text is used to dynamically display the "IBM Disclaimer" message on certain pages that are made available to customers as product preview.
var sPreviewDOMDivisionStringDeclare='<div ALIGN="left" id="disclaimer" style="border: 1px; border: double; Z-INDEX: 20; POSITION: relative; Left: 0px; Top: 0px; margin: 10px; padding: 10px; visibility: visible;" title="IBM Disclaimer Watermark"><span font-size: 1.0 em; font-weight: bold;">以下の情報はテクノロジー・プレビューとして提供されます。IBM はこのテクノロジー・プレビューに対するサポートは提供しません。また、IBM が将来の製品リリースの可能性を保障するものでもありません。一般出荷開始日、価格、オーダー情報、および契約条件は、製品の発表時に提供されます。 <\/span><\/div>';
var sPreviewNS4DivisionStringDeclare="<table width=\"95%\" cellpadding=\"10px\" border=\"1\"><tr align=\"left\"><td border=\"1\" ><font color=\"#000000\"><strong>以下の情報はテクノロジー・プレビューとして提供されます。IBM はこのテクノロジー・プレビューに対するサポートは提供しません。また、IBM が将来の製品リリースの可能性を保障するものでもありません。一般出荷開始日、価格、オーダー情報、および契約条件は、製品の発表時に提供されます。 <\/strong><\/font><\/td><\/tr><\/table>";

// the following text is used to dynamically display the "IBM Disclaimer" message on certain pages that are for authorized service providers.
var sProviderDOMDivisionStringDeclare='<div ALIGN="left" id="disclaimer" style="border: 1px; border: double; Z-INDEX: 20; POSITION: relative; Left: 0px; Top: 0px; margin: 10px; padding: 10px; visibility: visible;" title="IBM Disclaimer Watermark"><span font-size: 1.0 em; font-weight: bold;">サービス・プロバイダー用<\/span><\/div>';
var sProviderNS4DivisionStringDeclare="<table width=\"95%\" cellpadding=\"10px\" border=\"1\"><tr align=\"left\"><td border=\"1\" ><font color=\"#000000\"><strong>For サービス・プロバイダー用<\/strong><\/font><\/td><\/tr><\/table>";


// the following text is used to dynamically display the "English might be more recent" message on certain pages for NLVs.
var sPreNLGADOMDivisionStringDeclare='<div ALIGN="left" id="disclaimer" style="border: 1px; border: double; Z-INDEX: 20; POSITION: relative; Left: 0px; Top: 0px; margin: 10px; padding: 10px; visibility: visible;" title="IBM Disclaimer Watermark"><span font-size: 1.0 em; font-weight: bold;">この情報は更新され、現在翻訳中です。現時点では、 <a href="null.htm" target="_top">更新情報 (英語)<\/a> を参照してください。 <\/span><\/div>';
var sPreNLGANS4DivisionStringDeclare="<table width=\"95%\" cellpadding=\"10px\" border=\"1\"><tr align=\"left\"><td border=\"1\" ><font color=\"#000000\"><strong> この情報は更新され、現在翻訳中です。現時点では、 <a href=\"null.htm\" target=\"_top\">更新情報 (英語)<\/a> を参照してください。 <\/strong><\/font><\/td><\/tr><\/table>";

/* TRNOTE - END TRANSLATABLE TEXT */

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// begin code execution path
//////////////////////////////////////////////////////////////////////
//The following if statement is included for pages which already have an onload
//handler. Most of these pages are interactive information. The onload functions
//of the article take precedence over the onload here.
//8/20/03--added the condition for the 'results' name--Nik Coates
//9/24/03--added code to handle previously existing onload handlers and that allowed the initial conditons to be simplified--Darel Benysh
//if ( (top.isIE && window.document.body.onload == null) || 
//     (top.isNS && window.onload == null) ||
//      (top.name == 'results') )
//{
// window.onload=defineEvents;
//}
var arrayOnloads = new Array();

if (window.onload == null) {
 if (top.dump)
  top.dump("synch.js: defining global onload event.")
 window.onload=defineEvents;
} else {
 if (top.dump)
  top.dump("synch.js: onload event ALREADY DEFINED! Do array onload method.")
 if (window.onload != doOnloads) {
      arrayOnloads[0] = window.onload;
      window.onload = doOnloads;
   }
   arrayOnloads[arrayOnloads.length] = defineEvents; 
}

//This block makes sure that we are in the IC frameset
//if not, we replace wherever we are with the IC frameset, passing in the "real location"
//8/15/03--added the condition for the 'results' name--Nik Coates
//9/24/04--added special dynamic page additions and excluded the 'results' frame from that branch -- dvb
if (!(top.bannerFrame && top.navFrame && top.hidden && top.text) &&
	!(top.bannerFrame && top.accNav && top.hidden && top.text) &&
       (top.name != 'results') ){
	
	//document.images is a funky way to test if the browser supports the replace() function.
	//If a browser supports document.images, it supports the replace() function.
	//We'd rather use the replace() function, because that doesn't mess up the Back button.
	//  "real location" is the index.htm file with the relative path name of this html file
	//  concatinated as a ? parameter.  It used to be easier to calculate, but with the 
	//  subdirectories, I thought I'd better write a function for it instead.
	if (document.images) { 
		top.location.replace(getRealLocation());
	} else {
		top.location.href = getRealLocation();
	}
} else if (top.name == 'results') {
	// on the search results page
	// don't do anything special here yet.


} else { 
	// we are in the frameset, so continue processing
	////////////////////////////////////////////////////
	// dynamic page additions
	//if (top.isPreGA) addIBMConfidential();

	// To add technology preview, change following condition to match on package directory string.
	// e.g. if (location.pathname.indexOf("/iphbi/") != -1 || location.pathname.indexOf("/iphbk/") != -1 || location.pathname.indexOf("/iphaz/") != -1 || location.pathname.indexOf("/iphay/") != -1)
	var dateCutoff = new Date(2004, 6, 11, 1, 0, 0, 0);
	var dateThis = new Date(document.lastModified);
	top.dump("synch.js:\tdateCutoff =\t"+dateCutoff+"\n\t\tdateThis =\t"+dateThis);
	// if not running on the HMC or on default CD installed location and if this doc last mod date is before the cutoff date
if (true) addIBMpreNLGA();

	if (false)
	    addIBMDisclaimer();
	else if (location.pathname.indexOf("/iphau/") != -1)
		addIBMServiceDisclaimer();
	else addBlankDiv();	 // this function is a safety net for pages that call synch outside of the <BODY> tag.

}
//////////////////////////////////////////////////////////////////////
// end code execution path
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// supporting functions
//////////////////////////////////////////////////////////////////////
function getRealLocation() {
	//this function needs to return the index.htm file name followed by a '?' which denotes
	//the "search" parameters.  Then it concatinates index.htm? with the relative path to this
	//content file.
	realLocation = location.protocol + "//" + location.host;
	realLocationSAV = realLocation;
	realArray = location.pathname.split("/");

	for (i = 0; i < realArray.length; i++) {
		if (realArray[i] == "info") {
			for (j = 0; j < i; j++) realLocation = realLocation + realArray[j] + "/";
			realLocation = realLocation + "index.htm?";
			for (j = i; j < realArray.length - 1; j++) realLocation = realLocation+realArray[j]+"/";
			realLocation = realLocation + realArray[realArray.length - 1];
			i = realArray.length;
		}
	}
	//if realLocation is the same as we started with-- we are probably using the file 
	//protocol in internet explorer, so split the pathname using the "\" character instead
	if (realLocation == realLocationSAV) {
		realArray = location.pathname.split("\\");

		for (i = 0; i < realArray.length; i++) {
			if (realArray[i] == "info") {
				for (j = 0; j < i; j++) realLocation = realLocation + realArray[j] + "/";
				realLocation = realLocation + "index.htm?";
				for (j = i; j < realArray.length - 1; j++) realLocation = realLocation+realArray[j]+"/";
				realLocation = realLocation + realArray[realArray.length - 1];
				i = realArray.length;
			}
		}
	}
	return realLocation;
}

function getFileToFind() {
	//This is similar to the function above, but it only returns the relative path to 
	//this content file.  This function is also called by index.htm.
	realFile = "";
	realArray = location.pathname.split("/");
	
	for (i = 0; i < realArray.length; i++) {
		if (realArray[i] == "info") {
			for (j = i+1; j < realArray.length - 1; j++) realFile = realFile+realArray[j]+"/";
			realFile = realFile + realArray[realArray.length - 1];
			i = realArray.length;
		}
	}
	//if realFile is the empty string -- we are probably using the file 
	//protocol in internet explorer, so split the pathname using the "\" character instead
	if (realFile == "") {
	    realArray = location.pathname.split("\\");
	    for (i = 0; i < realArray.length; i++) {
		if (realArray[i] == "info") {
		    for (j = i+1; j < realArray.length - 1; j++) realFile = realFile+realArray[j]+"/";
		    realFile = realFile + realArray[realArray.length - 1];
		    i = realArray.length;
		}
	    }
		
        }
	return realFile;
}


function addIBMConfidential(){
	if (this.bNestedFrames) return;
	if (this.document){
		if (document.getElementById){
			// create div
			this.document.write(DOMCreateDivDefault.substr(0));
			this.document.close();

			// add content to div
			var dynString=DOMDivisionStringBase;
			dynString+=DOMDivisionStringAddn1+document.lastModified+DOMDivisionStringAddn2;
			writeIt(dynString, 'waterMark');
		}else{
			this.document.open();
			this.document.write(NS4DivisionString);
			this.document.close();
		}
	}
}
function addBlankDiv(){
	if (this.bNestedFrames) return;
	if (this.document){
		if (document.getElementById){
			//create div
			this.document.write(DOMCreateDivBlank.substr(0));
			this.document.close();

			// add nothing to div
			var dynString="";
			writeIt(dynString, 'waterMark');
		}
	}
}
function addIBMDisclaimer(){
	if (this.bNestedFrames) return;
	if (this.document){
		if (document.getElementById){
			this.document.write(sPreviewDOMDivisionStringDeclare.substr(0));
			this.document.close();
		}else{
			this.document.open();
			this.document.write(sPreviewNS4DivisionStringDeclare.substr(0));
			this.document.close();
		}
	}
}
function addIBMServiceDisclaimer(){
	if (this.bNestedFrames) return;
	if (this.document){
		if (document.getElementById){
			this.document.write(sProviderDOMDivisionStringDeclare.substr(0));
			this.document.close();
		}else{
			this.document.open();
			this.document.write(sProviderNS4DivisionStringDeclare.substr(0));
			this.document.close();
		}
	}
}
function addIBMpreNLGA(){
	top.dump("addIBMpreNLGA() being called");
	if (this.bNestedFrames) return;
	var strReplacement = top.url_base+"/../en_US/index.htm?";
	var strTopicPath= top.text.location.pathname.toString( );
	var delimiter = (strTopicPath.toLowerCase().indexOf("/") != -1) ? "/" : (strTopicPath.toLowerCase().indexOf("\\") != -1) ? "\\" : alert("error in filepath");
	var arTopicPath= strTopicPath.split(delimiter);
	var strPathandFile="";
	var bFound = false;
	for (i = 0; i < arTopicPath.length & !bFound; i++) {
		// if we found the 'info' dir and there are at least 2 more array elements (another dir and a filename) then proceed.
		if (arTopicPath[i] == "info" && i+2 <= arTopicPath.length - 1) {
			bFound= true;
			for (j = i; j < arTopicPath.length; j++) {
				strPathandFile += delimiter + arTopicPath[j];
			}
		}
	}
	if (bFound) {
		strReplacement +=strPathandFile;
		var strRegex = /\bnull.htm/
		var strResult = sPreNLGADOMDivisionStringDeclare.replace(strRegex, strReplacement);
		top.dump("addIBMpreNLGA(): strTopicPath = "+strTopicPath+"\ndelimiter = "+delimiter+"\nbFound = "+bFound+"\nstrPathandFile = "+strPathandFile+"\nstrReplacement = "+strReplacement);
		
		if (this.document){
			if (document.getElementById){
				strResult = sPreNLGADOMDivisionStringDeclare.replace(strRegex, strReplacement);
				this.document.write(strResult.substr(0));
				this.document.close();
			}else{
				this.document.open();
				strResult = sPreNLGANS4DivisionStringDeclare.replace(strRegex, strReplacement);
				this.document.write(strResult.substr(0));
				this.document.close();
			}
		}
	}
}
function writeIt(text,id)
{
	if (document.getElementById)
	{
		x = document.getElementById(id);
		x.innerHTML = text;
	}
	else if (document.all)
	{
		x = document.all[id];
		x.innerHTML = text;
	}
	else if (document.layers)
	{
		x = document.layers[id];
		text2 = '<P CLASS="testclass">' + text + '</P>';
		x.document.open();
		x.document.write(text2);
		x.document.close();
	}
}


function defineEvents()
{
 //03/Dec/2003 dvb - created this section to define an object reference to the applet
  var objClient;
  if (top != null )
  {
   var top_name = top.name;
   if (top_name == 'ic_index')
    objClient = top.navFrame.appletFrame.document.IcClient
  } 

  if (opener != null)
  {
   var opener_name = opener.name;
   if (opener_name == 'ic_index')
    objClient = opener.navFrame.appletFrame.document.IcClient;
  }

 //10/21/2003 Nik Coates--added this section to synch up with the applet on load if not already synched
 //03/Dec/2003 dvb - changed this section to ues the object reference to the applet
 if ( (objClient != null) && 
       (objClient.getCurrentURL() != window.location.href) )
 {
    objClient.openURL(window.location.href);
 }

 for (var i=0; i<document.links.length; i++) 
 {
  if (document.links[i].protocol.indexOf("javascript:") == -1)
  { 
   document.links[i].onclick = openURL; 
  }
 }
}
function doOnloads()
{
	for (var i=0;i<arrayOnloads.length;i++)
		arrayOnloads[i]();
}

//8/15/03--added the code to include the search results in the synching.
//10/21/03--changed structure to pass the link to the correct window and to call the applet to synch up
function openURL()
{
 var finished = false;
 var url_changed = false;
 if (top != null )
 {
  var top_name = top.name;
  if (top_name == 'ic_index')
  {
   var new_url = top.navFrame.appletFrame.document.IcClient.openURL(this.href);
   if (new_url != null && new_url != "")
   {
//    alert("redirecting URL: "+new_url);
    this.href = new_url;
    url_changed = true;
   }
   finished = true;
  }
 } 
 
 if (!finished && opener != null)
 {
  var opener_name = opener.name;
  if (opener_name == 'ic_index')
  {
   var new_url = opener.navFrame.appletFrame.document.IcClient.openURL(this.href);
   if (new_url != null && new_url != "")
   {
//    alert("redirecting URL: "+new_url);
    this.href = new_url;
    url_changed = true;
   }
  }
 }

 //here we check the link to see if it to the iSeries information center
//if it is, we change the link to point to the correct location.
 if (!url_changed)
 {
  var this_link = this.href;
  if (this_link.indexOf(top.url_base) == 0)
  {
   var path_string = this_link.substring(top.url_base.length);
   var path = path_string.split("/");
   
   //here's our check.  we look for the 'books' directory  and non-"iph" packages
   //if found, we redirect to the iSeries IC
   if (path.length > 2 && (path[1].toLowerCase() == "books" || path[2].toLowerCase() == "books" || path[2].toLowerCase().indexOf("rza") == 0 || path[2].toLowerCase().indexOf("rba") == 0 || path[2].toLowerCase().indexOf("cl") == 0) )
   {
    var temp_int = this_link.indexOf(top.release);
    var part_1 = this_link.substring(0, temp_int);
    var part_2 = "";
    var temp_int = this_link.indexOf(top.language); 
 
    //have to correct for the special case 'info/books/....pdf' link
    if (path[2].toLowerCase() == "books")
     part_2 = this_link.substring(temp_int+top.language.length+5, this_link.length);
    else
     part_2 = this_link.substring(temp_int+top.language.length, this_link.length);
    this.href = part_1+top.iseries_release+"/"+top.iseries_language+part_2;
   }
  }
 }
 
 //find the correct window in which to open the link
 if (this.target == null || this.target == "")
 {
  var this_host = this.hostname.toLowerCase();
  var ic_host = window.location.hostname.toLowerCase();
  var link_href = this.href.toLowerCase();
  var base_url = "null";
  if (top)
   base_url = top.url_base.toLowerCase();
  if ((link_href.indexOf(base_url) != 0))
  {
   if(this_host == ic_host)
    this.target = "ic_window_2";
   else
    this.target = "inet_window";
  }
  else 
  {
   var path = this.pathname.toLowerCase().split('.');
   if (path[path.length-1].indexOf("pdf") == 0) 
    this.target = "pdf_window";
   else
    this.target = "text";
  }
 }

}

//END NON-TRANSLATABLE

