/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.util.Date;

public abstract class PKCS11Object {
    public static final int CLASS = 0;
    public static final int TOKEN = 1;
    public static final int PRIVATE = 2;
    public static final int LABEL = 3;
    public static final int APPLICATION = 16;
    public static final int VALUE = 17;
    public static final int OBJECT_ID = 18;
    public static final int CERTIFICATE_TYPE = 128;
    public static final int ISSUER = 129;
    public static final int SERIAL_NUMBER = 130;
    public static final int AC_ISSUER = 131;
    public static final int OWNER = 132;
    public static final int ATTR_TYPES = 133;
    public static final int TRUSTED = 134;
    public static final int KEY_TYPE = 256;
    public static final int SUBJECT = 257;
    public static final int ID = 258;
    public static final int SENSITIVE = 259;
    public static final int ENCRYPT = 260;
    public static final int DECRYPT = 261;
    public static final int WRAP = 262;
    public static final int UNWRAP = 263;
    public static final int SIGN = 264;
    public static final int SIGN_RECOVER = 265;
    public static final int VERIFY = 266;
    public static final int VERIFY_RECOVER = 267;
    public static final int DERIVE = 268;
    public static final int START_DATE = 272;
    public static final int END_DATE = 273;
    public static final int MODULUS = 288;
    public static final int MODULUS_BITS = 289;
    public static final int PUBLIC_EXPONENT = 290;
    public static final int PRIVATE_EXPONENT = 291;
    public static final int PRIME_1 = 292;
    public static final int PRIME_2 = 293;
    public static final int EXPONENT_1 = 294;
    public static final int EXPONENT_2 = 295;
    public static final int COEFFICIENT = 296;
    public static final int PRIME = 304;
    public static final int SUBPRIME = 305;
    public static final int BASE = 306;
    public static final int PRIME_BITS = 307;
    public static final int SUBPRIME_BITS = 308;
    public static final int VALUE_BITS = 352;
    public static final int VALUE_LEN = 353;
    public static final int EXTRACTABLE = 354;
    public static final int LOCAL = 355;
    public static final int NEVER_EXTRACTABLE = 356;
    public static final int ALWAYS_SENSITIVE = 357;
    public static final int KEY_GEN_MECHANISM = 358;
    public static final int MODIFIABLE = 368;
    public static final int ECDSA_PARAMS = 384;
    public static final int EC_PARAMS = 384;
    public static final int EC_POINT = 385;
    public static final int SECONDARY_AUTH = 512;
    public static final int AUTH_PIN_FLAGS = 513;
    public static final int HW_FEATURE_TYPE = 768;
    public static final int RESET_ON_INIT = 769;
    public static final int HAS_RESET = 770;
    public static final int VENDOR_DEFINED = Integer.MIN_VALUE;
    public static final int INVALID = -1;
    private static final int[] CKA_types = new int[]{0, 1, 2, 3, 16, 17, 18, 128, 129, 130, 131, 132, 133, 134, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 272, 273, 288, 289, 290, 291, 292, 293, 294, 295, 296, 304, 305, 306, 307, 308, 352, 353, 354, 355, 356, 357, 358, 368, 384, 384, 385, 512, 513, 768, 769, 770};
    private static final String[] CKA_names = new String[]{PKCS11Object.a("[\u0016]\u001c!"), PKCS11Object.a("L\u0015W\n<"), PKCS11Object.a("H\bU\u00193L\u001f"), PKCS11Object.a("T\u001b^\n>"), PKCS11Object.a("Y\nL\u0003;[\u001bH\u0006=V"), PKCS11Object.a("N\u001bP\u001a7"), PKCS11Object.a("W\u0018V\n1L\u0005U\u000b"), PKCS11Object.a("[\u001fN\u001b;^\u0013_\u000e&]\u0005H\u0016\"]"), PKCS11Object.a("Q\tO\u001a7J"), PKCS11Object.a("K\u001fN\u00063T\u0005R\u001a?Z\u001fN"), PKCS11Object.a("Y\u0019C\u0006!K\u000fY\u001d"), PKCS11Object.a("W\rR\n "), PKCS11Object.a("Y\u000eH\u001d-L\u0003L\n!"), PKCS11Object.a("L\bI\u001c&]\u001e"), PKCS11Object.a("S\u001fE\u0010&A\nY"), PKCS11Object.a("K\u000f^\u00057[\u000e"), PKCS11Object.a("Q\u001e"), PKCS11Object.a("K\u001fR\u001c;L\u0013J\n"), PKCS11Object.a("]\u0014_\u001d+H\u000e"), PKCS11Object.a("\\\u001f_\u001d+H\u000e"), PKCS11Object.a("O\b]\u001f"), PKCS11Object.a("M\u0014K\u001d3H"), PKCS11Object.a("K\u0013[\u0001"), PKCS11Object.a("K\u0013[\u0001-J\u001f_\u0000$]\b"), PKCS11Object.a("N\u001fN\u00064A"), PKCS11Object.a("N\u001fN\u00064A\u0005N\n1W\fY\u001d"), PKCS11Object.a("\\\u001fN\u0006$]"), PKCS11Object.a("K\u000e]\u001d&G\u001e]\u001b7"), PKCS11Object.a("]\u0014X\u00106Y\u000eY"), PKCS11Object.a("U\u0015X\u001a>M\t"), PKCS11Object.a("U\u0015X\u001a>M\tC\r;L\t"), PKCS11Object.a("H\u000f^\u0003;[\u0005Y\u0017\"W\u0014Y\u0001&"), PKCS11Object.a("H\bU\u00193L\u001fC\n*H\u0015R\n<L"), PKCS11Object.a("H\bU\u00027Gk"), PKCS11Object.a("H\bU\u00027Gh"), PKCS11Object.a("]\u0002L\u0000<]\u0014H\u0010C"), PKCS11Object.a("]\u0002L\u0000<]\u0014H\u0010@"), PKCS11Object.a("[\u0015Y\t4Q\u0019U\n<L"), PKCS11Object.a("H\bU\u00027"), PKCS11Object.a("K\u000f^\u001f Q\u0017Y"), PKCS11Object.a("Z\u001bO\n"), PKCS11Object.a("H\bU\u00027G\u0018U\u001b!"), PKCS11Object.a("K\u000f^\u001f Q\u0017Y\u00100Q\u000eO"), PKCS11Object.a("N\u001bP\u001a7G\u0018U\u001b!"), PKCS11Object.a("N\u001bP\u001a7G\u0016Y\u0001"), PKCS11Object.a("]\u0002H\u001d3[\u000e]\r>]"), PKCS11Object.a("T\u0015_\u000e>"), PKCS11Object.a("V\u001fJ\n G\u001fD\u001b Y\u0019H\u000e0T\u001f"), PKCS11Object.a("Y\u0016K\u000e+K\u0005O\n<K\u0013H\u0006$]"), PKCS11Object.a("S\u001fE\u00105]\u0014C\u00027[\u0012]\u0001;K\u0017"), PKCS11Object.a("U\u0015X\u00064Q\u001b^\u00037"), PKCS11Object.a("]\u0019X\u001c3G\n]\u001d3U\t"), PKCS11Object.a("]\u0019C\u001f3J\u001bQ\u001c"), PKCS11Object.a("]\u0019C\u001f=Q\u0014H"), PKCS11Object.a("K\u001f_\u0000<\\\u001bN\u0016-Y\u000fH\u0007"), PKCS11Object.a("Y\u000fH\u0007-H\u0013R\u00104T\u001b[\u001c"), PKCS11Object.a("P\rC\t7Y\u000eI\u001d7G\u000eE\u001f7"), PKCS11Object.a("J\u001fO\n&G\u0015R\u0010;V\u0013H"), PKCS11Object.a("P\u001bO\u0010 ]\tY\u001b")};
    private static final Class[] CKA_classes = new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Q4h*\u0015}("))) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\K.n&\u001c\u007f"))) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\K.n&\u001c\u007f"))) : class$java$lang$String, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("C\u0018"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("C\u0018"))) : array$B, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Q4h*\u0015}("))) : class$java$lang$Integer, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("C\u0018"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("C\u0018"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("C\u0018"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("C\u0018"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("C\u0018"))) : array$B, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Q4h*\u0015}("))) : class$java$lang$Integer, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("C\u0018"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("C\u0018"))) : array$B, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean, class$java$util$Date == null ? (class$java$util$Date = PKCS11Object.class$(PKCS11Object.a("r;j.\\m.u#\\\\;h*"))) : class$java$util$Date, class$java$util$Date == null ? (class$java$util$Date = PKCS11Object.class$(PKCS11Object.a("r;j.\\m.u#\\\\;h*"))) : class$java$util$Date, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("r;j.\\u;h'\\Z3{\u0006\u001cl?{*\u0000"))) : class$java$math$BigInteger, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Q4h*\u0015}("))) : class$java$lang$Integer, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("r;j.\\u;h'\\Z3{\u0006\u001cl?{*\u0000"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("r;j.\\u;h'\\Z3{\u0006\u001cl?{*\u0000"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("r;j.\\u;h'\\Z3{\u0006\u001cl?{*\u0000"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("r;j.\\u;h'\\Z3{\u0006\u001cl?{*\u0000"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("r;j.\\u;h'\\Z3{\u0006\u001cl?{*\u0000"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("r;j.\\u;h'\\Z3{\u0006\u001cl?{*\u0000"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("r;j.\\u;h'\\Z3{\u0006\u001cl?{*\u0000"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("r;j.\\u;h'\\Z3{\u0006\u001cl?{*\u0000"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("r;j.\\u;h'\\Z3{\u0006\u001cl?{*\u0000"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("r;j.\\u;h'\\Z3{\u0006\u001cl?{*\u0000"))) : class$java$math$BigInteger, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Q4h*\u0015}("))) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Q4h*\u0015}("))) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Q4h*\u0015}("))) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Q4h*\u0015}("))) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Q4h*\u0015}("))) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("C\u0018"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("C\u0018"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("C\u0018"))) : array$B, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Q4h*\u0015}("))) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Q4h*\u0015}("))) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean};
    public static final Integer RSA = new Integer(0);
    public static final Integer DSA = new Integer(1);
    public static final Integer DH = new Integer(2);
    public static final Integer ECDSA = new Integer(3);
    public static final Integer EC = new Integer(3);
    public static final Integer X9_42_DH = new Integer(4);
    public static final Integer KEA = new Integer(5);
    public static final Integer GENERIC_SECRET = new Integer(16);
    public static final Integer RC2 = new Integer(17);
    public static final Integer RC4 = new Integer(18);
    public static final Integer DES = new Integer(19);
    public static final Integer DES2 = new Integer(20);
    public static final Integer DES3 = new Integer(21);
    public static final Integer CAST = new Integer(22);
    public static final Integer CAST3 = new Integer(23);
    public static final Integer CAST5 = new Integer(24);
    public static final Integer CAST128 = new Integer(24);
    public static final Integer RC5 = new Integer(25);
    public static final Integer IDEA = new Integer(26);
    public static final Integer SKIPJACK = new Integer(27);
    public static final Integer BATON = new Integer(28);
    public static final Integer JUNIPER = new Integer(29);
    public static final Integer CDMF = new Integer(30);
    public static final Integer AES = new Integer(31);
    private static final Integer[] CKK_types = new Integer[]{RSA, DSA, DH, ECDSA, EC, X9_42_DH, KEA, GENERIC_SECRET, RC2, RC4, DES, DES2, DES3, CAST, CAST3, CAST5, CAST128, RC5, IDEA, SKIPJACK, BATON, JUNIPER, CDMF, AES};
    private static final String[] CKK_names = new String[]{PKCS11Object.a("J\t]"), PKCS11Object.a("\\\t]"), PKCS11Object.a("\\\u0012"), PKCS11Object.a("]\u0019X\u001c3"), PKCS11Object.a("]\u0019"), PKCS11Object.a("@cC{@G\u001eT"), PKCS11Object.a("S\u001f]"), PKCS11Object.a("_\u001fR\n Q\u0019C\u001c7[\bY\u001b"), PKCS11Object.a("J\u0019."), PKCS11Object.a("J\u0019("), PKCS11Object.a("\\\u001fO"), PKCS11Object.a("\\\u001fO}"), PKCS11Object.a("\\\u001fO|"), PKCS11Object.a("[\u001bO\u001b"), PKCS11Object.a("[\u001bO\u001bA"), PKCS11Object.a("[\u001bO\u001bG"), PKCS11Object.a("[\u001bO\u001bC*b"), PKCS11Object.a("J\u0019)"), PKCS11Object.a("Q\u001eY\u000e"), PKCS11Object.a("K\u0011U\u001f8Y\u0019W"), PKCS11Object.a("Z\u001bH\u0000<"), PKCS11Object.a("R\u000fR\u0006\"]\b"), PKCS11Object.a("[\u001eQ\t"), PKCS11Object.a("Y\u001fO")};
    public static final Integer DATA = new Integer(0);
    public static final Integer CERTIFICATE = new Integer(1);
    public static final Integer PUBLIC_KEY = new Integer(2);
    public static final Integer PRIVATE_KEY = new Integer(3);
    public static final Integer SECRET_KEY = new Integer(4);
    public static final Integer HW_FEATURE = new Integer(5);
    public static final Integer DOMAIN_PARAMETERS = new Integer(6);
    private static final Integer[] CKO_types = new Integer[]{DATA, CERTIFICATE, PUBLIC_KEY, PRIVATE_KEY, SECRET_KEY, HW_FEATURE, DOMAIN_PARAMETERS};
    private static final String[] CKO_names = new String[]{PKCS11Object.a("\\\u001bH\u000e"), PKCS11Object.a("[\u001fN\u001b;^\u0013_\u000e&]"), PKCS11Object.a("H\u000f^\u0003;[\u0005W\n+"), PKCS11Object.a("H\bU\u00193L\u001fC\u00047A"), PKCS11Object.a("K\u001f_\u001d7L\u0005W\n+"), PKCS11Object.a("P\rC\t7Y\u000eI\u001d7"), PKCS11Object.a("\\\u0015Q\u000e;V\u0005L\u000e Y\u0017Y\u001b7J\t")};
    public static final Integer MONOTONIC_COUNTER = new Integer(1);
    public static final Integer CLOCK = new Integer(2);
    private static final Integer[] CKH_types = new Integer[]{MONOTONIC_COUNTER, CLOCK};
    private static final String[] CKH_names = new String[]{PKCS11Object.a("U\u0015R\u0000&W\u0014U\f-[\u0015I\u0001&]\b"), PKCS11Object.a("[\u0016S\f9")};
    public static final Integer X_509 = new Integer(0);
    public static final Integer X_509_ATTR_CERT = new Integer(1);
    private static final Integer[] CKC_types = new Integer[]{X_509, X_509_ATTR_CERT};
    private static final String[] CKC_names = new String[]{PKCS11Object.a("@\u0005)\u007fK"), PKCS11Object.a("@\u0005)\u007fKG\u001bH\u001b G\u0019Y\u001d&")};
    public static final Boolean TRUE = Boolean.TRUE;
    public static final Boolean FALSE = Boolean.FALSE;
    private static final int[] pinflagList = new int[]{65536, 131072, 262144, 524288};
    static final String[] pinflagNames = new String[]{PKCS11Object.a("M\tY\u001d-H\u0013R\u00101W\u000fR\u001b-T\u0015K"), PKCS11Object.a("M\tY\u001d-H\u0013R\u00104Q\u0014]\u0003-L\bE"), PKCS11Object.a("M\tY\u001d-H\u0013R\u0010>W\u0019W\n6"), PKCS11Object.a("M\tY\u001d-H\u0013R\u0010&W\u0005^\n-[\u0012]\u00015]\u001e")};
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$math$BigInteger;

    protected PKCS11Object() {
    }

    public abstract PKCS11Session getSession() throws PKCS11Exception;

    public abstract PKCS11Object copy(int[] var1, Object[] var2) throws PKCS11Exception;

    public abstract void destroy() throws PKCS11Exception;

    public abstract int size() throws PKCS11Exception;

    public Object[] getAttributeValues(int[] nArray) throws PKCS11Exception {
        Object[] objectArray = new Object[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            objectArray[n2] = this.getAttributeValue(nArray[n2]);
            ++n2;
        }
        return objectArray;
    }

    public abstract Object getAttributeValue(int var1) throws PKCS11Exception;

    public boolean getBoolAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean)) {
            throw new PKCS11Exception(18);
        }
        return (Boolean)this.getAttributeValue(n2);
    }

    public int getIntAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Q4h*\u0015}("))) : class$java$lang$Integer)) {
            throw new PKCS11Exception(18);
        }
        return (Integer)this.getAttributeValue(n2);
    }

    public String getStringAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$String == null ? (class$java$lang$String = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\K.n&\u001c\u007f"))) : class$java$lang$String)) {
            throw new PKCS11Exception(18);
        }
        return (String)this.getAttributeValue(n2);
    }

    public byte[] getByteArrayAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("C\u0018"))) : array$B)) {
            throw new PKCS11Exception(18);
        }
        return (byte[])this.getAttributeValue(n2);
    }

    public Date getDateAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$util$Date == null ? (class$java$util$Date = PKCS11Object.class$(PKCS11Object.a("r;j.\\m.u#\\\\;h*"))) : class$java$util$Date)) {
            throw new PKCS11Exception(18);
        }
        return (Date)this.getAttributeValue(n2);
    }

    public BigInteger getBigIntegerAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("r;j.\\u;h'\\Z3{\u0006\u001cl?{*\u0000"))) : class$java$math$BigInteger)) {
            throw new PKCS11Exception(18);
        }
        return (BigInteger)this.getAttributeValue(n2);
    }

    public abstract void setAttributeValues(int[] var1, Object[] var2) throws PKCS11Exception;

    public abstract void setAttributeValue(int var1, Object var2) throws PKCS11Exception;

    public void setBoolAttributeValue(int n2, boolean bl2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Z5s#\u0017y4"))) : class$java$lang$Boolean)) {
            throw new PKCS11Exception(18);
        }
        this.setAttributeValue(n2, new Boolean(bl2));
    }

    public void setIntAttributeValue(int n2, int n3) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Q4h*\u0015}("))) : class$java$lang$Integer)) {
            throw new PKCS11Exception(18);
        }
        this.setAttributeValue(n2, new Integer(n3));
    }

    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(512);
        String string = PKCS11Object.a("8z<oR8z<oR8z<oR8z<oR");
        stringBuffer.append(PKCS11Object.a("w8v*\u0011l`\u0016"));
        int n3 = 0;
        while (n3 < CKA_types.length) {
            String string2;
            String string3;
            block6: {
                n2 = CKA_types[n3];
                string3 = PKCS11Object.typeToString(n2);
                string2 = null;
                try {
                    Object object = this.getAttributeValue(n2);
                    string2 = PKCS11Object.attrToString(n2, object);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    if (pKCS11Exception.getCode() != 17) break block6;
                    string2 = PKCS11Object.a("0\u001bH\u001b Q\u0018I\u001b7G\tY\u0001!Q\u000eU\u001971");
                }
            }
            if (string2 != null) {
                stringBuffer.append("\t").append(string3).append(":");
                stringBuffer.append(string.substring(string3.length()));
                stringBuffer.append(string2).append("\n");
            }
            ++n3;
        }
        try {
            n2 = this.size();
            stringBuffer.append(PKCS11Object.a("\u0011\tU\u00157\"")).append(string.substring(4)).append(n2).append("\n");
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static Class valueClass(int n2) {
        int n3 = 0;
        while (n3 < CKA_types.length) {
            if (CKA_types[n3] == n2) {
                return CKA_classes[n3];
            }
            ++n3;
        }
        return null;
    }

    public static String typeToString(int n2) {
        int n3 = 0;
        while (n3 < CKA_types.length) {
            if (CKA_types[n3] == n2) {
                return CKA_names[n3];
            }
            ++n3;
        }
        return PKCS11Object.a("(\"") + Integer.toHexString(n2);
    }

    public static String classToString(Integer n2) {
        return PKCS11Object.IntegerToString(n2, CKO_types, CKO_names);
    }

    public static String keyToString(Integer n2) {
        return PKCS11Object.IntegerToString(n2, CKK_types, CKK_names);
    }

    public static String hwfeatureToString(Integer n2) {
        return PKCS11Object.IntegerToString(n2, CKH_types, CKH_names);
    }

    public static String certToString(Integer n2) {
        return PKCS11Object.IntegerToString(n2, CKC_types, CKC_names);
    }

    public static String pinflagsToString(Integer n2) {
        return PKCS11.flagsToString(n2, pinflagList, pinflagNames, PKCS11Object.a("8&<"));
    }

    public static String attrToString(int n2, Object object) {
        if (object == null) {
            return PKCS11Object.a("v/p#");
        }
        Class clazz = PKCS11Object.valueClass(n2);
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("r;j.\\t;r(\\Q4h*\u0015}("))) : class$java$lang$Integer)) {
            switch (n2) {
                case 0: {
                    return PKCS11Object.classToString((Integer)object);
                }
                case 256: {
                    return PKCS11Object.keyToString((Integer)object);
                }
                case 128: {
                    return PKCS11Object.certToString((Integer)object);
                }
                case 513: {
                    return PKCS11Object.pinflagsToString((Integer)object);
                }
                case 768: {
                    return PKCS11Object.hwfeatureToString((Integer)object);
                }
            }
            return object.toString();
        }
        if (clazz == (array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("C\u0018"))) : array$B)) {
            return PKCS11Object.bytesToString((byte[])object, 10);
        }
        if (clazz == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("r;j.\\u;h'\\Z3{\u0006\u001cl?{*\u0000"))) : class$java$math$BigInteger)) {
            return PKCS11Object.a("(\"") + ((BigInteger)object).toString(16);
        }
        return object.toString();
    }

    public static String bytesToString(byte[] byArray, int n2) {
        if (byArray == null) {
            return PKCS11Object.a("v/p#");
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            if (n2 != 0 && n4 > n2) {
                stringBuffer.append(PKCS11Object.a("8t2aR0")).append(byArray.length).append(PKCS11Object.a("88e;\u0017ks"));
                break;
            }
            if (n3 == 16) {
                stringBuffer.append('\n');
                n3 = 0;
            }
            if (n3 > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(PKCS11Object.a("(k.|F-l+wKy8\u007f+\u0017~").charAt(byArray[n4] >> 4 & 0xF));
            stringBuffer.append(PKCS11Object.a("(k.|F-l+wKy8\u007f+\u0017~").charAt(byArray[n4] & 0xF));
            ++n4;
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static String IntegerToString(Integer n2, Integer[] integerArray, String[] stringArray) {
        int n3 = n2;
        int n4 = 0;
        while (n4 < integerArray.length) {
            if (integerArray[n4] == n3) {
                return stringArray[n4];
            }
            ++n4;
        }
        return PKCS11Object.a("(\"") + Integer.toHexString(n3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 24;
                        break;
                    }
                    case 1: {
                        n5 = 90;
                        break;
                    }
                    case 2: {
                        n5 = 28;
                        break;
                    }
                    case 3: {
                        n5 = 79;
                        break;
                    }
                    default: {
                        n5 = 114;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

