/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;

public class PKCS11SlotInfo {
    public static final int TOKEN_PRESENT = 1;
    public static final int REMOVABLE_DEVICE = 2;
    public static final int HW_SLOT = 4;
    static int[] flagList = new int[]{1, 2, 4};
    static String[] flagNames = new String[]{PKCS11SlotInfo.a("7H;%]<W\"%@&I$"), PKCS11SlotInfo.a("1B=/E\"E<%L'B&)P&"), PKCS11SlotInfo.a("+P/3_,S")};
    private String description;
    private String manufacturer;
    private int flags;
    private int hardwareVersion;
    private int firmwareVersion;

    public PKCS11SlotInfo(String string, String string2, int n2, int n3, int n4) {
        this.description = string;
        this.manufacturer = string2;
        this.flags = n2;
        this.hardwareVersion = n3;
        this.firmwareVersion = n4;
    }

    public String description() {
        return this.description;
    }

    public String manufacturer() {
        return this.manufacturer;
    }

    public int flags() {
        return this.flags;
    }

    public int hardwareVersion() {
        return this.hardwareVersion;
    }

    public int firmwareVersion() {
        return this.firmwareVersion;
    }

    public boolean tokenPresent() {
        return (this.flags & 1) != 0;
    }

    public boolean removableDevice() {
        return (this.flags & 2) != 0;
    }

    public boolean hardwareSlot() {
        return (this.flags & 4) != 0;
    }

    public String toString() {
        return PKCS11SlotInfo.a("3L33\"RT\u001c\u000fg*i\u0016\u000f)i'P@3'b\u0003\u0003a\nw\u0004\t|\r=P@3C'P@") + this.description + PKCS11SlotInfo.a("i'P@3.f\u001e\u0015u\u0002d\u0004\u0015a\u0006uJ@3C'P@") + this.manufacturer + PKCS11SlotInfo.a("i'P@3%k\u0011\u0007`Y'P@3C'P@3C'P@") + this.flagsToString(PKCS11SlotInfo.a("C{P")) + PKCS11SlotInfo.a("i'P@3+f\u0002\u0004d\u0002u\u0015@e\u0006u\u0003\t|\r=P@") + PKCS11.versionString(this.hardwareVersion) + PKCS11SlotInfo.a("i'P@3%n\u0002\rd\u0002u\u0015@e\u0006u\u0003\t|\r=P@") + PKCS11.versionString(this.firmwareVersion);
    }

    public String flagsToString(String string) {
        return PKCS11.flagsToString(this.flags, flagList, flagNames, string);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 99;
                        break;
                    }
                    case 1: {
                        n5 = 7;
                        break;
                    }
                    case 2: {
                        n5 = 112;
                        break;
                    }
                    case 3: {
                        n5 = 96;
                        break;
                    }
                    default: {
                        n5 = 19;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

