/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;

public class PKCS11TokenInfo {
    public static final int RNG = 1;
    public static final int WRITE_PROTECTED = 2;
    public static final int LOGIN_REQUIRED = 4;
    public static final int USER_PIN_INITIALIZED = 8;
    public static final int EXCLUSIVE_EXISTS = 16;
    public static final int RESTORE_KEY_NOT_NEEDED = 32;
    public static final int CLOCK_ON_TOKEN = 64;
    public static final int SUPPORTS_PARALLEL = 128;
    public static final int PROTECTED_AUTHENTICATION_PATH = 256;
    public static final int DUAL_CRYPTO_OPERATIONS = 512;
    public static final int TOKEN_INITIALIZED = 1024;
    public static final int SECONDARY_AUTHENTICATION = 2048;
    public static final int USER_PIN_COUNT_LOW = 65536;
    public static final int USER_PIN_FINAL_TRY = 131072;
    public static final int USER_PIN_LOCKED = 262144;
    public static final int USER_PIN_TO_BE_CHANGED = 524288;
    public static final int SO_PIN_COUNT_LOW = 0x100000;
    public static final int SO_PIN_FINAL_TRY = 0x200000;
    public static final int SO_PIN_LOCKED = 0x400000;
    public static final int SO_PIN_TO_BE_CHANGED = 0x800000;
    public static final int UNAVAILABLE_INFORMATION = -1;
    public static final int EFFECTIVELY_INFINITE = 0;
    static final int[] flagList = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000};
    static final String[] flagNames = new String[]{PKCS11TokenInfo.a("2\u001eR"), PKCS11TokenInfo.a("7\u0002\\K%?\u0000GP4%\u0013AZ$"), PKCS11TokenInfo.a(",\u001fRV.?\u0002PN5)\u0002P["), PKCS11TokenInfo.a("5\u0003PM?0\u0019[@).\u0019AV!,\u0019OZ$"), PKCS11TokenInfo.a("%\bVS53\u0019CZ?%\b\\L43"), PKCS11TokenInfo.a("2\u0015FK/2\u0015JT%9\u000f[P4?\u001ePZ$%\u0014"), PKCS11TokenInfo.a("#\u001cZ\\+?\u001f[@4/\u001bPQ"), PKCS11TokenInfo.a("3\u0005EO/2\u0004F@0!\u0002TS,%\u001c"), PKCS11TokenInfo.a("0\u0002ZK%#\u0004P[?!\u0005AW%.\u0004\\\\!4\u0019ZQ?0\u0011AW"), PKCS11TokenInfo.a("$\u0005TS?#\u0002LO4/\u000fZO%2\u0011AV/.\u0003"), PKCS11TokenInfo.a("4\u001f^Z.?\u0019[V4)\u0011YV:%\u0014"), PKCS11TokenInfo.a("3\u0015VP.$\u0011GF?!\u0005AW%.\u0004\\\\!4\u0019ZQ"), PKCS11TokenInfo.a("5\u0003PM?0\u0019[@#/\u0005[K?,\u001fB"), PKCS11TokenInfo.a("5\u0003PM?0\u0019[@&)\u001eTS?4\u0002L"), PKCS11TokenInfo.a("5\u0003PM?0\u0019[@,/\u0013^Z$"), PKCS11TokenInfo.a("5\u0003PM?0\u0019[@4/\u000fWZ?#\u0018TQ'%\u0014"), PKCS11TokenInfo.a("3\u001fJO).\u000fVP5.\u0004JS/7"), PKCS11TokenInfo.a("3\u001fJO).\u000fSV.!\u001cJK29"), PKCS11TokenInfo.a("3\u001fJO).\u000fYP#+\u0015Q"), PKCS11TokenInfo.a("3\u001fJO).\u000fAP?\"\u0015J\\(!\u001eRZ$")};
    private String label;
    private String manufacturer;
    private String model;
    private String serialNumber;
    private int flags;
    private int maxSessionCount;
    private int sessionCount;
    private int maxRwSessionCount;
    private int rwSessionCount;
    private int maxPinLen;
    private int minPinLen;
    private int totalPublicMemory;
    private int freePublicMemory;
    private int totalPrivateMemory;
    private int freePrivateMemory;
    private int hardwareVersion;
    private int firmwareVersion;
    private String utcTime;

    public PKCS11TokenInfo(String string, String string2, String string3, String string4, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, String string5) {
        this.label = string;
        this.manufacturer = string2;
        this.model = string3;
        this.serialNumber = string4;
        this.flags = n2;
        this.maxSessionCount = n3;
        this.sessionCount = n4;
        this.maxRwSessionCount = n5;
        this.rwSessionCount = n6;
        this.maxPinLen = n7;
        this.minPinLen = n8;
        this.totalPublicMemory = n9;
        this.freePublicMemory = n10;
        this.totalPrivateMemory = n11;
        this.freePrivateMemory = n12;
        this.hardwareVersion = n13;
        this.firmwareVersion = n14;
        this.utcTime = string5;
    }

    public String label() {
        return this.label;
    }

    public String manufacturer() {
        return this.manufacturer;
    }

    public String model() {
        return this.model;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public int flags() {
        return this.flags;
    }

    public int maxSessionCount() {
        return this.maxSessionCount;
    }

    public int sessionCount() {
        return this.sessionCount;
    }

    public int maxRwSessionCount() {
        return this.maxRwSessionCount;
    }

    public int rwSessionCount() {
        return this.rwSessionCount;
    }

    public int maxPinLen() {
        return this.maxPinLen;
    }

    public int minPinLen() {
        return this.minPinLen;
    }

    public int totalPublicMemory() {
        return this.totalPublicMemory;
    }

    public int freePublicMemory() {
        return this.freePublicMemory;
    }

    public int totalPrivateMemory() {
        return this.totalPrivateMemory;
    }

    public int freePrivateMemory() {
        return this.freePrivateMemory;
    }

    public int hardwareVersion() {
        return this.hardwareVersion;
    }

    public int firmwareVersion() {
        return this.firmwareVersion;
    }

    public String utcTime() {
        return this.utcTime;
    }

    public String toString() {
        return PKCS11TokenInfo.a("0\u001bVLQQ\u0004zt\u0005\u000e\u0019{y\u000fZZ5?@@\u001ct}\u0005\fj5?@@p5?@@p5?@") + this.label + PKCS11TokenInfo.a("jp5?@-1{j\u0006\u00013aj\u0012\u0005\"/?@@p5?") + this.manufacturer + PKCS11TokenInfo.a("jp5?@-?qz\fZp5?@@p5?@@p5?") + this.model + PKCS11TokenInfo.a("jp5?@35gv\u0001\fj5?@@p5?@@p5?") + this.serialNumber + PKCS11TokenInfo.a("jp5?@&<tx\u0013Zp5?@@p5?@@p5?") + this.flagsToString(PKCS11TokenInfo.a("@,5")) + PKCS11TokenInfo.a("jp5?@-1m?\u0013\u0005#fv\u000f\u000e#/?@@p5?") + this.infinite(this.maxSessionCount) + PKCS11TokenInfo.a("jp5?@35fl\t\u000f>f%@@p5?@@p5?") + this.unavailable(this.sessionCount) + PKCS11TokenInfo.a("jp5?@-1m?27pfz\u0013\u00139zq\u0013Zp5?") + this.infinite(this.maxRwSessionCount) + PKCS11TokenInfo.a("jp5?@2\u00075l\u0005\u0013#|p\u000e\u0013j5?@@p5?") + this.unavailable(this.rwSessionCount) + PKCS11TokenInfo.a("jp5?@-1m?0)\u001e5s\u0005\u000ej5?@@p5?") + this.maxPinLen + PKCS11TokenInfo.a("jp5?@-9{?0)\u001e5s\u0005\u000ej5?@@p5?") + this.minPinLen + PKCS11TokenInfo.a("jp5?@4?a~\f@ `}\f\t35r\u0005\rj5?") + this.unavailable(this.totalPublicMemory) + PKCS11TokenInfo.a("jp5?@&\"pz@\u0010%ws\t\u0003pxz\rZp5?") + this.unavailable(this.freePublicMemory) + PKCS11TokenInfo.a("jp5?@4?a~\f@ gv\u0016\u0001$p?\r\u0005=/?") + this.unavailable(this.totalPrivateMemory) + PKCS11TokenInfo.a("jp5?@&\"pz@\u0010\"|i\u0001\u001455r\u0005\rj5?") + this.unavailable(this.freePrivateMemory) + PKCS11TokenInfo.a("jp5?@(1g{\u0017\u0001\"p?\u0016\u0005\"fv\u000f\u000ej5?") + PKCS11.versionString(this.hardwareVersion) + PKCS11TokenInfo.a("jp5?@&9gr\u0017\u0001\"p?\u0016\u0005\"fv\u000f\u000ej5?") + PKCS11.versionString(this.firmwareVersion) + (this.utcTime != null ? PKCS11TokenInfo.a("jp5?@5\u0004V?\u0014\t=p%@@p5?@@p5?") + this.utcTime : "");
    }

    public String flagsToString(String string) {
        return PKCS11.flagsToString(this.flags, flagList, flagNames, string);
    }

    String infinite(int n2) {
        return n2 == 0 ? PKCS11TokenInfo.a("%\u0016SZ#4\u0019CZ,9\u000f\\Q&)\u001e\\K%") : this.unavailable(n2);
    }

    String unavailable(int n2) {
        return n2 == -1 ? PKCS11TokenInfo.a("5\u001eTI!)\u001cT],%\u000f\\Q&/\u0002X^4)\u001f[") : Integer.toString(n2);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 96;
                        break;
                    }
                    case 1: {
                        n5 = 80;
                        break;
                    }
                    case 2: {
                        n5 = 21;
                        break;
                    }
                    case 3: {
                        n5 = 31;
                        break;
                    }
                    default: {
                        n5 = 96;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

