/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import mx4j.util.Utils;

public class MBeanInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6451021435135161911L;
    private String className;
    private String description;
    private MBeanConstructorInfo[] constructors;
    private MBeanAttributeInfo[] attributes;
    private MBeanOperationInfo[] operations;
    private MBeanNotificationInfo[] notifications;

    public MBeanInfo(String className, String description, MBeanAttributeInfo[] attributes, MBeanConstructorInfo[] constructors, MBeanOperationInfo[] operations, MBeanNotificationInfo[] notifications) {
        this.className = className;
        this.description = description;
        this.constructors = constructors == null ? new MBeanConstructorInfo[]{} : constructors;
        this.attributes = attributes == null ? new MBeanAttributeInfo[]{} : attributes;
        this.operations = operations == null ? new MBeanOperationInfo[]{} : operations;
        this.notifications = notifications == null ? new MBeanNotificationInfo[]{} : notifications;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exc) {
            return null;
        }
    }

    public String getClassName() {
        return this.className;
    }

    public String getDescription() {
        return this.description;
    }

    public MBeanConstructorInfo[] getConstructors() {
        return this.constructors != null ? (MBeanConstructorInfo[])this.constructors.clone() : new MBeanConstructorInfo[]{};
    }

    public MBeanAttributeInfo[] getAttributes() {
        return this.attributes != null ? (MBeanAttributeInfo[])this.attributes.clone() : new MBeanAttributeInfo[]{};
    }

    public MBeanOperationInfo[] getOperations() {
        return this.operations != null ? (MBeanOperationInfo[])this.operations.clone() : new MBeanOperationInfo[]{};
    }

    public MBeanNotificationInfo[] getNotifications() {
        return this.notifications != null ? (MBeanNotificationInfo[])this.notifications.clone() : new MBeanNotificationInfo[]{};
    }

    public int hashCode() {
        int hash;
        String cn = this.getClassName();
        String desc = this.getDescription();
        Object[] ctors = this.getConstructors();
        Object[] attrs = this.getAttributes();
        Object[] ops = this.getOperations();
        Object[] notifs = this.getNotifications();
        int n = hash = cn == null ? 0 : cn.hashCode();
        if (desc != null) {
            hash ^= desc.hashCode();
        }
        if (ctors != null) {
            hash ^= Utils.arrayHashCode((Object[])ctors);
        }
        if (attrs != null) {
            hash ^= Utils.arrayHashCode((Object[])attrs);
        }
        if (ops != null) {
            hash ^= Utils.arrayHashCode((Object[])ops);
        }
        if (notifs != null) {
            hash ^= Utils.arrayHashCode((Object[])notifs);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MBeanInfo)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        try {
            MBeanInfo other = (MBeanInfo)obj;
            if (this.equalClassNames(this, other) && this.equalDescriptions(this, other)) {
                if (!Utils.arrayEquals((Object[])this.getConstructors(), (Object[])other.getConstructors())) {
                    return false;
                }
                if (!Utils.arrayEquals((Object[])this.getAttributes(), (Object[])other.getAttributes())) {
                    return false;
                }
                if (!Utils.arrayEquals((Object[])this.getOperations(), (Object[])other.getOperations())) {
                    return false;
                }
                return Utils.arrayEquals((Object[])this.getNotifications(), (Object[])other.getNotifications());
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    private boolean equalClassNames(MBeanInfo infoone, MBeanInfo infotwo) {
        return this.infoStringEquals(infoone.getClassName(), infotwo.getClassName());
    }

    private boolean equalDescriptions(MBeanInfo infoone, MBeanInfo infotwo) {
        return this.infoStringEquals(infoone.getDescription(), infotwo.getDescription());
    }

    private boolean infoStringEquals(String sone, String stwo) {
        boolean result = false;
        if (sone == null && stwo == null) {
            result = true;
        } else if (sone != null && sone.equals(stwo)) {
            result = true;
        }
        return result;
    }
}

