/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class MBeanServerPermission
extends BasicPermission {
    private static final long serialVersionUID = -5661980843569388590L;
    private transient ArrayList targets;
    private transient boolean wildcard;
    private static Set set = new HashSet();

    public MBeanServerPermission(String name) {
        this(name, null);
    }

    public MBeanServerPermission(String name, String actions) {
        super(name);
        if (actions != null && !actions.equals("")) {
            throw new IllegalArgumentException("Action is non null and non empty");
        }
        this.parseName(name);
    }

    public int hashCode() {
        return this.targets.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        try {
            MBeanServerPermission other = (MBeanServerPermission)obj;
            return this.targets.equals(other.targets);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean implies(Permission p) {
        if (p == null) {
            return false;
        }
        if (this.getClass() != p.getClass()) {
            return false;
        }
        MBeanServerPermission other = (MBeanServerPermission)p;
        if (this.wildcard) {
            return true;
        }
        if (other.wildcard) {
            return false;
        }
        if (this.targets.containsAll(other.targets)) {
            return true;
        }
        if (other.targets.contains("newMBeanServer") && this.targets.contains("createMBeanServer")) {
            for (int i = 0; i < other.targets.size(); ++i) {
                Object perm = other.targets.get(i);
                if ("newMBeanServer".equals(perm) || this.targets.contains(perm)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void parseName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Permission name cannot be null");
        }
        if ((name = name.trim()).length() == 0) {
            throw new IllegalArgumentException("Permission name cannot be empty");
        }
        if ((name.startsWith("*") || name.endsWith("*")) && name.indexOf(",") < 0 && name.length() > 1) {
            throw new IllegalArgumentException("Permission name cannot be contain * and other characters");
        }
        this.targets = new ArrayList();
        StringTokenizer tokenizer = new StringTokenizer(name, ",");
        while (tokenizer.hasMoreTokens()) {
            String target = tokenizer.nextToken().trim();
            if (target.length() == 0) continue;
            if ("*".equals(target)) {
                this.targets.clear();
                this.wildcard = true;
                return;
            }
            if (set.contains(target)) {
                this.targets.add(target);
                continue;
            }
            throw new IllegalArgumentException("Permission name cannot contain method names other than createMBeanServer, newMBeanServer, releaseMBeanServer, findMBeanServer");
        }
        if (this.targets.size() < 1) {
            throw new IllegalArgumentException("Permission name does not contain targets");
        }
        Collections.sort(this.targets);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.parseName(this.getName());
    }

    public PermissionCollection newPermissionCollection() {
        return new MBeanServerPermissionCollection();
    }

    static {
        set.add("newMBeanServer");
        set.add("findMBeanServer");
        set.add("createMBeanServer");
        set.add("releaseMBeanServer");
    }

    final class MBeanServerPermissionCollection
    extends PermissionCollection {
        private Vector perms;

        public void add(Permission permission) {
            if (!(permission instanceof MBeanServerPermission)) {
                String s = "Permission not an MBeanServerPermission: " + permission;
                throw new IllegalArgumentException(s);
            }
            if (this.isReadOnly()) {
                throw new SecurityException("Read-only permission collection");
            }
            MBeanServerPermission mbeanserverpermission = (MBeanServerPermission)permission;
            if (this.perms == null) {
                this.perms = new Vector();
                this.perms.add(permission);
            } else if (!this.implies(permission)) {
                this.perms.add(permission);
            }
        }

        public boolean implies(Permission permission) {
            if (permission == null || !(permission instanceof MBeanServerPermission)) {
                return false;
            }
            boolean implies = false;
            if (this.perms != null) {
                Iterator iter = this.perms.iterator();
                while (iter.hasNext()) {
                    MBeanServerPermission per = (MBeanServerPermission)iter.next();
                    if (!per.implies(permission)) continue;
                    implies = true;
                    break;
                }
            }
            return implies;
        }

        public Enumeration elements() {
            Enumeration<Object> enumeration = null;
            enumeration = this.perms == null ? Collections.enumeration(Collections.EMPTY_SET) : this.perms.elements();
            return enumeration;
        }
    }
}

