/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.QueryExp;
import mx4j.util.Utils;

public class ObjectName
implements QueryExp,
Serializable {
    private static final long serialVersionUID = 1081892073854801359L;
    private static WeakObjectNameCache cache = new WeakObjectNameCache();
    private transient String domain;
    private transient Hashtable properties;
    private transient String propertiesString;
    private transient boolean isPropertyPattern;
    private transient boolean isDomainPattern;
    private transient int hashCode;
    private transient String canonicalName;
    static /* synthetic */ Class class$javax$management$ObjectName;

    public ObjectName(String name) throws MalformedObjectNameException {
        if (name == null) {
            throw new NullPointerException("ObjectName 'name' parameter can't be null");
        }
        if (name.compareTo("") == 0) {
            name = "*:*";
        }
        this.parse(name);
    }

    public ObjectName(String domain, Hashtable table) throws MalformedObjectNameException {
        if (domain == null) {
            throw new NullPointerException("ObjectName 'domain' parameter can't be null");
        }
        if (table == null) {
            throw new NullPointerException("ObjectName 'table' parameter can't be null");
        }
        if (!this.isDomainValid(domain)) {
            throw new MalformedObjectNameException("Invalid domain: " + domain);
        }
        if (table.isEmpty()) {
            throw new MalformedObjectNameException("Properties table cannot be empty");
        }
        Iterator i = table.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = entry.getKey().toString();
            if (!this.isKeyValid(key)) {
                throw new MalformedObjectNameException("Invalid key: " + key);
            }
            Object value = entry.getValue();
            if (!(value instanceof String)) {
                throw new MalformedObjectNameException("Property values must be Strings");
            }
            String strvalue = value.toString();
            if (this.isValueValid(strvalue)) continue;
            throw new MalformedObjectNameException("Invalid value: " + strvalue);
        }
        this.init(domain, table);
    }

    public ObjectName(String domain, String key, String value) throws MalformedObjectNameException {
        if (domain == null) {
            throw new NullPointerException("ObjectName 'domain' parameter can't be null");
        }
        if (key == null) {
            throw new NullPointerException("ObjectName 'key' parameter can't be null");
        }
        if (value == null) {
            throw new NullPointerException("ObjectName 'value' parameter can't be null");
        }
        if (!this.isDomainValid(domain)) {
            throw new MalformedObjectNameException("Invalid domain: " + domain);
        }
        if (!this.isKeyValid(key)) {
            throw new MalformedObjectNameException("Invalid key: " + key);
        }
        if (!this.isValueValid(value)) {
            throw new MalformedObjectNameException("Invalid value: " + value);
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put(key, value);
        this.init(domain, table);
    }

    public boolean apply(ObjectName name) {
        boolean result = name.isPattern() ? false : (this.isPattern() ? this.domainsMatch(this, name) && this.propertiesMatch(this, name) : this.equals(name));
        return result;
    }

    private boolean domainsMatch(ObjectName name1, ObjectName name2) {
        String thisDomain = name1.getDomain();
        boolean thisPattern = name1.isDomainPattern();
        String otherDomain = name2.getDomain();
        boolean otherPattern = name2.isDomainPattern();
        if (!thisPattern && otherPattern) {
            return false;
        }
        if (!(thisPattern || otherPattern || thisDomain.equals(otherDomain))) {
            return false;
        }
        return Utils.wildcardMatch((String)thisDomain, (String)otherDomain);
    }

    private boolean propertiesMatch(ObjectName name1, ObjectName name2) {
        Hashtable thisProperties = name1.getKeyPropertyList();
        boolean thisPattern = name1.isPropertyPattern();
        Hashtable otherProperties = name2.getKeyPropertyList();
        boolean otherPattern = name2.isPropertyPattern();
        if (!thisPattern && otherPattern) {
            return false;
        }
        if (!(thisPattern || otherPattern || thisProperties.equals(otherProperties))) {
            return false;
        }
        return !thisPattern || otherProperties.entrySet().containsAll(thisProperties.entrySet());
    }

    public void setMBeanServer(MBeanServer server) {
    }

    public String getCanonicalKeyPropertyListString() {
        TreeMap map = new TreeMap();
        map.putAll(this.properties);
        return this.convertPropertiesToString(map);
    }

    public String getCanonicalName() {
        if (this.canonicalName == null) {
            this.canonicalName = this.getName(true);
        }
        return this.canonicalName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getKeyProperty(String key) {
        return (String)this.properties.get(key);
    }

    public Hashtable getKeyPropertyList() {
        return (Hashtable)this.properties.clone();
    }

    public String getKeyPropertyListString() {
        return this.propertiesString;
    }

    public boolean isPattern() {
        return this.isDomainPattern() || this.isPropertyPattern();
    }

    public boolean isPropertyPattern() {
        return this.isPropertyPattern;
    }

    public boolean isDomainPattern() {
        return this.isDomainPattern;
    }

    public static ObjectName getInstance(ObjectName name) {
        if (name.getClass() == (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = ObjectName.class$("javax.management.ObjectName")) : class$javax$management$ObjectName)) {
            return name;
        }
        try {
            return ObjectName.getInstance(name.getCanonicalName());
        }
        catch (MalformedObjectNameException x) {
            throw new IllegalArgumentException(x.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectName getInstance(String name) throws MalformedObjectNameException {
        ObjectName cached = null;
        WeakObjectNameCache weakObjectNameCache = cache;
        synchronized (weakObjectNameCache) {
            cached = cache.get(name);
        }
        if (cached != null) {
            return cached;
        }
        return new ObjectName(name);
    }

    public static ObjectName getInstance(String domain, Hashtable table) throws MalformedObjectNameException {
        return new ObjectName(domain, table);
    }

    public static ObjectName getInstance(String domain, String key, String value) throws MalformedObjectNameException {
        return new ObjectName(domain, key, value);
    }

    public static String quote(String value) {
        StringBuffer buffer = new StringBuffer("\"");
        block7: for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\n': {
                    buffer.append("\\n");
                    continue block7;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block7;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block7;
                }
                case '*': {
                    buffer.append("\\*");
                    continue block7;
                }
                case '?': {
                    buffer.append("\\?");
                    continue block7;
                }
                default: {
                    buffer.append(ch);
                }
            }
        }
        buffer.append("\"");
        return buffer.toString();
    }

    public static String unquote(String value) throws IllegalArgumentException {
        int lastIndex = value.length() - 1;
        if (lastIndex < 1 || value.charAt(0) != '\"' || value.charAt(lastIndex) != '\"') {
            throw new IllegalArgumentException("The given string is not quoted");
        }
        StringBuffer buffer = new StringBuffer();
        block10: for (int i = 1; i < lastIndex; ++i) {
            char ch = value.charAt(i);
            if (ch == '\\') {
                if (++i == lastIndex) {
                    throw new IllegalArgumentException("Invalid escape sequence at the end of quoted string");
                }
                ch = value.charAt(i);
                switch (ch) {
                    case 'n': {
                        buffer.append("\n");
                        continue block10;
                    }
                    case '\"': {
                        buffer.append("\"");
                        continue block10;
                    }
                    case '\\': {
                        buffer.append("\\");
                        continue block10;
                    }
                    case '*': {
                        buffer.append("*");
                        continue block10;
                    }
                    case '?': {
                        buffer.append("?");
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid escape sequence: \\" + ch);
                    }
                }
            }
            switch (ch) {
                case '\n': 
                case '\"': 
                case '*': 
                case '?': {
                    throw new IllegalArgumentException("Invalid unescaped character: " + ch);
                }
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(String name) throws MalformedObjectNameException {
        String domain;
        boolean isSubclass;
        boolean bl = isSubclass = this.getClass() != (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = ObjectName.class$("javax.management.ObjectName")) : class$javax$management$ObjectName);
        if (!isSubclass) {
            ObjectName cached = null;
            WeakObjectNameCache weakObjectNameCache = cache;
            synchronized (weakObjectNameCache) {
                cached = cache.get(name);
            }
            if (cached != null) {
                this.domain = cached.getDomain();
                this.properties = cached.getKeyPropertyList();
                this.propertiesString = cached.getKeyPropertyListString();
                this.isDomainPattern = cached.isDomainPattern();
                this.isPropertyPattern = cached.isPropertyPattern();
                this.canonicalName = cached.getCanonicalName();
                return;
            }
        }
        if (!this.isDomainValid(domain = this.parseDomain(name))) {
            throw new MalformedObjectNameException("Invalid domain: " + domain);
        }
        String properties = this.parseProperties(name);
        Hashtable table = this.convertStringToProperties(properties);
        this.init(domain, table);
        if (!isSubclass) {
            WeakObjectNameCache weakObjectNameCache = cache;
            synchronized (weakObjectNameCache) {
                cache.put(name, this);
            }
        }
    }

    private String parseDomain(String objectName) throws MalformedObjectNameException {
        int colon = objectName.indexOf(58);
        if (colon < 0) {
            throw new MalformedObjectNameException("Missing ':' character in ObjectName");
        }
        String domain = objectName.substring(0, colon);
        return domain;
    }

    private boolean isDomainValid(String domain) {
        if (domain == null) {
            return false;
        }
        if (domain.indexOf(10) >= 0) {
            return false;
        }
        return domain.indexOf(":") < 0;
    }

    private String parseProperties(String objectName) throws MalformedObjectNameException {
        int colon = objectName.indexOf(58);
        if (colon < 0) {
            throw new MalformedObjectNameException("Missing ':' character in ObjectName");
        }
        String list = objectName.substring(colon + 1);
        return list;
    }

    private Hashtable convertStringToProperties(String properties) throws MalformedObjectNameException {
        if (properties.length() < 1) {
            throw new MalformedObjectNameException("Missing properties");
        }
        if (properties.trim().endsWith(",")) {
            throw new MalformedObjectNameException("Missing property after trailing comma");
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        boolean firstTime = true;
        StringBuffer propertiesString = new StringBuffer();
        StringBuffer toBeParsed = new StringBuffer(properties);
        while (toBeParsed.length() > 0) {
            String key = this.parsePropertyKey(toBeParsed);
            String value = null;
            value = "*".equals(key) ? "*" : this.parsePropertyValue(toBeParsed);
            String old = table.put(key, value);
            if (old != null) {
                throw new MalformedObjectNameException("Duplicate key not allowed: " + key);
            }
            if ("*".equals(key)) continue;
            if (!firstTime) {
                propertiesString.append(",");
            } else {
                firstTime = false;
            }
            propertiesString.append(key).append("=").append(value);
        }
        this.propertiesString = propertiesString.toString();
        return table;
    }

    private String parsePropertyKey(StringBuffer buffer) throws MalformedObjectNameException {
        String toBeParsed = buffer.toString();
        int equal = toBeParsed.indexOf(61);
        int comma = toBeParsed.indexOf(44);
        if (equal < 0 && comma < 0) {
            String key = toBeParsed.trim();
            if (!"*".equals(key)) {
                throw new MalformedObjectNameException("Invalid key: '" + key + "'");
            }
            buffer.setLength(0);
            return key;
        }
        if (comma >= 0 && comma < equal) {
            String key = toBeParsed.substring(0, comma).trim();
            if (!"*".equals(key)) {
                throw new MalformedObjectNameException("Invalid key: '" + key + "'");
            }
            buffer.delete(0, comma + 1);
            return key;
        }
        String key = toBeParsed.substring(0, equal);
        if (!this.isKeyValid(key)) {
            throw new MalformedObjectNameException("Invalid key: '" + key + "'");
        }
        buffer.delete(0, equal + 1);
        return key;
    }

    private boolean isKeyValid(String key) {
        if (key == null) {
            return false;
        }
        if (key.trim().length() < 1) {
            return false;
        }
        if (key.indexOf(10) >= 0) {
            return false;
        }
        if (key.indexOf(44) >= 0) {
            return false;
        }
        if (key.indexOf(61) >= 0) {
            return false;
        }
        if (key.indexOf(42) >= 0) {
            return false;
        }
        if (key.indexOf(63) >= 0) {
            return false;
        }
        return key.indexOf(58) < 0;
    }

    private String parsePropertyValue(StringBuffer buffer) throws MalformedObjectNameException {
        String toBeParsed = buffer.toString();
        if (toBeParsed.trim().startsWith("\"")) {
            int start = toBeParsed.indexOf(34) + 1;
            int endQuote = -1;
            while ((endQuote = toBeParsed.indexOf(34, start)) >= 0) {
                int bslashes = this.countBackslashesBackwards(toBeParsed, endQuote);
                if (bslashes % 2 != 0) {
                    start = endQuote + 1;
                    continue;
                }
                String value = toBeParsed.substring(0, endQuote + 1).trim();
                if (!this.isValueValid(value)) {
                    throw new MalformedObjectNameException("Invalid value: " + value);
                }
                buffer.delete(0, endQuote + 1);
                toBeParsed = buffer.toString();
                if (toBeParsed.trim().startsWith(",")) {
                    int comma = toBeParsed.indexOf(44);
                    buffer.delete(0, comma + 1);
                    return value;
                }
                if (toBeParsed.trim().length() == 0) {
                    buffer.setLength(0);
                    return value;
                }
                throw new MalformedObjectNameException("Garbage after quoted value: " + toBeParsed);
            }
            throw new MalformedObjectNameException("Missing closing quote: " + toBeParsed);
        }
        int comma = toBeParsed.indexOf(44);
        if (comma >= 0) {
            String value = toBeParsed.substring(0, comma);
            if (!this.isValueValid(value)) {
                throw new MalformedObjectNameException("Invalid value: '" + value + "'");
            }
            buffer.delete(0, comma + 1);
            return value;
        }
        String value = toBeParsed;
        if (!this.isValueValid(value)) {
            throw new MalformedObjectNameException("Invalid value: '" + value + "'");
        }
        buffer.setLength(0);
        return value;
    }

    private boolean isValueValid(String value) {
        if (value == null) {
            return false;
        }
        if (value.length() == 0) {
            return false;
        }
        if (value.indexOf(10) >= 0) {
            return false;
        }
        if (value.trim().startsWith("\"") && value.trim().endsWith("\"")) {
            return this.isValidQuotedValue(value.substring(1, value.length() - 1));
        }
        if (value.trim().startsWith("\"") && !value.trim().endsWith("\"") || !value.trim().startsWith("\"") && value.trim().endsWith("\"")) {
            return false;
        }
        if (value.indexOf(44) >= 0) {
            return false;
        }
        if (value.indexOf(61) >= 0) {
            return false;
        }
        if (value.indexOf(58) >= 0) {
            return false;
        }
        if (value.indexOf(34) >= 0) {
            return false;
        }
        if (value.indexOf(42) >= 0) {
            return false;
        }
        return value.indexOf(63) < 0;
    }

    private boolean isValidQuotedValue(String value) {
        boolean result = true;
        int pos = 0;
        block6: while (pos < value.length() && result) {
            char nextchar = value.charAt(pos);
            if (nextchar == '\\') {
                if (pos == value.length() - 1) {
                    result = false;
                    continue;
                }
                switch (value.charAt(pos + 1)) {
                    case '\"': 
                    case '*': 
                    case '?': 
                    case '\\': 
                    case 'n': {
                        pos += 2;
                        continue block6;
                    }
                }
                result = false;
                continue;
            }
            switch (nextchar) {
                case '\"': 
                case '*': 
                case '?': {
                    result = false;
                    continue block6;
                }
            }
            ++pos;
        }
        return result;
    }

    private int countBackslashesBackwards(String string, int from) {
        int bslashCount = 0;
        while (--from >= 0 && string.charAt(from) == '\\') {
            ++bslashCount;
        }
        return bslashCount;
    }

    private void init(String domain, Hashtable properties) {
        this.domain = domain;
        this.initDomain(domain);
        this.properties = properties;
        this.initProperties(properties);
        if (this.propertiesString == null) {
            this.propertiesString = this.convertPropertiesToString(properties);
        }
    }

    private int computeHashCode() {
        int hash = this.getDomain().hashCode();
        hash ^= this.properties.hashCode();
        return hash ^= new Boolean(this.isPropertyPattern()).hashCode();
    }

    private void initDomain(String domain) {
        if (domain.indexOf(42) >= 0 || domain.indexOf(63) >= 0) {
            this.isDomainPattern = true;
        }
    }

    private void initProperties(Hashtable properties) {
        if (properties.containsKey("*")) {
            properties.remove("*");
            this.isPropertyPattern = true;
        }
    }

    private String convertPropertiesToString(Map properties) {
        StringBuffer b = new StringBuffer();
        boolean firstTime = true;
        Iterator i = properties.entrySet().iterator();
        while (i.hasNext()) {
            if (!firstTime) {
                b.append(",");
            } else {
                firstTime = false;
            }
            Map.Entry entry = i.next();
            b.append(entry.getKey());
            b.append("=");
            b.append(entry.getValue());
        }
        return b.toString();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.computeHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        try {
            ObjectName other = (ObjectName)obj;
            Hashtable otherprops = (Hashtable)other.properties.clone();
            return this.getDomain().equals(other.getDomain()) && this.properties.equals(otherprops) && this.isPropertyPattern() == other.isPropertyPattern();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        return this.getName(false);
    }

    private String getName(boolean canonical) {
        StringBuffer buffer = new StringBuffer(this.getDomain()).append(":");
        buffer.append(canonical ? this.getCanonicalKeyPropertyListString() : this.getKeyPropertyListString());
        if (this.isPropertyPattern()) {
            if (this.properties.isEmpty()) {
                buffer.append("*");
            } else {
                buffer.append(",*");
            }
        }
        return buffer.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        String name = this.getName(false);
        out.writeObject(name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String objectName = (String)in.readObject();
        try {
            this.parse(objectName);
        }
        catch (MalformedObjectNameException x) {
            throw new InvalidObjectException("String representing the ObjectName is not a valid ObjectName: " + x.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class WeakObjectNameCache {
        private ReferenceQueue queue = new ReferenceQueue();
        private HashMap map = new HashMap();

        private WeakObjectNameCache() {
        }

        public void put(String key, ObjectName value) {
            this.cleanup();
            this.map.put(key, WeakValue.create(key, value, this.queue));
        }

        public ObjectName get(String key) {
            this.cleanup();
            WeakValue value = (WeakValue)this.map.get(key);
            if (value == null) {
                return null;
            }
            return (ObjectName)value.get();
        }

        private void cleanup() {
            WeakValue ref = null;
            while ((ref = (WeakValue)this.queue.poll()) != null) {
                this.map.remove(ref.getKey());
            }
        }

        private static final class WeakValue
        extends WeakReference {
            private Object key;

            public static WeakValue create(Object key, Object value, ReferenceQueue queue) {
                if (value == null) {
                    return null;
                }
                return new WeakValue(key, value, queue);
            }

            private WeakValue(Object key, Object value, ReferenceQueue queue) {
                super(value, queue);
                this.key = key;
            }

            public Object getKey() {
                return this.key;
            }
        }
    }
}

