/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import mx4j.AbstractDynamicMBean;
import mx4j.server.MBeanIntrospector;
import mx4j.server.MBeanMetaData;

public class StandardMBean
implements DynamicMBean {
    private MBeanMetaData metadata;
    private MBeanInfo info;
    private DynamicMBean support;

    public StandardMBean(Object implementation, Class management) throws NotCompliantMBeanException {
        this(implementation, management, false);
    }

    protected StandardMBean(Class managementInterface) throws NotCompliantMBeanException {
        this(null, managementInterface, true);
    }

    private StandardMBean(Object implementation, Class management, boolean useThis) throws NotCompliantMBeanException {
        if (useThis) {
            implementation = this;
        }
        if (implementation == null) {
            throw new IllegalArgumentException("Implementation cannot be null");
        }
        if (management != null && !management.isInterface()) {
            throw new NotCompliantMBeanException("Class " + management + " is not an interface");
        }
        this.metadata = this.introspectMBean(implementation, management);
        if (this.metadata == null) {
            throw new NotCompliantMBeanException("StandardMBean is not compliant");
        }
        this.support = new StandardMBeanSupport();
    }

    public void setImplementation(Object implementation) throws NotCompliantMBeanException {
        if (implementation == null) {
            throw new IllegalArgumentException("Implementation cannot be null");
        }
        Class management = this.getMBeanInterface();
        if (!management.isInstance(implementation)) {
            throw new NotCompliantMBeanException("Implementation " + implementation + " does not implement interface " + management);
        }
        this.metadata.mbean = implementation;
    }

    public Object getImplementation() {
        return this.metadata.mbean;
    }

    public final Class getMBeanInterface() {
        return this.metadata.management;
    }

    public Class getImplementationClass() {
        return this.metadata.mbean.getClass();
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.support.getAttribute(attribute);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.support.setAttribute(attribute);
    }

    public AttributeList getAttributes(String[] attributes) {
        return this.support.getAttributes(attributes);
    }

    public AttributeList setAttributes(AttributeList attributes) {
        return this.support.setAttributes(attributes);
    }

    public Object invoke(String method, Object[] arguments, String[] params) throws MBeanException, ReflectionException {
        return this.support.invoke(method, arguments, params);
    }

    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = this.getCachedMBeanInfo();
        if (info == null) {
            info = this.setupMBeanInfo(this.metadata.info);
            this.cacheMBeanInfo(info);
        }
        return info;
    }

    protected String getClassName(MBeanInfo info) {
        return info == null ? null : info.getClassName();
    }

    protected String getDescription(MBeanInfo info) {
        return info == null ? null : info.getDescription();
    }

    protected String getDescription(MBeanFeatureInfo info) {
        return info == null ? null : info.getDescription();
    }

    protected String getDescription(MBeanAttributeInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected String getDescription(MBeanConstructorInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected String getDescription(MBeanOperationInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected String getDescription(MBeanConstructorInfo constructor, MBeanParameterInfo param, int sequence) {
        return param == null ? null : param.getDescription();
    }

    protected String getDescription(MBeanOperationInfo operation, MBeanParameterInfo param, int sequence) {
        return param == null ? null : param.getDescription();
    }

    protected String getParameterName(MBeanConstructorInfo constructor, MBeanParameterInfo param, int sequence) {
        return param == null ? null : param.getName();
    }

    protected String getParameterName(MBeanOperationInfo operation, MBeanParameterInfo param, int sequence) {
        return param == null ? null : param.getName();
    }

    protected int getImpact(MBeanOperationInfo info) {
        return info == null ? 3 : info.getImpact();
    }

    protected MBeanConstructorInfo[] getConstructors(MBeanConstructorInfo[] constructors, Object implementation) {
        if (implementation == this || implementation == null) {
            return constructors;
        }
        return null;
    }

    protected MBeanInfo getCachedMBeanInfo() {
        return this.info;
    }

    protected void cacheMBeanInfo(MBeanInfo info) {
        this.info = info;
    }

    private MBeanInfo setupMBeanInfo(MBeanInfo info) {
        String clsName = this.getClassName(info);
        String description = this.getDescription(info);
        MBeanConstructorInfo[] ctors = this.setupConstructors(info.getConstructors());
        MBeanAttributeInfo[] attrs = this.setupAttributes(info.getAttributes());
        MBeanOperationInfo[] opers = this.setupOperations(info.getOperations());
        MBeanNotificationInfo[] notifs = this.setupNotifications(info.getNotifications());
        return new MBeanInfo(clsName, description, attrs, ctors, opers, notifs);
    }

    private MBeanConstructorInfo[] setupConstructors(MBeanConstructorInfo[] originalCtors) {
        MBeanConstructorInfo[] ctors = this.getConstructors(originalCtors, this.getImplementation());
        if (ctors == null) {
            return null;
        }
        MBeanConstructorInfo[] newCtors = new MBeanConstructorInfo[ctors.length];
        for (int i = 0; i < ctors.length; ++i) {
            MBeanConstructorInfo ctor = ctors[i];
            if (ctor == null) continue;
            MBeanParameterInfo[] newParams = null;
            MBeanParameterInfo[] params = ctor.getSignature();
            if (params != null) {
                newParams = new MBeanParameterInfo[params.length];
                for (int j = 0; j < params.length; ++j) {
                    MBeanParameterInfo param = params[j];
                    if (param == null) continue;
                    String paramName = this.getParameterName(ctor, param, j);
                    String paramDescr = this.getDescription(ctor, param, j);
                    newParams[j] = new MBeanParameterInfo(paramName, param.getType(), paramDescr);
                }
            }
            String ctorDescr = this.getDescription(ctor);
            newCtors[i] = new MBeanConstructorInfo(ctor.getName(), ctorDescr, newParams);
        }
        return newCtors;
    }

    private MBeanAttributeInfo[] setupAttributes(MBeanAttributeInfo[] attrs) {
        if (attrs == null) {
            return null;
        }
        MBeanAttributeInfo[] newAttrs = new MBeanAttributeInfo[attrs.length];
        for (int i = 0; i < attrs.length; ++i) {
            MBeanAttributeInfo attr = attrs[i];
            if (attr == null) continue;
            String attrDescr = this.getDescription(attr);
            newAttrs[i] = new MBeanAttributeInfo(attr.getName(), attr.getType(), attrDescr, attr.isReadable(), attr.isWritable(), attr.isIs());
        }
        return newAttrs;
    }

    private MBeanOperationInfo[] setupOperations(MBeanOperationInfo[] opers) {
        if (opers == null) {
            return null;
        }
        MBeanOperationInfo[] newOpers = new MBeanOperationInfo[opers.length];
        for (int i = 0; i < opers.length; ++i) {
            MBeanOperationInfo oper = opers[i];
            if (oper == null) continue;
            MBeanParameterInfo[] newParams = null;
            MBeanParameterInfo[] params = oper.getSignature();
            if (params != null) {
                newParams = new MBeanParameterInfo[params.length];
                for (int j = 0; j < params.length; ++j) {
                    MBeanParameterInfo param = params[j];
                    if (param == null) continue;
                    String paramName = this.getParameterName(oper, param, j);
                    String paramDescr = this.getDescription(oper, param, j);
                    newParams[j] = new MBeanParameterInfo(paramName, param.getType(), paramDescr);
                }
            }
            String operDescr = this.getDescription(oper);
            int operImpact = this.getImpact(oper);
            newOpers[i] = new MBeanOperationInfo(oper.getName(), operDescr, newParams, oper.getReturnType(), operImpact);
        }
        return newOpers;
    }

    private MBeanNotificationInfo[] setupNotifications(MBeanNotificationInfo[] notifs) {
        return notifs == null ? null : notifs;
    }

    private MBeanMetaData introspectMBean(Object implementation, Class management) {
        MBeanMetaData metadata = new MBeanMetaData();
        metadata.mbean = implementation;
        metadata.classloader = implementation.getClass().getClassLoader();
        metadata.standard = true;
        if (management != null) {
            metadata.management = management;
        }
        MBeanIntrospector introspector = new MBeanIntrospector();
        introspector.introspect(metadata);
        if (!introspector.isMBeanCompliant(metadata)) {
            return null;
        }
        return metadata;
    }

    private class StandardMBeanSupport
    extends AbstractDynamicMBean {
        private StandardMBeanSupport() {
        }

        public synchronized MBeanInfo getMBeanInfo() {
            return StandardMBean.this.getMBeanInfo();
        }

        protected Object getResource() {
            return StandardMBean.this.getImplementation();
        }
    }
}

