/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.management.Descriptor;
import javax.management.DescriptorAccess;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class ModelMBeanInfoSupport
extends MBeanInfo
implements ModelMBeanInfo,
Serializable {
    private static final long serialVersionUID = -1935722590756516193L;
    private Descriptor modelMBeanDescriptor;
    private MBeanAttributeInfo[] modelMBeanAttributes;
    private MBeanConstructorInfo[] modelMBeanConstructors;
    private MBeanNotificationInfo[] modelMBeanNotifications;
    private MBeanOperationInfo[] modelMBeanOperations;

    public ModelMBeanInfoSupport(String className, String description, ModelMBeanAttributeInfo[] attributes, ModelMBeanConstructorInfo[] constructors, ModelMBeanOperationInfo[] operations, ModelMBeanNotificationInfo[] notifications) {
        this(className, description, attributes, constructors, operations, notifications, null);
    }

    public ModelMBeanInfoSupport(String className, String description, ModelMBeanAttributeInfo[] attributes, ModelMBeanConstructorInfo[] constructors, ModelMBeanOperationInfo[] operations, ModelMBeanNotificationInfo[] notifications, Descriptor mbeanDescriptor) {
        super(className, description, attributes, constructors, operations, notifications);
        this.initialize(attributes, constructors, operations, notifications);
        this.checkAndSetDescriptor(mbeanDescriptor);
    }

    private void initialize(ModelMBeanAttributeInfo[] attributes, ModelMBeanConstructorInfo[] constructors, ModelMBeanOperationInfo[] operations, ModelMBeanNotificationInfo[] notifications) {
        this.modelMBeanAttributes = attributes == null ? new ModelMBeanAttributeInfo[0] : attributes;
        this.modelMBeanConstructors = constructors == null ? new ModelMBeanConstructorInfo[0] : constructors;
        this.modelMBeanNotifications = notifications == null ? new ModelMBeanNotificationInfo[0] : notifications;
        this.modelMBeanOperations = operations == null ? new ModelMBeanOperationInfo[0] : operations;
    }

    public ModelMBeanInfoSupport(ModelMBeanInfo model) {
        super(model.getClassName(), model.getDescription(), model.getAttributes(), model.getConstructors(), model.getOperations(), model.getNotifications());
        ModelMBeanNotificationInfo[] notifications;
        ModelMBeanOperationInfo[] operations;
        ModelMBeanConstructorInfo[] constructors;
        ModelMBeanAttributeInfo[] attributes = (ModelMBeanAttributeInfo[])model.getAttributes();
        if (attributes != null) {
            this.modelMBeanAttributes = new ModelMBeanAttributeInfo[attributes.length];
            for (int i = 0; i < attributes.length; ++i) {
                this.modelMBeanAttributes[i] = new ModelMBeanAttributeInfo(attributes[i]);
            }
        }
        if ((constructors = (ModelMBeanConstructorInfo[])model.getConstructors()) != null) {
            this.modelMBeanConstructors = new ModelMBeanConstructorInfo[constructors.length];
            for (int i = 0; i < constructors.length; ++i) {
                this.modelMBeanConstructors[i] = new ModelMBeanConstructorInfo(constructors[i].getName(), constructors[i].getDescription(), constructors[i].getSignature(), constructors[i].getDescriptor());
            }
        }
        if ((operations = (ModelMBeanOperationInfo[])model.getOperations()) != null) {
            this.modelMBeanOperations = new ModelMBeanOperationInfo[operations.length];
            for (int i = 0; i < operations.length; ++i) {
                this.modelMBeanOperations[i] = new ModelMBeanOperationInfo(operations[i]);
            }
        }
        if ((notifications = (ModelMBeanNotificationInfo[])model.getNotifications()) != null) {
            this.modelMBeanNotifications = new ModelMBeanNotificationInfo[notifications.length];
            for (int i = 0; i < notifications.length; ++i) {
                this.modelMBeanNotifications[i] = new ModelMBeanNotificationInfo(notifications[i]);
            }
        }
        Descriptor mBeanDescriptor = null;
        try {
            mBeanDescriptor = model.getMBeanDescriptor();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.checkAndSetDescriptor(mBeanDescriptor);
    }

    public Descriptor[] getDescriptors(String type) throws MBeanException, RuntimeOperationsException {
        if (type == null) {
            Descriptor[] attrs = this.getDescriptors("attribute");
            Descriptor[] opers = this.getDescriptors("operation");
            Descriptor[] ctors = this.getDescriptors("constructor");
            Descriptor[] notifs = this.getDescriptors("notification");
            Descriptor[] all = new Descriptor[attrs.length + opers.length + ctors.length + notifs.length + 1];
            int i = 0;
            all[i] = this.getMBeanDescriptor();
            System.arraycopy(attrs, 0, all, ++i, attrs.length);
            System.arraycopy(opers, 0, all, i += attrs.length, opers.length);
            System.arraycopy(ctors, 0, all, i += opers.length, ctors.length);
            System.arraycopy(notifs, 0, all, i += ctors.length, notifs.length);
            return all;
        }
        if (type.equals("attribute")) {
            MBeanAttributeInfo[] attrs = this.modelMBeanAttributes;
            if (attrs == null) {
                return new Descriptor[0];
            }
            Descriptor[] attributes = new Descriptor[attrs.length];
            for (int i = 0; i < attrs.length; ++i) {
                ModelMBeanAttributeInfo attr = (ModelMBeanAttributeInfo)attrs[i];
                attributes[i] = attr != null ? attr.getDescriptor() : null;
            }
            return attributes;
        }
        if (type.equals("operation")) {
            MBeanOperationInfo[] opers = this.modelMBeanOperations;
            if (opers == null) {
                return new Descriptor[0];
            }
            Descriptor[] operations = new Descriptor[opers.length];
            for (int i = 0; i < opers.length; ++i) {
                ModelMBeanOperationInfo oper = (ModelMBeanOperationInfo)opers[i];
                operations[i] = oper != null ? oper.getDescriptor() : null;
            }
            return operations;
        }
        if (type.equals("constructor")) {
            MBeanConstructorInfo[] ctors = this.modelMBeanConstructors;
            if (ctors == null) {
                return new Descriptor[0];
            }
            Descriptor[] constructors = new Descriptor[ctors.length];
            for (int i = 0; i < ctors.length; ++i) {
                ModelMBeanConstructorInfo ctor = (ModelMBeanConstructorInfo)ctors[i];
                constructors[i] = ctor != null ? ctor.getDescriptor() : null;
            }
            return constructors;
        }
        if (type.equals("notification")) {
            MBeanNotificationInfo[] notifs = this.modelMBeanNotifications;
            if (notifs == null) {
                return new Descriptor[0];
            }
            Descriptor[] notifications = new Descriptor[notifs.length];
            for (int i = 0; i < notifs.length; ++i) {
                ModelMBeanNotificationInfo notif = (ModelMBeanNotificationInfo)notifs[i];
                notifications[i] = notif != null ? notif.getDescriptor() : null;
            }
            return notifications;
        }
        if (type.equals("mbean")) {
            Descriptor[] notifications = new Descriptor[1];
            for (int i = 0; i < 1; ++i) {
                Descriptor desc;
                notifications[i] = desc = this.getMBeanDescriptor();
            }
            return notifications;
        }
        throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptor type"));
    }

    public void setDescriptors(Descriptor[] descriptors) throws MBeanException, RuntimeOperationsException {
        if (descriptors == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptors cannot be null"));
        }
        RuntimeOperationsException x = null;
        for (int i = 0; i < descriptors.length; ++i) {
            try {
                this.setDescriptor(descriptors[i], null);
                continue;
            }
            catch (RuntimeOperationsException ignored) {
                x = ignored;
            }
        }
        if (x != null) {
            throw x;
        }
    }

    public Descriptor getDescriptor(String name) throws MBeanException, RuntimeOperationsException {
        return this.getDescriptor(name, null);
    }

    public Descriptor getDescriptor(String name, String type) throws MBeanException, RuntimeOperationsException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor name cannot be null"));
        }
        if ("MBean".equals(type)) {
            return this.getMBeanDescriptor();
        }
        if (type != null) {
            Descriptor[] descrs = this.getDescriptors(type);
            for (int i = 0; i < descrs.length; ++i) {
                Descriptor descr = descrs[i];
                if (descr == null || !name.equals(descr.getFieldValue("name"))) continue;
                return descr;
            }
        } else {
            Descriptor result = this.findDescriptorByName(this.modelMBeanAttributes, name);
            if (result != null) {
                return result;
            }
            result = this.findDescriptorByName(this.modelMBeanConstructors, name);
            if (result != null) {
                return result;
            }
            result = this.findDescriptorByName(this.modelMBeanNotifications, name);
            if (result != null) {
                return result;
            }
            result = this.findDescriptorByName(this.modelMBeanOperations, name);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    public void setDescriptor(Descriptor descriptor, String descriptorType) throws MBeanException, RuntimeOperationsException {
        MBeanOperationInfo[] opers;
        String name;
        if (descriptor == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor must not be null"));
        }
        if (descriptorType == null) {
            descriptorType = (String)descriptor.getFieldValue("descriptorType");
            if (descriptorType == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Field descriptorType in the given descriptor is not valid"));
            }
            if (descriptorType.equals("operation")) {
                String role = (String)descriptor.getFieldValue("role");
                if (role == null) {
                    throw new RuntimeOperationsException(new IllegalArgumentException("Field role in the given descriptor is not valid"));
                }
                descriptorType = role;
            }
        }
        if ((name = (String)descriptor.getFieldValue("name")) == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Field name in the given descriptor is not valid"));
        }
        if (descriptorType.equals("MBean")) {
            this.setMBeanDescriptor(descriptor);
        } else if (descriptorType.equals("attribute")) {
            MBeanAttributeInfo[] attrs = this.modelMBeanAttributes;
            if (attrs != null) {
                boolean foundit = false;
                for (int i = 0; i < attrs.length && !foundit; ++i) {
                    ModelMBeanAttributeInfo attr = (ModelMBeanAttributeInfo)attrs[i];
                    if (attr == null || !name.equals(attr.getName())) continue;
                    attr.setDescriptor(descriptor);
                    foundit = true;
                }
                if (!foundit) {
                    throw new RuntimeOperationsException(new IllegalArgumentException("No such attribute"));
                }
            }
        } else if (descriptorType.equals("notification")) {
            MBeanNotificationInfo[] notifs = this.modelMBeanNotifications;
            if (notifs != null) {
                boolean foundit = false;
                for (int i = 0; i < notifs.length && !foundit; ++i) {
                    ModelMBeanNotificationInfo notif = (ModelMBeanNotificationInfo)notifs[i];
                    if (notif == null || !name.equals(notif.getName())) continue;
                    notif.setDescriptor(descriptor);
                    foundit = true;
                }
                if (!foundit) {
                    throw new RuntimeOperationsException(new IllegalArgumentException("No such notification"));
                }
            }
        } else if (descriptorType.equals("constructor")) {
            MBeanConstructorInfo[] ctors = this.modelMBeanConstructors;
            if (ctors != null) {
                boolean foundit = false;
                for (int i = 0; i < ctors.length && !foundit; ++i) {
                    ModelMBeanConstructorInfo ctor = (ModelMBeanConstructorInfo)ctors[i];
                    if (ctor == null || !name.equals(ctor.getName())) continue;
                    ctor.setDescriptor(descriptor);
                    foundit = true;
                }
                if (!foundit) {
                    throw new RuntimeOperationsException(new IllegalArgumentException("No such constructor"));
                }
            }
        } else if (descriptorType.equals("operation") && (opers = this.modelMBeanOperations) != null) {
            boolean foundit = false;
            for (int i = 0; i < opers.length && !foundit; ++i) {
                ModelMBeanOperationInfo oper = (ModelMBeanOperationInfo)opers[i];
                if (oper == null || !name.equals(oper.getName())) continue;
                oper.setDescriptor(descriptor);
                foundit = true;
            }
            if (!foundit) {
                throw new RuntimeOperationsException(new IllegalArgumentException("No such operation"));
            }
        }
    }

    public ModelMBeanAttributeInfo getAttribute(String name) throws MBeanException, RuntimeOperationsException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Name argument cannot be null"));
        }
        MBeanAttributeInfo[] attrs = this.modelMBeanAttributes;
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                ModelMBeanAttributeInfo attr = (ModelMBeanAttributeInfo)attrs[i];
                if (attr == null || !name.equals(attr.getName())) continue;
                return (ModelMBeanAttributeInfo)attr.clone();
            }
        }
        return null;
    }

    public ModelMBeanOperationInfo getOperation(String name) throws MBeanException, RuntimeOperationsException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Name argument cannot be null"));
        }
        MBeanOperationInfo[] opers = this.modelMBeanOperations;
        if (opers != null) {
            for (int i = 0; i < opers.length; ++i) {
                ModelMBeanOperationInfo oper = (ModelMBeanOperationInfo)opers[i];
                if (oper == null || !name.equals(oper.getName())) continue;
                return (ModelMBeanOperationInfo)oper.clone();
            }
        }
        return null;
    }

    public ModelMBeanConstructorInfo getConstructor(String name) throws MBeanException, RuntimeOperationsException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Name argument cannot be null"));
        }
        MBeanConstructorInfo[] ctors = this.modelMBeanConstructors;
        if (ctors != null) {
            for (int i = 0; i < ctors.length; ++i) {
                ModelMBeanConstructorInfo ctor = (ModelMBeanConstructorInfo)ctors[i];
                if (ctor == null || !name.equals(ctor.getName())) continue;
                return (ModelMBeanConstructorInfo)ctor.clone();
            }
        }
        return null;
    }

    public ModelMBeanNotificationInfo getNotification(String name) throws MBeanException, RuntimeOperationsException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Name argument cannot be null"));
        }
        MBeanNotificationInfo[] notifs = this.modelMBeanNotifications;
        if (notifs != null) {
            for (int i = 0; i < notifs.length; ++i) {
                ModelMBeanNotificationInfo notif = (ModelMBeanNotificationInfo)notifs[i];
                if (notif == null || !name.equals(notif.getName())) continue;
                return (ModelMBeanNotificationInfo)notif.clone();
            }
        }
        return null;
    }

    public Descriptor getMBeanDescriptor() throws MBeanException, RuntimeOperationsException {
        return (Descriptor)this.modelMBeanDescriptor.clone();
    }

    public void setMBeanDescriptor(Descriptor descriptor) throws MBeanException, RuntimeOperationsException {
        if (descriptor == null) {
            this.modelMBeanDescriptor = this.createDefaultMBeanDescriptor();
        } else if (this.isDescriptorValid(descriptor)) {
            this.modelMBeanDescriptor = (Descriptor)descriptor.clone();
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptor"));
        }
    }

    public MBeanConstructorInfo[] getConstructors() {
        MBeanConstructorInfo[] ctors = this.modelMBeanConstructors;
        if (ctors == null) {
            return null;
        }
        MBeanConstructorInfo[] constructors = new ModelMBeanConstructorInfo[ctors.length];
        for (int i = 0; i < ctors.length; ++i) {
            ModelMBeanConstructorInfo ctor = (ModelMBeanConstructorInfo)ctors[i];
            constructors[i] = ctor != null ? (ModelMBeanConstructorInfo)ctor.clone() : null;
        }
        return constructors;
    }

    public MBeanAttributeInfo[] getAttributes() {
        MBeanAttributeInfo[] attrs = this.modelMBeanAttributes;
        if (attrs == null) {
            return null;
        }
        MBeanAttributeInfo[] attributes = new ModelMBeanAttributeInfo[attrs.length];
        for (int i = 0; i < attrs.length; ++i) {
            ModelMBeanAttributeInfo attr = (ModelMBeanAttributeInfo)attrs[i];
            attributes[i] = attr != null ? (ModelMBeanAttributeInfo)attr.clone() : null;
        }
        return attributes;
    }

    public MBeanOperationInfo[] getOperations() {
        MBeanOperationInfo[] opers = this.modelMBeanOperations;
        if (opers == null) {
            return null;
        }
        MBeanOperationInfo[] operations = new ModelMBeanOperationInfo[opers.length];
        for (int i = 0; i < opers.length; ++i) {
            ModelMBeanOperationInfo oper = (ModelMBeanOperationInfo)opers[i];
            operations[i] = oper != null ? (ModelMBeanOperationInfo)oper.clone() : null;
        }
        return operations;
    }

    public MBeanNotificationInfo[] getNotifications() {
        MBeanNotificationInfo[] notifs = this.modelMBeanNotifications;
        if (notifs == null) {
            return null;
        }
        MBeanNotificationInfo[] notifications = new ModelMBeanNotificationInfo[notifs.length];
        for (int i = 0; i < notifs.length; ++i) {
            ModelMBeanNotificationInfo notif = (ModelMBeanNotificationInfo)notifs[i];
            notifications[i] = notif != null ? (ModelMBeanNotificationInfo)notif.clone() : null;
        }
        return notifications;
    }

    public Object clone() {
        ModelMBeanInfoSupport info = (ModelMBeanInfoSupport)super.clone();
        info.modelMBeanAttributes = this.getAttributes();
        info.modelMBeanConstructors = this.getConstructors();
        info.modelMBeanNotifications = this.getNotifications();
        info.modelMBeanOperations = this.getOperations();
        info.modelMBeanDescriptor = (Descriptor)this.modelMBeanDescriptor.clone();
        return info;
    }

    private void checkAndSetDescriptor(Descriptor descriptor) {
        if (descriptor == null) {
            this.modelMBeanDescriptor = this.createDefaultMBeanDescriptor();
        } else if (this.isDescriptorValid(descriptor)) {
            this.modelMBeanDescriptor = this.addRequiredFields(descriptor);
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid Descriptor"));
        }
    }

    private boolean isDescriptorValid(Descriptor descriptor) {
        if (!descriptor.isValid()) {
            return false;
        }
        List<String> names = Arrays.asList(descriptor.getFieldNames());
        if (!names.contains("name") || !names.contains("descriptortype")) {
            return false;
        }
        String desctype = (String)descriptor.getFieldValue("descriptortype");
        return desctype.compareToIgnoreCase("mbean") == 0;
    }

    private Descriptor createDefaultMBeanDescriptor() {
        String[] names = new String[]{"name", "descriptorType", "displayName", "persistPolicy", "log", "visibility"};
        int index = this.getClassName().lastIndexOf(46) + 1;
        Object[] values = new Object[]{this.getClassName().substring(index), "mbean", this.getClassName(), "never", "F", "1"};
        return new DescriptorSupport(names, values);
    }

    private Descriptor findDescriptorByName(MBeanFeatureInfo[] features, String name) {
        if (features != null) {
            for (int i = 0; i < features.length; ++i) {
                if (features[i] == null || !features[i].getName().equals(name) || !(features[i] instanceof DescriptorAccess)) continue;
                return ((DescriptorAccess)((Object)features[i])).getDescriptor();
            }
        }
        return null;
    }

    private Descriptor addRequiredFields(Descriptor d) {
        Descriptor result = (Descriptor)d.clone();
        String[] reqfields = new String[]{"displayname", "persistpolicy", "log", "visibility"};
        String[] defvalues = new String[]{(String)d.getFieldValue("name"), "never", "F", "1"};
        List<String> fields = Arrays.asList(d.getFieldNames());
        for (int i = 0; i < reqfields.length; ++i) {
            if (fields.contains(reqfields[i])) continue;
            result.setField(reqfields[i], defvalues[i]);
        }
        return result;
    }
}

