/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import mx4j.remote.JMXServiceURLCodec;

public class JMXServiceURL
implements Serializable {
    private String protocol;
    private String host;
    private int port;
    private String urlPath;
    private transient Map attributes;
    private transient int hash;

    public JMXServiceURL(String url) throws MalformedURLException {
        if (url == null) {
            throw new NullPointerException("Null JMXServiceURL string");
        }
        this.attributes = new HashMap();
        this.parse(url);
    }

    public JMXServiceURL(String protocol, String host, int port) throws MalformedURLException {
        this(protocol, host, port, null, null);
    }

    public JMXServiceURL(String protocol, String host, int port, String urlPath) throws MalformedURLException {
        this(protocol, host, port, null, null);
    }

    private JMXServiceURL(String protocol, String host, int port, String urlPath, Map attributes) throws MalformedURLException {
        if (port < 0) {
            throw new MalformedURLException("Port number cannot be less than zero");
        }
        if (protocol == null) {
            protocol = "jmxmp";
        }
        if (urlPath == null) {
            urlPath = "";
        }
        if (attributes == null) {
            attributes = new HashMap();
        }
        if (host == null) {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException x) {
                throw new MalformedURLException("Cannot resolve local host name");
            }
        }
        this.setProtocol(protocol);
        this.setHost(host);
        this.setPort(port);
        this.setURLPath(urlPath);
        this.attributes = attributes;
    }

    private static String escape(String value) {
        return JMXServiceURLCodec.encode((String)value);
    }

    private static String unescape(String value) {
        return JMXServiceURLCodec.decode((String)value);
    }

    public String getProtocol() {
        return this.protocol;
    }

    private void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    private void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    private void setPort(int port) {
        this.port = port;
    }

    public String getURLPath() {
        return this.urlPath;
    }

    private void setURLPath(String urlPath) {
        this.urlPath = urlPath;
    }

    private Map getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public int hashCode() {
        if (this.hash == 0) {
            Map attribs;
            String path;
            this.hash = this.getProtocol().hashCode();
            this.hash ^= this.getHost().hashCode();
            int port = this.getPort();
            if (port > 0) {
                this.hash ^= port;
            }
            if ((path = this.getURLPath()) != null) {
                this.hash ^= path.hashCode();
            }
            if ((attribs = this.getAttributes()) != null) {
                this.hash ^= ((Object)attribs).hashCode();
            }
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        int otherPort;
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        JMXServiceURL other = (JMXServiceURL)obj;
        if (!this.getProtocol().equals(other.getProtocol())) {
            return false;
        }
        if (!this.getHost().equals(other.getHost())) {
            return false;
        }
        int port = this.getPort();
        if (port != (otherPort = other.getPort())) {
            return false;
        }
        String path = this.getURLPath();
        String otherPath = other.getURLPath();
        if (path != null && !path.equals(otherPath)) {
            return false;
        }
        if (path == null && otherPath != null) {
            return false;
        }
        Map attribs = this.getAttributes();
        Map otherAttribs = other.getAttributes();
        if (attribs != null && !((Object)attribs).equals(otherAttribs)) {
            return false;
        }
        return attribs != null || otherPath == null;
    }

    public String toString() {
        Map attribs;
        String path;
        StringBuffer buffer = new StringBuffer("service:jmx:");
        buffer.append(this.getProtocol()).append("://");
        buffer.append(this.getHost());
        int port = this.getPort();
        if (port > 0) {
            buffer.append(":").append(port);
        }
        if ((path = this.getURLPath()) != null) {
            buffer.append("/").append(path);
        }
        if ((attribs = this.getAttributes()) != null) {
            Iterator i = attribs.entrySet().iterator();
            while (i.hasNext()) {
                buffer.append(";");
                Map.Entry entry = i.next();
                buffer.append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return buffer.toString();
    }

    private void parse(String url) throws MalformedURLException {
        String hostSeparator;
        String prefix = "service:jmx:";
        if (!url.startsWith(prefix)) {
            throw new MalformedURLException("JMXServiceURL " + url + " must start with " + prefix);
        }
        String parse = url.substring(prefix.length());
        int index = parse.indexOf(hostSeparator = "://");
        if (index < 0) {
            throw new MalformedURLException("No protocol defined for JMXServiceURL " + url);
        }
        String protocol = parse.substring(0, index);
        this.checkProtocol(url, protocol);
        this.setProtocol(protocol);
        String hostAndMore = parse.substring(index + hostSeparator.length());
        index = hostAndMore.indexOf(47);
        if (index < 0) {
            int semicolon = hostAndMore.indexOf(59);
            if (semicolon < 0) {
                this.parseHostAndPort(url, hostAndMore);
            } else {
                String hostAndPort = hostAndMore.substring(0, semicolon);
                this.parseHostAndPort(url, hostAndPort);
                String more = hostAndMore.substring(semicolon + 1);
                this.parseProperties(url, more);
            }
            this.setURLPath("");
        } else {
            String hostAndPort = hostAndMore.substring(0, index);
            this.parseHostAndPort(url, hostAndPort);
            String pathAndMore = hostAndMore.substring(index + 1);
            if (pathAndMore.length() > 0) {
                int semicolon = pathAndMore.indexOf(59);
                if (semicolon < 0) {
                    this.checkURLPath(url, pathAndMore);
                    this.setURLPath(pathAndMore);
                } else {
                    String path = pathAndMore.substring(0, semicolon);
                    this.checkURLPath(url, path);
                    this.setURLPath(path);
                    String more = pathAndMore.substring(semicolon + 1);
                    this.parseProperties(url, more);
                }
            }
        }
    }

    private void parseHostAndPort(String url, String hostAndPort) throws MalformedURLException {
        if (hostAndPort.length() == 0) {
            throw new MalformedURLException("No host defined for JMXServiceURL " + url);
        }
        int colon = hostAndPort.indexOf(58);
        if (colon == 0) {
            throw new MalformedURLException("No host defined for JMXServiceURL " + url);
        }
        if (colon > 0) {
            String host = hostAndPort.substring(0, colon);
            this.checkHost(url, host);
            this.setHost(host);
            String portString = hostAndPort.substring(colon + 1);
            try {
                int port = Integer.parseInt(portString);
                this.setPort(port);
            }
            catch (NumberFormatException x) {
                throw new MalformedURLException("Invalid port " + portString + " for JMXServiceURL " + url);
            }
        } else {
            this.checkHost(url, hostAndPort);
            this.setHost(hostAndPort);
            this.setPort(0);
        }
    }

    private void parseProperties(String url, String properties) throws MalformedURLException {
        StringTokenizer tokenizer = new StringTokenizer(properties, ";");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int equal = token.indexOf(61);
            String key = null;
            String value = null;
            if (equal <= 0) {
                key = token;
                value = "true";
            } else {
                key = token.substring(0, equal);
                value = token.substring(equal + 1);
                value = JMXServiceURL.unescape(value);
            }
            this.checkAttributeKey(url, key);
            this.attributes.put(key, value);
        }
    }

    private void checkAttributeKey(String url, String key) throws MalformedURLException {
        if (key.length() == 0) {
            throw new MalformedURLException("Invalid key " + key + " for JMXServiceURL " + url);
        }
        if (!key.trim().equals(key)) {
            throw new MalformedURLException("No leading or trailing white space allowed in attribute key for JMXServiceURL " + url);
        }
    }

    private void checkProtocol(String url, String protocol) throws MalformedURLException {
        if (protocol.length() == 0) {
            throw new MalformedURLException("No protocol defined for JMXServiceURL " + url);
        }
        if (!protocol.trim().equals(protocol)) {
            throw new MalformedURLException("No leading or trailing white space allowed in protocol for JMXServiceURL " + url);
        }
    }

    private void checkHost(String url, String host) throws MalformedURLException {
        if (host.length() == 0) {
            throw new MalformedURLException("No host defined for JMXServiceURL " + url);
        }
        if (!host.trim().equals(host)) {
            throw new MalformedURLException("No leading or trailing white space allowed in host for JMXServiceURL " + url);
        }
    }

    private void checkURLPath(String url, String path) throws MalformedURLException {
        if (path.startsWith("/")) {
            throw new MalformedURLException("Invalid path for JMXServiceURL " + url);
        }
        if (!path.trim().equals(path)) {
            throw new MalformedURLException("No leading or trailing white space allowed in path for JMXServiceURL " + url);
        }
    }
}

