/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.generic;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Map;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.generic.GenericConnectorServerMBean;
import javax.management.remote.generic.MessageConnectionServer;
import mx4j.remote.generic.DefaultMessageConnectionServer;
import mx4j.remote.generic.IncomingConnectionHandler;
import mx4j.remote.generic.MessageHandler;

public class GenericConnectorServer
implements GenericConnectorServerMBean,
MBeanRegistration {
    public static final String PORT_ATTRIBUTE = "generic.connection.server.port";
    public static final String IP_ADDRESS_ATTRIBUTE = "generic.connection.server.ip.address";
    public static final String MESSAGE_CONNECTION_SERVER_CLASS_ATTRIBUTE = "generic.message.connection.server.class";
    private static final int DEFAULT_PORT = 8848;
    private final Map environment;
    private volatile MBeanServerConnection server;
    private int port = -1;
    private MessageConnectionServer connectionServer;
    private IncomingConnectionHandler connectionHandler;
    private int maxConnections;

    public GenericConnectorServer(Map environment) {
        this.environment = environment == null ? null : Collections.unmodifiableMap(environment);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.setMBeanServerConnection(server);
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            this.setMBeanServerConnection(null);
        }
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.setMBeanServerConnection(null);
    }

    public JMXConnector getStub(Map environment) throws IOException, UnsupportedOperationException {
        return null;
    }

    public String[] getConnectionIds() {
        return new String[0];
    }

    public boolean isActive() {
        return false;
    }

    public void stop() throws IOException {
    }

    public void setMBeanServerConnection(MBeanServerConnection server) {
        this.server = server;
    }

    public Map getAttributes() {
        return this.environment;
    }

    public void close() throws IOException {
        this.connectionHandler.interrupt();
        this.getMessageConnectionServer().close();
    }

    public int getConnectionCount() {
        return this.connectionHandler.getConnectionCount();
    }

    public JMXServiceURL getAddress() {
        return null;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void start() throws IOException {
        if (this.server == null) {
            throw new IllegalStateException("MBeanServerConnection not set");
        }
        MessageHandler handler = MessageHandler.Factory.getInstance().newMessageHandler();
        handler.setup(this.server, this.getAttributes());
        this.connectionHandler = new IncomingConnectionHandler(this.getMessageConnectionServer(), this.getMaxConnections(), handler);
        this.connectionHandler.start();
    }

    public int getPort() {
        if (this.port < 0) {
            Object portValue = this.getAttributes().get(PORT_ATTRIBUTE);
            if (portValue instanceof Integer) {
                this.setPort((Integer)portValue);
            } else if (portValue instanceof String) {
                try {
                    this.setPort(Integer.parseInt((String)portValue));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.port < 0) {
                this.setPort(8848);
            }
        }
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public MessageConnectionServer getMessageConnectionServer() {
        if (this.connectionServer == null) {
            String ip = (String)this.getAttributes().get(IP_ADDRESS_ATTRIBUTE);
            String clsName = (String)this.getAttributes().get(MESSAGE_CONNECTION_SERVER_CLASS_ATTRIBUTE);
            if (clsName != null) {
                try {
                    Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(clsName);
                    Constructor<?> ctor = cls.getConstructor(Integer.TYPE);
                    this.connectionServer = (MessageConnectionServer)ctor.newInstance(new Integer(this.getPort()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.connectionServer == null) {
                this.connectionServer = new DefaultMessageConnectionServer(this.getPort());
            }
        }
        return this.connectionServer;
    }

    public void setMessageConnectionServer(MessageConnectionServer connectionServer) {
        this.connectionServer = connectionServer;
    }
}

