/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.management.remote.JMXPrincipal;
import javax.management.remote.rmi.RMIAuthenticator;
import javax.security.auth.Subject;

public class RMIPasswordAuthenticator
implements RMIAuthenticator {
    private Properties pwProps = null;
    private String pwFile = null;
    private Properties defaultProps = null;

    public RMIPasswordAuthenticator(Properties pwProps) {
        if (pwProps == null) {
            throw new IllegalArgumentException("Properties cant be null");
        }
        this.defaultProps = pwProps;
        this.pwProps = (Properties)pwProps.clone();
    }

    public RMIPasswordAuthenticator(String pwFile) throws IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(pwFile));
        this.pwProps = props;
        this.pwFile = pwFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subject authenticate(Object credentials) {
        try {
            Object[] cr = (Object[])credentials;
            if (cr.length != 2) {
                throw new SecurityException("Invalid Credentials: credential lenght: [" + cr.length + "],expecting [2].");
            }
            String username = (String)cr[0];
            String password = (String)cr[1];
            if (username == null || password == null) {
                throw new SecurityException("Invalid Credentials: password and/or username is null.");
            }
            String passFromProps = null;
            RMIPasswordAuthenticator rMIPasswordAuthenticator = this;
            synchronized (rMIPasswordAuthenticator) {
                passFromProps = this.pwProps.getProperty(username);
            }
            if (passFromProps == null || !password.equals(passFromProps)) {
                throw new SecurityException("Invalid Credentials: username and/or password is invalid.");
            }
            Subject subject = new Subject();
            subject.getPrincipals().add(new JMXPrincipal(username));
            return subject;
        }
        catch (Exception e) {
            throw new SecurityException("Unexpected Exception caught: " + e + ", cause: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws IOException {
        Properties properties;
        if (this.pwFile != null) {
            properties = this.pwProps;
            synchronized (properties) {
                this.pwProps.clear();
                this.pwProps.load(new FileInputStream(this.pwFile));
            }
        }
        if (this.defaultProps != null) {
            properties = this.pwProps;
            synchronized (properties) {
                this.pwProps.clear();
                this.pwProps.putAll((Map<?, ?>)this.defaultProps);
            }
        }
    }
}

