/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.rmi.RMIMBeanServerConnection;
import javax.management.remote.rmi.RMIServer;
import javax.security.auth.Subject;

public abstract class RMIServerImpl
implements RMIServer {
    private MBeanServer server;
    private List clients = new LinkedList();

    public RMIServerImpl(Map env) throws RemoteException {
    }

    public abstract Remote toStub() throws RemoteException;

    public String getVersion() {
        return null;
    }

    public synchronized void setMBeanServer(MBeanServer server) {
        this.server = server;
    }

    public synchronized MBeanServer getMBeanServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMIMBeanServerConnection newClient(Object credentials) throws RemoteException {
        RMIMBeanServerConnection client = this.makeClient(null, null);
        List list = this.clients;
        synchronized (list) {
            this.clients.add(client);
        }
        return client;
    }

    protected abstract RMIMBeanServerConnection makeClient(String var1, Subject var2) throws RemoteException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionCount() {
        List list = this.clients;
        synchronized (list) {
            return this.clients.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void close() throws IOException {
        IOException rethrow = null;
        try {
            this.closeServer();
        }
        catch (IOException x) {
            rethrow = x;
        }
        List list = this.clients;
        // MONITORENTER : list
        while (true) {
            if (this.clients.size() <= 0) {
                // MONITOREXIT : list
                if (rethrow == null) return;
                throw rethrow;
            }
            RMIMBeanServerConnection connection = (RMIMBeanServerConnection)this.clients.get(0);
            try {
                connection.close();
            }
            catch (RemoteException x) {
                if (rethrow != null) continue;
                rethrow = x;
                continue;
            }
            break;
        }
    }

    protected abstract void closeServer() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clientClosed(RMIMBeanServerConnection connection) throws RemoteException {
        List list = this.clients;
        synchronized (list) {
            this.clients.remove(connection);
        }
    }
}

