/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.ByteArray;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.protocol.BODY;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.MessagingException;

public class IMAPInputStream
extends InputStream {
    private IMAPMessage msg;
    private String section;
    private int pos;
    private int blksize;
    private int max;
    private byte[] buf;
    private int bufcount;
    private int bufpos;

    public IMAPInputStream(IMAPMessage msg, String section, int max) {
        this.msg = msg;
        this.section = section;
        this.max = max;
        this.pos = 0;
        this.blksize = msg.getFetchBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fill() throws IOException {
        ByteArray ba;
        if (this.max != -1 && this.pos >= this.max) {
            if (this.pos == 0) {
                this.checkSeen();
            }
            return;
        }
        BODY b = null;
        Object object = this.msg.getMessageCacheLock();
        synchronized (object) {
            if (this.msg.isExpunged()) {
                throw new IOException("No content for expunged message");
            }
            int seqnum = this.msg.getSequenceNumber();
            try {
                b = this.msg.getProtocol().fetchBody(seqnum, this.section, this.pos, this.blksize);
            }
            catch (ProtocolException pex) {
                throw new IOException(pex.getMessage());
            }
            catch (FolderClosedException fex) {
                throw new IOException(fex.getMessage());
            }
        }
        if (b == null || (ba = b.getByteArray()) == null) {
            throw new IOException("No content");
        }
        if (this.pos == 0) {
            this.checkSeen();
        }
        this.buf = ba.getBytes();
        this.bufpos = ba.getStart();
        int n = ba.getCount();
        this.bufcount = this.bufpos + n;
        this.pos += n;
    }

    public synchronized int read() throws IOException {
        if (this.bufpos >= this.bufcount) {
            this.fill();
            if (this.bufpos >= this.bufcount) {
                return -1;
            }
        }
        return this.buf[this.bufpos++] & 0xFF;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int avail = this.bufcount - this.bufpos;
        if (avail <= 0) {
            this.fill();
            avail = this.bufcount - this.bufpos;
            if (avail <= 0) {
                return -1;
            }
        }
        int cnt = avail < len ? avail : len;
        System.arraycopy(this.buf, this.bufpos, b, off, cnt);
        this.bufpos += cnt;
        return cnt;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public synchronized int available() throws IOException {
        return this.bufcount - this.bufpos;
    }

    private void checkSeen() {
        try {
            Folder f = this.msg.getFolder();
            if (f != null && f.getMode() != 1 && !this.msg.isSet(Flags.Flag.SEEN)) {
                this.msg.setFlag(Flags.Flag.SEEN, true);
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }
}

