/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.index.IIndex;
import org.eclipse.help.internal.index.Index;
import org.eclipse.help.internal.index.IndexBuilder;
import org.eclipse.help.internal.index.IndexFile;

public class IndexManager {
    private Collection contributingPlugins;
    private Map indexesByLang = new HashMap();
    public static final String INDEX_XP_NAME = "index";

    public IndexManager() {
        this.build(Platform.getNL());
    }

    private void build(String locale) {
        Collection contributedIndexFiles = this.getContributedIndexFiles(locale);
        IndexBuilder builder = new IndexBuilder(locale);
        builder.build(contributedIndexFiles);
        IIndex index = builder.getBuiltIndex();
        this.indexesByLang.put(locale, index);
    }

    private Collection getContributedIndexFiles(String locale) {
        this.contributingPlugins = new HashSet();
        ArrayList<IndexFile> contributedIndexFiles = new ArrayList<IndexFile>();
        IExtensionPoint xpt = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.help", INDEX_XP_NAME);
        if (xpt == null) {
            return contributedIndexFiles;
        }
        IExtension[] extensions = xpt.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.contributingPlugins.add(extensions[i].getNamespace());
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals(INDEX_XP_NAME)) {
                    String pluginId = configElements[j].getDeclaringExtension().getNamespace();
                    String href = configElements[j].getAttribute("file");
                    if (href != null) {
                        contributedIndexFiles.add(new IndexFile(pluginId, href, locale));
                    }
                }
                ++j;
            }
            ++i;
        }
        return contributedIndexFiles;
    }

    public Collection getContributingPlugins() {
        return this.contributingPlugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIndex getIndex(String locale) {
        if (locale == null) {
            return new Index();
        }
        IIndex index = (IIndex)this.indexesByLang.get(locale);
        if (index == null) {
            IndexManager indexManager = this;
            synchronized (indexManager) {
                if (index == null) {
                    this.build(locale);
                }
            }
            index = (IIndex)this.indexesByLang.get(locale);
            if (index == null) {
                index = new Index();
            }
        }
        return index;
    }
}

