/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.toc.Criteria;

public class FilterManager {
    private Map criteriasByLang;
    private List supportedCriteria;
    private static final String SUPPORTED_CRITERIA = "supportedCriteria";
    private static final int SUPPORTED_CRITERIA_AMOUNT = 6;
    private String locale = Platform.getNL();

    public FilterManager() {
        this.criteriasByLang = new HashMap();
        this.supportedCriteria = new ArrayList(3);
        StringTokenizer criterias = new StringTokenizer(HelpPlugin.getDefault().getPluginPreferences().getString(SUPPORTED_CRITERIA), ",;");
        while (criterias.hasMoreTokens()) {
            this.supportedCriteria.add(criterias.nextToken().toLowerCase().trim());
        }
    }

    public void addCriteria(Criteria cr) {
        ArrayList<String> valueList;
        HashMap criterias = (HashMap)this.criteriasByLang.get(this.locale);
        if (criterias == null) {
            criterias = new HashMap(6);
        }
        if ((valueList = (ArrayList<String>)criterias.get(cr.getName())) == null) {
            valueList = new ArrayList<String>(2);
        }
        if (!valueList.contains(cr.getValue())) {
            valueList.add(cr.getValue());
        }
        Collections.sort(valueList);
        criterias.put(cr.getName(), valueList);
        this.criteriasByLang.put(this.locale, criterias);
    }

    public void removeCriteria(Criteria cr) {
        HashMap criterias = (HashMap)this.criteriasByLang.get(Platform.getNL());
        List valueList = (List)criterias.get(cr.getName());
        if (valueList != null) {
            valueList.remove(cr.getValue());
            criterias.put(cr.getName(), valueList);
        }
        this.criteriasByLang.put(Platform.getNL(), criterias);
    }

    public Map getCriterias(String localName) {
        return (HashMap)this.criteriasByLang.get(localName);
    }

    public boolean isSupportedCriteria(String name) {
        return this.supportedCriteria.contains(name.toLowerCase());
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }
}

