/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.IToc;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.model.ITocElement;
import org.eclipse.help.internal.toc.TocBuilder;
import org.eclipse.help.internal.toc.TocFile;
import org.osgi.framework.Bundle;

public class TocManager {
    public static final String TOC_XP_NAME = "toc";
    public static final String TOC_ELEMENT_NAME = "toc";
    public static final String INDEX_ELEMENT_NAME = "index";
    private Map tocsByLang;
    private Map contributingPlugins2IndexPaths;

    public TocManager() {
        try {
            this.tocsByLang = new HashMap();
            this.build(Platform.getNL());
        }
        catch (Exception e) {
            HelpPlugin.logError("", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITocElement[] getTocs(String locale) {
        if (locale == null) {
            return new ITocElement[0];
        }
        ITocElement[] tocs = (ITocElement[])this.tocsByLang.get(locale);
        if (tocs == null) {
            TocManager tocManager = this;
            synchronized (tocManager) {
                if (tocs == null) {
                    HelpPlugin.getFilterManager().setLocale(locale);
                    this.build(locale);
                }
            }
            tocs = (ITocElement[])this.tocsByLang.get(locale);
            if (tocs == null) {
                tocs = new ITocElement[]{};
            }
        }
        return tocs;
    }

    public ITocElement getToc(String href, String locale) {
        if (href == null || href.equals("")) {
            return null;
        }
        ITocElement[] tocs = this.getTocs(locale);
        int i = 0;
        while (i < tocs.length) {
            if (tocs[i].getHref().equals(href)) {
                return tocs[i];
            }
            ++i;
        }
        return null;
    }

    public Collection getContributingPlugins() {
        if (this.contributingPlugins2IndexPaths == null) {
            this.getContributedTocFiles(Locale.getDefault().toString());
        }
        return this.contributingPlugins2IndexPaths.keySet();
    }

    public String getIndexPath(String pluginId) {
        if (this.contributingPlugins2IndexPaths == null) {
            this.getContributedTocFiles(Locale.getDefault().toString());
        }
        return (String)this.contributingPlugins2IndexPaths.get(pluginId);
    }

    private void build(String locale) {
        IToc[] tocs;
        try {
            Collection contributedTocFiles = this.getContributedTocFiles(locale);
            TocBuilder builder = new TocBuilder();
            builder.build(contributedTocFiles);
            Collection builtTocs = builder.getBuiltTocs();
            tocs = new ITocElement[builtTocs.size()];
            int i = 0;
            Iterator it = builtTocs.iterator();
            while (it.hasNext()) {
                tocs[i++] = (ITocElement)it.next();
            }
            List orderedTocs = this.orderTocs(builtTocs);
            tocs = new ITocElement[orderedTocs.size()];
            orderedTocs.toArray(tocs);
            this.debug(orderedTocs);
        }
        catch (Exception e) {
            tocs = new IToc[]{};
            HelpPlugin.logError("", e);
        }
        this.tocsByLang.put(locale, tocs);
    }

    private List orderTocs(Collection unorderedTocs) {
        ArrayList orderedHrefs = this.getPreferredTocOrder();
        ArrayList<ITocElement> orderedTocs = new ArrayList<ITocElement>(unorderedTocs.size());
        Iterator it = orderedHrefs.iterator();
        while (it.hasNext()) {
            String href = (String)it.next();
            ITocElement toc = this.getToc(unorderedTocs, href);
            if (toc == null) continue;
            orderedTocs.add(toc);
        }
        it = unorderedTocs.iterator();
        while (it.hasNext()) {
            ITocElement toc = (ITocElement)it.next();
            if (orderedTocs.contains(toc)) continue;
            orderedTocs.add(toc);
        }
        return orderedTocs;
    }

    private ArrayList getPreferredTocOrder() {
        ArrayList<Object> orderedTocs = new ArrayList<Object>();
        try {
            Preferences pref = HelpPlugin.getDefault().getPluginPreferences();
            String preferredTocs = pref.getString("baseTOCS");
            if (preferredTocs != null) {
                StringTokenizer suggestdOrderedInfosets = new StringTokenizer(preferredTocs, " ;,");
                while (suggestdOrderedInfosets.hasMoreElements()) {
                    orderedTocs.add(suggestdOrderedInfosets.nextElement());
                }
            }
        }
        catch (Exception e) {
            HelpPlugin.logError("Problems occurred reading plug-in preferences.", e);
        }
        return orderedTocs;
    }

    private Collection getIgnoredTocs() {
        HashSet<Object> ignored = new HashSet<Object>();
        try {
            Preferences pref = HelpPlugin.getDefault().getPluginPreferences();
            String preferredTocs = pref.getString("ignoredTOCS");
            if (preferredTocs != null) {
                StringTokenizer suggestdOrderedInfosets = new StringTokenizer(preferredTocs, " ;,");
                while (suggestdOrderedInfosets.hasMoreElements()) {
                    ignored.add(suggestdOrderedInfosets.nextElement());
                }
            }
        }
        catch (Exception e) {
            HelpPlugin.logError("Problems occurred reading plug-in preferences.", e);
        }
        return ignored;
    }

    private ITocElement getToc(Collection list, String href) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ITocElement toc = (ITocElement)it.next();
            if (!toc.getHref().equals(href)) continue;
            return toc;
        }
        return null;
    }

    protected Collection getContributedTocFiles(String locale) {
        this.contributingPlugins2IndexPaths = new HashMap();
        ArrayList<TocFile> contributedTocFiles = new ArrayList<TocFile>();
        Collection ignored = this.getIgnoredTocs();
        IExtensionPoint xpt = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.help", "toc");
        if (xpt == null) {
            return contributedTocFiles;
        }
        IExtension[] extensions = xpt.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            String pluginId = extensions[i].getNamespace();
            if (!this.contributingPlugins2IndexPaths.containsKey(pluginId)) {
                this.contributingPlugins2IndexPaths.put(pluginId, null);
            }
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String path;
                if (configElements[j].getName().equals("toc")) {
                    String href = configElements[j].getAttribute("file");
                    if (href != null && !ignored.contains("/" + pluginId + "/" + href)) {
                        boolean isPrimary = "true".equals(configElements[j].getAttribute("primary"));
                        String extraDir = configElements[j].getAttribute("extradir");
                        contributedTocFiles.add(new TocFile(pluginId, href, isPrimary, locale, extraDir));
                    }
                } else if (configElements[j].getName().equals(INDEX_ELEMENT_NAME) && (path = configElements[j].getAttribute("path")) != null && path.length() != 0) {
                    this.contributingPlugins2IndexPaths.put(pluginId, path);
                }
                ++j;
            }
            ++i;
        }
        return contributedTocFiles;
    }

    private void debug(List orderedTocs) {
        try {
            Bundle bundle = Platform.getBundle((String)HelpPlugin.DEBUG_PLUGIN);
            if (bundle != null) {
                bundle.start();
                HelpPlugin.getDefault().getDebugger().debug(orderedTocs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            HelpPlugin.logError("", e);
        }
    }
}

