/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.model.ITopicElement;
import org.eclipse.help.internal.toc.Criteria;
import org.eclipse.help.internal.toc.FilterManager;
import org.eclipse.help.internal.toc.HrefUtil;
import org.eclipse.help.internal.toc.TocBuilder;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.toc.TocNode;
import org.xml.sax.Attributes;

public class Topic
extends TocNode
implements ITopicElement {
    private String href;
    private String label;
    private ITopic[] topicArray;
    private HashMap criteria = new HashMap(5);

    protected Topic(TocFile tocFile, Attributes attrs) {
        if (attrs == null) {
            return;
        }
        this.href = attrs.getValue("href");
        if (this.href != null && this.href.length() > 0) {
            this.href = HrefUtil.normalizeHref(tocFile.getPluginID(), this.href);
        }
        this.label = attrs.getValue("label");
        if (this.label == null) {
            throw new RuntimeException("topic label==null");
        }
        tocFile.getToc().registerTopic(this);
    }

    public final void build(TocBuilder builder) {
        builder.buildTopic(this);
    }

    public String getHref() {
        return this.href;
    }

    public String getLabel() {
        return this.label;
    }

    public ITopic[] getSubtopics() {
        if (this.topicArray == null) {
            List topics = this.getChildTopics();
            this.topicArray = new ITopic[topics.size()];
            topics.toArray(this.topicArray);
        }
        return this.topicArray;
    }

    void setLabel(String label) {
        this.label = label;
    }

    void setHref(String href) {
        this.href = href;
    }

    public ITopic[] getPathInToc(IToc toc) {
        List ancestors = Topic.getTopicPathInToc(toc, this);
        if (ancestors == null) {
            return null;
        }
        return ancestors.toArray(new ITopic[ancestors.size()]);
    }

    static List getTopicPathInToc(IToc toc, Topic topic) {
        ArrayList topicParents = new ArrayList(topic.getParents());
        Iterator it = topicParents.listIterator();
        while (it.hasNext()) {
            TocNode tocNode = (TocNode)it.next();
            if (tocNode instanceof Topic) continue;
            if (tocNode == toc) {
                ArrayList<Topic> ancestors = new ArrayList<Topic>();
                ancestors.add(topic);
                return ancestors;
            }
            List grandParents = tocNode.getParents();
            it.remove();
            Iterator it2 = grandParents.iterator();
            while (it2.hasNext()) {
                it.add(it2.next());
                it.previous();
            }
        }
        it = topicParents.iterator();
        while (it.hasNext()) {
            List a = Topic.getTopicPathInToc(toc, (Topic)it.next());
            if (a == null) continue;
            a.add(topic);
            return a;
        }
        return null;
    }

    public HashMap getCriteria() {
        return this.criteria;
    }

    public void addCriteria(Criteria cr) {
        FilterManager filterManager = HelpPlugin.getFilterManager();
        if (filterManager.isSupportedCriteria(cr.getName())) {
            ArrayList<String> valueList = (ArrayList<String>)this.criteria.get(cr.getName());
            if (valueList == null) {
                valueList = new ArrayList<String>(2);
            }
            valueList.add(cr.getValue());
            this.criteria.put(cr.getName(), valueList);
            filterManager.addCriteria(cr);
        }
    }
}

