/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class StopWatch {
    private static final int STACKSIZE = 64;
    private long[] timers = new long[64];
    private String[] labels = new String[64];
    private int stackp = -1;
    private static PrintStream log = null;
    private static StopWatch instance = null;

    public static StopWatch instance() {
        return instance;
    }

    private StopWatch() {
    }

    public void start(String string) {
        if (log != null) {
            if (this.stackp == 63) {
                throw new IllegalStateException("stack overflow");
            }
            this.timers[++this.stackp] = System.currentTimeMillis();
            this.labels[this.stackp] = string;
        }
    }

    public void stop() {
        if (log != null) {
            if (this.stackp < 0) {
                throw new IllegalStateException("stack underflow");
            }
            long l = System.currentTimeMillis();
            long l2 = l - this.timers[this.stackp];
            log.println("" + l + " " + this.stackp + " " + StopWatch.pad("" + l2, 7) + " : " + StopWatch.pad(" ", this.stackp * 2) + this.labels[this.stackp]);
            --this.stackp;
        }
    }

    private static String pad(String string, int n) {
        String string2 = "";
        for (int i = 0; i < n - string.length(); ++i) {
            string2 = string2 + " ";
        }
        return string2 + string;
    }

    private static void usage() {
        System.out.println("usage: Stopwatch -f <logfile> [options]");
        System.out.println();
        System.out.println("  Options");
        System.out.println("  -------");
        System.out.println("    -t <threshold> - used to filter data.  Only data");
        System.out.println("        points whose percentage of the overall time");
        System.out.println("        exceeds the threshold will be shown.  The units");
        System.out.println("        are in tenths of a percent point.  The default");
        System.out.println("        is 0.");
        System.out.println();
        System.out.println("    -h - prints this message.");
        System.out.println();
        System.out.println("  Examples");
        System.out.println("  --------");
        System.out.println();
        System.out.println("    1) Stopwatch -f c:/WebSphere/AppServer/Stopwatch.log");
        System.out.println();
        System.out.println("       processes the specified log using the default filter.");
        System.out.println();
        System.out.println("    2) Stopwatch -f c:/WebSphere/AppServer/Stopwatch.log -t 5");
        System.out.println();
        System.out.println("       processes the specified log and filters out all data points");
        System.out.println("       that represent less than 0.5% of the overall time.");
        System.out.println();
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        try {
            String string = null;
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("-t")) {
                    n = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-h")) {
                    StopWatch.usage();
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-f")) {
                    string = stringArray[++i];
                    continue;
                }
                StopWatch.usage();
            }
            if (string == null) {
                StopWatch.usage();
            }
            System.out.println("latency  %all  %prnt");
            System.out.println("-------- ----- ----- --------------------------------------");
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = null;
            Vector<String> vector = new Vector<String>();
            Stats[] statsArray = new Stats[256];
            while ((string2 = bufferedReader.readLine()) != null) {
                vector.add(string2);
            }
            int n2 = -1;
            for (int i = vector.size() - 1; i >= 0; --i) {
                String string3 = (String)vector.get(i);
                StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
                long l = Long.parseLong(stringTokenizer.nextToken());
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                int n4 = Integer.parseInt(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                String string4 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string4 = string4 + stringTokenizer.nextToken() + " ";
                }
                if (n3 != n2) {
                    if (n3 == n2 + 1) {
                        if (statsArray[n3] == null) {
                            statsArray[n3] = new Stats();
                        }
                        n2 = n3;
                    } else if (n3 < n2) {
                        n2 = n3;
                    } else {
                        throw new IllegalStateException("invalid indexing");
                    }
                }
                statsArray[n3].timestamp = l;
                statsArray[n3].indent = n3;
                statsArray[n3].label = string4;
                statsArray[n3].latency = n4;
                if (n3 <= 0) continue;
                Stats stats = statsArray[n3];
                Stats stats2 = statsArray[n3 - 1];
                Stats stats3 = statsArray[0];
                int n5 = stats.latency * 1000 / stats3.latency;
                int n6 = 1000;
                if (stats2.latency > 0) {
                    n6 = stats.latency * 1000 / stats2.latency;
                }
                if (n5 < n) continue;
                System.out.println(StopWatch.pad("" + stats.latency, 8) + StopWatch.pad("" + n5 / 10, 4) + "." + n5 % 10 + StopWatch.pad("" + n6 / 10, 4) + "." + n6 % 10 + StopWatch.pad(" ", stats.indent * 2) + stats.label);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static {
        instance = new StopWatch();
        if (Boolean.getBoolean("was.stopwatch")) {
            try {
                log = new PrintStream(new FileOutputStream("Stopwatch.log"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    static class Stats {
        long timestamp = 0L;
        int indent = 0;
        int latency = 0;
        String label = null;

        Stats() {
        }
    }
}

