/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.auth.module.proxy;

import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class WSLoginModuleProxy
implements LoginModule {
    private static final PrivilegedAction getCtxClassLoader = new PrivilegedAction(){

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };
    private boolean debug;
    private LoginModule loginModule;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
        String string = (String)map2.get("delegate");
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("delegate is not set");
        }
        if (this.debug) {
            System.out.println("delegate class name: " + string);
        }
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)getCtxClassLoader);
        if (this.debug) {
            if (classLoader != null) {
                System.out.println("Using the current thread class loader");
            } else {
                System.out.println("Using the class loader that loads the JAAS extension");
            }
        }
        try {
            this.loginModule = classLoader != null ? (LoginModule)classLoader.loadClass(string).newInstance() : (LoginModule)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            if (this.debug) {
                exception.printStackTrace();
            }
            throw new RuntimeException(exception.getMessage());
        }
        this.loginModule.initialize(subject, callbackHandler, map, map2);
    }

    public boolean login() throws LoginException {
        return this.loginModule.login();
    }

    public boolean commit() throws LoginException {
        return this.loginModule.commit();
    }

    public boolean abort() throws LoginException {
        return this.loginModule.abort();
    }

    public boolean logout() throws LoginException {
        return this.loginModule.logout();
    }
}

