/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bidiTools.bdlayout;

import com.ibm.bidiTools.bdlayout.BidiFlag;
import com.ibm.bidiTools.bdlayout.BidiText;
import com.ibm.bidiTools.bdlayout.BidiTransform;

class BidiOrder {
    private static final int UBAT_B = 0;
    private static final int UBAT_S = 1;
    private static final int UBAT_L = 2;
    private static final int UBAT_R = 3;
    private static final int UBAT_EN = 4;
    private static final int UBAT_AN = 5;
    private static final int UBAT_ET = 6;
    private static final int UBAT_ES = 7;
    private static final int UBAT_CS = 8;
    private static final int UBAT_W = 9;
    private static final int UBAT_N = 10;
    private static final int UBAT_BD = 11;
    private static final int ITIL = 11;
    private static final int ITCOND = 12;
    private static final byte TONATIONAL_FLAG = 1;
    private static final byte TONOMINAL_FLAG = 2;
    private static final byte CONTEXTUAL_FLAG = 4;
    private static final byte SWAPPING_FLAG = 8;
    private static final char[][] notSpacing = new char[][]{{'\u0300', '\u0385'}, {'\u0483', '\u0486'}, {'\u05b0', '\u05bd'}, {'\u05bf', '\u05bf'}, {'\u05c1', '\u05c2'}, {'\u05f5', '\u05f5'}, {'\u064b', '\u0652'}, {'\u0670', '\u0670'}, {'\u06d6', '\u06e4'}, {'\u06e7', '\u06e8'}, {'\u06ea', '\u06ed'}, {'\u0901', '\u0902'}, {'\u093c', '\u093c'}, {'\u0941', '\u0948'}, {'\u094d', '\u094d'}, {'\u0951', '\u0954'}, {'\u0962', '\u0963'}, {'\u0981', '\u0981'}, {'\u09bc', '\u09bc'}, {'\u09c1', '\u09c4'}, {'\u09cd', '\u09cd'}, {'\u09e2', '\u09e3'}, {'\u0a02', '\u0a02'}, {'\u0a3c', '\u0a3c'}, {'\u0a41', '\u0a4c'}, {'\u0a70', '\u0a71'}, {'\u0a81', '\u0a82'}, {'\u0abc', '\u0abc'}, {'\u0ac1', '\u0ac8'}, {'\u0acd', '\u0acd'}, {'\u0b01', '\u0b01'}, {'\u0b3c', '\u0b3c'}, {'\u0b3f', '\u0b3f'}, {'\u0b41', '\u0b43'}, {'\u0b4d', '\u0b4d'}, {'\u0bc0', '\u0bc0'}, {'\u0bcd', '\u0bcd'}, {'\u0c3e', '\u0c40'}, {'\u0c46', '\u0c56'}, {'\u0cbf', '\u0cbf'}, {'\u0cc6', '\u0cc6'}, {'\u0ccc', '\u0ccd'}, {'\u0d41', '\u0d43'}, {'\u0d4d', '\u0d4d'}, {'\u0e31', '\u0e31'}, {'\u0e34', '\u0e3a'}, {'\u0e47', '\u0e4d'}, {'\u0eb1', '\u0eb1'}, {'\u0eb4', '\u0ebc'}, {'\u0ec8', '\u0ecd'}, {'\u1026', '\u102a'}, {'\u102e', '\u102e'}, {'\u1030', '\u1030'}, {'\u1036', '\u1037'}, {'\u103b', '\u103b'}, {'\u103d', '\u103e'}, {'\u104b', '\u104c'}, {'\u20d0', '\u20ff'}, {'\u302a', '\u302f'}, {'\u3099', '\u309a'}};
    private static final char[][] symPairs = new char[][]{{'(', ')'}, {')', '('}, {'<', '>'}, {'>', '<'}, {'[', ']'}, {']', '['}, {'{', '}'}, {'}', '{'}, {'\u00ab', '\u00bb'}, {'\u00bb', '\u00ab'}, {'\u207d', '\u207e'}, {'\u207e', '\u207d'}, {'\u208d', '\u208e'}, {'\u208e', '\u208d'}, {'\u2329', '\u232a'}, {'\u232a', '\u2329'}, {'\ufe59', '\ufe5a'}, {'\ufe5a', '\ufe59'}, {'\ufe5b', '\ufe5c'}, {'\ufe5c', '\ufe5b'}, {'\ufe5d', '\ufe5e'}, {'\ufe5e', '\ufe5d'}, {'\ufe64', '\ufe65'}, {'\ufe65', '\ufe64'}};
    private static final short[][] impTab_LTR = new short[][]{{0, 0, 0, 3, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 3, 0, 1, 4, 4, 2, 4, 4, 2, 0}, {0, 0, 0, 3, 0, 1, 4, 4, 4, 4, 4, 2, 1}, {0, 0, 0, 3, 6, 1, 5, 4, 4, 4, 4, 1, 0}, {0, 0, 0, 3, 102, 97, 5, 4, 4, 4, 4, 1, 1}, {0, 0, 0, 3, 102, 65, 5, 4, 4, 4, 4, 1, 1}, {0, 0, 0, 3, 6, 1, 8, 7, 7, 4, 4, 2, 0}, {0, 0, 0, 3, 6, 65, 5, 4, 4, 4, 4, 2, 1}, {0, 0, 0, 3, 6, 1, 5, 4, 4, 4, 4, 2, 0}};
    private static final short[][] impTab_RTL = new short[][]{{0, 0, 7, 0, 2, 5, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 167, 0, 2, 165, 129, 0, 0, 0, 0, 0, 1}, {0, 0, 7, 0, 2, 5, 4, 3, 3, 0, 0, 1, 0}, {0, 0, 39, 0, 2, 37, 33, 0, 0, 0, 0, 1, 1}, {0, 0, 7, 0, 2, 5, 1, 0, 0, 0, 0, 1, 0}, {0, 0, 7, 0, 2, 5, 1, 0, 6, 0, 0, 1, 0}, {0, 0, 39, 0, 36, 5, 33, 0, 0, 0, 0, 1, 1}, {0, 0, 7, 0, 9, 5, 8, 8, 8, 8, 8, 1, 0}, {0, 0, 7, 0, 9, 37, 8, 8, 8, 8, 8, 1, 1}, {0, 0, 7, 0, 9, 5, 7, 8, 8, 8, 8, 1, 0}};
    private static final short[][] impTab_LTR_r = new short[][]{{0, 0, 0, 3, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 3, 0, 1, 4, 4, 2, 4, 4, 2, 0}, {0, 0, 0, 3, 0, 1, 4, 4, 4, 4, 4, 1, 1}, {0, 0, 0, 3, 6, 1, 5, 4, 4, 4, 4, 1, 0}, {0, 0, 0, 163, 6, 161, 5, 4, 4, 4, 4, 1, 1}, {0, 0, 0, 163, 198, 161, 5, 4, 4, 4, 4, 1, 1}, {0, 0, 0, 163, 6, 161, 8, 7, 7, 4, 4, 2, 1}, {0, 0, 0, 163, 198, 161, 5, 4, 4, 4, 4, 1, 1}, {0, 0, 0, 163, 6, 161, 5, 4, 4, 4, 4, 2, 1}};
    private static final short[][] impTab_RTL_r = new short[][]{{0, 0, 7, 0, 2, 5, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 167, 0, 194, 165, 1, 0, 0, 0, 0, 0, 1}, {160, 160, 7, 160, 2, 165, 4, 3, 3, 10, 10, 1, 1}, {160, 160, 7, 160, 194, 165, 11, 10, 10, 10, 10, 0, 1}, {160, 160, 7, 160, 2, 165, 4, 10, 10, 10, 10, 1, 1}, {0, 0, 7, 0, 2, 5, 1, 0, 6, 0, 0, 1, 0}, {0, 0, 167, 0, 164, 5, 161, 0, 0, 0, 0, 0, 1}, {0, 0, 7, 0, 9, 5, 8, 8, 8, 8, 8, 1, 0}, {0, 0, 7, 0, 9, 165, 8, 8, 8, 8, 8, 0, 1}, {0, 0, 7, 0, 9, 5, 7, 8, 8, 8, 8, 1, 0}, {160, 160, 7, 160, 2, 165, 11, 10, 10, 10, 10, 0, 1}, {160, 160, 7, 160, 194, 165, 11, 10, 10, 10, 10, 0, 1}};
    int ucb_ix;
    byte ucb_outLev;
    byte ucb_basLev;
    byte ucb_curLev;
    byte ucb_impLev;
    int ucb_impSta;
    int ucb_araLet;
    int ucb_lineSepPos;
    int ucb_condPos;
    int ucb_Shaping;
    int ucb_xType;
    byte ucb_wTarget;
    int ucb_pType;
    BidiFlag ics_num_flag;
    int ics_formShp;
    boolean ics_symmetric;
    BidiFlag ics_orient_in;
    BidiFlag ics_orient_out;
    BidiFlag ics_type_in;
    BidiFlag ics_type_out;
    BidiFlag ics_txtShp_flag;
    int ics_size;
    int ics_size_out;
    int ics_orient;
    int ics_wordbreak;
    int ics_flip_flag;
    int ics_num;
    boolean ics_compc;
    char[] ics_buffer_in;
    char[] ics_buffer_out;
    byte[] ics_A_level;
    int[] ics_SrcToTrgMap;
    int[] ics_TrgToSrcMap;
    byte[] specialTreatment;
    boolean notImpToImp;
    boolean visToVis;
    short[][] impTab;
    boolean roundTrip;

    BidiOrder() {
    }

    private static boolean odd(int n) {
        return (n & 1) == 1;
    }

    private static boolean even(int n) {
        return (n & 1) == 0;
    }

    private static boolean UCQSPAC(char c) {
        int n = 0;
        int n2 = notSpacing.length - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            if (c < notSpacing[n3][0]) {
                n2 = n3 - 1;
                continue;
            }
            if (c > notSpacing[n3][1]) {
                n = n3 + 1;
                continue;
            }
            return false;
        }
        return true;
    }

    private static char UCQSYMM(char c) {
        int n = 0;
        int n2 = 23;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            char c2 = symPairs[n3][0];
            if (c < c2) {
                n2 = n3 - 1;
                continue;
            }
            if (c > c2) {
                n = n3 + 1;
                continue;
            }
            return symPairs[n3][1];
        }
        return c;
    }

    private void implicitProcessing() {
        short s;
        int n = 0;
        int n2 = this.impTab[this.ucb_impSta][this.ucb_xType];
        short s2 = (short)(n2 >> 5);
        n2 = (short)(n2 & 0x1F);
        short s3 = this.impTab[n2][11];
        if (s2 > 0) {
            switch (s2) {
                case 1: {
                    for (n = this.ucb_condPos; n < this.ucb_ix; ++n) {
                        this.ics_A_level[n] = this.ucb_curLev;
                    }
                    this.ucb_condPos = -1;
                    break;
                }
                case 2: {
                    for (n = this.ucb_condPos; n < this.ucb_ix; ++n) {
                        this.ics_A_level[n] = (byte)(this.ucb_curLev + 1);
                    }
                    this.ucb_condPos = -1;
                    break;
                }
                case 3: {
                    for (n = this.ucb_condPos; n < this.ucb_ix; ++n) {
                        this.ics_A_level[n] = (byte)(this.ucb_curLev + 1);
                    }
                    this.ics_A_level[n] = (byte)(this.ucb_curLev + 2);
                    this.ucb_condPos = -1;
                    break;
                }
                case 4: {
                    this.ucb_condPos = this.ucb_ix;
                    break;
                }
                case 5: {
                    this.ucb_condPos = -1;
                    break;
                }
                case 6: {
                    this.ics_A_level[this.ucb_ix - 1] = (byte)(this.ucb_curLev + 2);
                }
            }
        }
        if ((s = this.impTab[n2][12]) == 0) {
            if (this.ucb_condPos > -1) {
                for (n = this.ucb_condPos; n < this.ucb_ix; ++n) {
                    this.ics_A_level[n] = (byte)(this.ucb_curLev + s3);
                    if ((this.ucb_curLev + s3) % 2 != 0) continue;
                    this.specialTreatment[n] = 0;
                }
            }
            this.ucb_condPos = -1;
            if (this.ucb_lineSepPos >= 0) {
                this.ics_A_level[this.ucb_lineSepPos] = 0;
                this.ucb_lineSepPos = -1;
            }
        } else if (this.ucb_condPos == -1) {
            this.ucb_condPos = this.ucb_ix;
        }
        this.ucb_impLev = (byte)s3;
        this.ucb_impSta = n2;
        this.ucb_wTarget = (byte)(this.ucb_curLev + this.ucb_impLev);
    }

    private static int getChType(char c) {
        if (c == '\n' || c == '\r' || c >= '\u001c' && c <= '\u001e' || c == '\u0085' || c == '\u2029') {
            return 0;
        }
        if (c == '\t' || c == '\u000b' || c == '\u001f') {
            return 1;
        }
        if (c > '@' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8' && c <= '\u058f' || c >= '\u0900' && c <= '\u10ff' || c == '\u200e' || c >= '\u20d0' && c <= '\u20ff' || c >= '\u2160' && c <= '\u2182' || c >= '\u3040' && c <= '\u9fff' || c >= '\uf900' && c <= '\ufb17' || c == '\ufe60' || c == '\ufe6b' || c == '\uff06' || c >= '\uff20' && c <= '\uff3a' || c >= '\uff41' && c <= '\uff5a' || c >= '\uff60' && c <= '\uffdf') {
            return 2;
        }
        if (c >= '\u05d0' && c <= '\u065f' || c >= '\u066e' && c <= '\u06ef' || c >= '\u06fa' && c <= '\u08ff' || c == '\u200f' || c >= '\ufb20' && c <= '\ufdff' || c >= '\ufe70' && c <= '\ufefc') {
            return 3;
        }
        if (c >= '0' && c <= '9' || c >= '\u00b2' && c <= '\u00b3' || c == '\u00b9' || c >= '\u06f0' && c <= '\u06f9' || c == '\u2070' || c >= '\u2074' && c <= '\u2079' || c >= '\u2080' && c <= '\u2089' || c >= '\u2460' && c <= '\u249b' || c == '\u24ea' || c >= '\uff10' && c <= '\uff19') {
            return 4;
        }
        if (c >= '\u0660' && c <= '\u0669' || c >= '\u066b' && c <= '\u066c') {
            return 5;
        }
        if (c >= '#' && c <= '%' || c == '+' || c == '-' || c >= '\u00a2' && c <= '\u00a5' || c >= '\u00b0' && c <= '\u00b1' || c == '\u066a' || c >= '\u09f2' && c <= '\u09f3' || c == '\u0af1' || c == '\u0bf9' || c == '\u0e3f' || c == '\u17db' || c >= '\u2030' && c <= '\u2034' || c >= '\u207a' && c <= '\u207b' || c >= '\u208a' && c <= '\u208b' || c >= '\u20a0' && c <= '\u20b1' || c == '\u212e' || c >= '\u2212' && c <= '\u2213' || c == '\ufb29' || c == '\ufe5f' || c >= '\ufe62' && c <= '\ufe63' || c >= '\ufe69' && c <= '\ufe6a' || c >= '\uff03' && c <= '\uff05' || c == '\uff0b' || c == '\uff0d' || c >= '\uffe0' && c <= '\uffe1' || c >= '\uffe5' && c <= '\uffe6') {
            return 6;
        }
        if (c == '/' || c == '\uff0f') {
            return 7;
        }
        if (c == ',' || c == '.' || c == ':' || c == '\u00a0' || c == '\u060c' || c == '\ufe50' || c == '\ufe52' || c == '\ufe55' || c == '\uff0c' || c == '\uff0e' || c == '\uff1a') {
            return 8;
        }
        if (c == '\f' || c == ' ' || c == '\u1680' || c == '\u180e' || c >= '\u2000' && c <= '\u200a' || c == '\u2028' || c == '\u202f' || c == '\u205f' || c == '\u3000') {
            return 9;
        }
        if (c >= '\u202a' && c <= '\u202e' || c >= '\u206c' && c <= '\u206f') {
            return 11;
        }
        return 10;
    }

    private static int firstStrong(char[] cArray, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = BidiOrder.getChType(cArray[i]);
            if (n2 != 2 && n2 != 3) continue;
            return n2;
        }
        return 10;
    }

    private static int lastStrong(char[] cArray, int n) {
        for (int i = n - 1; i >= 0; --i) {
            int n2 = BidiOrder.getChType(cArray[i]);
            if (n2 != 2 && n2 != 3) continue;
            return n2;
        }
        return 10;
    }

    private void BaseLvl() {
        int n;
        if (this.ics_orient_in == BidiFlag.ORIENTATION_CONTEXT_LTR || this.ics_orient_in == BidiFlag.ORIENTATION_CONTEXT_RTL) {
            n = BidiOrder.firstStrong(this.ics_buffer_in, this.ics_size);
            switch (n) {
                case 2: {
                    this.ics_orient_in = BidiFlag.ORIENTATION_LTR;
                    break;
                }
                case 3: {
                    this.ics_orient_in = BidiFlag.ORIENTATION_RTL;
                    break;
                }
                case 10: {
                    this.ics_orient_in = this.ics_orient_in == BidiFlag.ORIENTATION_CONTEXT_RTL ? BidiFlag.ORIENTATION_RTL : BidiFlag.ORIENTATION_LTR;
                }
            }
        }
        if (this.ics_orient_out == BidiFlag.ORIENTATION_CONTEXT_LTR || this.ics_orient_out == BidiFlag.ORIENTATION_CONTEXT_RTL) {
            n = BidiOrder.firstStrong(this.ics_buffer_in, this.ics_size);
            switch (n) {
                case 2: {
                    n = BidiOrder.lastStrong(this.ics_buffer_in, this.ics_size);
                    if (n == 3) {
                        this.ics_orient_out = BidiFlag.ORIENTATION_RTL;
                        break;
                    }
                    this.ics_orient_out = BidiFlag.ORIENTATION_LTR;
                    break;
                }
                case 3: {
                    this.ics_orient_out = BidiFlag.ORIENTATION_RTL;
                    break;
                }
                case 10: {
                    this.ics_orient_out = this.ics_orient_out == BidiFlag.ORIENTATION_CONTEXT_RTL ? BidiFlag.ORIENTATION_RTL : BidiFlag.ORIENTATION_LTR;
                }
            }
        }
        this.visToVis = false;
        if (this.ics_type_in == BidiFlag.TYPE_VISUAL && this.ics_type_out == BidiFlag.TYPE_IMPLICIT) {
            this.ucb_basLev = this.ics_orient_out == BidiFlag.ORIENTATION_RTL ? (byte)1 : 0;
            this.ucb_outLev = 0;
            this.ucb_curLev = this.ucb_basLev;
            if (this.ucb_basLev == 0) {
                this.ucb_curLev = (byte)2;
            }
        } else {
            this.ucb_basLev = this.ics_orient_in == BidiFlag.ORIENTATION_RTL ? (byte)1 : 0;
            this.ucb_outLev = this.ics_orient_out == BidiFlag.ORIENTATION_RTL ? (byte)1 : 0;
            this.ucb_curLev = this.ucb_basLev;
            if (this.ucb_basLev == 0 && this.ucb_outLev == 1) {
                this.ucb_curLev = (byte)2;
            }
            if (this.ics_type_in == BidiFlag.TYPE_VISUAL) {
                this.visToVis = true;
            }
        }
        this.ucb_lineSepPos = -1;
        this.impTab = this.roundTrip ? ((this.ucb_curLev & 1) == 1 ? impTab_RTL_r : impTab_LTR_r) : ((this.ucb_curLev & 1) == 1 ? impTab_RTL : impTab_LTR);
        this.ucb_impSta = 0;
        this.ucb_impLev = 0;
        this.ucb_condPos = -1;
    }

    /*
     * Unable to fully structure code
     */
    private void pass1() {
        var4_1 = 0;
        if (this.ucb_ix == 0) {
            this.ucb_pType = 0;
        }
        this.ucb_wTarget = 0;
        var2_2 = this.ics_buffer_in[this.ucb_ix];
        var1_3 = BidiOrder.getChType(var2_2);
        switch (var1_3) {
            case 11: {
                switch (var2_2) {
                    case '\u206c': {
                        this.ics_formShp = 0;
                        break;
                    }
                    case '\u206d': {
                        this.ics_formShp = 1;
                        break;
                    }
                    case '\u206e': {
                        this.ics_num_flag = BidiFlag.NUMERALS_NATIONAL;
                        break;
                    }
                    case '\u206f': {
                        this.ics_num_flag = BidiFlag.NUMERALS_NOMINAL;
                    }
                }
                break;
            }
            case 0: {
                this.ucb_xType = 0;
                this.implicitProcessing();
                this.ucb_wTarget = 0;
                var4_1 = 0;
                this.BaseLvl();
                break;
            }
            case 1: {
                this.ucb_xType = 1;
                this.implicitProcessing();
                this.ucb_wTarget = this.ucb_basLev;
                break;
            }
            default: {
                if (var2_2 == '\u2028') {
                    this.ucb_lineSepPos = this.ucb_ix;
                    this.ucb_wTarget = 0;
                    break;
                }
                if (var1_3 == 4 && this.ics_num_flag == BidiFlag.NUMERALS_NATIONAL) {
                    var4_1 = 1;
                    var1_3 = 5;
                }
                if (var1_3 == 5 && this.ics_num_flag == BidiFlag.NUMERALS_NOMINAL) {
                    var4_1 = 2;
                    var1_3 = 4;
                }
                if (var1_3 != 4 || this.ics_num_flag != BidiFlag.NUMERALS_CONTEXTUAL) ** GOTO lbl66
                if (this.ucb_pType != 5) ** GOTO lbl51
                var4_1 = 5;
                var1_3 = 5;
                ** GOTO lbl66
lbl51:
                // 1 sources

                if (this.ucb_pType != 9 && this.ucb_pType != 10 && this.ucb_pType != 8 && this.ucb_pType != 7 || this.ucb_ix <= 0 || (this.specialTreatment[this.ucb_ix - 1] & 4) != 0) ** GOTO lbl63
                var5_4 = 0;
                for (var5_4 = this.ucb_ix - 2; var5_4 >= 0; --var5_4) {
                    this.ucb_pType = BidiOrder.getChType(this.ics_buffer_in[var5_4]);
                    if (this.ucb_pType == 3 || (this.specialTreatment[var5_4] & 4) != 0) {
                        var4_1 = 5;
                        var1_3 = 5;
                    } else if (this.ucb_pType != 2 && (this.ucb_pType != 4 || (this.specialTreatment[var5_4] & 4) != 0)) {
                        continue;
                    }
                    ** GOTO lbl66
                }
                ** GOTO lbl66
lbl63:
                // 1 sources

                if (this.ucb_ix > 0 && (this.specialTreatment[this.ucb_ix - 1] & 4) != 0 || this.ucb_pType == 3) {
                    var4_1 = 5;
                    var1_3 = 5;
                }
lbl66:
                // 8 sources

                if (var1_3 == 2) {
                    this.ucb_araLet = 0;
                }
                if (var1_3 == 3) {
                    if (var2_2 >= '\u0600' && var2_2 <= '\u06ef') {
                        this.ucb_araLet = 1;
                        if (this.ics_txtShp_flag != BidiFlag.TEXT_NOMINAL) {
                            this.ucb_Shaping = 1;
                        }
                    }
                    if (var2_2 >= '\ufb50' && var2_2 <= '\ufefc') {
                        this.ucb_araLet = 1;
                        if (this.ics_txtShp_flag != BidiFlag.TEXT_NOMINAL && this.ics_formShp == 1) {
                            this.ucb_Shaping = 1;
                        }
                    }
                }
                if (var1_3 == 6) {
                    var5_4 = 0;
                    var6_5 = 0;
                    if (this.ucb_pType == 4) {
                        var1_3 = 4;
                    } else if (this.ucb_pType == 5) {
                        var1_3 = 10;
                    }
                    while (var5_4 == 0) {
                        if (this.ucb_ix + var6_5 + 1 >= this.ics_size) {
                            var5_4 = 1;
                            continue;
                        }
                        this.ucb_pType = BidiOrder.getChType(this.ics_buffer_in[this.ucb_ix + var6_5 + 1]);
                        if (this.ucb_pType == 4) {
                            var1_3 = this.ucb_araLet == 1 ? 10 : 4;
                            var5_4 = 1;
                        } else if (this.ucb_pType == 5) {
                            var1_3 = 10;
                            var5_4 = 1;
                        }
                        if (this.ucb_pType == 6) {
                            ++var6_5;
                            continue;
                        }
                        var5_4 = 1;
                    }
                }
                if (var1_3 == 7 || var1_3 == 8) {
                    v0 = this.ucb_xType = this.ucb_ix + 1 < this.ics_size ? BidiOrder.getChType(this.ics_buffer_in[this.ucb_ix + 1]) : 0;
                    var1_3 = this.ucb_pType == 4 ? (this.ucb_xType == 4 ? 4 : 10) : (this.ucb_pType == 5 && var1_3 == 8 ? (this.ucb_xType == 4 ? 5 : 10) : 10);
                }
                var3_6 = this.ucb_impLev;
                this.ucb_xType = var1_3;
                if (this.visToVis) {
                    this.ucb_xType = 10;
                }
                this.implicitProcessing();
                if (!BidiOrder.UCQSPAC(var2_2)) {
                    this.ucb_wTarget = var2_2 >= '\u064b' && var2_2 <= '\u0652' ? (byte)(this.ucb_curLev + this.ucb_impLev) : (byte)(this.ucb_curLev + var3_6);
                    var1_3 = this.ucb_ix == 0 ? 10 : this.ucb_pType;
                    if (this.ucb_condPos == this.ucb_ix) {
                        this.ucb_condPos = -1;
                    }
                }
                if (var1_3 != 10 || !this.ics_symmetric || this.ucb_condPos <= -1 && !BidiOrder.odd(this.ucb_curLev + this.ucb_impLev) || BidiOrder.UCQSYMM(var2_2) == var2_2) break;
                var4_1 = 8;
            }
        }
        this.ucb_pType = var1_3;
        this.ics_A_level[this.ucb_ix] = this.ucb_wTarget;
        this.specialTreatment[this.ucb_ix] = var4_1;
    }

    private void pass2() {
        int n;
        int[] nArray = new int[20];
        int[] nArray2 = new int[20];
        int n2 = 0;
        for (n = 0; n < 19; ++n) {
            nArray[n] = 0;
            nArray2[n] = this.ics_size - 1;
        }
        this.ucb_ix = 0;
        while (this.ucb_ix < this.ics_size) {
            int n3;
            int n4 = n3 = this.ics_A_level[this.ucb_ix];
            if ((this.specialTreatment[this.ucb_ix] & 8) > 0 && BidiOrder.even(n4)) {
                this.specialTreatment[this.ucb_ix] = 0;
            }
            n = this.ucb_ix;
            if (n4 > n2) {
                int n5 = this.ucb_ix + 1;
                for (int i = n4; i > n2; --i) {
                    nArray[i] = this.ucb_ix;
                    while (n5 < this.ics_size && this.ics_A_level[n5] >= i) {
                        ++n5;
                    }
                    nArray2[i] = n5 - 1;
                }
            }
            if (this.notImpToImp) {
                for (n3 = n4; n3 >= this.ucb_outLev + 1; --n3) {
                    n = nArray[n3] + nArray2[n3] - n;
                }
            }
            this.ics_TrgToSrcMap[this.ucb_ix] = n;
            n2 = n4;
            ++this.ucb_ix;
        }
    }

    private void pass3() {
        this.ucb_ix = 0;
        while (this.ucb_ix < this.ics_size) {
            int n;
            int n2 = this.ucb_ix;
            int n3 = this.ics_TrgToSrcMap[this.ucb_ix];
            while ((n3 & Integer.MIN_VALUE) == 0 && ((n = this.ics_TrgToSrcMap[n3]) & Integer.MIN_VALUE) == 0) {
                this.ics_TrgToSrcMap[n3] = n2 | Integer.MIN_VALUE;
                n2 = n3;
                n3 = n;
            }
            ++this.ucb_ix;
        }
        this.ucb_ix = 0;
        while (this.ucb_ix < this.ics_size) {
            int n = this.ucb_ix++;
            this.ics_TrgToSrcMap[n] = this.ics_TrgToSrcMap[n] & Integer.MAX_VALUE;
        }
    }

    private void pass4() {
        for (int i = 0; i < this.ics_size; ++i) {
            int n = this.ics_TrgToSrcMap[i];
            byte by = this.specialTreatment[n];
            char c = this.ics_buffer_in[n];
            if ((by & 1) > 0) {
                if (c >= '0' && c <= '9') {
                    c = (char)(c + 1584);
                }
            } else if ((by & 2) > 0) {
                if (c >= '\u0660' && c <= '\u0669') {
                    c = (char)(c - 1584);
                }
            } else if ((by & 8) > 0) {
                c = BidiOrder.UCQSYMM(c);
            }
            this.ics_buffer_out[i] = c;
        }
    }

    synchronized void order(BidiText bidiText, BidiText bidiText2, BidiTransform bidiTransform) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (bidiText.count < 1) {
            return;
        }
        this.roundTrip = bidiTransform.roundTrip;
        this.ics_orient_in = bidiText.flags.getOrientation();
        this.ics_orient_out = bidiText2.flags.getOrientation();
        this.ics_type_in = bidiText.flags.getType();
        this.ics_type_out = bidiText2.flags.getType();
        this.notImpToImp = this.ics_type_in != BidiFlag.TYPE_IMPLICIT | this.ics_type_out != BidiFlag.TYPE_IMPLICIT;
        this.ics_buffer_in = new char[bidiText.count];
        if (this.ics_orient_in == BidiFlag.ORIENTATION_RTL && this.ics_type_in == BidiFlag.TYPE_VISUAL && this.ics_type_out != BidiFlag.TYPE_VISUAL) {
            int n2 = bidiText.offset + bidiText.count - 1;
            for (int i = 0; i < bidiText.count; ++i) {
                this.ics_buffer_in[i] = bidiText.data[n2 - i];
            }
            this.ics_orient_in = BidiFlag.ORIENTATION_LTR;
        } else {
            System.arraycopy(bidiText.data, bidiText.offset, this.ics_buffer_in, 0, bidiText.count);
        }
        this.ics_size_out = 0;
        this.ics_size = bidiText.count;
        this.ics_num_flag = bidiText2.flags.getNumerals();
        this.ics_txtShp_flag = bidiText2.flags.getText();
        this.ics_compc = false;
        this.ics_formShp = 0;
        this.ics_symmetric = bidiText2.flags.getSwap() != bidiText.flags.getSwap();
        this.ics_buffer_out = new char[this.ics_buffer_in.length];
        this.ics_A_level = new byte[bidiText.count];
        this.ics_TrgToSrcMap = new int[bidiText.count];
        this.specialTreatment = new byte[bidiText.count];
        this.ucb_ix = 0;
        this.ucb_pType = 0;
        this.ucb_Shaping = 0;
        this.ucb_araLet = 0;
        this.BaseLvl();
        while (this.ucb_ix < this.ics_size) {
            this.pass1();
            ++this.ucb_ix;
        }
        this.ucb_xType = 0;
        this.implicitProcessing();
        this.pass2();
        this.pass3();
        this.pass4();
        if (this.ics_compc) {
            this.ics_SrcToTrgMap = new int[bidiText.count];
            for (n = 0; n < this.ics_size; ++n) {
                this.ics_SrcToTrgMap[this.ics_TrgToSrcMap[this.ics_TrgToSrcMap[n]]] = this.ics_TrgToSrcMap[n];
            }
        }
        System.arraycopy(this.ics_buffer_out, 0, bidiText2.data, bidiText2.offset, bidiText.count);
        bidiText2.count = bidiText.count;
    }
}

