/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.IBMCharsetDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;

class DBA_Decoder
extends IBMCharsetDecoder {
    private final byte[] leadByte;
    private final boolean maplow;
    private final char[] singleMap;
    char[] charMap;

    protected DBA_Decoder(Charset charset, byte[] byArray, char[] cArray, byte by, char[] cArray2) {
        super(charset, 1.0f, 1.0f);
        this.leadByte = byArray;
        this.singleMap = cArray;
        this.maplow = by == 1;
        this.charMap = cArray2;
    }

    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n;
        byte[] byArray = byteBuffer.array();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        int n5 = 1;
        CoderResult coderResult = CoderResult.UNDERFLOW;
        for (n = byteBuffer.arrayOffset() + byteBuffer.position(); n < n2; n += n5) {
            char c;
            int n6 = byArray[n] & 0xFF;
            if (this.leadByte[n6] == 0) {
                c = this.maplow && n6 < 128 ? (char)n6 : this.singleMap[n6];
                n5 = 1;
            } else {
                if (n + 1 >= n2) break;
                n6 = (n6 << 8) + (byArray[n + 1] & 0xFF);
                c = this.charMap[n6];
                n5 = 2;
            }
            if (c == '\u0000' && n6 != 0) {
                coderResult = CoderResult.unmappableForLength(1);
                break;
            }
            if (n4 - n3 < 1) {
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            cArray[n3++] = c;
        }
        byteBuffer.position(n - byteBuffer.arrayOffset());
        charBuffer.position(n3 - charBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        int n2 = 1;
        try {
            while (byteBuffer.hasRemaining()) {
                char c;
                int n3 = byteBuffer.get() & 0xFF;
                if (this.leadByte[n3] == 0) {
                    c = this.maplow && n3 < 128 ? (char)n3 : this.singleMap[n3];
                    n2 = 1;
                } else {
                    if (!byteBuffer.hasRemaining()) break;
                    n3 = (n3 << 8) + (byteBuffer.get() & 0xFF);
                    c = this.charMap[n3];
                    n2 = 2;
                }
                if (c == '\u0000' && n3 != 0) {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (!charBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                n += n2;
                charBuffer.put(c);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    protected final CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray() && !UseBuffer) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }
}

