/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.IBMCharsetEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

class UTF32Encoder
extends IBMCharsetEncoder {
    protected static final int BYTE_ORDER_MARK = 65279;
    protected static final int REVERSED_MARK = -131072;
    protected static final int BIG = 2;
    protected static final int LITTLE = 1;
    private int byteOrder;
    private boolean usesMark;
    private boolean needsMark;
    private final Surrogate.Parser sgp;

    protected UTF32Encoder(Charset charset, int n, boolean bl) {
        byte[] byArray;
        float f = bl ? 8.0f : 4.0f;
        if (n == 1) {
            byte[] byArray2 = new byte[4];
            byArray2[0] = -3;
            byArray2[1] = -1;
            byArray2[2] = 0;
            byArray = byArray2;
            byArray2[3] = 0;
        } else {
            byte[] byArray3 = new byte[4];
            byArray3[0] = 0;
            byArray3[1] = 0;
            byArray3[2] = -1;
            byArray = byArray3;
            byArray3[3] = -3;
        }
        super(charset, 4.0f, f, byArray);
        this.sgp = new Surrogate.Parser();
        this.usesMark = this.needsMark = bl;
        this.byteOrder = n;
        if (n == 0) {
            this.byteOrder = 2;
        }
    }

    private void put(int n, ByteBuffer byteBuffer) {
        if (this.byteOrder == 2) {
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)(n >> 16 & 0xFF));
            byteBuffer.put((byte)(n >> 8 & 0xFF));
            byteBuffer.put((byte)(n & 0xFF));
        } else {
            byteBuffer.put((byte)(n & 0xFF));
            byteBuffer.put((byte)(n >> 8 & 0xFF));
            byteBuffer.put((byte)(n >> 16 & 0xFF));
            byteBuffer.put((byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        if (this.needsMark) {
            if (byteBuffer.remaining() < 4) {
                return CoderResult.OVERFLOW;
            }
            this.put(65279, byteBuffer);
            this.needsMark = false;
        }
        try {
            while (charBuffer.hasRemaining()) {
                int n2 = charBuffer.get();
                if (Surrogate.is(n2)) {
                    if ((n2 = this.sgp.parse((char)n2, charBuffer)) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    if (byteBuffer.remaining() < 4) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    n += 2;
                } else {
                    if (byteBuffer.remaining() < 4) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    ++n;
                }
                this.put(n2, byteBuffer);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    protected void implReset() {
        this.needsMark = this.usesMark;
    }
}

