/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.ce.cm.DuplicateKeyException;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.ce.cm.StaleStatementException;
import com.ibm.websphere.rsadapter.GenericDataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.cci.WSRelationalRAAdapter;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.transaction.xa.XAException;

public class DB2DataStoreHelper
extends GenericDataStoreHelper {
    private static final TraceComponent tc = Tr.register((Class)DB2DataStoreHelper.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    protected static final TraceComponent db2Tc = Tr.register((String)"com.ibm.ws.db2.logwriter", (String)"WAS.database", null);
    HashMap db2ErrorMap = new HashMap(37);
    private static final int HASHSIZE = 37;
    private HashMap userNewMap = null;
    private boolean db2ZOS;
    private String productName = null;
    private String currentSQLid = null;

    public DB2DataStoreHelper(Properties properties) {
        super(properties);
        if (properties != null) {
            this.currentSQLid = properties.getProperty("currentSQLID");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"DSConfigurationHelper.ZOS_CURRENT_SQLID is", (Object)this.currentSQLid);
            }
        }
        this.addInitialMaps();
        this.dshMd.setGetTypeMapSupport(false);
        this.dshMd.setHelperType(1);
        this.dshMd.setStatementCacheIsoLevel(true);
        this.dshMd.setDatabaseDefaultIsolationLevel(4, this.customDefinedWasDefaultIsoLevel);
        String string = System.getProperty("os.name");
        if (string.equalsIgnoreCase("OS/390") || string.equalsIgnoreCase("Z/OS")) {
            this.db2ZOS = true;
            this.dshMd.setExtendedForUpdateSupport(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"the metadata for the Db2 is", (Object)this.dshMd);
            Tr.debug((TraceComponent)tc, (String)"done constructing DB2DataStoreHelper:", (Object)this);
        }
    }

    private void addInitialMaps() {
        this.db2ErrorMap.put(new Integer(-1015), StaleConnectionException.class);
        this.db2ErrorMap.put(new Integer(-1034), StaleConnectionException.class);
        this.db2ErrorMap.put(new Integer(-1035), StaleConnectionException.class);
        this.db2ErrorMap.put(new Integer(-6036), StaleConnectionException.class);
        this.db2ErrorMap.put(new Integer(-30081), StaleConnectionException.class);
        this.db2ErrorMap.put(new Integer(-30108), StaleConnectionException.class);
        this.db2ErrorMap.put(new Integer(-1224), StaleConnectionException.class);
        this.db2ErrorMap.put(new Integer(-1229), StaleConnectionException.class);
        this.db2ErrorMap.put("58004", StaleConnectionException.class);
        this.db2ErrorMap.put(new Integer(-518), StaleStatementException.class);
        this.db2ErrorMap.put(new Integer(-514), StaleStatementException.class);
        this.db2ErrorMap.put(new Integer(-803), DuplicateKeyException.class);
        this.db2ErrorMap.put(new Integer(-30080), StaleConnectionException.class);
        this.db2ErrorMap.put(new Integer(-924), StaleConnectionException.class);
        this.db2ErrorMap.put(new Integer(-923), StaleConnectionException.class);
        this.db2ErrorMap.put(new Integer(-906), StaleConnectionException.class);
        this.db2ErrorMap.put("S1000", Void.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doConnectionSetup(Connection connection) throws SQLException {
        Wrapper wrapper;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("doConnectionSetup: " + this));
        }
        if (this.productName == null) {
            wrapper = connection.getMetaData();
            this.productName = wrapper.getDatabaseProductName();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Product name = " + this.productName));
            }
            if (this.productName.equals("DB2") || this.productName.toUpperCase().startsWith("DSN")) {
                this.db2ZOS = true;
                this.dshMd.setExtendedForUpdateSupport(true);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("DB2DataStoreHelper.doConnectionSetup updated DataStoreMetaData to relfect db2 zOS values: " + this.dshMd.toString()));
                }
            } else {
                this.db2ZOS = false;
                this.dshMd.setExtendedForUpdateSupport(false);
            }
        }
        wrapper = null;
        try {
            if (this.currentSQLid != null && !this.currentSQLid.equals("")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Setting currentSQLID : " + this.currentSQLid));
                }
                wrapper = connection.createStatement();
                String string = "set current sqlid = '" + this.currentSQLid + "'";
                wrapper.executeUpdate(string);
            }
        }
        finally {
            block20: {
                try {
                    if (wrapper != null) {
                        wrapper.close();
                    }
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.websphere.rsadapter.DB2DataStoreHelper.doConnectionSetup", (String)"231", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block20;
                    Tr.debug((TraceComponent)tc, (String)"SQLException occured in closing the statement ", (Object)sQLException);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            if (this.db2ZOS) {
                Tr.exit((TraceComponent)tc, (String)"doConnectionSetup exit and db2ZOS flag is  ", (Object)"TRUE");
            } else {
                Tr.exit((TraceComponent)tc, (String)"doConnectionSetup exit and db2ZOS flag is  ", (Object)"FALSE");
            }
        }
    }

    public void doStatementCleanup(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setFetchDirection(1000);
        if (preparedStatement.getMaxFieldSize() != 0) {
            preparedStatement.setMaxFieldSize(0);
        }
        if (preparedStatement.getMaxRows() != 0) {
            preparedStatement.setMaxRows(0);
        }
        preparedStatement.setQueryTimeout(0);
    }

    public final Class findMappingClass(SQLException sQLException) {
        Object var2_2 = null;
        String string = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("findMappingClass for: " + sQLException));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"the DataStoreHelper is: ", (Object)this);
        }
        if (sQLException != null) {
            if (this.userNewMap != null) {
                var2_2 = this.userNewMap.get(new Integer(sQLException.getErrorCode()));
                if (var2_2 != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"findMappingClass return: ", var2_2);
                    }
                    return var2_2;
                }
                string = sQLException.getSQLState();
                if (string != null && (var2_2 = this.userNewMap.get(string)) != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"findMappingClass return: ", var2_2);
                    }
                    return var2_2;
                }
            }
            if ((var2_2 = this.db2ErrorMap.get(new Integer(sQLException.getErrorCode()))) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"findMappingClass: return ", var2_2);
                }
                return var2_2;
            }
            string = sQLException.getSQLState();
            if (string != null) {
                var2_2 = this.db2ErrorMap.get(string);
            }
            if (var2_2 == null) {
                SQLException sQLException2 = sQLException.getNextException();
                if (sQLException2 != null) {
                    return this.findMappingClass(sQLException2);
                }
                return super.findMappingClass(sQLException);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findMappingClass: return ", var2_2);
        }
        return var2_2;
    }

    public int getIsolationLevel(AccessIntent accessIntent) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getIsolationLevel, intent: ", (Object)accessIntent);
        }
        int n = this.dshMd.getDatabaseDefaultIsolationLevel();
        if (accessIntent != null) {
            if (accessIntent.getConcurrencyControl() == 2) {
                n = 2;
            } else if (accessIntent.getAccessType() == 2) {
                n = 4;
            } else {
                int n2 = accessIntent.getPessimisticUpdateLockHint();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The hint_value is: ", (Object)new Integer(n2));
                }
                switch (n2) {
                    case 2: 
                    case 3: {
                        n = 4;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 4: {
                        n = 8;
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getIsolationLevel, return:", (Object)AdapterUtil.getIsolationLevelString((int)n));
        }
        return n;
    }

    public int getResultSetConcurrency(AccessIntent accessIntent) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getResultSetConcurrency, return:ResultSet.CONCUR_READ_ONLY, intent:", (Object)accessIntent);
        }
        return 1007;
    }

    public final String showLockInfo(Properties properties) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"showLockInfo: ", (Object)properties);
        }
        if (properties == null) {
            Tr.error((TraceComponent)tc, (String)"MTHD_MIS_USE", (Object)"showLockInfo");
            return null;
        }
        String string = properties.getProperty("databaseName", "sample");
        String string2 = properties.getProperty("outputFile");
        String string3 = properties.getProperty("db2Install", "");
        String string4 = properties.getProperty("workingDir", "");
        if (string2 == null) {
            Tr.error((TraceComponent)tc, (String)"MTHD_MIS_USE", (Object)"showLockInfo");
            return null;
        }
        String string5 = this.createdb2File(string4, string);
        String string6 = System.getProperty("os.name");
        StringBuffer stringBuffer = new StringBuffer(131);
        if (string6.equals("AIX")) {
            stringBuffer.append(string3).append("db2 -o -v -t -f").append(string5).append(" -z").append(string2);
        } else {
            if (string6.equals("OS/400")) {
                return "";
            }
            if (string6.equals("Windows 2000") || string6.equals("Windows NT")) {
                stringBuffer.append(string3).append("db2cmd.exe  /c /i db2 -o -v -t -f ").append(string5).append(" -z").append(string2);
            } else if (string6.equals("SUN")) {
                stringBuffer.append(string3).append("db2 -o -v -t -f").append(string5).append(" -z").append(string2);
            } else if (string6.equals("HP-UX")) {
                stringBuffer.append(string3).append("db2 -o -v -t -f").append(string5).append(" -z").append(string2);
            } else {
                Tr.error((TraceComponent)tc, (String)"OS_NOT_SUPPORTED", (Object)string6);
            }
        }
        this.executeCommand(stringBuffer.toString());
        return AdapterUtil.getNLSMessage((String)"DB2_LOCK_INFO", (Object)string2);
    }

    private void executeCommand(String string) {
        try {
            Runtime runtime = null;
            Process process = null;
            runtime = Runtime.getRuntime();
            process = runtime.exec(string);
            process.waitFor();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.rsadapter.DB2DataStoreHelper.executeCommand", (String)"307", (Object)this);
            Tr.error((TraceComponent)tc, (String)"DB2_CMD_ERROR", (Object)new Object[]{string, exception});
        }
    }

    private String createdb2File(String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(67);
        stringBuffer.append(string).append("inputFile");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The inputFile is: " + stringBuffer));
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(stringBuffer.toString()));
        bufferedWriter.write("db2start;");
        bufferedWriter.newLine();
        bufferedWriter.write("LIST APPLICATIONS FOR DATABASE ");
        bufferedWriter.write(string2);
        bufferedWriter.write(" SHOW DETAIL;");
        bufferedWriter.newLine();
        bufferedWriter.write("update monitor switches using LOCK ON;");
        bufferedWriter.newLine();
        bufferedWriter.write("get snapshot for LOCKS on ");
        bufferedWriter.write(string2);
        bufferedWriter.write(";");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.close();
        bufferedWriter = null;
        return stringBuffer.toString();
    }

    public final void setUserDefinedMap(Map map) {
        this.userNewMap = new HashMap(map);
    }

    public PrintWriter getPrintWriter() {
        if (TraceComponent.isAnyTracingEnabled() && db2Tc.isDebugEnabled()) {
            Tr.info((TraceComponent)tc, (String)"DB2_TRACE_INFORMATION");
        }
        return null;
    }

    public boolean isBatchUpdateSupportedWithAccessIntent(AccessIntent accessIntent) {
        if (accessIntent != null && accessIntent.getConcurrencyControl() == 2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isBatchUpdateSupportedWithAccessIntent(): returning false because occ is used.  AccessIntent is: ", (Object)accessIntent);
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isBatchUpdateSupportedWithAccessIntent(): returning true.  Accessintent is:", (Object)accessIntent);
        }
        return true;
    }

    public int getLockType(AccessIntent accessIntent) {
        HashMap hashMap;
        boolean bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLockType ", (Object)new Object[]{this, accessIntent, this.db2ZOS ? "DB2ZOS" : "not DB2ZOS", AdapterUtil.getHelperTypeAsString((int)this.dshMd.getHelperType())});
        }
        boolean bl2 = bl = (hashMap = (HashMap)WSRelationalRAAdapter.EJB_DEPLOY_PROPS.get()) != null && Boolean.TRUE.equals(hashMap.get("MULTIPLE_FOR_UPDATE_METHODS"));
        if (!this.db2ZOS && !bl) {
            int n = super.getLockType(accessIntent);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getLockType", (Object)AdapterUtil.getLockTypeAsString((int)n));
            }
            return n;
        }
        int n = 1;
        if (accessIntent != null) {
            if (accessIntent.getAccessType() == 1 && accessIntent.getConcurrencyControl() == 1) {
                int n2 = accessIntent.getPessimisticUpdateLockHint();
                switch (n2) {
                    case 3: {
                        n = 3;
                        break;
                    }
                    case 4: {
                        n = 4;
                    }
                }
            }
        } else if (this.db2ZOS) {
            n = 3;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLockType", (Object)AdapterUtil.getLockTypeAsString((int)n));
        }
        return n;
    }

    public String getXAExceptionContents(XAException xAException) {
        StringBuffer stringBuffer = new StringBuffer(200);
        Throwable throwable = xAException.getCause();
        if (throwable != null && throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            stringBuffer.append(EOLN).append("The DB2 Error message is : ").append(sQLException.getMessage()).append(EOLN);
            stringBuffer.append("The DB2 Error code is    : ").append(sQLException.getErrorCode()).append(EOLN);
            stringBuffer.append("The DB2 SQLState is      : ").append(sQLException.getSQLState()).append(EOLN);
        }
        return stringBuffer.toString();
    }
}

