/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.ce.cm.DuplicateKeyException;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.rsadapter.GenericDataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfigurationHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class MicrosoftSQLServerDataStoreHelper
extends GenericDataStoreHelper {
    private static final TraceComponent tc = Tr.register((Class)MicrosoftSQLServerDataStoreHelper.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    public static final String[] RESOURCE_TYPES = new String[]{"undefined", "NULL", "Database", "File", "Index", "Table", "Page", "Key", "Extent", "Row Id", "Application"};
    public static final String[] LOCK_REQUEST_STATUSES = new String[]{"undefined", "Granted", "Converting", "Waiting"};
    public static final String[] LOCK_OWNER_TPYES = new String[]{"undefined", "Transaction", "Cursor", "Session", "ExSession"};
    public static final String[] LOCK_REQUEST_MODES = new String[]{"NULL", "Sch-S (Schema Stability)", "Sch-M (Schema modification)", "S (Shared)", "U (Update)", "X (Exclusive)", "IS (Intent Shared)", "IU (Intent Update)", "IX (Intent Exclusive)", "SIU (Shared Intent Update)", "SIX (Shared Intent Exclusive)", "UIX (Update Intent Exclusive)", "BU", "RangeS_S (Shared Key-Range and Shared Resource lock)", "RangeS_U (Shared Key-Range and Update Resource lock)", "RangeI_N (Insert Key-Range and Null Resource lock)", "RangeI_S", "RangeI_U", "RangeI_X", "RangeX_S", "RangeX_U", "RangeX_X"};

    public MicrosoftSQLServerDataStoreHelper(Properties properties) {
        super(properties);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)properties);
        }
        this.dshMd.setDatabaseDefaultIsolationLevel(4, this.customDefinedWasDefaultIsoLevel);
        this.dshMd.setGetTypeMapSupport(false);
        this.dshMd.setHelperType(10);
        this.dshMd.setReadOnlySupport(false);
        this.dshMd.setSelectForUpdateSupport(false);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Metadata for MicrosoftSQLServerDataStoreHelper:", (Object)this.dshMd);
        }
        this.genErrorMap.put(new Integer(230), StaleConnectionException.class);
        this.genErrorMap.put(new Integer(2627), DuplicateKeyException.class);
        this.genErrorMap.put(new Integer(6002), StaleConnectionException.class);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public void doStatementCleanup(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setCursorName(null);
        preparedStatement.setFetchDirection(1000);
        preparedStatement.setMaxFieldSize(Integer.MAX_VALUE);
        preparedStatement.setMaxRows(0);
        preparedStatement.setQueryTimeout(0);
    }

    public int getIsolationLevel(AccessIntent accessIntent) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getIsolationLevel", (Object)accessIntent);
        }
        int n = this.dshMd.getDatabaseDefaultIsolationLevel();
        if (accessIntent != null) {
            if (accessIntent.getConcurrencyControl() == 2) {
                n = 2;
            } else if (accessIntent.getAccessType() == 2) {
                n = 4;
            } else {
                int n2 = accessIntent.getPessimisticUpdateLockHint();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Pessimistic update lock hint is: " + n2));
                }
                switch (n2) {
                    case 2: 
                    case 3: {
                        n = 4;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 4: {
                        n = 8;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getIsolationLevel", (Object)AdapterUtil.getIsolationLevelString((int)n));
        }
        return n;
    }

    public int getResultSetConcurrency(AccessIntent accessIntent) throws ResourceException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResultSetConcurrency", (Object)accessIntent);
        }
        int n2 = n = accessIntent != null && accessIntent.getAccessType() == 1 && accessIntent.getConcurrencyControl() == 1 && (accessIntent.getPessimisticUpdateLockHint() == 4 || accessIntent.getPessimisticUpdateLockHint() == 3) ? 1008 : 1007;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResultSetConcurrency", (Object)AdapterUtil.getConcurrencyModeString((int)n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String showLockInfo(Properties properties) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"showLockInfo: ", (Object)properties);
        }
        if (properties == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"showLockInfo: must specify connection properties ", (Object)properties);
            }
            return null;
        }
        ConnectionPoolDataSource connectionPoolDataSource = null;
        String string = properties.getProperty("user", "sa");
        String string2 = properties.getProperty("password", "");
        String string3 = "com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolDataSource";
        properties.remove("driverType");
        properties.remove("user");
        properties.remove("password");
        properties.setProperty("databaseName", "master");
        Object object = null;
        try {
            object = DSConfigurationHelper.createDataSource((Object)string3);
            DSConfigurationHelper.setDataSourceProperties((Object)object, (Properties)properties);
            connectionPoolDataSource = (ConnectionPoolDataSource)object;
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)(this.getClass().getName() + ".showLockInfo"), (String)"214", (Object)this);
            Exception exception = (Exception)resourceException.getCause();
            if (exception == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to establish a connection -- linked exception is null, current exception is:", (Object)((Object)resourceException));
                }
                throw resourceException;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Failed to establish a connection -- data source creation exception is:", (Object)exception);
            }
            throw exception;
        }
        PooledConnection pooledConnection = null;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            pooledConnection = connectionPoolDataSource.getPooledConnection(string, string2);
            connection = pooledConnection.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select * from syslockinfo");
            while (resultSet.next()) {
                stringBuffer.append(EOLN + "----------------------------------------");
                stringBuffer.append(EOLN + "Lock Resource Text   (rsc_text) : ");
                stringBuffer.append(resultSet.getString("rsc_text"));
                stringBuffer.append(EOLN + "Resource Database Id (rsc_dbid) : ");
                stringBuffer.append(resultSet.getInt("rsc_dbid"));
                stringBuffer.append(EOLN + "Resource Index Id    (rsc_indid) : ");
                stringBuffer.append(resultSet.getInt("rsc_indid"));
                stringBuffer.append(EOLN + "Resource Object Id   (rsc_objid) : ");
                stringBuffer.append(resultSet.getInt("rsc_objid"));
                stringBuffer.append(EOLN + "Resource Type        (rsc_type) : ");
                stringBuffer.append(RESOURCE_TYPES[resultSet.getInt("rsc_type")]);
                stringBuffer.append(EOLN + "Resource Flags       (rsc_flag) : ");
                stringBuffer.append(resultSet.getInt("rsc_flag"));
                stringBuffer.append(EOLN + "Lock Request Mode    (req_mode) : ");
                stringBuffer.append(LOCK_REQUEST_MODES[resultSet.getInt("req_mode")]);
                stringBuffer.append(EOLN + "Lock Request Status  (req_status) : ");
                stringBuffer.append(LOCK_REQUEST_STATUSES[resultSet.getInt("req_status")]);
                stringBuffer.append(EOLN + "Lock Reference Count (req_refcnt) : ");
                stringBuffer.append(resultSet.getInt("req_refcnt"));
                stringBuffer.append(EOLN + "Process ID           (req_spid) : ");
                stringBuffer.append(resultSet.getInt("req_spid"));
                stringBuffer.append(EOLN + "Execution Context ID (req_ecid) : ");
                stringBuffer.append(resultSet.getInt("req_ecid"));
                stringBuffer.append(EOLN + "Lock Owner Type      (req_ownertype) : ");
                stringBuffer.append(LOCK_OWNER_TPYES[resultSet.getInt("req_ownertype")]);
                stringBuffer.append(EOLN + "Transaction ID       (req_transactionID) : ");
                stringBuffer.append(resultSet.getInt("req_transactionID"));
                ++n;
            }
            stringBuffer.append(EOLN + "===> " + n + " Microsoft SQL Server locks found" + EOLN + EOLN + EOLN);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
            if (pooledConnection != null) {
                try {
                    pooledConnection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return stringBuffer.toString();
    }
}

