/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import com.ibm.java.diagnostics.collector.DiagnosticsConfigChecker;
import com.ibm.java.diagnostics.collector.DumpDescriptor;
import com.ibm.java.diagnostics.collector.DumpEvent;
import com.ibm.java.diagnostics.collector.DumpSearch;
import com.ibm.java.diagnostics.collector.JextractRunner;
import com.ibm.java.diagnostics.collector.Messages;
import com.ibm.java.diagnostics.collector.MustGatherZip;
import com.ibm.java.diagnostics.collector.Settings;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class DiagnosticsCollector {
    private static final String DOTLOG = ".log";
    private static final String JAVADC = "JavaDiagnosticsCollector.";
    private static Logger logger;
    private static String logFileName;
    public static String TOOLNAME;

    private static void initLogger() {
        logger = Logger.getLogger("com.ibm.java.diagnostics.collector");
        logger.setLevel(Level.ALL);
    }

    private static void addConsoleHandlerToLogger(Settings settings) {
        Level consoleLogLevel = settings.getConsoleLogLevel();
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new SimpleFormatter());
        consoleHandler.setLevel(consoleLogLevel);
        logger.addHandler(consoleHandler);
    }

    private static void addFileHandlerToLogger(Settings settings) {
        String cwd;
        String outputPath = settings.getOutputDirPath();
        File targetLogFile = null;
        File targetLogDir = null;
        if (outputPath != null) {
            File outputDir = new File(outputPath);
            if (outputDir.exists()) {
                if (outputDir.isDirectory()) {
                    targetLogDir = outputDir;
                } else {
                    logger.log(Level.WARNING, Messages.getString("DiagnosticsCollector.17"), outputPath);
                }
            } else if (outputDir.mkdirs()) {
                targetLogFile = outputDir;
            } else {
                logger.log(Level.WARNING, Messages.getString("DiagnosticsCollector.18"), outputPath);
            }
        }
        if (targetLogDir == null && (cwd = System.getProperty("user.dir")) != null) {
            targetLogDir = new File(cwd);
        }
        if (targetLogDir != null) {
            try {
                targetLogFile = File.createTempFile(JAVADC, DOTLOG, targetLogDir);
            }
            catch (IOException ioe) {
                logger.log(Level.FINE, Messages.getString("DiagnosticsCollector.19") + targetLogDir.getAbsolutePath());
            }
        }
        if (targetLogFile == null) {
            try {
                targetLogFile = File.createTempFile(JAVADC, DOTLOG, null);
            }
            catch (IOException ioe) {
                logger.log(Level.FINE, Messages.getString("DiagnosticsCollector.20"));
            }
        }
        if (targetLogFile != null) {
            DiagnosticsCollector.addFileHandlerAndSetLogFileName(targetLogFile.getAbsolutePath(), settings.getFileLogLevel());
        }
    }

    private static void addFileHandlerAndSetLogFileName(String targetLogFilePath, Level logLevel) {
        FileHandler fh = null;
        try {
            fh = new FileHandler(targetLogFilePath);
        }
        catch (SecurityException e) {
            logger.log(Level.SEVERE, Messages.getString("DiagnosticsCollector.0"), targetLogFilePath);
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, Messages.getString("DiagnosticsCollector.1"), targetLogFilePath);
        }
        if (fh != null) {
            fh.setFormatter(new SimpleFormatter());
            fh.setLevel(logLevel);
            logger.addHandler(fh);
            logFileName = targetLogFilePath;
        } else {
            String msg_format = TOOLNAME + Messages.getString("DiagnosticsCollector.2");
            logger.log(Level.SEVERE, msg_format, logFileName);
            logFileName = null;
        }
    }

    public static void main(String[] args) {
        DiagnosticsCollector.initLogger();
        DumpEvent de = new DumpEvent(args, logger);
        Settings settings = new Settings(de, logger);
        DiagnosticsCollector.addConsoleHandlerToLogger(settings);
        logger.setUseParentHandlers(false);
        DiagnosticsCollector.addFileHandlerToLogger(settings);
        logger.info("IBM Monitoring and Diagnostic Tools for Java - Diagnostics Collector");
        logger.info(Messages.getString("DiagnosticsCollector.4"));
        String fv = System.getProperty("java.fullversion");
        String lineSep = System.getProperty("line.separator");
        String pfm_fv = fv.replace("\n", lineSep);
        String fv_msg_template = Messages.getString("DiagnosticsCollector.5");
        String fv_msg = MessageFormat.format(fv_msg_template, pfm_fv);
        logger.config(TOOLNAME + fv_msg);
        String jclVer = System.getProperty("java.jcl.version");
        logger.config("java.jcl.version: \"" + jclVer + "\"");
        String dcBuildId = de.getBuildId();
        logger.config(TOOLNAME + Messages.getString("DiagnosticsCollector.6") + dcBuildId);
        if (!de.argsValid()) {
            logger.severe(TOOLNAME + Messages.getString("DiagnosticsCollector.7"));
            System.err.println("\n\n" + TOOLNAME + Messages.getString("DiagnosticsCollector.8") + dcBuildId + Messages.getString("DiagnosticsCollector.9"));
            System.exit(1);
        }
        System.err.println("\n\n" + TOOLNAME + Messages.getString("DiagnosticsCollector.10") + dcBuildId + Messages.getString("DiagnosticsCollector.11"));
        DumpSearch ds = new DumpSearch(de, logger);
        DumpDescriptor[] dda = ds.getDumpSetAsArray();
        if (settings.getRunJextract()) {
            JextractRunner jexr = new JextractRunner(logger);
            jexr.process(dda);
        } else {
            logger.config(Messages.getString("DiagnosticsCollector.21"));
        }
        if (de.isConfigCheck()) {
            boolean javadumpFound = false;
            for (DumpDescriptor d : dda) {
                if (d == null || d.getDumpType() != DumpDescriptor.DumpType.JAVA) continue;
                javadumpFound = true;
            }
            if (!javadumpFound && settings.getConfigCheckJavacore()) {
                logger.fine("Setting config.check.javacore is true but no javacore found yet. Waiting 5 seconds for javacore to finish ...");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    logger.log(Level.FINE, "Interrupted waiting for javacore to finish");
                }
                DumpSearch dsRetry = new DumpSearch(de, logger);
                dda = dsRetry.getDumpSetAsArray();
            }
            System.err.println(TOOLNAME + Messages.getString("DiagnosticsCollector.12") + dcBuildId + Messages.getString("DiagnosticsCollector.13"));
            DiagnosticsConfigChecker dcc = new DiagnosticsConfigChecker(de, dda, logger);
            dcc.check();
        }
        if (!de.getNoZipFlag()) {
            System.err.println(TOOLNAME + Messages.getString("DiagnosticsCollector.14"));
            MustGatherZip mgz = new MustGatherZip(logger, logFileName, de, dda, settings);
            if (mgz.isZipFileCreated()) {
                System.err.println(TOOLNAME + Messages.getString("DiagnosticsCollector.15") + mgz.getFilePath());
            } else {
                System.err.println(TOOLNAME + Messages.getString("DiagnosticsCollector.16"));
            }
        }
    }

    static {
        TOOLNAME = "Java Diagnostics Collector";
    }
}

