/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import com.ibm.java.diagnostics.collector.DiagnosticsCollector;
import com.ibm.java.diagnostics.collector.Messages;
import com.ibm.java.diagnostics.collector.Util;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumpEvent {
    private boolean argsValid;
    private boolean configCheck;
    private String event;
    private String home;
    private String lastDump;
    private List<String> dumpList;
    private String uid;
    private String stamp;
    private String pid;
    private String job;
    private boolean noZipFlag;
    private String buildId;
    private File settingsFile;
    private String settingsString;
    private Logger logger;
    private String _CEE_DMPTARG = System.getenv("_CEE_DMPTARG");
    private String IBM_COREDIR = System.getenv("IBM_COREDIR");
    private String IBM_HEAPDUMPDIR = System.getenv("IBM_HEAPDUMPDIR");
    private String IBM_JAVACOREDIR = System.getenv("IBM_JAVACOREDIR");
    private String JAVA_DUMP_TDUMP_PATTERN = System.getenv("JAVA_DUMP_TDUMP_PATTERN");
    private File jarFile;

    public DumpEvent(String[] args, Logger logger) {
        this.logger = logger;
        this.argsValid(this.doArgs(args));
        this.setJarFile(this.findJarFile());
        this.setBuildId(this.findBuildId());
        this.setSettingsFile(this.findSettingsFile());
        this.logger.finest("The dump event is \"" + this.getEvent() + "\"");
    }

    private File findJarFile() {
        URL classUrl = this.getClass().getResource("/com/ibm/java/diagnostics/collector/DiagnosticsCollector.class");
        String classUrlStr = null;
        if (classUrl != null) {
            classUrlStr = classUrl.toString();
        }
        String jarUrlStr = null;
        File f = null;
        if (classUrlStr != null && classUrlStr.startsWith("jar:") && classUrlStr.contains(".jar!")) {
            int start = classUrlStr.indexOf(":") + 1;
            int end = classUrlStr.indexOf("!");
            jarUrlStr = classUrlStr.substring(start, end);
            URI jarUri = null;
            try {
                jarUri = new URI(jarUrlStr);
                f = new File(jarUri);
            }
            catch (URISyntaxException e) {
                this.logger.log(Level.FINE, "Problem with URI for Diagnostics Collector jar: " + jarUrlStr, e);
            }
        }
        if (f == null) {
            this.logger.fine("Diagnostics Collector jar not found, class loaded from: " + classUrlStr);
        } else {
            this.logger.fine("Diagnostics Collector jar found at: " + f.getAbsolutePath());
        }
        return f;
    }

    File findSettingsFile() {
        File jarParentDirSettings;
        File jarParentDir;
        File cwdSettings;
        File settings = this.getSettingsFile();
        if (settings == null && (cwdSettings = new File("dc.properties")).canRead()) {
            settings = cwdSettings;
        }
        File jarFileDir = null;
        if (settings == null) {
            File jf = this.getJarFile();
            if (jf != null) {
                jarFileDir = jf.getParentFile();
            }
            File jarDirSettings = null;
            if (jarFileDir != null && (jarDirSettings = new File(jarFileDir, "dc.properties")).canRead()) {
                settings = jarDirSettings;
            }
        }
        if (settings == null && jarFileDir != null && (jarParentDir = jarFileDir.getParentFile()) != null && (jarParentDirSettings = new File(jarParentDir, "dc.properties")).canRead()) {
            settings = jarParentDirSettings;
        }
        if (settings == null) {
            this.logger.fine("No user settings file detected");
        }
        return settings;
    }

    public String get_CEE_DMPTARG() {
        return this._CEE_DMPTARG;
    }

    public String getEvent() {
        return this.event;
    }

    public String getHome() {
        return this.home;
    }

    public String getIBM_COREDIR() {
        return this.IBM_COREDIR;
    }

    public String getIBM_HEAPDUMPDIR() {
        return this.IBM_HEAPDUMPDIR;
    }

    public String getIBM_JAVACOREDIR() {
        return this.IBM_JAVACOREDIR;
    }

    public String getJAVA_DUMP_TDUMP_PATTERN() {
        return this.JAVA_DUMP_TDUMP_PATTERN;
    }

    public String getLastDump() {
        return this.lastDump;
    }

    public List<String> getDumpList() {
        return this.dumpList;
    }

    public String getUid() {
        return this.uid;
    }

    public void set_CEE_DMPTARG(String _cee_dmptarg) {
        this._CEE_DMPTARG = _cee_dmptarg;
    }

    public void setEvent(String event) {
        if (this.event == null || !this.event.equals("check")) {
            this.event = event;
        }
    }

    public void setHome(String home) {
        this.home = home;
    }

    public void setIBM_COREDIR(String ibm_coredir) {
        this.IBM_COREDIR = ibm_coredir;
    }

    public void setIBM_HEAPDUMPDIR(String ibm_heapdumpdir) {
        this.IBM_HEAPDUMPDIR = ibm_heapdumpdir;
    }

    public void setIBM_JAVACOREDIR(String ibm_javacoredir) {
        this.IBM_JAVACOREDIR = ibm_javacoredir;
    }

    public void setJAVA_DUMP_TDUMP_PATTERN(String java_dump_tdump_pattern) {
        this.JAVA_DUMP_TDUMP_PATTERN = java_dump_tdump_pattern;
    }

    public void setLastDump(String last_dump) {
        this.lastDump = last_dump;
    }

    public void setDumpList(List<String> dumpList) {
        this.dumpList = dumpList;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getStamp() {
        return this.stamp;
    }

    boolean doArgs(String[] args) {
        if (args == null) {
            return false;
        }
        String eventVal = null;
        String stampVal = null;
        String lastdumpVal = null;
        String dumpListVal = null;
        String uidVal = null;
        String jobVal = null;
        String settingsVal = null;
        boolean argsValid = true;
        for (int i = 0; i < args.length; ++i) {
            int next;
            if ("-event".equals(args[i])) {
                next = i + 1;
                if (next >= args.length || args[next] == null || args[next].startsWith("-")) continue;
                eventVal = args[next];
                this.logger.fine("-event " + Messages.getString("DumpEvent.0") + eventVal);
                ++i;
                continue;
            }
            if ("-stamp".equals(args[i])) {
                next = i + 1;
                if (next >= args.length || args[next] == null || args[next].startsWith("-")) continue;
                stampVal = args[next];
                this.logger.fine("-stamp " + Messages.getString("DumpEvent.1") + stampVal);
                ++i;
                continue;
            }
            if ("-lastdump".equals(args[i])) {
                next = i + 1;
                if (next >= args.length || args[next] == null) continue;
                if (!args[next].startsWith("-")) {
                    lastdumpVal = args[next];
                    this.logger.fine("-lastdump " + Messages.getString("DumpEvent.2") + lastdumpVal);
                    ++i;
                    continue;
                }
                if (!args[next].equals("-")) continue;
                ++i;
                continue;
            }
            if ("-dumplist".equals(args[i])) {
                next = i + 1;
                if (next >= args.length || args[next] == null || args[next].startsWith("-") && !args[next].equals("-") && !args[next].startsWith("-\t")) continue;
                dumpListVal = args[next];
                this.logger.fine("-dumplist " + Messages.getString("DumpEvent.2") + lastdumpVal);
                ++i;
                continue;
            }
            if ("-uid".equals(args[i])) {
                next = i + 1;
                if (next >= args.length || args[next] == null || args[next].startsWith("-")) continue;
                uidVal = args[next];
                this.logger.fine("-uid " + Messages.getString("DumpEvent.3") + uidVal);
                ++i;
                continue;
            }
            if ("-job".equals(args[i])) {
                next = i + 1;
                if (next >= args.length || args[next] == null || args[next].startsWith("-")) continue;
                jobVal = args[next];
                this.logger.fine("-job " + Messages.getString("DumpEvent.5") + jobVal);
                ++i;
                continue;
            }
            if ("-settings".equals(args[i])) {
                next = i + 1;
                if (next >= args.length || args[next] == null || args[next].startsWith("-")) continue;
                settingsVal = args[next];
                this.logger.fine("-settings" + Messages.getString("DumpEvent.7") + settingsVal);
                ++i;
                continue;
            }
            if ("-nozip".equals(args[i])) {
                this.setNoZipFlag();
                continue;
            }
            if ("-check".equals(args[i])) {
                this.setConfigCheck(true);
                continue;
            }
            argsValid = false;
            this.logger.warning(DiagnosticsCollector.TOOLNAME + Messages.getString("DumpEvent.10") + args[i]);
        }
        argsValid &= this.checkAndSetEvent(eventVal);
        argsValid &= this.checkAndSetStamp(stampVal);
        argsValid &= this.checkAndSetLastdump(lastdumpVal);
        argsValid &= this.checkAndSetDumpList(dumpListVal);
        argsValid &= this.checkAndSetUid(uidVal);
        argsValid &= this.checkAndSetJob(jobVal);
        return argsValid &= this.checkAndSetSettings(settingsVal);
    }

    boolean checkAndSetSettings(String settingsVal) {
        if (settingsVal != null) {
            File sf = new File(settingsVal);
            if (sf.canRead()) {
                this.logger.config(Messages.getString("DumpEvent.11") + sf.getAbsolutePath());
                this.settingsFile = sf;
            } else {
                this.logger.warning(Messages.getString("DumpEvent.12") + sf.getAbsolutePath());
                this.logger.warning(Messages.getString("DumpEvent.13"));
            }
            this.settingsString = settingsVal;
        }
        return true;
    }

    void setNoZipFlag() {
        this.logger.config(Messages.getString("DumpEvent.15"));
        this.noZipFlag = true;
    }

    boolean getNoZipFlag() {
        return this.noZipFlag;
    }

    boolean checkAndSetJob(String jobVal) {
        boolean validity = true;
        if (jobVal != null) {
            boolean lengthValid;
            boolean noWhitespace = Pattern.matches("\\S+", jobVal);
            boolean bl = lengthValid = jobVal.length() <= 50;
            if (noWhitespace && lengthValid) {
                this.setJob(jobVal);
            } else {
                this.logger.warning(DiagnosticsCollector.TOOLNAME + Messages.getString("DumpEvent.17") + jobVal + "\"");
                validity = false;
            }
            if (System.getProperty("os.name").indexOf("z/OS") == -1) {
                this.logger.fine("-job parameter not used on this platform");
            }
        }
        return validity;
    }

    boolean checkAndSetUid(String uidVal) {
        String userName = System.getProperty("user.name");
        this.logger.config(Messages.getString("DumpEvent.18") + userName);
        if (uidVal != null) {
            boolean lengthValid;
            boolean noWhitespace = Pattern.matches("\\S+", uidVal);
            boolean bl = lengthValid = uidVal.length() < 129;
            if (noWhitespace && lengthValid) {
                if (!userName.equals(uidVal)) {
                    this.logger.config(Messages.getString("DumpEvent.19") + uidVal + Messages.getString("DumpEvent.20") + userName);
                }
                this.setUid(uidVal);
            } else {
                this.logger.config(Messages.getString("DumpEvent.21") + uidVal + Messages.getString("DumpEvent.22") + userName);
                this.setUid(userName);
            }
        } else {
            this.logger.config(Messages.getString("DumpEvent.23") + userName);
            this.setUid(userName);
        }
        return true;
    }

    boolean checkAndSetDumpList(String dumpListVal) {
        String[] dumps;
        if (dumpListVal == null || dumpListVal.equals("%list")) {
            this.setDumpList(null);
            return true;
        }
        ArrayList<String> validDumps = new ArrayList<String>();
        for (String dumpString : dumps = dumpListVal.split("\t")) {
            validDumps.add(dumpString);
        }
        this.setDumpList(validDumps);
        return true;
    }

    boolean checkAndSetLastdump(String lastdumpVal) {
        if (lastdumpVal != null && !"".equals(lastdumpVal)) {
            File dir;
            File f = new File(lastdumpVal);
            if (!f.canRead()) {
                if (Util.isOnZOS()) {
                    if (Util.datasetExists(this.logger, lastdumpVal.replace("&DS", "001"))) {
                        this.setLastDump(lastdumpVal);
                        return true;
                    }
                    if (Util.datasetExists(this.logger, lastdumpVal.concat(".X001"))) {
                        this.setLastDump(lastdumpVal.concat(".X&DS"));
                        return true;
                    }
                }
                this.logger.warning(DiagnosticsCollector.TOOLNAME + Messages.getString("DumpEvent.24") + lastdumpVal);
            }
            if ((dir = f.getParentFile()) != null && !dir.canRead()) {
                this.logger.warning(DiagnosticsCollector.TOOLNAME + Messages.getString("DumpEvent.25") + dir.getAbsolutePath());
            }
        }
        this.setLastDump(lastdumpVal);
        return true;
    }

    boolean checkAndSetStamp(String stampVal) {
        if (stampVal != null) {
            if (stampVal.startsWith("dc_config_check") || Pattern.matches("\\d\\d\\d\\d\\d\\d\\d\\d\\.\\d\\d\\d\\d\\d\\d\\.\\d+", stampVal)) {
                this.setStamp("." + stampVal + ".");
                this.setPid(stampVal.substring(stampVal.lastIndexOf(".") + 1));
                return true;
            }
            this.logger.warning(DiagnosticsCollector.TOOLNAME + Messages.getString("DumpEvent.26") + stampVal);
            return false;
        }
        this.logger.warning(DiagnosticsCollector.TOOLNAME + Messages.getString("DumpEvent.27"));
        return false;
    }

    boolean checkAndSetEvent(String eventVal) {
        if (eventVal != null) {
            if (eventVal.equals("gpf") || eventVal.equals("outofmemoryerror") || eventVal.equals("user") || eventVal.equals("abort") || eventVal.equals("vmstart") || eventVal.equals("vmstop") || eventVal.equals("check")) {
                this.setEvent(eventVal);
            } else {
                this.setEvent("dumpevent");
                this.logger.config(Messages.getString("DumpEvent.28") + eventVal + Messages.getString("DumpEvent.29") + this.getEvent());
            }
        } else {
            this.setEvent("dumpevent");
            this.logger.config(Messages.getString("DumpEvent.30") + this.getEvent());
        }
        return true;
    }

    public boolean argsValid() {
        return this.argsValid;
    }

    private void argsValid(boolean flag) {
        this.argsValid = flag;
    }

    public void setStamp(String stamp) {
        this.stamp = stamp;
    }

    public String getJob() {
        return this.job;
    }

    public void setJob(String job) {
        this.job = job;
    }

    String findBuildId() {
        String build = null;
        File f = this.getJarFile();
        if (f != null) {
            try {
                JarFile dcJar = new JarFile(f);
                Manifest mf = dcJar.getManifest();
                Attributes attr = null;
                if (mf != null) {
                    attr = mf.getMainAttributes();
                }
                if (attr != null) {
                    build = attr.getValue("Build-Identifier");
                }
            }
            catch (IOException e) {
                this.logger.log(Level.FINE, "Problem getting build id from Diagnostics Collector jar manifest", e);
            }
        }
        if (build == null) {
            build = "not_packaged";
        }
        return build;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public void setBuildId(String buildId) {
        this.buildId = buildId;
    }

    public File getSettingsFile() {
        return this.settingsFile;
    }

    public void setSettingsFile(File settingsFile) {
        this.settingsFile = settingsFile;
    }

    public void setJarFile(File jarFile) {
        this.jarFile = jarFile;
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public boolean isConfigCheck() {
        return this.configCheck;
    }

    public void setConfigCheck(boolean configCheck) {
        this.configCheck = configCheck;
        if (configCheck) {
            this.setEvent("check");
        }
    }

    String getSettingsString() {
        return this.settingsString;
    }
}

