/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import com.ibm.java.diagnostics.collector.DiagnosticsCollector;
import com.ibm.java.diagnostics.collector.DumpDescriptor;
import com.ibm.java.diagnostics.collector.DumpEvent;
import com.ibm.java.diagnostics.collector.DumpSet;
import com.ibm.java.diagnostics.collector.Messages;
import com.ibm.java.diagnostics.collector.Util;
import com.ibm.java.diagnostics.collector.snapDumpFilter;
import com.ibm.java.diagnostics.collector.startEndFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumpSearch {
    private static final String ZOS_DUMP_SECTION_TOKEN = "&DS";
    private static final String ZOS_64BIT_SYSTEM_DUMP_SUFFIX = ".X&DS";
    private DumpEvent de;
    private Logger logger;
    private static String pfmTmpDir;
    private static String javaIoTmpDir;
    private static String slash;

    public DumpSearch(DumpEvent dumpEvent, Logger l) throws IllegalArgumentException {
        if (dumpEvent == null) {
            throw new IllegalArgumentException("dumpEvent is null");
        }
        if (l == null) {
            throw new IllegalArgumentException("logger is null");
        }
        this.de = dumpEvent;
        this.logger = l;
        javaIoTmpDir = System.getProperty("java.io.tmpdir");
        this.logger.finest("System property java.io.tmpdir: " + javaIoTmpDir);
        pfmTmpDir = System.getProperty("os.name").indexOf("Windows") != -1 ? "C:\\Temp" : "/tmp";
        slash = System.getProperty("file.separator");
    }

    public DumpDescriptor[] getDumpSetAsArray() {
        boolean searchForVerbosegcOnly;
        this.logger.fine("Searching for dump files");
        DumpSet dumpSet = new DumpSet();
        List<String> dumpList = this.de.getDumpList();
        if (dumpList != null) {
            searchForVerbosegcOnly = true;
            String dumpListString = dumpList.toString();
            this.logger.fine("Dump list parameter: " + dumpListString);
            DumpDescriptor[] dda = this.getDumpsFromList(dumpList);
            dumpSet.addAll(dda);
        } else {
            DumpDescriptor tdump;
            searchForVerbosegcOnly = false;
            DumpDescriptor last = this.getLastDump();
            this.logLastDump(last);
            if (last != null) {
                dumpSet.add(last);
            }
            File[] dirsToSearch = this.getDirsToSearch();
            DumpDescriptor[] dirDumpTargets = this.getDumpTargetsInDirs(dirsToSearch);
            dumpSet.addAll(dirDumpTargets);
            String osName = System.getProperty("os.name");
            this.logger.fine("os name is: " + osName);
            if (osName.indexOf("z/OS") != -1 && (tdump = this.findZOSSystemDump()) != null) {
                dumpSet.add(tdump);
            }
        }
        DumpDescriptor[] searchDumps = dumpSet.getDumpSet();
        for (int i = 0; i < searchDumps.length; ++i) {
            if (searchDumps[i] == null || searchDumps[i].getDumpType() != DumpDescriptor.DumpType.JAVA) continue;
            DumpDescriptor[] customDumpTargets = this.getCustomDumpTargets(searchDumps[i].getFile(), searchForVerbosegcOnly);
            dumpSet.addAll(customDumpTargets);
        }
        DumpSet existingDumps = new DumpSet();
        DumpDescriptor[] allDumpTargets = dumpSet.getDumpSet();
        for (int i = 0; i < allDumpTargets.length; ++i) {
            if (allDumpTargets[i] == null) continue;
            File f = allDumpTargets[i].getFile();
            if (f != null) {
                if (f.canRead()) {
                    existingDumps.add(allDumpTargets[i]);
                    this.logger.fine("Found dump file: " + f.getAbsolutePath());
                    continue;
                }
                if (f.exists()) {
                    this.logger.fine("Dump file exists but is not readable: " + f.getAbsolutePath());
                    continue;
                }
                this.logger.fine("Checked for dump but no file found at: " + f.getAbsolutePath());
                continue;
            }
            if (allDumpTargets[i].getLabel() == null || allDumpTargets[i].getDumpType() != DumpDescriptor.DumpType.SYSTEM) continue;
            String dsn = allDumpTargets[i].getName();
            if (allDumpTargets[i].exists(this.logger)) {
                if (allDumpTargets[i].isSplit(this.logger)) {
                    String template = Messages.getString("DumpSearch.5");
                    String message = MessageFormat.format(template, dsn);
                    this.logger.warning(message);
                    continue;
                }
                existingDumps.add(allDumpTargets[i]);
                this.logger.fine("Found z/OS system dump: " + dsn);
                continue;
            }
            this.logger.fine("Checked for z/OS system dump but no dataset found matching: " + dsn);
        }
        return existingDumps.getDumpSet();
    }

    private DumpDescriptor[] getDumpsFromList(List<String> dumpList) {
        assert (dumpList != null);
        DumpSet ds = new DumpSet();
        for (String dumpString : dumpList) {
            if (dumpString.equals("-")) continue;
            File f = new File(dumpString);
            DumpDescriptor dd = Util.isOnZOS() ? (Util.datasetExists(this.logger, dumpString.replace(ZOS_DUMP_SECTION_TOKEN, "001")) ? new DumpDescriptor(dumpString, DumpDescriptor.DumpType.SYSTEM) : (Util.datasetExists(this.logger, dumpString.concat(".X001")) ? new DumpDescriptor(dumpString.concat(ZOS_64BIT_SYSTEM_DUMP_SUFFIX), DumpDescriptor.DumpType.SYSTEM) : new DumpDescriptor(f))) : new DumpDescriptor(f);
            ds.add(dd);
        }
        return ds.getDumpSet();
    }

    private DumpDescriptor findZOSSystemDump() {
        String dumpLabel;
        String dumpLabelString = this.generateZOSDumpLabel();
        if (dumpLabelString != null) {
            this.logger.fine("z/OS dump label: " + dumpLabelString);
            DumpDescriptor dd = new DumpDescriptor(dumpLabelString, DumpDescriptor.DumpType.SYSTEM);
            boolean exists = dd.exists(this.logger);
            if (exists) {
                this.logger.fine("Found " + dd.getName());
                return dd;
            }
            this.logger.fine("Dump " + dd.getName() + " not found.");
        }
        if ((dumpLabel = this.generateZOS64DumpLabel()) != null) {
            DumpDescriptor dd = new DumpDescriptor(dumpLabel, DumpDescriptor.DumpType.SYSTEM);
            boolean exists = dd.exists(this.logger);
            if (exists) {
                this.logger.fine("Found " + dd.getName());
                return dd;
            }
            this.logger.fine("Dump " + dd.getName() + " not found.");
        }
        return null;
    }

    private String generateZOSDumpLabel() {
        StringBuffer dumpLabel = new StringBuffer();
        boolean labelValid = true;
        if (this.de.getUid() != null) {
            dumpLabel.append(this.de.getUid());
        } else {
            this.logger.fine("Failed to generate z/OS dump label: uid is null");
            labelValid = false;
        }
        dumpLabel.append(".JVM.TDUMP.");
        if (this.de.getJob() != null) {
            dumpLabel.append(this.de.getJob());
        } else {
            this.logger.fine("Failed to generate z/OS dump label: job is null");
            labelValid = false;
        }
        String stamp = this.de.getStamp();
        if (stamp != null) {
            dumpLabel.append(".D" + stamp.substring(3, 9));
            dumpLabel.append(".T" + stamp.substring(10, 16));
        } else {
            this.logger.fine("Failed to generate z/OS dump label: stamp is null");
            labelValid = false;
        }
        if (labelValid) {
            return dumpLabel.toString();
        }
        return null;
    }

    private String generateZOS64DumpLabel() {
        StringBuffer dumpLabel = new StringBuffer();
        boolean labelValid = true;
        if (this.de.getUid() != null) {
            dumpLabel.append(this.de.getUid());
        } else {
            this.logger.fine("Failed to generate z/OS dump label: uid is null");
            labelValid = false;
        }
        dumpLabel.append(".JVM.");
        if (this.de.getJob() != null) {
            dumpLabel.append(this.de.getJob());
        } else {
            this.logger.fine("Failed to generate z/OS dump label: job is null");
            labelValid = false;
        }
        String stamp = this.de.getStamp();
        if (stamp != null) {
            dumpLabel.append(".D" + stamp.substring(3, 9));
            dumpLabel.append(".T" + stamp.substring(10, 16));
            dumpLabel.append(ZOS_64BIT_SYSTEM_DUMP_SUFFIX);
        } else {
            this.logger.fine("Failed to generate z/OS dump label: stamp is null");
            labelValid = false;
        }
        if (labelValid) {
            return dumpLabel.toString();
        }
        return null;
    }

    DumpDescriptor[] getCustomDumpTargets(File javacore, boolean verbosegcOnly) {
        if (javacore == null) {
            this.logger.fine("null passed to getCustomDumpTargets");
            return null;
        }
        if (!javacore.exists()) {
            return null;
        }
        if (!javacore.canRead()) {
            String template = Messages.getString("DumpSearch.0");
            String msg = MessageFormat.format(template, javacore.getAbsolutePath(), System.getProperty("user.name"));
            this.logger.warning(DiagnosticsCollector.TOOLNAME + msg);
            return null;
        }
        this.logger.fine("Search java dump for dump file settings: " + javacore.getPath());
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(javacore));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            String template = Messages.getString("DumpSearch.2");
            String msg = MessageFormat.format(template, javacore.getAbsolutePath());
            this.logger.warning(DiagnosticsCollector.TOOLNAME + msg);
            return null;
        }
        String line = null;
        try {
            line = br.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            String template = Messages.getString("DumpSearch.3");
            String msg = MessageFormat.format(template, javacore.getAbsolutePath(), e.getMessage());
            this.logger.warning(msg);
        }
        DumpSet ds = new DumpSet();
        while (line != null) {
            DumpDescriptor vgcLog;
            DumpDescriptor[] dda;
            if (!verbosegcOnly && (dda = this.getDumpLocationFromJavacoreLine(line)) != null) {
                ds.addAll(dda);
            }
            if ((vgcLog = this.getVerboseGCLogFromJavacoreLine(line)) != null) {
                ds.add(vgcLog);
            }
            try {
                line = br.readLine();
            }
            catch (IOException e) {
                this.logger.log(Level.FINE, DiagnosticsCollector.TOOLNAME + ": IOException while trying to read a line from " + javacore.getAbsolutePath(), e);
            }
        }
        return ds.getDumpSet();
    }

    private DumpDescriptor getVerboseGCLogFromJavacoreLine(String line) {
        if (line == null) {
            return null;
        }
        if (!line.startsWith("2CIUSERARG")) {
            return null;
        }
        int filenameStart = line.indexOf("-Xverbosegclog:");
        if (filenameStart == -1) {
            return null;
        }
        String filename = null;
        if (line.length() > (filenameStart += 15)) {
            filename = line.substring(filenameStart);
        }
        if (filename != null && !filename.equals("")) {
            this.logger.fine("Found -Xverbosegclog setting: " + filename);
            File f = new File(filename);
            DumpDescriptor dd = new DumpDescriptor(f, DumpDescriptor.DumpType.VERBOSEGC);
            return dd;
        }
        return null;
    }

    DumpDescriptor[] getDumpLocationFromJavacoreLine(String line) {
        if (line == null) {
            return null;
        }
        if (!line.startsWith("2CIUSERARG")) {
            return null;
        }
        if (line.indexOf("-Xdump:") == -1) {
            return null;
        }
        String filename = this.getDumpFilenameFromJavacoreLine(line);
        if (filename != null && !filename.equals("")) {
            String[] colonSections = line.split(":");
            String dumpTypeName = colonSections[1];
            DumpDescriptor.DumpType dumpType = null;
            dumpType = dumpTypeName.equals("system") ? DumpDescriptor.DumpType.SYSTEM : (dumpTypeName.equals("java") ? DumpDescriptor.DumpType.JAVA : (dumpTypeName.equals("heap") ? DumpDescriptor.DumpType.HEAP : (dumpTypeName.equals("snap") ? DumpDescriptor.DumpType.SNAP : DumpDescriptor.DumpType.UNKNOWN)));
            this.logger.fine("Found -Xdump " + (Object)((Object)dumpType) + " file setting " + filename);
            if (Util.isOnZOS() && dumpType == DumpDescriptor.DumpType.SYSTEM) {
                if (!filename.contains(ZOS_DUMP_SECTION_TOKEN)) {
                    DumpDescriptor[] dda = new DumpDescriptor[]{new DumpDescriptor(filename, dumpType), new DumpDescriptor(filename.concat(ZOS_64BIT_SYSTEM_DUMP_SUFFIX), dumpType)};
                    return dda;
                }
                DumpDescriptor[] dda = new DumpDescriptor[]{new DumpDescriptor(filename, dumpType)};
                return dda;
            }
            File f0 = new File(filename);
            File f1 = new File(javaIoTmpDir + slash + f0.getName());
            File f2 = new File(pfmTmpDir + slash + f0.getName());
            DumpDescriptor[] dda = new DumpDescriptor[]{new DumpDescriptor(f0, dumpType), new DumpDescriptor(f1, dumpType), new DumpDescriptor(f2, dumpType)};
            return dda;
        }
        return null;
    }

    String getDumpFilenameFromJavacoreLine(String line) {
        String[] subopts = new String[]{"file=", "label=", "dsn="};
        String filename = null;
        for (String subopt : subopts) {
            int filenameStart;
            int suboptStart = line.indexOf(subopt);
            if (suboptStart == -1 || (filenameStart = suboptStart + subopt.length()) >= line.length()) continue;
            int commaIndex = line.indexOf(",", filenameStart);
            if (commaIndex == -1) {
                filename = line.substring(filenameStart);
                break;
            }
            filename = line.substring(filenameStart, commaIndex);
            break;
        }
        return filename;
    }

    DumpDescriptor[] getDumpTargetsInDirs(File[] dirsToSearch) {
        if (dirsToSearch == null) {
            this.logger.fine("getDumpTargetsInDirs: dir array null");
            return null;
        }
        DumpSet ds = new DumpSet();
        String stamp = this.de.getStamp();
        for (int i = 0; i < dirsToSearch.length; ++i) {
            File dir = dirsToSearch[i];
            if (dir == null) continue;
            this.findDumpMatchesAndAddToDumpSet("javacore" + stamp, "txt", DumpDescriptor.DumpType.JAVA, dir, ds);
            this.findDumpMatchesAndAddToDumpSet("core" + stamp, "dmp", DumpDescriptor.DumpType.SYSTEM, dir, ds);
            this.findDumpMatchesAndAddToDumpSet("user", "dmp", DumpDescriptor.DumpType.SYSTEM, dir, ds);
            this.findDumpMatchesAndAddToDumpSet("core", this.de.getPid(), DumpDescriptor.DumpType.SYSTEM, dir, ds);
            this.findDumpMatchesAndAddToDumpSet("heapdump" + stamp, "txt", DumpDescriptor.DumpType.HEAP, dir, ds);
            this.findDumpMatchesAndAddToDumpSet("heapdump" + stamp, "phd", DumpDescriptor.DumpType.HEAP, dir, ds);
            snapDumpFilter snapPattern = new snapDumpFilter(stamp);
            File[] snapDumps = dir.listFiles(snapPattern);
            if (snapDumps == null) continue;
            for (int s = 0; s < snapDumps.length; ++s) {
                if (snapDumps[s] == null) continue;
                DumpDescriptor snapDD = new DumpDescriptor(snapDumps[s], DumpDescriptor.DumpType.SNAP);
                ds.add(snapDD);
            }
        }
        return ds.getDumpSet();
    }

    void findDumpMatchesAndAddToDumpSet(String prefix, String extension, DumpDescriptor.DumpType dtype, File dir, DumpSet ds) {
        startEndFilter pattern = new startEndFilter(prefix, extension);
        File[] hits = dir.listFiles(pattern);
        if (hits != null) {
            for (int j = 0; j < hits.length; ++j) {
                if (hits[j] == null) continue;
                DumpDescriptor dd = new DumpDescriptor(hits[j], dtype);
                ds.add(dd);
            }
        }
    }

    File[] getDirsToSearch() {
        File cwd;
        HashSet<File> dirs = new HashSet<File>();
        String lastDumpName = this.de.getLastDump();
        File lastDumpFile = null;
        if (lastDumpName != null) {
            lastDumpFile = new File(lastDumpName);
        }
        File lastDumpDir = null;
        if (lastDumpFile != null) {
            lastDumpDir = lastDumpFile.getParentFile();
        }
        if (lastDumpDir != null) {
            dirs.add(lastDumpDir);
            this.logger.fine("Search last dump directory: " + lastDumpDir.getAbsolutePath());
        }
        if ((cwd = new File(System.getProperty("user.dir"))) != null) {
            dirs.add(cwd);
            this.logger.fine("Search current working directory: " + cwd.getAbsolutePath());
        }
        if (this.de.getIBM_JAVACOREDIR() != null) {
            File ibm_javacoredir = new File(this.de.getIBM_JAVACOREDIR());
            if (ibm_javacoredir != null) {
                dirs.add(ibm_javacoredir);
                this.logger.fine("Search IBM_JAVACOREDIR: " + ibm_javacoredir.getAbsolutePath());
            }
        } else {
            this.logger.fine("IBM_JAVACOREDIR not set");
        }
        if (this.de.getIBM_HEAPDUMPDIR() != null) {
            File ibm_heapdumpdir = new File(this.de.getIBM_HEAPDUMPDIR());
            if (ibm_heapdumpdir != null) {
                dirs.add(ibm_heapdumpdir);
                this.logger.fine("Search IBM_HEAPDUMPDIR: " + ibm_heapdumpdir.getAbsolutePath());
            }
        } else {
            this.logger.fine("IBM_HEAPDUMPDIR not set");
        }
        if (this.de.getIBM_COREDIR() != null) {
            File ibm_coredir = new File(this.de.getIBM_COREDIR());
            if (ibm_coredir != null) {
                dirs.add(ibm_coredir);
                this.logger.fine("Search IBM_COREDIR: " + ibm_coredir.getAbsolutePath());
            }
        } else {
            this.logger.fine("IBM_COREDIR not set");
        }
        if (this.de.get_CEE_DMPTARG() != null) {
            File _cee_dmptarg = new File(this.de.get_CEE_DMPTARG());
            if (_cee_dmptarg != null) {
                dirs.add(_cee_dmptarg);
                String template = Messages.getString("DumpSearch.4");
                String msg = MessageFormat.format(template, _cee_dmptarg.getAbsolutePath());
                this.logger.fine(msg);
            }
        } else {
            this.logger.fine("_CEE_DMPTARG not set");
        }
        File tmpdir = this.getFileFromEnvVar("TMPDIR");
        if (tmpdir != null) {
            dirs.add(tmpdir);
            this.logger.fine("Search TMPDIR: " + tmpdir.getAbsolutePath());
        } else {
            this.logger.fine("TMPDIR not set");
        }
        dirs.add(new File(pfmTmpDir));
        this.logger.fine("Search platform temporary directory " + pfmTmpDir);
        return dirs.toArray(new File[dirs.size()]);
    }

    private File getFileFromEnvVar(String envVarName) {
        String var = null;
        File f = null;
        if (envVarName != null) {
            var = System.getenv(envVarName);
        }
        if (var != null) {
            f = new File(var);
        }
        return f;
    }

    private void logLastDump(DumpDescriptor last) {
        if (last == null) {
            this.logger.fine("Last dump parameter not set");
        } else if (last.getLabel() != null) {
            this.logger.fine("Last dump parameter: " + last.getLabel());
        } else {
            this.logger.fine("Last dump parameter: " + last.getFilePath());
        }
    }

    DumpDescriptor getLastDump() {
        DumpDescriptor dd;
        String lastDumpName = this.de.getLastDump();
        if (lastDumpName == null || "".equals(lastDumpName)) {
            return null;
        }
        if (Util.isOnZOS() && (dd = new DumpDescriptor(lastDumpName, DumpDescriptor.DumpType.SYSTEM)).exists(this.logger)) {
            return dd;
        }
        return new DumpDescriptor(lastDumpName);
    }
}

