/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import com.ibm.java.diagnostics.collector.DiagnosticsCollector;
import com.ibm.java.diagnostics.collector.DumpDescriptor;
import com.ibm.java.diagnostics.collector.DumpEvent;
import com.ibm.java.diagnostics.collector.Messages;
import com.ibm.java.diagnostics.collector.Settings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class MustGatherZip {
    private String outputName;
    private String outputPath;
    private Logger logger;
    private boolean zipFileCreated;

    public MustGatherZip(Logger logger, String logFilename, DumpEvent de, DumpDescriptor[] dda, Settings s) throws IllegalArgumentException {
        if (de == null) {
            throw new IllegalArgumentException("de is null");
        }
        if (dda == null) {
            throw new IllegalArgumentException("dda is null");
        }
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        this.logger = logger;
        this.outputName = "java." + this.eventName(de.getEvent()) + de.getStamp() + "zip";
        this.zipFileCreated = this.createZipFile(dda, logFilename, s);
        if (this.zipFileCreated) {
            logger.fine("Output zip file created: " + this.outputName);
        } else {
            logger.fine("Output zip file was not created: " + this.outputName);
        }
    }

    private boolean createZipFile(DumpDescriptor[] dda, String logFilename, Settings s) {
        boolean fileCreated = false;
        File zf = null;
        String outDirPath = null;
        if (s != null) {
            outDirPath = s.getOutputDirPath();
        }
        File outDir = null;
        if (outDirPath != null && !(outDir = new File(outDirPath)).exists()) {
            boolean created = outDir.mkdirs();
            if (created) {
                this.logger.fine("Output directory created: " + outDir.getAbsolutePath());
            } else {
                this.logger.fine("Could not create output dir: " + outDir.getAbsolutePath());
            }
        }
        if ((zf = outDir != null && outDir.exists() ? new File(outDir, this.outputName) : new File(this.outputName)) != null) {
            this.setFilePath(zf.getAbsolutePath());
            if (zf.exists()) {
                this.logger.severe(DiagnosticsCollector.TOOLNAME + Messages.getString("MustGatherZip.0") + zf.getAbsolutePath() + Messages.getString("MustGatherZip.1"));
            } else {
                this.logger.fine("Writing output file: " + zf.getAbsolutePath());
                try {
                    HashSet<File> extra;
                    zf.createNewFile();
                    FileOutputStream zfos = new FileOutputStream(zf);
                    ZipOutputStream zfzos = new ZipOutputStream(zfos);
                    if (dda != null) {
                        for (int i = 0; i < dda.length; ++i) {
                            if (dda[i] == null) continue;
                            File target = null;
                            if (dda[i].getDumpType() == DumpDescriptor.DumpType.SYSTEM) {
                                if (dda[i].isJextractRun()) {
                                    target = dda[i].getJextractZip();
                                } else {
                                    target = dda[i].getFile();
                                    if (target == null && dda[i].getLabel() != null) {
                                        String template = Messages.getString("MustGatherZip.6");
                                        String message = MessageFormat.format(template, dda[i].getName(), zf.getAbsolutePath());
                                        this.logger.warning(message);
                                    }
                                }
                            } else {
                                target = dda[i].getFile();
                            }
                            this.addFileToZip(target, zfzos);
                        }
                    }
                    if (s != null && (extra = s.getFilesToCollect()).size() > 0) {
                        this.logger.fine("Settings file: number of extra files to collect: " + extra.size());
                        Iterator<File> i = extra.iterator();
                        while (i.hasNext()) {
                            this.addFileToZip(i.next(), zfzos);
                        }
                    }
                    if (logFilename != null) {
                        File logfile = new File(logFilename);
                        this.addFileToZip(logfile, zfzos);
                    }
                    zfzos.close();
                    fileCreated = true;
                }
                catch (IOException ioe) {
                    this.logger.log(Level.SEVERE, Messages.getString("MustGatherZip.5"), ioe);
                    this.logger.log(Level.SEVERE, Messages.getString("MustGatherZip.2"), zf.getAbsolutePath());
                }
            }
        }
        return fileCreated;
    }

    void addFileToZip(File target, ZipOutputStream zip) throws IOException {
        if (target == null) {
            return;
        }
        if (target.canRead()) {
            int len;
            this.logger.fine("Add file " + target.getAbsolutePath() + " to output zipfile " + this.outputName);
            FileInputStream in = new FileInputStream(target);
            zip.putNextEntry(new ZipEntry(target.getName()));
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) >= 0) {
                zip.write(buf, 0, len);
            }
            zip.closeEntry();
            ((InputStream)in).close();
        } else if (target.exists()) {
            this.logger.warning(DiagnosticsCollector.TOOLNAME + Messages.getString("MustGatherZip.3") + target.getAbsolutePath() + Messages.getString("MustGatherZip.4") + System.getProperty("user.name"));
        } else {
            this.logger.fine("File not found: " + target.getAbsolutePath());
        }
    }

    String eventName(String event) {
        if (event != null) {
            if (event.equals("gpf")) {
                return "gpf";
            }
            if (event.equals("outofmemoryerror")) {
                return "outofmemoryerror";
            }
            if (event.equals("user")) {
                return "usersignal";
            }
            if (event.equals("abort")) {
                return "abortsignal";
            }
            if (event.equals("vmstart")) {
                return "vmstart";
            }
            if (event.equals("vmstop")) {
                return "vmstop";
            }
            if (event.equals("check")) {
                return "check";
            }
        }
        this.logger.fine("unrecognised dump event: \"" + event + "\"");
        return "dumpevent";
    }

    public String getFilePath() {
        return this.outputPath;
    }

    public void setFilePath(String path) {
        this.outputPath = path;
    }

    public boolean isZipFileCreated() {
        return this.zipFileCreated;
    }
}

