/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.client.applicationclient;

import com.ibm.websphere.client.applicationclient.ClientContainerException;
import com.ibm.websphere.client.applicationclient.NoMainClassException;
import com.ibm.wsspi.bootstrap.WSPreLauncher;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipException;
import javax.naming.NamingException;

public class launchClient {
    public static Properties clientContainerProps;
    public static Exception launchException;
    private static final boolean debugEnabled;
    private static final String CC_LAUNCHER_PROPS = "cc_launcher.properties";
    private static final String ECLIPSE_LAUNCHCLIENT_APPL_ID = "com.ibm.ws.runtime.LaunchClient";
    private static final String ECLIPSE_LAUNCHCLIENTAPI_APPL_ID = "com.ibm.ws.runtime.LaunchClientApi";
    private static String[] ECLIPSE_LAUNCHCLIENT_CMD;

    public void launch(String string, Properties properties, String[] stringArray) throws ClientContainerException, IllegalArgumentException, NamingException, IOException, ZipException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        clientContainerProps = properties != null ? (Properties)properties.clone() : null;
        launchException = null;
        launchClient.setClientContainerDefaultProperties();
        String[] stringArray2 = launchClient.composeArgsForWsPreLauncher(stringArray, ECLIPSE_LAUNCHCLIENTAPI_APPL_ID, string);
        WSPreLauncher.main((String[])stringArray2);
        if (launchException != null) {
            if (launchException instanceof ClientContainerException) {
                throw (ClientContainerException)launchException;
            }
            if (launchException instanceof NoMainClassException) {
                throw (NoMainClassException)launchException;
            }
            if (launchException instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)launchException;
            }
            if (launchException instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)launchException;
            }
            if (launchException instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)launchException;
            }
            if (launchException instanceof IllegalAccessException) {
                throw (IllegalAccessException)launchException;
            }
            if (launchException instanceof InvocationTargetException) {
                throw (InvocationTargetException)launchException;
            }
            if (launchException instanceof IOException) {
                throw (IOException)launchException;
            }
            if (launchException instanceof NamingException) {
                throw (NamingException)launchException;
            }
        }
    }

    public static void main(String[] stringArray) {
        launchClient.setClientContainerDefaultProperties();
        launchClient.setJava2SecurityProperties(stringArray);
        String[] stringArray2 = launchClient.composeArgsForWsPreLauncher(stringArray);
        launchClient.debugPreLauncherArgs(stringArray2);
        WSPreLauncher.main((String[])stringArray2);
    }

    private static void setInstallRoot() {
        String string = System.getProperty("was.install.root", "").replace('\\', '/');
        if (string.length() == 0) {
            System.err.println("Error: \"was.install.root\" is not set");
            System.exit(-1);
        }
        System.setProperty("was.install.root", string);
        String string2 = System.getProperty("user.install.root", "").replace('\\', '/');
        if (string2.length() == 0) {
            System.setProperty("user.install.root", string);
        } else {
            System.setProperty("user.install.root", string2);
        }
    }

    private static void setClientContainerDefaultProperties() {
        launchClient.setInstallRoot();
        InputStream inputStream = launchClient.class.getClassLoader().getResourceAsStream(CC_LAUNCHER_PROPS);
        Properties properties = new Properties();
        try {
            if (inputStream != null) {
                properties.load(inputStream);
                inputStream.close();
            } else {
                launchClient.debug("WARNING: com.ibm.websphere.client.applicationclient.cc_launcher.properties is not found.");
            }
        }
        catch (IOException iOException) {
            launchClient.debug("WARNING: Reading error for com.ibm.websphere.client.applicationclient.cc_launcher.properties, skip properties file.");
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)properties.get(string);
            if (System.getProperty(string, "").length() != 0) continue;
            System.setProperty(string, launchClient.replaceMacro(string2));
        }
    }

    private static String replaceMacro(String string) {
        int n;
        String string2 = string;
        int n2 = string.indexOf("${");
        if (n2 > -1 && (n = string.indexOf(125, n2)) > -1) {
            String string3 = string.substring(n2 + 2, n);
            String string4 = System.getProperty(string3, "");
            string2 = string.replaceAll("[$][{]" + string3 + "[}]", string4);
            launchClient.replaceMacro(string2);
        }
        return string2;
    }

    private static void setJava2SecurityProperties(String[] stringArray) {
        boolean bl = false;
        String string = "";
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("-CC")) continue;
            if (stringArray[i].compareTo("-CCsecurityManager=enable") == 0) {
                bl = true;
            }
            if (stringArray[i].startsWith("-CCsecurityMgrClass") && stringArray[i].indexOf("=") != -1) {
                string = stringArray[i].substring(stringArray[i].indexOf("="));
            }
            if (!stringArray[i].startsWith("-CCsecurityMgrPolicy") || stringArray[i].indexOf("=") == -1) continue;
            string2 = stringArray[i].substring(stringArray[i].indexOf("="));
        }
        if (bl) {
            System.setProperty("eclipse.security", string);
            if (string2.length() > 0) {
                System.setProperty("java.security.policy", string);
            } else {
                System.setProperty("java.security.policy", launchClient.replaceMacro("file:${user.install.root}/properties/client.policy"));
            }
        }
    }

    private static String[] composeArgsForWsPreLauncher(String[] stringArray) {
        return launchClient.composeArgsForWsPreLauncher(stringArray, ECLIPSE_LAUNCHCLIENT_APPL_ID, null);
    }

    private static String[] composeArgsForWsPreLauncher(String[] stringArray, String string, String string2) {
        int n;
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < ECLIPSE_LAUNCHCLIENT_CMD.length; ++n) {
            vector.add(ECLIPSE_LAUNCHCLIENT_CMD[n]);
        }
        vector.add(string);
        if (string2 != null) {
            vector.add(string2);
        }
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                vector.add(stringArray[n]);
            }
        }
        String[] stringArray2 = new String[vector.size()];
        return vector.toArray(stringArray2);
    }

    private static void debugPreLauncherArgs(String[] stringArray) {
        if (!debugEnabled) {
            return;
        }
        System.out.println("Client Container default properties");
        System.out.println("===================================");
        System.out.println("was.install.root=" + System.getProperty("was.install.root"));
        System.out.println("user.install.root=" + System.getProperty("user.install.root"));
        System.out.println("eclipse.security=" + System.getProperty("eclipse.security"));
        System.out.println("java.security.policy=" + System.getProperty("java.security.policy"));
        System.out.println("java.class.path=" + System.getProperty("java.class.path"));
        InputStream inputStream = launchClient.class.getClassLoader().getResourceAsStream(CC_LAUNCHER_PROPS);
        Properties properties = new Properties();
        try {
            if (inputStream != null) {
                properties.load(inputStream);
                inputStream.close();
            } else {
                launchClient.debug("WARNING: com.ibm.websphere.client.applicationclient.cc_launcher.properties is not found.");
            }
        }
        catch (IOException iOException) {
            launchClient.debug("WARNING: Reading error for com.ibm.websphere.client.applicationclient.cc_launcher.properties, skip properties file.");
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println(string + "=" + System.getProperty(string));
        }
        System.out.println("");
        System.out.println("launchClient arguments");
        System.out.println("======================");
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
        }
    }

    private static void debug(String string) {
        if (debugEnabled) {
            System.out.println(string);
        }
    }

    static {
        debugEnabled = Boolean.getBoolean("ws.launchClient.debug");
        ECLIPSE_LAUNCHCLIENT_CMD = new String[]{"-nosplash", "-noExit", "-application", "com.ibm.ws.bootstrap.WSLauncher"};
    }
}

