/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import com.sun.java.swing.plaf.gtk.GTKRegion;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import java.awt.Graphics;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JCheckBox;
import javax.swing.JToolBar;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthIcon;

class GTKIconFactory {
    private static SynthIcon expandedIcon;
    private static SynthIcon collapsedIcon;
    private static SynthIcon radioButtonIcon;
    private static SynthIcon checkBoxIcon;
    private static SynthIcon menuArrowIcon;
    private static SynthIcon menuCheckIcon;
    private static SynthIcon menuItemArrowIcon;
    private static SynthIcon menuItemCheckIcon;
    private static SynthIcon checkBoxMenuItemArrowIcon;
    private static SynthIcon checkBoxMenuItemCheckIcon;
    private static SynthIcon radioButtonMenuItemArrowIcon;
    private static SynthIcon radioButtonMenuItemCheckIcon;

    GTKIconFactory() {
    }

    public static SynthIcon getTreeExpandedIcon() {
        if (expandedIcon == null) {
            expandedIcon = new SynthExpanderIcon("paintTreeExpandedIcon");
        }
        return expandedIcon;
    }

    public static void paintTreeExpandedIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        ((GTKStyle)synthContext.getStyle()).getEngine(synthContext).paintExpander(synthContext, graphics, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState()), 1, "treeview", n, n2, n3, n4);
    }

    public static SynthIcon getTreeCollapsedIcon() {
        if (collapsedIcon == null) {
            collapsedIcon = new SynthExpanderIcon("paintTreeCollapsedIcon");
        }
        return collapsedIcon;
    }

    public static void paintTreeCollapsedIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        ((GTKStyle)synthContext.getStyle()).getEngine(synthContext).paintExpander(synthContext, graphics, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState()), 0, "treeview", n, n2, n3, n4);
    }

    public static SynthIcon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new DelegatingIcon("paintRadioButtonIcon", 13, 13);
        }
        return radioButtonIcon;
    }

    public static void paintRadioButtonIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n5 = synthContext.getComponentState();
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n5);
        int n7 = 1;
        if ((n5 & 0x200) != 0) {
            n6 = 512;
        }
        if (n6 == 512) {
            n7 = 0;
        }
        ((GTKStyle)synthContext.getStyle()).getEngine(synthContext).paintOption(synthContext, graphics, n6, n7, "radiobutton", n, n2, n3, n4);
    }

    public static SynthIcon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new DelegatingIcon("paintCheckBoxIcon", 13, 13);
        }
        return checkBoxIcon;
    }

    public static void paintCheckBoxIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n5 = synthContext.getComponentState();
        int n6 = 1;
        if (((JCheckBox)synthContext.getComponent()).isSelected()) {
            n6 = 0;
        }
        ((GTKStyle)synthContext.getStyle()).getEngine(synthContext).paintCheck(synthContext, graphics, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState()), n6, "checkbutton", n, n2, n3, n4);
    }

    public static SynthIcon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new DelegatingIcon("paintMenuArrowIcon", 13, 13);
        }
        return menuArrowIcon;
    }

    public static void paintMenuArrowIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n5 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        int n6 = 1;
        if (n5 == 2) {
            n6 = 0;
        }
        int n7 = synthContext.getComponent().getComponentOrientation().isLeftToRight() ? 103 : 102;
        gTKStyle.getEngine(synthContext).paintArrow(synthContext, graphics, n5, n6, n7, "menuitem", n + 3, n2 + 3, 7, 7);
    }

    public static SynthIcon getMenuItemArrowIcon() {
        if (menuItemArrowIcon == null) {
            menuItemArrowIcon = new DelegatingIcon("paintMenuItemArrowIcon", 13, 13);
        }
        return menuItemArrowIcon;
    }

    public static void paintMenuItemArrowIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public static SynthIcon getCheckBoxMenuItemArrowIcon() {
        if (checkBoxMenuItemArrowIcon == null) {
            checkBoxMenuItemArrowIcon = new DelegatingIcon("paintCheckBoxMenuItemArrowIcon", 13, 13);
        }
        return checkBoxMenuItemArrowIcon;
    }

    public static void paintCheckBoxMenuItemArrowIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public static SynthIcon getCheckBoxMenuItemCheckIcon() {
        if (checkBoxMenuItemCheckIcon == null) {
            checkBoxMenuItemCheckIcon = new DelegatingIcon("paintCheckBoxMenuItemCheckIcon", 13, 13);
        }
        return checkBoxMenuItemCheckIcon;
    }

    public static void paintCheckBoxMenuItemCheckIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n5 = synthContext.getComponentState();
        int n6 = 1;
        int n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n5);
        if ((n5 & 2) != 0) {
            n7 = 2;
        }
        if ((n5 & 0x200) != 0) {
            n6 = 0;
        }
        gTKStyle.getEngine(synthContext).paintCheck(synthContext, graphics, n7, n6, "check", n, n2, n3, n4);
    }

    public static SynthIcon getRadioButtonMenuItemArrowIcon() {
        if (radioButtonMenuItemArrowIcon == null) {
            radioButtonMenuItemArrowIcon = new DelegatingIcon("paintRadioButtonMenuItemArrowIcon", 13, 13);
        }
        return radioButtonMenuItemArrowIcon;
    }

    public static void paintRadioButtonMenuItemArrowIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public static SynthIcon getRadioButtonMenuItemCheckIcon() {
        if (radioButtonMenuItemCheckIcon == null) {
            radioButtonMenuItemCheckIcon = new DelegatingIcon("paintRadioButtonMenuItemCheckIcon", 13, 13);
        }
        return radioButtonMenuItemCheckIcon;
    }

    public static void paintRadioButtonMenuItemCheckIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n5 = synthContext.getComponentState();
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n5);
        if ((n5 & 2) != 0) {
            n6 = 2;
        }
        int n7 = 1;
        if ((n5 & 0x200) != 0) {
            n7 = 0;
        }
        ((GTKStyle)synthContext.getStyle()).getEngine(synthContext).paintOption(synthContext, graphics, n6, n7, "option", n, n2, n3, n4);
    }

    public static SynthIcon getToolBarHandleIcon() {
        return new ToolBarHandleIcon();
    }

    public static void paintToolBarHandleIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = ((JToolBar)synthContext.getComponent()).getOrientation() == 0 ? 0 : 1;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKStyle.getEngine(synthContext).paintHandle(synthContext, graphics, n6, 1, "handlebox", n, n2, n3, n4, n5);
    }

    private static class ToolBarHandleIcon
    extends SynthIcon {
        private SynthStyle style;

        private ToolBarHandleIcon() {
        }

        public void paintIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            if (synthContext != null) {
                synthContext = this.getContext(synthContext);
                GTKIconFactory.paintToolBarHandleIcon(synthContext, graphics, n, n2, n3, n4);
            }
        }

        public int getIconWidth(SynthContext synthContext) {
            if (((JToolBar)synthContext.getComponent()).getOrientation() == 0) {
                return 10;
            }
            return synthContext.getComponent().getWidth();
        }

        public int getIconHeight(SynthContext synthContext) {
            if (((JToolBar)synthContext.getComponent()).getOrientation() == 0) {
                return synthContext.getComponent().getHeight();
            }
            return 10;
        }

        private SynthContext getContext(SynthContext synthContext) {
            if (this.style == null) {
                this.style = SynthLookAndFeel.getStyleFactory().getStyle(synthContext.getComponent(), GTKRegion.HANDLE_BOX);
            }
            return new SynthContext(synthContext.getComponent(), GTKRegion.HANDLE_BOX, this.style, 1);
        }
    }

    private static class SynthExpanderIcon
    extends SynthIcon {
        private static final Class[] PARAM_TYPES = new Class[]{SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
        private int width = -1;
        private int height = -1;
        private Object method;

        SynthExpanderIcon(String string) {
            this.method = string;
        }

        public void paintIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            if (synthContext != null) {
                try {
                    this.getMethod().invoke(GTKIconFactory.class, synthContext, graphics, new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4));
                    this.updateSizeIfNecessary(synthContext);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }

        public int getIconWidth(SynthContext synthContext) {
            this.updateSizeIfNecessary(synthContext);
            return this.width;
        }

        public int getIconHeight(SynthContext synthContext) {
            this.updateSizeIfNecessary(synthContext);
            return this.height;
        }

        private void updateSizeIfNecessary(SynthContext synthContext) {
            if (this.width == -1 && synthContext != null) {
                this.width = this.height = synthContext.getStyle().getInt(synthContext, "Tree.expanderSize", 10);
            }
        }

        private Method getMethod() {
            if (this.method instanceof String) {
                Method[] methodArray = GTKIconFactory.class.getMethods();
                try {
                    this.method = GTKIconFactory.class.getMethod((String)this.method, PARAM_TYPES);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    System.out.println("NSME: " + noSuchMethodException);
                }
            }
            return (Method)this.method;
        }
    }

    private static class DelegatingIcon
    extends SynthIcon
    implements UIResource {
        private static final Class[] PARAM_TYPES = new Class[]{SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
        private int width;
        private int height;
        private Object method;

        DelegatingIcon(String string, int n, int n2) {
            this.method = string;
            this.width = n;
            this.height = n2;
        }

        public void paintIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            if (synthContext != null) {
                try {
                    this.getMethod().invoke(GTKIconFactory.class, synthContext, graphics, new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4));
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }

        public int getIconWidth(SynthContext synthContext) {
            return this.width;
        }

        public int getIconHeight(SynthContext synthContext) {
            return this.height;
        }

        private Method getMethod() {
            if (this.method instanceof String) {
                Method[] methodArray = GTKIconFactory.class.getMethods();
                try {
                    this.method = GTKIconFactory.class.getMethod((String)this.method, PARAM_TYPES);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    System.out.println("NSME: " + noSuchMethodException);
                }
            }
            return (Method)this.method;
        }
    }
}

