/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyEventPostProcessor;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import javax.swing.plaf.basic.ComboPopup;

public class WindowsRootPaneUI
extends BasicRootPaneUI {
    private static final WindowsRootPaneUI windowsRootPaneUI = new WindowsRootPaneUI();
    static final AltProcessor altProcessor = new AltProcessor();

    public static ComponentUI createUI(JComponent jComponent) {
        return windowsRootPaneUI;
    }

    static class AltProcessor
    implements KeyEventPostProcessor {
        static boolean altKeyPressed = false;
        private static boolean altKeyReleased = false;
        static boolean menuCanceledOnPress = false;
        static JRootPane root = null;
        static Window winAncestor = null;
        private static JMenuBar mbar = null;
        private int topTier = 0;
        private JMenuBar topMBar = null;

        AltProcessor() {
        }

        void altPressed(KeyEvent keyEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length > 0 && !(menuElementArray[0] instanceof ComboPopup)) {
                menuSelectionManager.clearSelectedPath();
                menuCanceledOnPress = true;
                keyEvent.consume();
            } else if (menuElementArray.length > 0) {
                menuCanceledOnPress = false;
                WindowsLookAndFeel.setMnemonicHidden(false);
                WindowsUtils.repaintMnemonicsInWindow(winAncestor);
                keyEvent.consume();
            } else {
                JMenu jMenu;
                menuCanceledOnPress = false;
                WindowsLookAndFeel.setMnemonicHidden(false);
                WindowsUtils.repaintMnemonicsInWindow(winAncestor);
                JMenu jMenu2 = jMenu = mbar != null ? mbar.getMenu(0) : null;
                if (jMenu != null) {
                    keyEvent.consume();
                }
            }
        }

        void altReleased(KeyEvent keyEvent) {
            if (menuCanceledOnPress) {
                WindowsLookAndFeel.setMnemonicHidden(true);
                WindowsUtils.repaintMnemonicsInWindow(winAncestor);
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (menuSelectionManager.getSelectedPath().length == 0) {
                JMenu jMenu;
                JMenu jMenu2 = jMenu = mbar != null ? mbar.getMenu(0) : null;
                if (jMenu != null) {
                    MenuElement[] menuElementArray = new MenuElement[]{mbar, jMenu};
                    menuSelectionManager.setSelectedPath(menuElementArray);
                }
            }
        }

        public boolean postProcessKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 18) {
                root = SwingUtilities.getRootPane(keyEvent.getComponent());
                winAncestor = root == null ? null : SwingUtilities.getWindowAncestor(root);
                mbar = this.getJMenuBar(root);
                if (keyEvent.getID() == 401) {
                    if (!altKeyPressed) {
                        this.altPressed(keyEvent);
                    }
                    altKeyPressed = true;
                    altKeyReleased = false;
                    return true;
                }
                if (keyEvent.getID() == 402) {
                    MenuSelectionManager menuSelectionManager;
                    MenuElement[] menuElementArray;
                    if (altKeyPressed) {
                        this.altReleased(keyEvent);
                    } else if (altKeyReleased || (menuElementArray = (menuSelectionManager = MenuSelectionManager.defaultManager()).getSelectedPath()).length <= 0) {
                        // empty if block
                    }
                    altKeyPressed = false;
                    altKeyReleased = true;
                }
                root = null;
                winAncestor = null;
            } else {
                altKeyPressed = false;
            }
            return false;
        }

        private JMenuBar getJMenuBar(JRootPane jRootPane) {
            Window window;
            JMenuBar jMenuBar = null;
            if (jRootPane != null && (jMenuBar = this.getTopJMenuBar(jRootPane)) == null && jRootPane.getParent() instanceof JInternalFrame && (window = SwingUtilities.windowForComponent(jRootPane.getParent())) != null && window instanceof RootPaneContainer) {
                jRootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                jMenuBar = this.getTopJMenuBar(jRootPane);
            }
            return jMenuBar;
        }

        private JMenuBar getTopJMenuBar(JRootPane jRootPane) {
            this.topTier = 0;
            this.topMBar = null;
            if (jRootPane != null) {
                Container container = jRootPane.getContentPane();
                this.searchChildren(container, 0);
            }
            return this.topMBar;
        }

        private boolean searchChildren(Container container, int n) {
            if (container != null) {
                if (this.topTier != 0 && ++n >= this.topTier) {
                    return false;
                }
                Component[] componentArray = container.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    Component component = componentArray[i];
                    if (component instanceof JMenuBar) {
                        if (this.topTier != 0 && n >= this.topTier) continue;
                        this.topTier = n;
                        this.topMBar = (JMenuBar)component;
                        return true;
                    }
                    if (component instanceof Container && this.searchChildren((Container)component, n)) break;
                }
            }
            return false;
        }
    }
}

