/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.DisplayMode;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.ColorModel;

public abstract class GraphicsDevice {
    private Window fullScreenWindow;
    private Rectangle windowedModeBounds;
    public static final int TYPE_RASTER_SCREEN = 0;
    public static final int TYPE_PRINTER = 1;
    public static final int TYPE_IMAGE_BUFFER = 2;

    protected GraphicsDevice() {
    }

    public abstract int getType();

    public abstract String getIDstring();

    public abstract GraphicsConfiguration[] getConfigurations();

    public abstract GraphicsConfiguration getDefaultConfiguration();

    public GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate graphicsConfigTemplate) {
        GraphicsConfiguration[] graphicsConfigurationArray = this.getConfigurations();
        return graphicsConfigTemplate.getBestConfiguration(graphicsConfigurationArray);
    }

    public boolean isFullScreenSupported() {
        return false;
    }

    public void setFullScreenWindow(Window window) {
        DisplayMode displayMode = window == null ? null : this.getDisplayMode();
        if (this.fullScreenWindow != null && this.windowedModeBounds != null) {
            if (this.windowedModeBounds.width == 0) {
                this.windowedModeBounds.width = 1;
            }
            if (this.windowedModeBounds.height == 0) {
                this.windowedModeBounds.height = 1;
            }
            this.fullScreenWindow.setBounds(this.windowedModeBounds);
        }
        this.fullScreenWindow = window;
        if (this.fullScreenWindow != null) {
            this.windowedModeBounds = this.fullScreenWindow.getBounds();
            this.fullScreenWindow.setBounds(0, 0, displayMode.getWidth(), displayMode.getHeight());
            this.fullScreenWindow.setVisible(true);
            this.fullScreenWindow.toFront();
        }
    }

    public Window getFullScreenWindow() {
        return this.fullScreenWindow;
    }

    public boolean isDisplayChangeSupported() {
        return false;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        throw new UnsupportedOperationException("Cannot change display mode");
    }

    public DisplayMode getDisplayMode() {
        GraphicsConfiguration graphicsConfiguration = this.getDefaultConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        ColorModel colorModel = graphicsConfiguration.getColorModel();
        return new DisplayMode(rectangle.width, rectangle.height, colorModel.getPixelSize(), 0);
    }

    public DisplayMode[] getDisplayModes() {
        return new DisplayMode[]{this.getDisplayMode()};
    }

    public int getAvailableAcceleratedMemory() {
        return -1;
    }
}

