/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.WindowListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import sun.awt.SunToolkit;

public class JWindow
extends Window
implements Accessible,
RootPaneContainer {
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    protected AccessibleContext accessibleContext = null;

    public JWindow() {
        this((Frame)null);
    }

    public JWindow(GraphicsConfiguration graphicsConfiguration) {
        this(null, graphicsConfiguration);
        super.setFocusableWindowState(false);
    }

    public JWindow(Frame frame) {
        super(frame == null ? SwingUtilities.getSharedOwnerFrame() : frame);
        if (frame == null) {
            WindowListener windowListener = SwingUtilities.getSharedOwnerFrameShutdownListener();
            this.addWindowListener(windowListener);
        }
        this.windowInit();
    }

    public JWindow(Window window) {
        super(window == null ? SwingUtilities.getSharedOwnerFrame() : window);
        if (window == null) {
            WindowListener windowListener = SwingUtilities.getSharedOwnerFrameShutdownListener();
            this.addWindowListener(windowListener);
        }
        this.windowInit();
    }

    public JWindow(Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window == null ? SwingUtilities.getSharedOwnerFrame() : window, graphicsConfiguration);
        if (window == null) {
            WindowListener windowListener = SwingUtilities.getSharedOwnerFrameShutdownListener();
            this.addWindowListener(windowListener);
        }
        this.windowInit();
    }

    protected void windowInit() {
        this.setLocale(JComponent.getDefaultLocale());
        this.setRootPane(this.createRootPane());
        this.setRootPaneCheckingEnabled(true);
        SunToolkit.checkAndSetPolicy(this, true);
    }

    protected JRootPane createRootPane() {
        JRootPane jRootPane = new JRootPane();
        jRootPane.setOpaque(true);
        return jRootPane;
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().add(component, object, n);
        } else {
            super.addImpl(component, object, n);
        }
    }

    public void remove(Component component) {
        if (component == this.rootPane) {
            super.remove(component);
        } else {
            this.getContentPane().remove(component);
        }
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().setLayout(layoutManager);
        } else {
            super.setLayout(layoutManager);
        }
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
            }
            finally {
                this.setRootPaneCheckingEnabled(bl);
            }
        }
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container container) {
        this.getRootPane().setContentPane(container);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.getRootPane().setLayeredPane(jLayeredPane);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void setGlassPane(Component component) {
        this.getRootPane().setGlassPane(component);
    }

    protected String paramString() {
        String string = this.rootPaneCheckingEnabled ? "true" : "false";
        return super.paramString() + ",rootPaneCheckingEnabled=" + string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJWindow();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJWindow
    extends Window.AccessibleAWTWindow {
        protected AccessibleJWindow() {
        }
    }
}

