/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.LazyActionMap;
import javax.swing.text.View;
import sun.swing.UIAction;

public class BasicLabelUI
extends LabelUI
implements PropertyChangeListener {
    private static final BasicLabelUI SAFE_BASIC_LABEL_UI = new BasicLabelUI();
    protected static BasicLabelUI labelUI = new BasicLabelUI();
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);
    private static Rectangle iconR = new Rectangle();
    private static Rectangle textR = new Rectangle();
    private static Rectangle viewR = new Rectangle();
    private static Insets viewInsets = new Insets(0, 0, 0, 0);

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("press"));
        lazyActionMap.put(new Actions("release"));
    }

    protected String layoutCL(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        return SwingUtilities.layoutCompoundLabel(jLabel, fontMetrics, string, icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, jLabel.getIconTextGap());
    }

    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        int n3 = jLabel.getDisplayedMnemonicIndex();
        graphics.setColor(jLabel.getForeground());
        SwingUtilities2.drawStringUnderlineCharAt(jLabel, graphics, string, n3, n, n2);
    }

    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        int n3 = jLabel.getDisplayedMnemonicIndex();
        Color color = jLabel.getBackground();
        graphics.setColor(color.brighter());
        SwingUtilities2.drawStringUnderlineCharAt(jLabel, graphics, string, n3, n + 1, n2 + 1);
        graphics.setColor(color.darker());
        SwingUtilities2.drawStringUnderlineCharAt(jLabel, graphics, string, n3, n, n2);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Icon icon;
        JLabel jLabel = (JLabel)jComponent;
        String string = jLabel.getText();
        Icon icon2 = icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        if (icon == null && string == null) {
            return;
        }
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jLabel, graphics);
        Insets insets = jComponent.getInsets(paintViewInsets);
        BasicLabelUI.paintViewR.x = insets.left;
        BasicLabelUI.paintViewR.y = insets.top;
        BasicLabelUI.paintViewR.width = jComponent.getWidth() - (insets.left + insets.right);
        BasicLabelUI.paintViewR.height = jComponent.getHeight() - (insets.top + insets.bottom);
        BasicLabelUI.paintIconR.height = 0;
        BasicLabelUI.paintIconR.width = 0;
        BasicLabelUI.paintIconR.y = 0;
        BasicLabelUI.paintIconR.x = 0;
        BasicLabelUI.paintTextR.height = 0;
        BasicLabelUI.paintTextR.width = 0;
        BasicLabelUI.paintTextR.y = 0;
        BasicLabelUI.paintTextR.x = 0;
        String string2 = this.layoutCL(jLabel, fontMetrics, string, icon, paintViewR, paintIconR, paintTextR);
        if (icon != null) {
            icon.paintIcon(jComponent, graphics, BasicLabelUI.paintIconR.x, BasicLabelUI.paintIconR.y);
        }
        if (string != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, paintTextR);
            } else {
                int n = BasicLabelUI.paintTextR.x;
                int n2 = BasicLabelUI.paintTextR.y + fontMetrics.getAscent();
                if (jLabel.isEnabled()) {
                    this.paintEnabledText(jLabel, graphics, string2, n, n2);
                } else {
                    this.paintDisabledText(jLabel, graphics, string2, n, n2);
                }
            }
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        JLabel jLabel = (JLabel)jComponent;
        String string = jLabel.getText();
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        Insets insets = jLabel.getInsets(viewInsets);
        Font font = jLabel.getFont();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        if (icon == null && (string == null || string != null && font == null)) {
            return new Dimension(n, n2);
        }
        if (string == null || icon != null && font == null) {
            return new Dimension(icon.getIconWidth() + n, icon.getIconHeight() + n2);
        }
        FontMetrics fontMetrics = jLabel.getFontMetrics(font);
        BasicLabelUI.iconR.height = 0;
        BasicLabelUI.iconR.width = 0;
        BasicLabelUI.iconR.y = 0;
        BasicLabelUI.iconR.x = 0;
        BasicLabelUI.textR.height = 0;
        BasicLabelUI.textR.width = 0;
        BasicLabelUI.textR.y = 0;
        BasicLabelUI.textR.x = 0;
        BasicLabelUI.viewR.x = n;
        BasicLabelUI.viewR.y = n2;
        BasicLabelUI.viewR.height = Short.MAX_VALUE;
        BasicLabelUI.viewR.width = Short.MAX_VALUE;
        this.layoutCL(jLabel, fontMetrics, string, icon, viewR, iconR, textR);
        int n3 = Math.min(BasicLabelUI.iconR.x, BasicLabelUI.textR.x);
        int n4 = Math.max(BasicLabelUI.iconR.x + BasicLabelUI.iconR.width, BasicLabelUI.textR.x + BasicLabelUI.textR.width);
        int n5 = Math.min(BasicLabelUI.iconR.y, BasicLabelUI.textR.y);
        int n6 = Math.max(BasicLabelUI.iconR.y + BasicLabelUI.iconR.height, BasicLabelUI.textR.y + BasicLabelUI.textR.height);
        Dimension dimension = new Dimension(n4 - n3, n6 - n5);
        dimension.width += n;
        dimension.height += n2;
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    public void installUI(JComponent jComponent) {
        this.installDefaults((JLabel)jComponent);
        this.installComponents((JLabel)jComponent);
        this.installListeners((JLabel)jComponent);
        this.installKeyboardActions((JLabel)jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults((JLabel)jComponent);
        this.uninstallComponents((JLabel)jComponent);
        this.uninstallListeners((JLabel)jComponent);
        this.uninstallKeyboardActions((JLabel)jComponent);
    }

    protected void installDefaults(JLabel jLabel) {
        LookAndFeel.installColorsAndFont(jLabel, "Label.background", "Label.foreground", "Label.font");
        LookAndFeel.installProperty(jLabel, "opaque", Boolean.FALSE);
    }

    protected void installListeners(JLabel jLabel) {
        jLabel.addPropertyChangeListener(this);
    }

    protected void installComponents(JLabel jLabel) {
        BasicHTML.updateRenderer(jLabel, jLabel.getText());
        jLabel.setInheritsPopupMenu(true);
    }

    protected void installKeyboardActions(JLabel jLabel) {
        int n = jLabel.getDisplayedMnemonic();
        Component component = jLabel.getLabelFor();
        if (n != 0 && component != null) {
            LazyActionMap.installLazyActionMap(jLabel, BasicLabelUI.class, "Label.actionMap");
            InputMap inputMap = SwingUtilities.getUIInputMap(jLabel, 2);
            if (inputMap == null) {
                inputMap = new ComponentInputMapUIResource(jLabel);
                SwingUtilities.replaceUIInputMap(jLabel, 2, inputMap);
            }
            inputMap.clear();
            inputMap.put(KeyStroke.getKeyStroke(n, 8, false), "press");
        } else {
            InputMap inputMap = SwingUtilities.getUIInputMap(jLabel, 2);
            if (inputMap != null) {
                inputMap.clear();
            }
        }
    }

    protected void uninstallDefaults(JLabel jLabel) {
    }

    protected void uninstallListeners(JLabel jLabel) {
        jLabel.removePropertyChangeListener(this);
    }

    protected void uninstallComponents(JLabel jLabel) {
        BasicHTML.updateRenderer(jLabel, "");
    }

    protected void uninstallKeyboardActions(JLabel jLabel) {
        SwingUtilities.replaceUIInputMap(jLabel, 0, null);
        SwingUtilities.replaceUIInputMap(jLabel, 2, null);
        SwingUtilities.replaceUIActionMap(jLabel, null);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        if (System.getSecurityManager() != null) {
            return SAFE_BASIC_LABEL_UI;
        }
        return labelUI;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "text" || "font" == string || "foreground" == string) {
            JLabel jLabel = (JLabel)propertyChangeEvent.getSource();
            String string2 = jLabel.getText();
            BasicHTML.updateRenderer(jLabel, string2);
        } else if (string == "labelFor" || string == "displayedMnemonic") {
            this.installKeyboardActions((JLabel)propertyChangeEvent.getSource());
        }
    }

    private static class Actions
    extends UIAction {
        private static final String PRESS = "press";
        private static final String RELEASE = "release";

        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JLabel jLabel = (JLabel)actionEvent.getSource();
            String string = this.getName();
            if (string == PRESS) {
                this.doPress(jLabel);
            } else if (string == RELEASE) {
                this.doRelease(jLabel);
            }
        }

        private void doPress(JLabel jLabel) {
            Component component = jLabel.getLabelFor();
            if (component != null && component.isEnabled()) {
                InputMap inputMap = SwingUtilities.getUIInputMap(jLabel, 0);
                if (inputMap == null) {
                    inputMap = new InputMapUIResource();
                    SwingUtilities.replaceUIInputMap(jLabel, 0, inputMap);
                }
                int n = jLabel.getDisplayedMnemonic();
                inputMap.put(KeyStroke.getKeyStroke(n, 8, true), RELEASE);
                inputMap.put(KeyStroke.getKeyStroke(0, 8, true), RELEASE);
                inputMap.put(KeyStroke.getKeyStroke(n, 0, true), RELEASE);
                Component component2 = jLabel.getLabelFor();
                jLabel.requestFocus();
            }
        }

        private void doRelease(JLabel jLabel) {
            Component component = jLabel.getLabelFor();
            if (component != null && component.isEnabled()) {
                InputMap inputMap = SwingUtilities.getUIInputMap(jLabel, 0);
                if (inputMap != null) {
                    inputMap.remove(KeyStroke.getKeyStroke(jLabel.getDisplayedMnemonic(), 8, true));
                    inputMap.remove(KeyStroke.getKeyStroke(0, 8, true));
                    inputMap.remove(KeyStroke.getKeyStroke(jLabel.getDisplayedMnemonic(), 0, true));
                }
                if (component instanceof Container && ((Container)component).isFocusCycleRoot()) {
                    component.requestFocus();
                } else {
                    BasicLookAndFeel.compositeRequestFocus(component);
                }
            }
        }
    }
}

