/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.CachedPainter;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalIconFactory
implements Serializable {
    private static Icon fileChooserDetailViewIcon;
    private static Icon fileChooserHomeFolderIcon;
    private static Icon fileChooserListViewIcon;
    private static Icon fileChooserNewFolderIcon;
    private static Icon fileChooserUpFolderIcon;
    private static Icon internalFrameAltMaximizeIcon;
    private static Icon internalFrameCloseIcon;
    private static Icon internalFrameDefaultMenuIcon;
    private static Icon internalFrameMaximizeIcon;
    private static Icon internalFrameMinimizeIcon;
    private static Icon radioButtonIcon;
    private static Icon treeComputerIcon;
    private static Icon treeFloppyDriveIcon;
    private static Icon treeHardDriveIcon;
    private static Icon menuArrowIcon;
    private static Icon menuItemArrowIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon checkBoxIcon;
    private static Icon oceanHorizontalSliderThumb;
    private static Icon oceanVerticalSliderThumb;
    public static final boolean DARK = false;
    public static final boolean LIGHT = true;
    private static final Dimension folderIcon16Size;
    private static final Dimension fileIcon16Size;
    private static final Dimension treeControlSize;
    private static final Dimension menuArrowIconSize;
    private static final Dimension menuCheckIconSize;
    private static final int xOff = 4;

    public static Icon getFileChooserDetailViewIcon() {
        if (fileChooserDetailViewIcon == null) {
            fileChooserDetailViewIcon = new FileChooserDetailViewIcon();
        }
        return fileChooserDetailViewIcon;
    }

    public static Icon getFileChooserHomeFolderIcon() {
        if (fileChooserHomeFolderIcon == null) {
            fileChooserHomeFolderIcon = new FileChooserHomeFolderIcon();
        }
        return fileChooserHomeFolderIcon;
    }

    public static Icon getFileChooserListViewIcon() {
        if (fileChooserListViewIcon == null) {
            fileChooserListViewIcon = new FileChooserListViewIcon();
        }
        return fileChooserListViewIcon;
    }

    public static Icon getFileChooserNewFolderIcon() {
        if (fileChooserNewFolderIcon == null) {
            fileChooserNewFolderIcon = new FileChooserNewFolderIcon();
        }
        return fileChooserNewFolderIcon;
    }

    public static Icon getFileChooserUpFolderIcon() {
        if (fileChooserUpFolderIcon == null) {
            fileChooserUpFolderIcon = new FileChooserUpFolderIcon();
        }
        return fileChooserUpFolderIcon;
    }

    public static Icon getInternalFrameAltMaximizeIcon(int n) {
        return new InternalFrameAltMaximizeIcon(n);
    }

    public static Icon getInternalFrameCloseIcon(int n) {
        return new InternalFrameCloseIcon(n);
    }

    public static Icon getInternalFrameDefaultMenuIcon() {
        if (internalFrameDefaultMenuIcon == null) {
            internalFrameDefaultMenuIcon = new InternalFrameDefaultMenuIcon();
        }
        return internalFrameDefaultMenuIcon;
    }

    public static Icon getInternalFrameMaximizeIcon(int n) {
        return new InternalFrameMaximizeIcon(n);
    }

    public static Icon getInternalFrameMinimizeIcon(int n) {
        return new InternalFrameMinimizeIcon(n);
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getTreeComputerIcon() {
        if (treeComputerIcon == null) {
            treeComputerIcon = new TreeComputerIcon();
        }
        return treeComputerIcon;
    }

    public static Icon getTreeFloppyDriveIcon() {
        if (treeFloppyDriveIcon == null) {
            treeFloppyDriveIcon = new TreeFloppyDriveIcon();
        }
        return treeFloppyDriveIcon;
    }

    public static Icon getTreeFolderIcon() {
        return new TreeFolderIcon();
    }

    public static Icon getTreeHardDriveIcon() {
        if (treeHardDriveIcon == null) {
            treeHardDriveIcon = new TreeHardDriveIcon();
        }
        return treeHardDriveIcon;
    }

    public static Icon getTreeLeafIcon() {
        return new TreeLeafIcon();
    }

    public static Icon getTreeControlIcon(boolean bl) {
        return new TreeControlIcon(bl);
    }

    public static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon();
        }
        return menuArrowIcon;
    }

    public static Icon getMenuItemCheckIcon() {
        return null;
    }

    public static Icon getMenuItemArrowIcon() {
        if (menuItemArrowIcon == null) {
            menuItemArrowIcon = new MenuItemArrowIcon();
        }
        return menuItemArrowIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    public static Icon getHorizontalSliderThumbIcon() {
        if (MetalLookAndFeel.usingOcean()) {
            if (oceanHorizontalSliderThumb == null) {
                oceanHorizontalSliderThumb = new OceanHorizontalSliderThumbIcon();
            }
            return oceanHorizontalSliderThumb;
        }
        return new HorizontalSliderThumbIcon();
    }

    public static Icon getVerticalSliderThumbIcon() {
        if (MetalLookAndFeel.usingOcean()) {
            if (oceanVerticalSliderThumb == null) {
                oceanVerticalSliderThumb = new OceanVerticalSliderThumbIcon();
            }
            return oceanVerticalSliderThumb;
        }
        return new VerticalSliderThumbIcon();
    }

    static {
        folderIcon16Size = new Dimension(16, 16);
        fileIcon16Size = new Dimension(16, 16);
        treeControlSize = new Dimension(18, 18);
        menuArrowIconSize = new Dimension(4, 8);
        menuCheckIconSize = new Dimension(10, 10);
    }

    private static class OceanHorizontalSliderThumbIcon
    extends CachedPainter
    implements Icon,
    Serializable,
    UIResource {
        private static Polygon THUMB_SHAPE = new Polygon(new int[]{0, 14, 14, 7, 0}, new int[]{0, 0, 8, 15, 8}, 5);

        OceanHorizontalSliderThumbIcon() {
            super(3);
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!(graphics instanceof Graphics2D)) {
                return;
            }
            this.paint(component, graphics, n, n2, this.getIconWidth(), this.getIconHeight(), component.hasFocus(), component.isEnabled(), MetalLookAndFeel.getCurrentTheme());
        }

        protected Image createImage(Component component, int n, int n2, GraphicsConfiguration graphicsConfiguration) {
            return graphicsConfiguration.createCompatibleImage(n, n2, 2);
        }

        protected void paintToImage(Component component, Graphics graphics, int n, int n2, Object[] objectArray) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            boolean bl = (Boolean)objectArray[0];
            boolean bl2 = (Boolean)objectArray[1];
            Rectangle rectangle = graphics2D.getClipBounds();
            graphics2D.clip(THUMB_SHAPE);
            if (!bl2) {
                graphics2D.setColor(MetalLookAndFeel.getControl());
                graphics2D.fillRect(1, 1, 13, 14);
            } else if (bl) {
                MetalUtils.drawGradient(component, graphics2D, "Slider.focusGradient", 1, 1, 13, 14, true);
            } else {
                MetalUtils.drawGradient(component, graphics2D, "Slider.gradient", 1, 1, 13, 14, true);
            }
            graphics2D.setClip(rectangle);
            if (bl) {
                graphics2D.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            } else {
                graphics2D.setColor(bl2 ? MetalLookAndFeel.getPrimaryControlInfo() : MetalLookAndFeel.getControlDarkShadow());
            }
            graphics2D.drawLine(1, 0, 13, 0);
            graphics2D.drawLine(0, 1, 0, 8);
            graphics2D.drawLine(14, 1, 14, 8);
            graphics2D.drawLine(1, 9, 7, 15);
            graphics2D.drawLine(7, 15, 14, 8);
            if (bl && bl2) {
                graphics2D.setColor(MetalLookAndFeel.getPrimaryControl());
                graphics2D.fillRect(1, 1, 13, 1);
                graphics2D.fillRect(1, 2, 1, 7);
                graphics2D.fillRect(13, 2, 1, 7);
                graphics2D.drawLine(2, 9, 7, 14);
                graphics2D.drawLine(8, 13, 12, 9);
            }
        }

        public int getIconWidth() {
            return 15;
        }

        public int getIconHeight() {
            return 16;
        }
    }

    private static class OceanVerticalSliderThumbIcon
    extends CachedPainter
    implements Icon,
    Serializable,
    UIResource {
        private static Polygon LTR_THUMB_SHAPE = new Polygon(new int[]{0, 8, 15, 8, 0}, new int[]{0, 0, 7, 14, 14}, 5);
        private static Polygon RTL_THUMB_SHAPE = new Polygon(new int[]{15, 15, 7, 0, 7}, new int[]{0, 14, 14, 7, 0}, 5);

        OceanVerticalSliderThumbIcon() {
            super(3);
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!(graphics instanceof Graphics2D)) {
                return;
            }
            this.paint(component, graphics, n, n2, this.getIconWidth(), this.getIconHeight(), MetalUtils.isLeftToRight(component), component.hasFocus(), component.isEnabled(), MetalLookAndFeel.getCurrentTheme());
        }

        protected void paintToImage(Component component, Graphics graphics, int n, int n2, Object[] objectArray) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            boolean bl = (Boolean)objectArray[0];
            boolean bl2 = (Boolean)objectArray[1];
            boolean bl3 = (Boolean)objectArray[2];
            Rectangle rectangle = graphics2D.getClipBounds();
            if (bl) {
                graphics2D.clip(LTR_THUMB_SHAPE);
            } else {
                graphics2D.clip(RTL_THUMB_SHAPE);
            }
            if (!bl3) {
                graphics2D.setColor(MetalLookAndFeel.getControl());
                graphics2D.fillRect(1, 1, 14, 14);
            } else if (bl2) {
                MetalUtils.drawGradient(component, graphics2D, "Slider.focusGradient", 1, 1, 14, 14, false);
            } else {
                MetalUtils.drawGradient(component, graphics2D, "Slider.gradient", 1, 1, 14, 14, false);
            }
            graphics2D.setClip(rectangle);
            if (bl2) {
                graphics2D.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            } else {
                graphics2D.setColor(bl3 ? MetalLookAndFeel.getPrimaryControlInfo() : MetalLookAndFeel.getControlDarkShadow());
            }
            if (bl) {
                graphics2D.drawLine(1, 0, 8, 0);
                graphics2D.drawLine(0, 1, 0, 13);
                graphics2D.drawLine(1, 14, 8, 14);
                graphics2D.drawLine(9, 1, 15, 7);
                graphics2D.drawLine(9, 13, 15, 7);
            } else {
                graphics2D.drawLine(7, 0, 14, 0);
                graphics2D.drawLine(15, 1, 15, 13);
                graphics2D.drawLine(7, 14, 14, 14);
                graphics2D.drawLine(0, 7, 6, 1);
                graphics2D.drawLine(0, 7, 6, 13);
            }
            if (bl2 && bl3) {
                graphics2D.setColor(MetalLookAndFeel.getPrimaryControl());
                if (bl) {
                    graphics2D.drawLine(1, 1, 8, 1);
                    graphics2D.drawLine(1, 1, 1, 13);
                    graphics2D.drawLine(1, 13, 8, 13);
                    graphics2D.drawLine(9, 2, 14, 7);
                    graphics2D.drawLine(9, 12, 14, 7);
                } else {
                    graphics2D.drawLine(7, 1, 14, 1);
                    graphics2D.drawLine(14, 1, 14, 13);
                    graphics2D.drawLine(7, 13, 14, 13);
                    graphics2D.drawLine(1, 7, 7, 1);
                    graphics2D.drawLine(1, 7, 7, 13);
                }
            }
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 15;
        }

        protected Image createImage(Component component, int n, int n2, GraphicsConfiguration graphicsConfiguration) {
            return graphicsConfiguration.createCompatibleImage(n, n2, 2);
        }
    }

    private static class HorizontalSliderThumbIcon
    implements Icon,
    Serializable,
    UIResource {
        protected static MetalBumps controlBumps;
        protected static MetalBumps primaryBumps;

        public HorizontalSliderThumbIcon() {
            controlBumps = new MetalBumps(10, 6, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlInfo(), MetalLookAndFeel.getControl());
            primaryBumps = new MetalBumps(10, 6, MetalLookAndFeel.getPrimaryControl(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControlShadow());
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JSlider jSlider = (JSlider)component;
            graphics.translate(n, n2);
            if (jSlider.hasFocus()) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            } else {
                graphics.setColor(jSlider.isEnabled() ? MetalLookAndFeel.getPrimaryControlInfo() : MetalLookAndFeel.getControlDarkShadow());
            }
            graphics.drawLine(1, 0, 13, 0);
            graphics.drawLine(0, 1, 0, 8);
            graphics.drawLine(14, 1, 14, 8);
            graphics.drawLine(1, 9, 7, 15);
            graphics.drawLine(7, 15, 14, 8);
            if (jSlider.hasFocus()) {
                graphics.setColor(component.getForeground());
            } else {
                graphics.setColor(MetalLookAndFeel.getControl());
            }
            graphics.fillRect(1, 1, 13, 8);
            graphics.drawLine(2, 9, 12, 9);
            graphics.drawLine(3, 10, 11, 10);
            graphics.drawLine(4, 11, 10, 11);
            graphics.drawLine(5, 12, 9, 12);
            graphics.drawLine(6, 13, 8, 13);
            graphics.drawLine(7, 14, 7, 14);
            if (jSlider.isEnabled()) {
                if (jSlider.hasFocus()) {
                    primaryBumps.paintIcon(component, graphics, 2, 2);
                } else {
                    controlBumps.paintIcon(component, graphics, 2, 2);
                }
            }
            if (jSlider.isEnabled()) {
                graphics.setColor(jSlider.hasFocus() ? MetalLookAndFeel.getPrimaryControl() : MetalLookAndFeel.getControlHighlight());
                graphics.drawLine(1, 1, 13, 1);
                graphics.drawLine(1, 1, 1, 8);
            }
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 15;
        }

        public int getIconHeight() {
            return 16;
        }
    }

    private static class VerticalSliderThumbIcon
    implements Icon,
    Serializable,
    UIResource {
        protected static MetalBumps controlBumps;
        protected static MetalBumps primaryBumps;

        public VerticalSliderThumbIcon() {
            controlBumps = new MetalBumps(6, 10, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlInfo(), MetalLookAndFeel.getControl());
            primaryBumps = new MetalBumps(6, 10, MetalLookAndFeel.getPrimaryControl(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControlShadow());
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3;
            JSlider jSlider = (JSlider)component;
            boolean bl = MetalUtils.isLeftToRight(jSlider);
            graphics.translate(n, n2);
            if (jSlider.hasFocus()) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            } else {
                graphics.setColor(jSlider.isEnabled() ? MetalLookAndFeel.getPrimaryControlInfo() : MetalLookAndFeel.getControlDarkShadow());
            }
            if (bl) {
                graphics.drawLine(1, 0, 8, 0);
                graphics.drawLine(0, 1, 0, 13);
                graphics.drawLine(1, 14, 8, 14);
                graphics.drawLine(9, 1, 15, 7);
                graphics.drawLine(9, 13, 15, 7);
            } else {
                graphics.drawLine(7, 0, 14, 0);
                graphics.drawLine(15, 1, 15, 13);
                graphics.drawLine(7, 14, 14, 14);
                graphics.drawLine(0, 7, 6, 1);
                graphics.drawLine(0, 7, 6, 13);
            }
            if (jSlider.hasFocus()) {
                graphics.setColor(component.getForeground());
            } else {
                graphics.setColor(MetalLookAndFeel.getControl());
            }
            if (bl) {
                graphics.fillRect(1, 1, 8, 13);
                graphics.drawLine(9, 2, 9, 12);
                graphics.drawLine(10, 3, 10, 11);
                graphics.drawLine(11, 4, 11, 10);
                graphics.drawLine(12, 5, 12, 9);
                graphics.drawLine(13, 6, 13, 8);
                graphics.drawLine(14, 7, 14, 7);
            } else {
                graphics.fillRect(7, 1, 8, 13);
                graphics.drawLine(6, 3, 6, 12);
                graphics.drawLine(5, 4, 5, 11);
                graphics.drawLine(4, 5, 4, 10);
                graphics.drawLine(3, 6, 3, 9);
                graphics.drawLine(2, 7, 2, 8);
            }
            int n4 = n3 = bl ? 2 : 8;
            if (jSlider.isEnabled()) {
                if (jSlider.hasFocus()) {
                    primaryBumps.paintIcon(component, graphics, n3, 2);
                } else {
                    controlBumps.paintIcon(component, graphics, n3, 2);
                }
            }
            if (jSlider.isEnabled()) {
                graphics.setColor(jSlider.hasFocus() ? MetalLookAndFeel.getPrimaryControl() : MetalLookAndFeel.getControlHighlight());
                if (bl) {
                    graphics.drawLine(1, 1, 8, 1);
                    graphics.drawLine(1, 1, 1, 13);
                } else {
                    graphics.drawLine(8, 1, 14, 1);
                    graphics.drawLine(1, 7, 7, 1);
                }
            }
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 15;
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonMenuItemIcon() {
        }

        public void paintOceanIcon(Component component, Graphics graphics, int n, int n2) {
            ButtonModel buttonModel = ((JMenuItem)component).getModel();
            boolean bl = buttonModel.isSelected();
            boolean bl2 = buttonModel.isEnabled();
            boolean bl3 = buttonModel.isPressed();
            boolean bl4 = buttonModel.isArmed();
            graphics.translate(n, n2);
            if (bl2) {
                MetalUtils.drawGradient(component, graphics, "RadioButtonMenuItem.gradient", 1, 1, 7, 7, true);
                if (bl3 || bl4) {
                    graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                } else {
                    graphics.setColor(MetalLookAndFeel.getControlHighlight());
                }
                graphics.drawLine(2, 9, 7, 9);
                graphics.drawLine(9, 2, 9, 7);
                graphics.drawLine(8, 8, 8, 8);
                if (bl3 || bl4) {
                    graphics.setColor(MetalLookAndFeel.getControlInfo());
                } else {
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                }
            } else {
                graphics.setColor(MetalLookAndFeel.getMenuDisabledForeground());
            }
            graphics.drawLine(2, 0, 6, 0);
            graphics.drawLine(2, 8, 6, 8);
            graphics.drawLine(0, 2, 0, 6);
            graphics.drawLine(8, 2, 8, 6);
            graphics.drawLine(1, 1, 1, 1);
            graphics.drawLine(7, 1, 7, 1);
            graphics.drawLine(1, 7, 1, 7);
            graphics.drawLine(7, 7, 7, 7);
            if (bl) {
                if (bl2) {
                    if (bl4 || component instanceof JMenu && buttonModel.isSelected()) {
                        graphics.setColor(MetalLookAndFeel.getMenuSelectedForeground());
                    } else {
                        graphics.setColor(component.getForeground());
                    }
                } else {
                    graphics.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                }
                graphics.drawLine(3, 2, 5, 2);
                graphics.drawLine(2, 3, 6, 3);
                graphics.drawLine(2, 4, 6, 4);
                graphics.drawLine(2, 5, 6, 5);
                graphics.drawLine(3, 6, 5, 6);
            }
            graphics.translate(-n, -n2);
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (MetalLookAndFeel.usingOcean()) {
                this.paintOceanIcon(component, graphics, n, n2);
                return;
            }
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            boolean bl = buttonModel.isSelected();
            boolean bl2 = buttonModel.isEnabled();
            boolean bl3 = buttonModel.isPressed();
            boolean bl4 = buttonModel.isArmed();
            graphics.translate(n, n2);
            if (bl2) {
                if (bl3 || bl4) {
                    graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                    graphics.drawLine(3, 1, 8, 1);
                    graphics.drawLine(2, 9, 7, 9);
                    graphics.drawLine(1, 3, 1, 8);
                    graphics.drawLine(9, 2, 9, 7);
                    graphics.drawLine(2, 2, 2, 2);
                    graphics.drawLine(8, 8, 8, 8);
                    graphics.setColor(MetalLookAndFeel.getControlInfo());
                    graphics.drawLine(2, 0, 6, 0);
                    graphics.drawLine(2, 8, 6, 8);
                    graphics.drawLine(0, 2, 0, 6);
                    graphics.drawLine(8, 2, 8, 6);
                    graphics.drawLine(1, 1, 1, 1);
                    graphics.drawLine(7, 1, 7, 1);
                    graphics.drawLine(1, 7, 1, 7);
                    graphics.drawLine(7, 7, 7, 7);
                } else {
                    graphics.setColor(MetalLookAndFeel.getControlHighlight());
                    graphics.drawLine(3, 1, 8, 1);
                    graphics.drawLine(2, 9, 7, 9);
                    graphics.drawLine(1, 3, 1, 8);
                    graphics.drawLine(9, 2, 9, 7);
                    graphics.drawLine(2, 2, 2, 2);
                    graphics.drawLine(8, 8, 8, 8);
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawLine(2, 0, 6, 0);
                    graphics.drawLine(2, 8, 6, 8);
                    graphics.drawLine(0, 2, 0, 6);
                    graphics.drawLine(8, 2, 8, 6);
                    graphics.drawLine(1, 1, 1, 1);
                    graphics.drawLine(7, 1, 7, 1);
                    graphics.drawLine(1, 7, 1, 7);
                    graphics.drawLine(7, 7, 7, 7);
                }
            } else {
                graphics.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                graphics.drawLine(2, 0, 6, 0);
                graphics.drawLine(2, 8, 6, 8);
                graphics.drawLine(0, 2, 0, 6);
                graphics.drawLine(8, 2, 8, 6);
                graphics.drawLine(1, 1, 1, 1);
                graphics.drawLine(7, 1, 7, 1);
                graphics.drawLine(1, 7, 1, 7);
                graphics.drawLine(7, 7, 7, 7);
            }
            if (bl) {
                if (bl2) {
                    if (buttonModel.isArmed() || component instanceof JMenu && buttonModel.isSelected()) {
                        graphics.setColor(MetalLookAndFeel.getMenuSelectedForeground());
                    } else {
                        graphics.setColor(jMenuItem.getForeground());
                    }
                } else {
                    graphics.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                }
                graphics.drawLine(3, 2, 5, 2);
                graphics.drawLine(2, 3, 6, 3);
                graphics.drawLine(2, 4, 6, 4);
                graphics.drawLine(2, 5, 6, 5);
                graphics.drawLine(3, 6, 5, 6);
            }
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return menuCheckIconSize.width;
        }

        public int getIconHeight() {
            return menuCheckIconSize.height;
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxMenuItemIcon() {
        }

        public void paintOceanIcon(Component component, Graphics graphics, int n, int n2) {
            ButtonModel buttonModel = ((JMenuItem)component).getModel();
            boolean bl = buttonModel.isSelected();
            boolean bl2 = buttonModel.isEnabled();
            boolean bl3 = buttonModel.isPressed();
            boolean bl4 = buttonModel.isArmed();
            graphics.translate(n, n2);
            if (bl2) {
                MetalUtils.drawGradient(component, graphics, "CheckBoxMenuItem.gradient", 1, 1, 7, 7, true);
                if (bl3 || bl4) {
                    graphics.setColor(MetalLookAndFeel.getControlInfo());
                    graphics.drawLine(0, 0, 8, 0);
                    graphics.drawLine(0, 0, 0, 8);
                    graphics.drawLine(8, 2, 8, 8);
                    graphics.drawLine(2, 8, 8, 8);
                    graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                    graphics.drawLine(9, 1, 9, 9);
                    graphics.drawLine(1, 9, 9, 9);
                } else {
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawLine(0, 0, 8, 0);
                    graphics.drawLine(0, 0, 0, 8);
                    graphics.drawLine(8, 2, 8, 8);
                    graphics.drawLine(2, 8, 8, 8);
                    graphics.setColor(MetalLookAndFeel.getControlHighlight());
                    graphics.drawLine(9, 1, 9, 9);
                    graphics.drawLine(1, 9, 9, 9);
                }
            } else {
                graphics.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                graphics.drawRect(0, 0, 8, 8);
            }
            if (bl) {
                if (bl2) {
                    if (bl4 || component instanceof JMenu && bl) {
                        graphics.setColor(MetalLookAndFeel.getMenuSelectedForeground());
                    } else {
                        graphics.setColor(component.getForeground());
                    }
                } else {
                    graphics.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                }
                graphics.drawLine(2, 2, 2, 6);
                graphics.drawLine(3, 2, 3, 6);
                graphics.drawLine(4, 4, 8, 0);
                graphics.drawLine(4, 5, 9, 0);
            }
            graphics.translate(-n, -n2);
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (MetalLookAndFeel.usingOcean()) {
                this.paintOceanIcon(component, graphics, n, n2);
                return;
            }
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            boolean bl = buttonModel.isSelected();
            boolean bl2 = buttonModel.isEnabled();
            boolean bl3 = buttonModel.isPressed();
            boolean bl4 = buttonModel.isArmed();
            graphics.translate(n, n2);
            if (bl2) {
                if (bl3 || bl4) {
                    graphics.setColor(MetalLookAndFeel.getControlInfo());
                    graphics.drawLine(0, 0, 8, 0);
                    graphics.drawLine(0, 0, 0, 8);
                    graphics.drawLine(8, 2, 8, 8);
                    graphics.drawLine(2, 8, 8, 8);
                    graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                    graphics.drawLine(1, 1, 7, 1);
                    graphics.drawLine(1, 1, 1, 7);
                    graphics.drawLine(9, 1, 9, 9);
                    graphics.drawLine(1, 9, 9, 9);
                } else {
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawLine(0, 0, 8, 0);
                    graphics.drawLine(0, 0, 0, 8);
                    graphics.drawLine(8, 2, 8, 8);
                    graphics.drawLine(2, 8, 8, 8);
                    graphics.setColor(MetalLookAndFeel.getControlHighlight());
                    graphics.drawLine(1, 1, 7, 1);
                    graphics.drawLine(1, 1, 1, 7);
                    graphics.drawLine(9, 1, 9, 9);
                    graphics.drawLine(1, 9, 9, 9);
                }
            } else {
                graphics.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                graphics.drawRect(0, 0, 8, 8);
            }
            if (bl) {
                if (bl2) {
                    if (buttonModel.isArmed() || component instanceof JMenu && buttonModel.isSelected()) {
                        graphics.setColor(MetalLookAndFeel.getMenuSelectedForeground());
                    } else {
                        graphics.setColor(jMenuItem.getForeground());
                    }
                } else {
                    graphics.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                }
                graphics.drawLine(2, 2, 2, 6);
                graphics.drawLine(3, 2, 3, 6);
                graphics.drawLine(4, 4, 8, 0);
                graphics.drawLine(4, 5, 9, 0);
            }
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return menuCheckIconSize.width;
        }

        public int getIconHeight() {
            return menuCheckIconSize.height;
        }
    }

    private static class MenuItemArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuItemArrowIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return menuArrowIconSize.width;
        }

        public int getIconHeight() {
            return menuArrowIconSize.height;
        }
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuArrowIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            graphics.translate(n, n2);
            if (!buttonModel.isEnabled()) {
                graphics.setColor(MetalLookAndFeel.getMenuDisabledForeground());
            } else if (buttonModel.isArmed() || component instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(MetalLookAndFeel.getMenuSelectedForeground());
            } else {
                graphics.setColor(jMenuItem.getForeground());
            }
            if (MetalUtils.isLeftToRight(jMenuItem)) {
                graphics.drawLine(0, 0, 0, 7);
                graphics.drawLine(1, 1, 1, 6);
                graphics.drawLine(2, 2, 2, 5);
                graphics.drawLine(3, 3, 3, 4);
            } else {
                graphics.drawLine(4, 0, 4, 7);
                graphics.drawLine(3, 1, 3, 6);
                graphics.drawLine(2, 2, 2, 5);
                graphics.drawLine(1, 3, 1, 4);
            }
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return menuArrowIconSize.width;
        }

        public int getIconHeight() {
            return menuArrowIconSize.height;
        }
    }

    public static class TreeControlIcon
    implements Icon,
    Serializable {
        protected boolean isLight;
        ImageCacher imageCacher;
        transient boolean cachedOrientation = true;

        public TreeControlIcon(boolean bl) {
            this.isLight = bl;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Image image;
            GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
            if (this.imageCacher == null) {
                this.imageCacher = new ImageCacher();
            }
            if ((image = this.imageCacher.getImage(graphicsConfiguration)) == null || this.cachedOrientation != MetalUtils.isLeftToRight(component)) {
                this.cachedOrientation = MetalUtils.isLeftToRight(component);
                image = graphicsConfiguration != null ? graphicsConfiguration.createCompatibleImage(this.getIconWidth(), this.getIconHeight(), 2) : new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics graphics2 = image.getGraphics();
                this.paintMe(component, graphics2, n, n2);
                graphics2.dispose();
                this.imageCacher.cacheImage(image, graphicsConfiguration);
            }
            if (MetalUtils.isLeftToRight(component)) {
                if (this.isLight) {
                    graphics.drawImage(image, n + 5, n2 + 3, n + 18, n2 + 13, 4, 3, 17, 13, null);
                } else {
                    graphics.drawImage(image, n + 5, n2 + 3, n + 18, n2 + 17, 4, 3, 17, 17, null);
                }
            } else if (this.isLight) {
                graphics.drawImage(image, n + 3, n2 + 3, n + 16, n2 + 13, 4, 3, 17, 13, null);
            } else {
                graphics.drawImage(image, n + 3, n2 + 3, n + 16, n2 + 17, 4, 3, 17, 17, null);
            }
        }

        public void paintMe(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            int n3 = MetalUtils.isLeftToRight(component) ? 0 : 4;
            graphics.drawLine(n3 + 4, 6, n3 + 4, 9);
            graphics.drawLine(n3 + 5, 5, n3 + 5, 5);
            graphics.drawLine(n3 + 6, 4, n3 + 9, 4);
            graphics.drawLine(n3 + 10, 5, n3 + 10, 5);
            graphics.drawLine(n3 + 11, 6, n3 + 11, 9);
            graphics.drawLine(n3 + 10, 10, n3 + 10, 10);
            graphics.drawLine(n3 + 6, 11, n3 + 9, 11);
            graphics.drawLine(n3 + 5, 10, n3 + 5, 10);
            graphics.drawLine(n3 + 7, 7, n3 + 8, 7);
            graphics.drawLine(n3 + 7, 8, n3 + 8, 8);
            if (this.isLight) {
                if (MetalUtils.isLeftToRight(component)) {
                    graphics.drawLine(12, 7, 15, 7);
                    graphics.drawLine(12, 8, 15, 8);
                } else {
                    graphics.drawLine(4, 7, 7, 7);
                    graphics.drawLine(4, 8, 7, 8);
                }
            } else {
                graphics.drawLine(n3 + 7, 12, n3 + 7, 15);
                graphics.drawLine(n3 + 8, 12, n3 + 8, 15);
            }
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawLine(n3 + 5, 6, n3 + 5, 9);
            graphics.drawLine(n3 + 6, 5, n3 + 9, 5);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            graphics.drawLine(n3 + 6, 6, n3 + 6, 6);
            graphics.drawLine(n3 + 9, 6, n3 + 9, 6);
            graphics.drawLine(n3 + 6, 9, n3 + 6, 9);
            graphics.drawLine(n3 + 10, 6, n3 + 10, 9);
            graphics.drawLine(n3 + 6, 10, n3 + 9, 10);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.drawLine(n3 + 6, 7, n3 + 6, 8);
            graphics.drawLine(n3 + 7, 6, n3 + 8, 6);
            graphics.drawLine(n3 + 9, 7, n3 + 9, 7);
            graphics.drawLine(n3 + 7, 9, n3 + 7, 9);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(n3 + 8, 9, n3 + 9, 9);
            graphics.drawLine(n3 + 9, 8, n3 + 9, 8);
        }

        public int getIconWidth() {
            return treeControlSize.width;
        }

        public int getIconHeight() {
            return treeControlSize.height;
        }
    }

    public static class TreeLeafIcon
    extends FileIcon16 {
        public int getShift() {
            return 2;
        }

        public int getAdditionalHeight() {
            return 4;
        }
    }

    public static class FileIcon16
    implements Icon,
    Serializable {
        ImageCacher imageCacher;

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Image image;
            GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
            if (this.imageCacher == null) {
                this.imageCacher = new ImageCacher();
            }
            if ((image = this.imageCacher.getImage(graphicsConfiguration)) == null) {
                image = graphicsConfiguration != null ? graphicsConfiguration.createCompatibleImage(this.getIconWidth(), this.getIconHeight(), 2) : new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics graphics2 = image.getGraphics();
                this.paintMe(component, graphics2);
                graphics2.dispose();
                this.imageCacher.cacheImage(image, graphicsConfiguration);
            }
            graphics.drawImage(image, n, n2 + this.getShift(), null);
        }

        private void paintMe(Component component, Graphics graphics) {
            int n = fileIcon16Size.width - 1;
            int n2 = fileIcon16Size.height - 1;
            graphics.setColor(MetalLookAndFeel.getWindowBackground());
            graphics.fillRect(4, 2, 9, 12);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(2, 0, 2, n2);
            graphics.drawLine(2, 0, n - 4, 0);
            graphics.drawLine(2, n2, n - 1, n2);
            graphics.drawLine(n - 1, 6, n - 1, n2);
            graphics.drawLine(n - 6, 2, n - 2, 6);
            graphics.drawLine(n - 5, 1, n - 4, 1);
            graphics.drawLine(n - 3, 2, n - 3, 3);
            graphics.drawLine(n - 2, 4, n - 2, 5);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.drawLine(3, 1, 3, n2 - 1);
            graphics.drawLine(3, 1, n - 6, 1);
            graphics.drawLine(n - 2, 7, n - 2, n2 - 1);
            graphics.drawLine(n - 5, 2, n - 3, 4);
            graphics.drawLine(3, n2 - 1, n - 2, n2 - 1);
        }

        public int getShift() {
            return 0;
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getIconWidth() {
            return fileIcon16Size.width;
        }

        public int getIconHeight() {
            return fileIcon16Size.height + this.getAdditionalHeight();
        }
    }

    public static class TreeFolderIcon
    extends FolderIcon16 {
        public int getShift() {
            return -1;
        }

        public int getAdditionalHeight() {
            return 2;
        }
    }

    public static class FolderIcon16
    implements Icon,
    Serializable {
        ImageCacher imageCacher;

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Image image;
            GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
            if (this.imageCacher == null) {
                this.imageCacher = new ImageCacher();
            }
            if ((image = this.imageCacher.getImage(graphicsConfiguration)) == null) {
                image = graphicsConfiguration != null ? graphicsConfiguration.createCompatibleImage(this.getIconWidth(), this.getIconHeight(), 2) : new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics graphics2 = image.getGraphics();
                this.paintMe(component, graphics2);
                graphics2.dispose();
                this.imageCacher.cacheImage(image, graphicsConfiguration);
            }
            graphics.drawImage(image, n, n2 + this.getShift(), null);
        }

        private void paintMe(Component component, Graphics graphics) {
            int n = folderIcon16Size.width - 1;
            int n2 = folderIcon16Size.height - 1;
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawLine(n - 5, 3, n, 3);
            graphics.drawLine(n - 6, 4, n, 4);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(2, 7, 13, 8);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            graphics.drawLine(n - 6, 5, n - 1, 5);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(0, 6, 0, n2);
            graphics.drawLine(1, 5, n - 7, 5);
            graphics.drawLine(n - 6, 6, n - 1, 6);
            graphics.drawLine(n, 5, n, n2);
            graphics.drawLine(0, n2, n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(1, 6, 1, n2 - 1);
            graphics.drawLine(1, 6, n - 7, 6);
            graphics.drawLine(n - 6, 7, n - 1, 7);
        }

        public int getShift() {
            return 0;
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getIconWidth() {
            return folderIcon16Size.width;
        }

        public int getIconHeight() {
            return folderIcon16Size.height + this.getAdditionalHeight();
        }
    }

    static class ImageCacher {
        Vector images = new Vector(1, 1);
        ImageGcPair currentImageGcPair;

        ImageCacher() {
        }

        Image getImage(GraphicsConfiguration graphicsConfiguration) {
            if (this.currentImageGcPair == null || !this.currentImageGcPair.hasSameConfiguration(graphicsConfiguration)) {
                Enumeration enumeration = this.images.elements();
                while (enumeration.hasMoreElements()) {
                    ImageGcPair imageGcPair = (ImageGcPair)enumeration.nextElement();
                    if (!imageGcPair.hasSameConfiguration(graphicsConfiguration)) continue;
                    this.currentImageGcPair = imageGcPair;
                    return imageGcPair.image;
                }
                return null;
            }
            return this.currentImageGcPair.image;
        }

        void cacheImage(Image image, GraphicsConfiguration graphicsConfiguration) {
            ImageGcPair imageGcPair = new ImageGcPair(image, graphicsConfiguration);
            this.images.addElement(imageGcPair);
            this.currentImageGcPair = imageGcPair;
        }

        class ImageGcPair {
            Image image;
            GraphicsConfiguration gc;

            ImageGcPair(Image image, GraphicsConfiguration graphicsConfiguration) {
                this.image = image;
                this.gc = graphicsConfiguration;
            }

            boolean hasSameConfiguration(GraphicsConfiguration graphicsConfiguration) {
                return graphicsConfiguration != null && graphicsConfiguration.equals(this.gc) || graphicsConfiguration == null && this.gc == null;
            }
        }
    }

    private static class TreeFloppyDriveIcon
    implements Icon,
    UIResource,
    Serializable {
        private TreeFloppyDriveIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(2, 2, 12, 12);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(1, 1, 13, 1);
            graphics.drawLine(14, 2, 14, 14);
            graphics.drawLine(1, 14, 14, 14);
            graphics.drawLine(1, 1, 1, 14);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.fillRect(5, 2, 6, 5);
            graphics.drawLine(4, 8, 11, 8);
            graphics.drawLine(3, 9, 3, 13);
            graphics.drawLine(12, 9, 12, 13);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.fillRect(8, 3, 2, 3);
            graphics.fillRect(4, 9, 8, 5);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            graphics.drawLine(5, 10, 9, 10);
            graphics.drawLine(5, 12, 8, 12);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }
    }

    private static class TreeHardDriveIcon
    implements Icon,
    UIResource,
    Serializable {
        private TreeHardDriveIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(1, 4, 1, 5);
            graphics.drawLine(2, 3, 3, 3);
            graphics.drawLine(4, 2, 11, 2);
            graphics.drawLine(12, 3, 13, 3);
            graphics.drawLine(14, 4, 14, 5);
            graphics.drawLine(12, 6, 13, 6);
            graphics.drawLine(4, 7, 11, 7);
            graphics.drawLine(2, 6, 3, 6);
            graphics.drawLine(1, 7, 1, 8);
            graphics.drawLine(2, 9, 3, 9);
            graphics.drawLine(4, 10, 11, 10);
            graphics.drawLine(12, 9, 13, 9);
            graphics.drawLine(14, 7, 14, 8);
            graphics.drawLine(1, 10, 1, 11);
            graphics.drawLine(2, 12, 3, 12);
            graphics.drawLine(4, 13, 11, 13);
            graphics.drawLine(12, 12, 13, 12);
            graphics.drawLine(14, 10, 14, 11);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawLine(7, 6, 7, 6);
            graphics.drawLine(9, 6, 9, 6);
            graphics.drawLine(10, 5, 10, 5);
            graphics.drawLine(11, 6, 11, 6);
            graphics.drawLine(12, 5, 13, 5);
            graphics.drawLine(13, 4, 13, 4);
            graphics.drawLine(7, 9, 7, 9);
            graphics.drawLine(9, 9, 9, 9);
            graphics.drawLine(10, 8, 10, 8);
            graphics.drawLine(11, 9, 11, 9);
            graphics.drawLine(12, 8, 13, 8);
            graphics.drawLine(13, 7, 13, 7);
            graphics.drawLine(7, 12, 7, 12);
            graphics.drawLine(9, 12, 9, 12);
            graphics.drawLine(10, 11, 10, 11);
            graphics.drawLine(11, 12, 11, 12);
            graphics.drawLine(12, 11, 13, 11);
            graphics.drawLine(13, 10, 13, 10);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(4, 3, 5, 3);
            graphics.drawLine(7, 3, 9, 3);
            graphics.drawLine(11, 3, 11, 3);
            graphics.drawLine(2, 4, 6, 4);
            graphics.drawLine(8, 4, 8, 4);
            graphics.drawLine(2, 5, 3, 5);
            graphics.drawLine(4, 6, 4, 6);
            graphics.drawLine(2, 7, 3, 7);
            graphics.drawLine(2, 8, 3, 8);
            graphics.drawLine(4, 9, 4, 9);
            graphics.drawLine(2, 10, 3, 10);
            graphics.drawLine(2, 11, 3, 11);
            graphics.drawLine(4, 12, 4, 12);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }
    }

    private static class TreeComputerIcon
    implements Icon,
    UIResource,
    Serializable {
        private TreeComputerIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(5, 4, 6, 4);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(2, 2, 2, 8);
            graphics.drawLine(13, 2, 13, 8);
            graphics.drawLine(3, 1, 12, 1);
            graphics.drawLine(12, 9, 12, 9);
            graphics.drawLine(3, 9, 3, 9);
            graphics.drawLine(4, 4, 4, 7);
            graphics.drawLine(5, 3, 10, 3);
            graphics.drawLine(11, 4, 11, 7);
            graphics.drawLine(5, 8, 10, 8);
            graphics.drawLine(1, 10, 14, 10);
            graphics.drawLine(14, 10, 14, 14);
            graphics.drawLine(1, 14, 14, 14);
            graphics.drawLine(1, 10, 1, 14);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawLine(6, 12, 8, 12);
            graphics.drawLine(10, 12, 12, 12);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonIcon() {
        }

        public void paintOceanIcon(Component component, Graphics graphics, int n, int n2) {
            ButtonModel buttonModel = ((JRadioButton)component).getModel();
            boolean bl = buttonModel.isEnabled();
            boolean bl2 = bl && buttonModel.isPressed() && buttonModel.isArmed();
            boolean bl3 = bl && buttonModel.isRollover();
            graphics.translate(n, n2);
            if (bl && !bl2) {
                MetalUtils.drawGradient(component, graphics, "RadioButton.gradient", 1, 1, 10, 10, true);
                graphics.setColor(component.getBackground());
                graphics.fillRect(1, 1, 1, 1);
                graphics.fillRect(10, 1, 1, 1);
                graphics.fillRect(1, 10, 1, 1);
                graphics.fillRect(10, 10, 1, 1);
            } else if (bl2 || !bl) {
                if (bl2) {
                    graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                } else {
                    graphics.setColor(MetalLookAndFeel.getControl());
                }
                graphics.fillRect(2, 2, 8, 8);
                graphics.fillRect(4, 1, 4, 1);
                graphics.fillRect(4, 10, 4, 1);
                graphics.fillRect(1, 4, 1, 4);
                graphics.fillRect(10, 4, 1, 4);
            }
            if (!bl) {
                graphics.setColor(MetalLookAndFeel.getInactiveControlTextColor());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            graphics.drawLine(4, 0, 7, 0);
            graphics.drawLine(8, 1, 9, 1);
            graphics.drawLine(10, 2, 10, 3);
            graphics.drawLine(11, 4, 11, 7);
            graphics.drawLine(10, 8, 10, 9);
            graphics.drawLine(9, 10, 8, 10);
            graphics.drawLine(7, 11, 4, 11);
            graphics.drawLine(3, 10, 2, 10);
            graphics.drawLine(1, 9, 1, 8);
            graphics.drawLine(0, 7, 0, 4);
            graphics.drawLine(1, 3, 1, 2);
            graphics.drawLine(2, 1, 3, 1);
            if (bl2) {
                graphics.fillRect(1, 4, 1, 4);
                graphics.fillRect(2, 2, 1, 2);
                graphics.fillRect(3, 2, 1, 1);
                graphics.fillRect(4, 1, 4, 1);
            } else if (bl3) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                graphics.fillRect(4, 1, 4, 2);
                graphics.fillRect(8, 2, 2, 2);
                graphics.fillRect(9, 4, 2, 4);
                graphics.fillRect(8, 8, 2, 2);
                graphics.fillRect(4, 9, 4, 2);
                graphics.fillRect(2, 8, 2, 2);
                graphics.fillRect(1, 4, 2, 4);
                graphics.fillRect(2, 2, 2, 2);
            }
            if (buttonModel.isSelected()) {
                if (bl) {
                    graphics.setColor(component.getForeground());
                } else {
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                }
                graphics.fillRect(4, 4, 4, 4);
                graphics.drawLine(4, 3, 7, 3);
                graphics.drawLine(8, 4, 8, 7);
                graphics.drawLine(7, 8, 4, 8);
                graphics.drawLine(3, 7, 3, 4);
            }
            graphics.translate(-n, -n2);
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (MetalLookAndFeel.usingOcean()) {
                this.paintOceanIcon(component, graphics, n, n2);
                return;
            }
            JRadioButton jRadioButton = (JRadioButton)component;
            ButtonModel buttonModel = jRadioButton.getModel();
            boolean bl = buttonModel.isSelected();
            Color color = component.getBackground();
            Color color2 = component.getForeground();
            ColorUIResource colorUIResource = MetalLookAndFeel.getControlShadow();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getControlDarkShadow();
            Color color3 = MetalLookAndFeel.getControlHighlight();
            Color color4 = MetalLookAndFeel.getControlHighlight();
            Color color5 = color;
            if (!buttonModel.isEnabled()) {
                color3 = color4 = color;
                color2 = colorUIResource;
                colorUIResource2 = color2;
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                color5 = colorUIResource;
                color3 = color5;
            }
            graphics.translate(n, n2);
            graphics.setColor(color5);
            graphics.fillRect(2, 2, 9, 9);
            graphics.setColor(colorUIResource2);
            graphics.drawLine(4, 0, 7, 0);
            graphics.drawLine(8, 1, 9, 1);
            graphics.drawLine(10, 2, 10, 3);
            graphics.drawLine(11, 4, 11, 7);
            graphics.drawLine(10, 8, 10, 9);
            graphics.drawLine(9, 10, 8, 10);
            graphics.drawLine(7, 11, 4, 11);
            graphics.drawLine(3, 10, 2, 10);
            graphics.drawLine(1, 9, 1, 8);
            graphics.drawLine(0, 7, 0, 4);
            graphics.drawLine(1, 3, 1, 2);
            graphics.drawLine(2, 1, 3, 1);
            graphics.setColor(color3);
            graphics.drawLine(2, 9, 2, 8);
            graphics.drawLine(1, 7, 1, 4);
            graphics.drawLine(2, 2, 2, 3);
            graphics.drawLine(2, 2, 3, 2);
            graphics.drawLine(4, 1, 7, 1);
            graphics.drawLine(8, 2, 9, 2);
            graphics.setColor(color4);
            graphics.drawLine(10, 1, 10, 1);
            graphics.drawLine(11, 2, 11, 3);
            graphics.drawLine(12, 4, 12, 7);
            graphics.drawLine(11, 8, 11, 9);
            graphics.drawLine(10, 10, 10, 10);
            graphics.drawLine(9, 11, 8, 11);
            graphics.drawLine(7, 12, 4, 12);
            graphics.drawLine(3, 11, 2, 11);
            if (bl) {
                graphics.setColor(color2);
                graphics.fillRect(4, 4, 4, 4);
                graphics.drawLine(4, 3, 7, 3);
                graphics.drawLine(8, 4, 8, 7);
                graphics.drawLine(7, 8, 4, 8);
                graphics.drawLine(3, 7, 3, 4);
            }
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        private void paintOceanIcon(Component component, Graphics graphics, int n, int n2) {
            ButtonModel buttonModel = ((JCheckBox)component).getModel();
            graphics.translate(n, n2);
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    graphics.setColor(MetalLookAndFeel.getControlShadow());
                    graphics.fillRect(0, 0, n3, n4);
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.fillRect(0, 0, n3, 2);
                    graphics.fillRect(0, 2, 2, n4 - 2);
                    graphics.fillRect(n3 - 1, 1, 1, n4 - 1);
                    graphics.fillRect(1, n4 - 1, n3 - 2, 1);
                } else if (buttonModel.isRollover()) {
                    MetalUtils.drawGradient(component, graphics, "CheckBox.gradient", 0, 0, n3, n4, true);
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                    graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                    graphics.drawRect(1, 1, n3 - 3, n4 - 3);
                    graphics.drawRect(2, 2, n3 - 5, n4 - 5);
                } else {
                    MetalUtils.drawGradient(component, graphics, "CheckBox.gradient", 0, 0, n3, n4, true);
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                }
                graphics.setColor(MetalLookAndFeel.getControlInfo());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            }
            graphics.translate(-n, -n2);
            if (buttonModel.isSelected()) {
                this.drawCheck(component, graphics, n, n2);
            }
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (MetalLookAndFeel.usingOcean()) {
                this.paintOceanIcon(component, graphics, n, n2);
                return;
            }
            ButtonModel buttonModel = ((JCheckBox)component).getModel();
            int n3 = this.getControlSize();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    graphics.setColor(MetalLookAndFeel.getControlShadow());
                    graphics.fillRect(n, n2, n3 - 1, n3 - 1);
                    MetalUtils.drawPressed3DBorder(graphics, n, n2, n3, n3);
                } else {
                    MetalUtils.drawFlush3DBorder(graphics, n, n2, n3, n3);
                }
                graphics.setColor(MetalLookAndFeel.getControlInfo());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.drawRect(n, n2, n3 - 2, n3 - 2);
            }
            if (buttonModel.isSelected()) {
                this.drawCheck(component, graphics, n, n2);
            }
        }

        protected void drawCheck(Component component, Graphics graphics, int n, int n2) {
            int n3 = this.getControlSize();
            graphics.fillRect(n + 3, n2 + 5, 2, n3 - 8);
            graphics.drawLine(n + (n3 - 4), n2 + 3, n + 5, n2 + (n3 - 6));
            graphics.drawLine(n + (n3 - 4), n2 + 4, n + 5, n2 + (n3 - 5));
        }

        public int getIconWidth() {
            return this.getControlSize();
        }

        public int getIconHeight() {
            return this.getControlSize();
        }
    }

    private static class InternalFrameMinimizeIcon
    implements Icon,
    UIResource,
    Serializable {
        int iconSize = 16;

        public InternalFrameMinimizeIcon(int n) {
            this.iconSize = n;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            ColorUIResource colorUIResource = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource colorUIResource3 = MetalLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource colorUIResource4 = MetalLookAndFeel.getBlack();
            ColorUIResource colorUIResource5 = MetalLookAndFeel.getWhite();
            ColorUIResource colorUIResource6 = MetalLookAndFeel.getWhite();
            if (jButton.getClientProperty("paintActive") != Boolean.TRUE) {
                colorUIResource2 = colorUIResource = MetalLookAndFeel.getControl();
                colorUIResource3 = MetalLookAndFeel.getControlDarkShadow();
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    colorUIResource5 = colorUIResource2 = MetalLookAndFeel.getControlShadow();
                    colorUIResource3 = colorUIResource4;
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                colorUIResource5 = colorUIResource2 = MetalLookAndFeel.getPrimaryControlShadow();
                colorUIResource3 = colorUIResource4;
            }
            graphics.translate(n, n2);
            graphics.setColor(colorUIResource);
            graphics.fillRect(0, 0, this.iconSize, this.iconSize);
            graphics.setColor(colorUIResource2);
            graphics.fillRect(4, 11, this.iconSize - 13, this.iconSize - 13);
            graphics.setColor(colorUIResource6);
            graphics.drawRect(2, 10, this.iconSize - 10, this.iconSize - 11);
            graphics.setColor(colorUIResource5);
            graphics.drawRect(3, 10, this.iconSize - 12, this.iconSize - 12);
            graphics.setColor(colorUIResource4);
            graphics.drawRect(1, 8, this.iconSize - 10, this.iconSize - 10);
            graphics.drawRect(2, 9, this.iconSize - 12, this.iconSize - 12);
            graphics.setColor(colorUIResource3);
            graphics.drawRect(2, 9, this.iconSize - 11, this.iconSize - 11);
            graphics.drawLine(this.iconSize - 10, 10, this.iconSize - 10, 10);
            graphics.drawLine(3, this.iconSize - 3, 3, this.iconSize - 3);
            graphics.setColor(colorUIResource3);
            graphics.fillRect(this.iconSize - 7, 3, 3, 5);
            graphics.drawLine(this.iconSize - 6, 5, this.iconSize - 3, 2);
            graphics.drawLine(this.iconSize - 6, 6, this.iconSize - 2, 2);
            graphics.drawLine(this.iconSize - 6, 7, this.iconSize - 3, 7);
            graphics.setColor(colorUIResource4);
            graphics.drawLine(this.iconSize - 8, 2, this.iconSize - 7, 2);
            graphics.drawLine(this.iconSize - 8, 3, this.iconSize - 8, 7);
            graphics.drawLine(this.iconSize - 6, 4, this.iconSize - 3, 1);
            graphics.drawLine(this.iconSize - 4, 6, this.iconSize - 3, 6);
            graphics.setColor(colorUIResource6);
            graphics.drawLine(this.iconSize - 6, 3, this.iconSize - 6, 3);
            graphics.drawLine(this.iconSize - 4, 5, this.iconSize - 2, 3);
            graphics.drawLine(this.iconSize - 7, 8, this.iconSize - 3, 8);
            graphics.drawLine(this.iconSize - 2, 8, this.iconSize - 2, 7);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return this.iconSize;
        }

        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class InternalFrameMaximizeIcon
    implements Icon,
    UIResource,
    Serializable {
        protected int iconSize = 16;

        public InternalFrameMaximizeIcon(int n) {
            this.iconSize = n;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            ColorUIResource colorUIResource = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource colorUIResource3 = MetalLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource colorUIResource4 = MetalLookAndFeel.getBlack();
            ColorUIResource colorUIResource5 = MetalLookAndFeel.getWhite();
            ColorUIResource colorUIResource6 = MetalLookAndFeel.getWhite();
            if (jButton.getClientProperty("paintActive") != Boolean.TRUE) {
                colorUIResource2 = colorUIResource = MetalLookAndFeel.getControl();
                colorUIResource3 = MetalLookAndFeel.getControlDarkShadow();
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    colorUIResource5 = colorUIResource2 = MetalLookAndFeel.getControlShadow();
                    colorUIResource3 = colorUIResource4;
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                colorUIResource5 = colorUIResource2 = MetalLookAndFeel.getPrimaryControlShadow();
                colorUIResource3 = colorUIResource4;
            }
            graphics.translate(n, n2);
            graphics.setColor(colorUIResource);
            graphics.fillRect(0, 0, this.iconSize, this.iconSize);
            graphics.setColor(colorUIResource2);
            graphics.fillRect(3, 7, this.iconSize - 10, this.iconSize - 10);
            graphics.setColor(colorUIResource5);
            graphics.drawRect(3, 7, this.iconSize - 10, this.iconSize - 10);
            graphics.setColor(colorUIResource6);
            graphics.drawRect(2, 6, this.iconSize - 7, this.iconSize - 7);
            graphics.setColor(colorUIResource4);
            graphics.drawRect(1, 5, this.iconSize - 7, this.iconSize - 7);
            graphics.drawRect(2, 6, this.iconSize - 9, this.iconSize - 9);
            graphics.setColor(colorUIResource3);
            graphics.drawRect(2, 6, this.iconSize - 8, this.iconSize - 8);
            graphics.setColor(colorUIResource4);
            graphics.drawLine(3, this.iconSize - 5, this.iconSize - 9, 7);
            graphics.drawLine(this.iconSize - 6, 4, this.iconSize - 5, 3);
            graphics.drawLine(this.iconSize - 7, 1, this.iconSize - 7, 2);
            graphics.drawLine(this.iconSize - 6, 1, this.iconSize - 2, 1);
            graphics.setColor(colorUIResource5);
            graphics.drawLine(5, this.iconSize - 4, this.iconSize - 8, 9);
            graphics.setColor(colorUIResource6);
            graphics.drawLine(this.iconSize - 6, 3, this.iconSize - 4, 5);
            graphics.drawLine(this.iconSize - 4, 5, this.iconSize - 4, 6);
            graphics.drawLine(this.iconSize - 2, 7, this.iconSize - 1, 7);
            graphics.drawLine(this.iconSize - 1, 2, this.iconSize - 1, 6);
            graphics.setColor(colorUIResource3);
            graphics.drawLine(3, this.iconSize - 4, this.iconSize - 3, 2);
            graphics.drawLine(3, this.iconSize - 3, this.iconSize - 2, 2);
            graphics.drawLine(4, this.iconSize - 3, 5, this.iconSize - 3);
            graphics.drawLine(this.iconSize - 7, 8, this.iconSize - 7, 9);
            graphics.drawLine(this.iconSize - 6, 2, this.iconSize - 4, 2);
            graphics.drawRect(this.iconSize - 3, 3, 1, 3);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return this.iconSize;
        }

        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class InternalFrameDefaultMenuIcon
    implements Icon,
    UIResource,
    Serializable {
        private InternalFrameDefaultMenuIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            ColorUIResource colorUIResource = MetalLookAndFeel.getWindowBackground();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource colorUIResource3 = MetalLookAndFeel.getPrimaryControlDarkShadow();
            graphics.translate(n, n2);
            graphics.setColor(colorUIResource2);
            graphics.fillRect(0, 0, 16, 16);
            graphics.setColor(colorUIResource);
            graphics.fillRect(2, 6, 13, 9);
            graphics.drawLine(2, 2, 2, 2);
            graphics.drawLine(5, 2, 5, 2);
            graphics.drawLine(8, 2, 8, 2);
            graphics.drawLine(11, 2, 11, 2);
            graphics.setColor(colorUIResource3);
            graphics.drawRect(1, 1, 13, 13);
            graphics.drawLine(1, 0, 14, 0);
            graphics.drawLine(15, 1, 15, 14);
            graphics.drawLine(1, 15, 14, 15);
            graphics.drawLine(0, 1, 0, 14);
            graphics.drawLine(2, 5, 13, 5);
            graphics.drawLine(3, 3, 3, 3);
            graphics.drawLine(6, 3, 6, 3);
            graphics.drawLine(9, 3, 9, 3);
            graphics.drawLine(12, 3, 12, 3);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }
    }

    private static class InternalFrameAltMaximizeIcon
    implements Icon,
    UIResource,
    Serializable {
        int iconSize = 16;

        public InternalFrameAltMaximizeIcon(int n) {
            this.iconSize = n;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            ColorUIResource colorUIResource = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource colorUIResource3 = MetalLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource colorUIResource4 = MetalLookAndFeel.getBlack();
            ColorUIResource colorUIResource5 = MetalLookAndFeel.getWhite();
            ColorUIResource colorUIResource6 = MetalLookAndFeel.getWhite();
            if (jButton.getClientProperty("paintActive") != Boolean.TRUE) {
                colorUIResource2 = colorUIResource = MetalLookAndFeel.getControl();
                colorUIResource3 = MetalLookAndFeel.getControlDarkShadow();
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    colorUIResource5 = colorUIResource2 = MetalLookAndFeel.getControlShadow();
                    colorUIResource3 = colorUIResource4;
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                colorUIResource5 = colorUIResource2 = MetalLookAndFeel.getPrimaryControlShadow();
                colorUIResource3 = colorUIResource4;
            }
            graphics.translate(n, n2);
            graphics.setColor(colorUIResource);
            graphics.fillRect(0, 0, this.iconSize, this.iconSize);
            graphics.setColor(colorUIResource2);
            graphics.fillRect(3, 6, this.iconSize - 9, this.iconSize - 9);
            graphics.setColor(colorUIResource4);
            graphics.drawRect(1, 5, this.iconSize - 8, this.iconSize - 8);
            graphics.drawLine(1, this.iconSize - 2, 1, this.iconSize - 2);
            graphics.setColor(colorUIResource6);
            graphics.drawRect(2, 6, this.iconSize - 7, this.iconSize - 7);
            graphics.setColor(colorUIResource5);
            graphics.drawRect(3, 7, this.iconSize - 9, this.iconSize - 9);
            graphics.setColor(colorUIResource3);
            graphics.drawRect(2, 6, this.iconSize - 8, this.iconSize - 8);
            graphics.setColor(colorUIResource5);
            graphics.drawLine(this.iconSize - 6, 8, this.iconSize - 6, 8);
            graphics.drawLine(this.iconSize - 9, 6, this.iconSize - 7, 8);
            graphics.setColor(colorUIResource3);
            graphics.drawLine(3, this.iconSize - 3, 3, this.iconSize - 3);
            graphics.setColor(colorUIResource4);
            graphics.drawLine(this.iconSize - 6, 9, this.iconSize - 6, 9);
            graphics.setColor(colorUIResource);
            graphics.drawLine(this.iconSize - 9, 5, this.iconSize - 9, 5);
            graphics.setColor(colorUIResource3);
            graphics.fillRect(this.iconSize - 7, 3, 3, 5);
            graphics.drawLine(this.iconSize - 6, 5, this.iconSize - 3, 2);
            graphics.drawLine(this.iconSize - 6, 6, this.iconSize - 2, 2);
            graphics.drawLine(this.iconSize - 6, 7, this.iconSize - 3, 7);
            graphics.setColor(colorUIResource4);
            graphics.drawLine(this.iconSize - 8, 2, this.iconSize - 7, 2);
            graphics.drawLine(this.iconSize - 8, 3, this.iconSize - 8, 7);
            graphics.drawLine(this.iconSize - 6, 4, this.iconSize - 3, 1);
            graphics.drawLine(this.iconSize - 4, 6, this.iconSize - 3, 6);
            graphics.setColor(colorUIResource6);
            graphics.drawLine(this.iconSize - 6, 3, this.iconSize - 6, 3);
            graphics.drawLine(this.iconSize - 4, 5, this.iconSize - 2, 3);
            graphics.drawLine(this.iconSize - 4, 8, this.iconSize - 3, 8);
            graphics.drawLine(this.iconSize - 2, 8, this.iconSize - 2, 7);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return this.iconSize;
        }

        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class InternalFrameCloseIcon
    implements Icon,
    UIResource,
    Serializable {
        int iconSize = 16;

        public InternalFrameCloseIcon(int n) {
            this.iconSize = n;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            ColorUIResource colorUIResource = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource colorUIResource3 = MetalLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource colorUIResource4 = MetalLookAndFeel.getBlack();
            ColorUIResource colorUIResource5 = MetalLookAndFeel.getWhite();
            ColorUIResource colorUIResource6 = MetalLookAndFeel.getWhite();
            if (jButton.getClientProperty("paintActive") != Boolean.TRUE) {
                colorUIResource2 = colorUIResource = MetalLookAndFeel.getControl();
                colorUIResource3 = MetalLookAndFeel.getControlDarkShadow();
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    colorUIResource5 = colorUIResource2 = MetalLookAndFeel.getControlShadow();
                    colorUIResource3 = colorUIResource4;
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                colorUIResource5 = colorUIResource2 = MetalLookAndFeel.getPrimaryControlShadow();
                colorUIResource3 = colorUIResource4;
            }
            int n3 = this.iconSize / 2;
            graphics.translate(n, n2);
            graphics.setColor(colorUIResource);
            graphics.fillRect(0, 0, this.iconSize, this.iconSize);
            graphics.setColor(colorUIResource2);
            graphics.fillRect(3, 3, this.iconSize - 6, this.iconSize - 6);
            graphics.setColor(colorUIResource4);
            graphics.drawRect(1, 1, this.iconSize - 3, this.iconSize - 3);
            graphics.drawRect(2, 2, this.iconSize - 5, this.iconSize - 5);
            graphics.setColor(colorUIResource6);
            graphics.drawRect(2, 2, this.iconSize - 3, this.iconSize - 3);
            graphics.setColor(colorUIResource3);
            graphics.drawRect(2, 2, this.iconSize - 4, this.iconSize - 4);
            graphics.drawLine(3, this.iconSize - 3, 3, this.iconSize - 3);
            graphics.drawLine(this.iconSize - 3, 3, this.iconSize - 3, 3);
            graphics.setColor(colorUIResource4);
            graphics.drawLine(4, 5, 5, 4);
            graphics.drawLine(4, this.iconSize - 6, this.iconSize - 6, 4);
            graphics.setColor(colorUIResource5);
            graphics.drawLine(6, this.iconSize - 5, this.iconSize - 5, 6);
            graphics.drawLine(n3, n3 + 2, n3 + 2, n3);
            graphics.drawLine(this.iconSize - 5, this.iconSize - 5, this.iconSize - 4, this.iconSize - 5);
            graphics.drawLine(this.iconSize - 5, this.iconSize - 4, this.iconSize - 5, this.iconSize - 4);
            graphics.setColor(colorUIResource3);
            graphics.drawLine(5, 5, this.iconSize - 6, this.iconSize - 6);
            graphics.drawLine(6, 5, this.iconSize - 5, this.iconSize - 6);
            graphics.drawLine(5, 6, this.iconSize - 6, this.iconSize - 5);
            graphics.drawLine(5, this.iconSize - 5, this.iconSize - 5, 5);
            graphics.drawLine(5, this.iconSize - 6, this.iconSize - 6, 5);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return this.iconSize;
        }

        public int getIconHeight() {
            return this.iconSize;
        }
    }

    public static class PaletteCloseIcon
    implements Icon,
    UIResource,
    Serializable {
        int iconSize = 7;

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            ColorUIResource colorUIResource = MetalLookAndFeel.getPrimaryControlHighlight();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControlInfo();
            ColorUIResource colorUIResource3 = buttonModel.isPressed() && buttonModel.isArmed() ? colorUIResource2 : MetalLookAndFeel.getPrimaryControlDarkShadow();
            graphics.translate(n, n2);
            graphics.setColor(colorUIResource3);
            graphics.drawLine(0, 1, 5, 6);
            graphics.drawLine(1, 0, 6, 5);
            graphics.drawLine(1, 1, 6, 6);
            graphics.drawLine(6, 1, 1, 6);
            graphics.drawLine(5, 0, 0, 5);
            graphics.drawLine(5, 1, 1, 5);
            graphics.setColor(colorUIResource);
            graphics.drawLine(6, 2, 5, 3);
            graphics.drawLine(2, 6, 3, 5);
            graphics.drawLine(6, 6, 6, 6);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return this.iconSize;
        }

        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class FileChooserUpFolderIcon
    implements Icon,
    UIResource,
    Serializable {
        private FileChooserUpFolderIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(3, 5, 12, 9);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(1, 6, 1, 14);
            graphics.drawLine(2, 14, 15, 14);
            graphics.drawLine(15, 13, 15, 5);
            graphics.drawLine(2, 5, 9, 5);
            graphics.drawLine(10, 6, 14, 6);
            graphics.drawLine(8, 13, 8, 16);
            graphics.drawLine(8, 9, 8, 9);
            graphics.drawLine(7, 10, 9, 10);
            graphics.drawLine(6, 11, 10, 11);
            graphics.drawLine(5, 12, 11, 12);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(2, 6, 2, 13);
            graphics.drawLine(3, 6, 9, 6);
            graphics.drawLine(10, 7, 14, 7);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawLine(11, 3, 15, 3);
            graphics.drawLine(10, 4, 15, 4);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }
    }

    private static class FileChooserNewFolderIcon
    implements Icon,
    UIResource,
    Serializable {
        private FileChooserNewFolderIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(3, 5, 12, 9);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(1, 6, 1, 14);
            graphics.drawLine(2, 14, 15, 14);
            graphics.drawLine(15, 13, 15, 5);
            graphics.drawLine(2, 5, 9, 5);
            graphics.drawLine(10, 6, 14, 6);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(2, 6, 2, 13);
            graphics.drawLine(3, 6, 9, 6);
            graphics.drawLine(10, 7, 14, 7);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawLine(11, 3, 15, 3);
            graphics.drawLine(10, 4, 15, 4);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }
    }

    private static class FileChooserListViewIcon
    implements Icon,
    UIResource,
    Serializable {
        private FileChooserListViewIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(2, 2, 5, 2);
            graphics.drawLine(2, 3, 2, 7);
            graphics.drawLine(3, 7, 6, 7);
            graphics.drawLine(6, 6, 6, 3);
            graphics.drawLine(10, 2, 13, 2);
            graphics.drawLine(10, 3, 10, 7);
            graphics.drawLine(11, 7, 14, 7);
            graphics.drawLine(14, 6, 14, 3);
            graphics.drawLine(2, 10, 5, 10);
            graphics.drawLine(2, 11, 2, 15);
            graphics.drawLine(3, 15, 6, 15);
            graphics.drawLine(6, 14, 6, 11);
            graphics.drawLine(10, 10, 13, 10);
            graphics.drawLine(10, 11, 10, 15);
            graphics.drawLine(11, 15, 14, 15);
            graphics.drawLine(14, 14, 14, 11);
            graphics.drawLine(8, 5, 8, 5);
            graphics.drawLine(16, 5, 16, 5);
            graphics.drawLine(8, 13, 8, 13);
            graphics.drawLine(16, 13, 16, 13);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.drawRect(3, 3, 2, 3);
            graphics.drawRect(11, 3, 2, 3);
            graphics.drawRect(3, 11, 2, 3);
            graphics.drawRect(11, 11, 2, 3);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(4, 4, 4, 5);
            graphics.drawLine(12, 4, 12, 5);
            graphics.drawLine(4, 12, 4, 13);
            graphics.drawLine(12, 12, 12, 13);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }
    }

    private static class FileChooserHomeFolderIcon
    implements Icon,
    UIResource,
    Serializable {
        private FileChooserHomeFolderIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(8, 1, 1, 8);
            graphics.drawLine(8, 1, 15, 8);
            graphics.drawLine(11, 2, 11, 3);
            graphics.drawLine(12, 2, 12, 4);
            graphics.drawLine(3, 7, 3, 15);
            graphics.drawLine(13, 7, 13, 15);
            graphics.drawLine(4, 15, 12, 15);
            graphics.drawLine(6, 9, 6, 14);
            graphics.drawLine(10, 9, 10, 14);
            graphics.drawLine(7, 9, 9, 9);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.fillRect(8, 2, 1, 1);
            graphics.fillRect(7, 3, 3, 1);
            graphics.fillRect(6, 4, 5, 1);
            graphics.fillRect(5, 5, 7, 1);
            graphics.fillRect(4, 6, 9, 2);
            graphics.drawLine(9, 12, 9, 12);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.drawLine(4, 8, 12, 8);
            graphics.fillRect(4, 9, 2, 6);
            graphics.fillRect(11, 9, 2, 6);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }
    }

    private static class FileChooserDetailViewIcon
    implements Icon,
    UIResource,
    Serializable {
        private FileChooserDetailViewIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(2, 2, 5, 2);
            graphics.drawLine(2, 3, 2, 7);
            graphics.drawLine(3, 7, 6, 7);
            graphics.drawLine(6, 6, 6, 3);
            graphics.drawLine(2, 10, 5, 10);
            graphics.drawLine(2, 11, 2, 15);
            graphics.drawLine(3, 15, 6, 15);
            graphics.drawLine(6, 14, 6, 11);
            graphics.drawLine(8, 5, 15, 5);
            graphics.drawLine(8, 13, 15, 13);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.drawRect(3, 3, 2, 3);
            graphics.drawRect(3, 11, 2, 3);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(4, 4, 4, 5);
            graphics.drawLine(4, 12, 4, 13);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }
    }
}

