/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import javax.swing.text.BadLocationException;
import javax.swing.text.GlyphView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SegmentCache;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

class GlyphPainter1
extends GlyphView.GlyphPainter {
    FontMetrics metrics;

    GlyphPainter1() {
    }

    public float getSpan(GlyphView glyphView, int n, int n2, TabExpander tabExpander, float f) {
        this.sync(glyphView);
        Segment segment = glyphView.getText(n, n2);
        int n3 = Utilities.getTabbedTextWidth(segment, this.metrics, (int)f, tabExpander, n);
        SegmentCache.releaseSharedSegment(segment);
        return n3;
    }

    public float getHeight(GlyphView glyphView) {
        this.sync(glyphView);
        return this.metrics.getHeight();
    }

    public float getAscent(GlyphView glyphView) {
        this.sync(glyphView);
        return this.metrics.getAscent();
    }

    public float getDescent(GlyphView glyphView) {
        this.sync(glyphView);
        return this.metrics.getDescent();
    }

    public void paint(GlyphView glyphView, Graphics graphics, Shape shape, int n, int n2) {
        int n3;
        Segment segment;
        this.sync(glyphView);
        TabExpander tabExpander = glyphView.getTabExpander();
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        int n4 = rectangle.x;
        int n5 = glyphView.getStartOffset();
        if (n5 != n) {
            segment = glyphView.getText(n5, n);
            n3 = Utilities.getTabbedTextWidth(segment, this.metrics, n4, tabExpander, n5);
            n4 += n3;
            SegmentCache.releaseSharedSegment(segment);
        }
        n3 = rectangle.y + this.metrics.getHeight() - this.metrics.getDescent();
        segment = glyphView.getText(n, n2);
        graphics.setFont(this.metrics.getFont());
        Utilities.drawTabbedText(glyphView, segment, n4, n3, graphics, tabExpander, n);
        SegmentCache.releaseSharedSegment(segment);
    }

    public Shape modelToView(GlyphView glyphView, int n, Position.Bias bias, Shape shape) throws BadLocationException {
        this.sync(glyphView);
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        int n2 = glyphView.getStartOffset();
        int n3 = glyphView.getEndOffset();
        TabExpander tabExpander = glyphView.getTabExpander();
        if (n == n3) {
            return new Rectangle(rectangle.x + rectangle.width, rectangle.y, 0, this.metrics.getHeight());
        }
        if (n >= n2 && n <= n3) {
            Segment segment = glyphView.getText(n2, n);
            int n4 = Utilities.getTabbedTextWidth(segment, this.metrics, rectangle.x, tabExpander, n2);
            SegmentCache.releaseSharedSegment(segment);
            return new Rectangle(rectangle.x + n4, rectangle.y, 0, this.metrics.getHeight());
        }
        throw new BadLocationException("modelToView - can't convert", n3);
    }

    public int viewToModel(GlyphView glyphView, float f, float f2, Shape shape, Position.Bias[] biasArray) {
        this.sync(glyphView);
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        int n = glyphView.getStartOffset();
        int n2 = glyphView.getEndOffset();
        TabExpander tabExpander = glyphView.getTabExpander();
        Segment segment = glyphView.getText(n, n2);
        int n3 = Utilities.getTabbedTextOffset(segment, this.metrics, rectangle.x, (int)f, tabExpander, n);
        SegmentCache.releaseSharedSegment(segment);
        int n4 = n + n3;
        if (n4 == n2) {
            --n4;
        }
        biasArray[0] = Position.Bias.Forward;
        return n4;
    }

    public int getBoundedPosition(GlyphView glyphView, int n, float f, float f2) {
        this.sync(glyphView);
        TabExpander tabExpander = glyphView.getTabExpander();
        Segment segment = glyphView.getText(n, glyphView.getEndOffset());
        int n2 = Utilities.getTabbedTextOffset(segment, this.metrics, (int)f, (int)(f + f2), tabExpander, n, false);
        SegmentCache.releaseSharedSegment(segment);
        int n3 = n + n2;
        return n3;
    }

    void sync(GlyphView glyphView) {
        Font font = glyphView.getFont();
        if (this.metrics == null || !font.equals(this.metrics.getFont())) {
            Container container = glyphView.getContainer();
            this.metrics = container != null ? container.getFontMetrics(font) : Toolkit.getDefaultToolkit().getFontMetrics(font);
        }
    }
}

