/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.Segment;
import javax.swing.text.Utilities;

public class PlainDocument
extends AbstractDocument {
    public static final String tabSizeAttribute = "tabSize";
    public static final String lineLimitAttribute = "lineLimit";
    private AbstractDocument.AbstractElement defaultRoot;
    private Vector added = new Vector();
    private Vector removed = new Vector();
    private transient Segment s;

    public PlainDocument() {
        this(new GapContent());
    }

    public PlainDocument(AbstractDocument.Content content) {
        super(content);
        this.putProperty(tabSizeAttribute, new Integer(8));
        this.defaultRoot = this.createDefaultRoot();
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        Object object = this.getProperty("filterNewlines");
        if (object instanceof Boolean && object.equals(Boolean.TRUE) && string != null && string.indexOf(10) >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n2 = stringBuffer.length();
            for (int i = 0; i < n2; ++i) {
                if (stringBuffer.charAt(i) != '\n') continue;
                stringBuffer.setCharAt(i, ' ');
            }
            string = stringBuffer.toString();
        }
        super.insertString(n, string, attributeSet);
    }

    public Element getDefaultRootElement() {
        return this.defaultRoot;
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.createBranchElement(null, null);
        Element element = this.createLeafElement(branchElement, null, 0, 1);
        Element[] elementArray = new Element[]{element};
        branchElement.replace(0, 0, elementArray);
        return branchElement;
    }

    public Element getParagraphElement(int n) {
        Element element = this.getDefaultRootElement();
        return element.getElement(element.getElementIndex(n));
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        AbstractDocument.ElementEdit elementEdit = null;
        this.removed.removeAllElements();
        this.added.removeAllElements();
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.getDefaultRootElement();
        int n = defaultDocumentEvent.getOffset();
        int n2 = defaultDocumentEvent.getLength();
        if (n > 0) {
            --n;
            ++n2;
        }
        int n3 = branchElement.getElementIndex(n);
        Element element = branchElement.getElement(n3);
        int n4 = element.getStartOffset();
        int n5 = element.getEndOffset();
        int n6 = n4;
        try {
            int n7;
            if (this.s == null) {
                this.s = new Segment();
            }
            this.getContent().getChars(n, n2, this.s);
            boolean bl = false;
            for (n7 = 0; n7 < n2; ++n7) {
                char c = this.s.array[this.s.offset + n7];
                if (c != '\n') continue;
                int n8 = n + n7 + 1;
                this.added.addElement(this.createLeafElement(branchElement, null, n6, n8));
                n6 = n8;
                bl = true;
            }
            if (bl) {
                n7 = 1;
                this.removed.addElement(element);
                if (n + n2 == n5 && n6 != n5 && n3 + 1 < branchElement.getElementCount()) {
                    ++n7;
                    Element element2 = branchElement.getElement(n3 + 1);
                    this.removed.addElement(element2);
                    n5 = element2.getEndOffset();
                }
                if (n6 < n5) {
                    this.added.addElement(this.createLeafElement(branchElement, null, n6, n5));
                }
                Object[] objectArray = new Element[this.added.size()];
                this.added.copyInto(objectArray);
                Object[] objectArray2 = new Element[this.removed.size()];
                this.removed.copyInto(objectArray2);
                if (this.getProperty("i18n").equals(Boolean.TRUE) && Utilities.isComposedTextAttributeDefined(attributeSet)) {
                    elementEdit = new AbstractDocument.ElementEdit(branchElement, n3, (Element[])objectArray2, (Element[])objectArray);
                } else {
                    AbstractDocument.ElementEdit elementEdit2 = new AbstractDocument.ElementEdit(branchElement, n3, (Element[])objectArray2, (Element[])objectArray);
                    defaultDocumentEvent.addEdit(elementEdit2);
                    branchElement.replace(n3, objectArray2.length, (Element[])objectArray);
                }
            }
            if (Utilities.isComposedTextAttributeDefined(attributeSet)) {
                this.insertComposedTextUpdate(defaultDocumentEvent, attributeSet, elementEdit);
            }
        }
        catch (BadLocationException badLocationException) {
            throw new Error("Internal error: " + badLocationException.toString());
        }
        super.insertUpdate(defaultDocumentEvent, attributeSet);
    }

    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        this.removed.removeAllElements();
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.getDefaultRootElement();
        int n = defaultDocumentEvent.getOffset();
        int n2 = defaultDocumentEvent.getLength();
        int n3 = branchElement.getElementIndex(n);
        int n4 = branchElement.getElementIndex(n + n2);
        if (n3 != n4) {
            int n5;
            for (n5 = n3; n5 <= n4; ++n5) {
                this.removed.addElement(branchElement.getElement(n5));
            }
            n5 = branchElement.getElement(n3).getStartOffset();
            int n6 = branchElement.getElement(n4).getEndOffset();
            Element[] elementArray = new Element[]{this.createLeafElement(branchElement, null, n5, n6)};
            Object[] objectArray = new Element[this.removed.size()];
            this.removed.copyInto(objectArray);
            AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(branchElement, n3, (Element[])objectArray, elementArray);
            defaultDocumentEvent.addEdit(elementEdit);
            branchElement.replace(n3, objectArray.length, elementArray);
        } else {
            Element element;
            Element element2 = branchElement.getElement(n3);
            if (!element2.isLeaf() && Utilities.isComposedTextElement(element = element2.getElement(element2.getElementIndex(n)))) {
                Element[] elementArray = new Element[]{this.createLeafElement(branchElement, null, element2.getStartOffset(), element2.getEndOffset())};
                Element[] elementArray2 = new Element[]{element2};
                AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(branchElement, n3, elementArray2, elementArray);
                defaultDocumentEvent.addEdit(elementEdit);
                branchElement.replace(n3, 1, elementArray);
            }
        }
        super.removeUpdate(defaultDocumentEvent);
    }

    private void insertComposedTextUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet, AbstractDocument.ElementEdit elementEdit) {
        this.added.removeAllElements();
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.getDefaultRootElement();
        int n = defaultDocumentEvent.getOffset();
        int n2 = defaultDocumentEvent.getLength();
        int n3 = branchElement.getElementIndex(n);
        Element element = null;
        if (elementEdit == null) {
            element = branchElement.getElement(n3);
        } else {
            Element[] elementArray = elementEdit.getChildrenAdded();
            this.added.addElement(elementArray[0]);
            element = elementArray[1];
        }
        int n4 = element.getStartOffset();
        int n5 = element.getEndOffset();
        Element[] elementArray = new AbstractDocument.BranchElement[]{(AbstractDocument.BranchElement)this.createBranchElement(branchElement, null)};
        Element[] elementArray2 = elementEdit == null ? new Element[]{element} : elementEdit.getChildrenRemoved();
        int n6 = elementArray2.length;
        if (n4 != n) {
            this.added.addElement(this.createLeafElement(elementArray[0], null, n4, n));
        }
        this.added.addElement(this.createLeafElement(elementArray[0], attributeSet, n, n + n2));
        if (n5 != n + n2) {
            this.added.addElement(this.createLeafElement(elementArray[0], null, n + n2, n5));
        }
        Object[] objectArray = new Element[this.added.size()];
        this.added.copyInto(objectArray);
        AbstractDocument.ElementEdit elementEdit2 = new AbstractDocument.ElementEdit(branchElement, n3, elementArray2, elementArray);
        defaultDocumentEvent.addEdit(elementEdit2);
        ((AbstractDocument.BranchElement)elementArray[0]).replace(0, 0, (Element[])objectArray);
        branchElement.replace(n3, n6, elementArray);
    }
}

