/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.TabSet;

public class StyleConstants {
    public static final String ComponentElementName = "component";
    public static final String IconElementName = "icon";
    public static final Object NameAttribute = new StyleConstants("name");
    public static final Object ResolveAttribute = new StyleConstants("resolver");
    public static final Object ModelAttribute = new StyleConstants("model");
    public static final Object BidiLevel = new CharacterConstants("bidiLevel");
    public static final Object FontFamily;
    public static final Object Family;
    public static final Object FontSize;
    public static final Object Size;
    public static final Object Bold;
    public static final Object Italic;
    public static final Object Underline;
    public static final Object StrikeThrough;
    public static final Object Superscript;
    public static final Object Subscript;
    public static final Object Foreground;
    public static final Object Background;
    public static final Object ComponentAttribute;
    public static final Object IconAttribute;
    public static final Object ComposedTextAttribute;
    public static final Object FirstLineIndent;
    public static final Object LeftIndent;
    public static final Object RightIndent;
    public static final Object LineSpacing;
    public static final Object SpaceAbove;
    public static final Object SpaceBelow;
    public static final Object Alignment;
    public static final Object TabSet;
    public static final Object Orientation;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_JUSTIFIED = 3;
    static Object[] keys;
    private String representation;

    public String toString() {
        return this.representation;
    }

    public static int getBidiLevel(AttributeSet attributeSet) {
        Integer n = (Integer)attributeSet.getAttribute(BidiLevel);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static void setBidiLevel(MutableAttributeSet mutableAttributeSet, int n) {
        mutableAttributeSet.addAttribute(BidiLevel, new Integer(n));
    }

    public static Component getComponent(AttributeSet attributeSet) {
        return (Component)attributeSet.getAttribute(ComponentAttribute);
    }

    public static void setComponent(MutableAttributeSet mutableAttributeSet, Component component) {
        mutableAttributeSet.addAttribute("$ename", ComponentElementName);
        mutableAttributeSet.addAttribute(ComponentAttribute, component);
    }

    public static Icon getIcon(AttributeSet attributeSet) {
        return (Icon)attributeSet.getAttribute(IconAttribute);
    }

    public static void setIcon(MutableAttributeSet mutableAttributeSet, Icon icon) {
        mutableAttributeSet.addAttribute("$ename", IconElementName);
        mutableAttributeSet.addAttribute(IconAttribute, icon);
    }

    public static String getFontFamily(AttributeSet attributeSet) {
        String string = (String)attributeSet.getAttribute(FontFamily);
        if (string == null) {
            string = "Monospaced";
        }
        return string;
    }

    public static void setFontFamily(MutableAttributeSet mutableAttributeSet, String string) {
        mutableAttributeSet.addAttribute(FontFamily, string);
    }

    public static int getFontSize(AttributeSet attributeSet) {
        Integer n = (Integer)attributeSet.getAttribute(FontSize);
        if (n != null) {
            return n;
        }
        return 12;
    }

    public static void setFontSize(MutableAttributeSet mutableAttributeSet, int n) {
        mutableAttributeSet.addAttribute(FontSize, new Integer(n));
    }

    public static boolean isBold(AttributeSet attributeSet) {
        Boolean bl = (Boolean)attributeSet.getAttribute(Bold);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static void setBold(MutableAttributeSet mutableAttributeSet, boolean bl) {
        mutableAttributeSet.addAttribute(Bold, bl);
    }

    public static boolean isItalic(AttributeSet attributeSet) {
        Boolean bl = (Boolean)attributeSet.getAttribute(Italic);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static void setItalic(MutableAttributeSet mutableAttributeSet, boolean bl) {
        mutableAttributeSet.addAttribute(Italic, bl);
    }

    public static boolean isUnderline(AttributeSet attributeSet) {
        Boolean bl = (Boolean)attributeSet.getAttribute(Underline);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static boolean isStrikeThrough(AttributeSet attributeSet) {
        Boolean bl = (Boolean)attributeSet.getAttribute(StrikeThrough);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static boolean isSuperscript(AttributeSet attributeSet) {
        Boolean bl = (Boolean)attributeSet.getAttribute(Superscript);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static boolean isSubscript(AttributeSet attributeSet) {
        Boolean bl = (Boolean)attributeSet.getAttribute(Subscript);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static void setUnderline(MutableAttributeSet mutableAttributeSet, boolean bl) {
        mutableAttributeSet.addAttribute(Underline, bl);
    }

    public static void setStrikeThrough(MutableAttributeSet mutableAttributeSet, boolean bl) {
        mutableAttributeSet.addAttribute(StrikeThrough, bl);
    }

    public static void setSuperscript(MutableAttributeSet mutableAttributeSet, boolean bl) {
        mutableAttributeSet.addAttribute(Superscript, bl);
    }

    public static void setSubscript(MutableAttributeSet mutableAttributeSet, boolean bl) {
        mutableAttributeSet.addAttribute(Subscript, bl);
    }

    public static Color getForeground(AttributeSet attributeSet) {
        Color color = (Color)attributeSet.getAttribute(Foreground);
        if (color == null) {
            color = Color.black;
        }
        return color;
    }

    public static void setForeground(MutableAttributeSet mutableAttributeSet, Color color) {
        mutableAttributeSet.addAttribute(Foreground, color);
    }

    public static Color getBackground(AttributeSet attributeSet) {
        Color color = (Color)attributeSet.getAttribute(Background);
        if (color == null) {
            color = Color.black;
        }
        return color;
    }

    public static void setBackground(MutableAttributeSet mutableAttributeSet, Color color) {
        mutableAttributeSet.addAttribute(Background, color);
    }

    public static float getFirstLineIndent(AttributeSet attributeSet) {
        Float f = (Float)attributeSet.getAttribute(FirstLineIndent);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public static void setFirstLineIndent(MutableAttributeSet mutableAttributeSet, float f) {
        mutableAttributeSet.addAttribute(FirstLineIndent, new Float(f));
    }

    public static float getRightIndent(AttributeSet attributeSet) {
        Float f = (Float)attributeSet.getAttribute(RightIndent);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public static void setRightIndent(MutableAttributeSet mutableAttributeSet, float f) {
        mutableAttributeSet.addAttribute(RightIndent, new Float(f));
    }

    public static float getLeftIndent(AttributeSet attributeSet) {
        Float f = (Float)attributeSet.getAttribute(LeftIndent);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public static void setLeftIndent(MutableAttributeSet mutableAttributeSet, float f) {
        mutableAttributeSet.addAttribute(LeftIndent, new Float(f));
    }

    public static float getLineSpacing(AttributeSet attributeSet) {
        Float f = (Float)attributeSet.getAttribute(LineSpacing);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public static void setLineSpacing(MutableAttributeSet mutableAttributeSet, float f) {
        mutableAttributeSet.addAttribute(LineSpacing, new Float(f));
    }

    public static float getSpaceAbove(AttributeSet attributeSet) {
        Float f = (Float)attributeSet.getAttribute(SpaceAbove);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public static void setSpaceAbove(MutableAttributeSet mutableAttributeSet, float f) {
        mutableAttributeSet.addAttribute(SpaceAbove, new Float(f));
    }

    public static float getSpaceBelow(AttributeSet attributeSet) {
        Float f = (Float)attributeSet.getAttribute(SpaceBelow);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public static void setSpaceBelow(MutableAttributeSet mutableAttributeSet, float f) {
        mutableAttributeSet.addAttribute(SpaceBelow, new Float(f));
    }

    public static int getAlignment(AttributeSet attributeSet) {
        Integer n = (Integer)attributeSet.getAttribute(Alignment);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static void setAlignment(MutableAttributeSet mutableAttributeSet, int n) {
        mutableAttributeSet.addAttribute(Alignment, new Integer(n));
    }

    public static TabSet getTabSet(AttributeSet attributeSet) {
        TabSet tabSet = (TabSet)attributeSet.getAttribute(TabSet);
        return tabSet;
    }

    public static void setTabSet(MutableAttributeSet mutableAttributeSet, TabSet tabSet) {
        mutableAttributeSet.addAttribute(TabSet, tabSet);
    }

    StyleConstants(String string) {
        this.representation = string;
    }

    static {
        Family = FontFamily = new FontConstants("family");
        Size = FontSize = new FontConstants("size");
        Bold = new FontConstants("bold");
        Italic = new FontConstants("italic");
        Underline = new CharacterConstants("underline");
        StrikeThrough = new CharacterConstants("strikethrough");
        Superscript = new CharacterConstants("superscript");
        Subscript = new CharacterConstants("subscript");
        Foreground = new ColorConstants("foreground");
        Background = new ColorConstants("background");
        ComponentAttribute = new CharacterConstants(ComponentElementName);
        IconAttribute = new CharacterConstants(IconElementName);
        ComposedTextAttribute = new StyleConstants("composed text");
        FirstLineIndent = new ParagraphConstants("FirstLineIndent");
        LeftIndent = new ParagraphConstants("LeftIndent");
        RightIndent = new ParagraphConstants("RightIndent");
        LineSpacing = new ParagraphConstants("LineSpacing");
        SpaceAbove = new ParagraphConstants("SpaceAbove");
        SpaceBelow = new ParagraphConstants("SpaceBelow");
        Alignment = new ParagraphConstants("Alignment");
        TabSet = new ParagraphConstants("TabSet");
        Orientation = new ParagraphConstants("Orientation");
        keys = new Object[]{NameAttribute, ResolveAttribute, BidiLevel, FontFamily, FontSize, Bold, Italic, Underline, StrikeThrough, Superscript, Subscript, Foreground, Background, ComponentAttribute, IconAttribute, FirstLineIndent, LeftIndent, RightIndent, LineSpacing, SpaceAbove, SpaceBelow, Alignment, TabSet, Orientation, ModelAttribute, ComposedTextAttribute};
    }

    public static class FontConstants
    extends StyleConstants
    implements AttributeSet.FontAttribute,
    AttributeSet.CharacterAttribute {
        private FontConstants(String string) {
            super(string);
        }
    }

    public static class ColorConstants
    extends StyleConstants
    implements AttributeSet.ColorAttribute,
    AttributeSet.CharacterAttribute {
        private ColorConstants(String string) {
            super(string);
        }
    }

    public static class CharacterConstants
    extends StyleConstants
    implements AttributeSet.CharacterAttribute {
        private CharacterConstants(String string) {
            super(string);
        }
    }

    public static class ParagraphConstants
    extends StyleConstants
    implements AttributeSet.ParagraphAttribute {
        private ParagraphConstants(String string) {
            super(string);
        }
    }
}

