/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsDevice;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import sun.awt.DisplayChangedListener;
import sun.awt.FontConfiguration;
import sun.awt.SunDisplayChanger;
import sun.awt.Win32GraphicsDevice;
import sun.awt.WindowsFlags;
import sun.awt.windows.WFontConfiguration;
import sun.awt.windows.WPrinterJob;
import sun.awt.windows.WToolkit;
import sun.font.FontManager;
import sun.java2d.SunGraphicsEnvironment;

public class Win32GraphicsEnvironment
extends SunGraphicsEnvironment
implements DisplayChangedListener {
    SunDisplayChanger displayChanger = new SunDisplayChanger();
    private static boolean displayInitialized;
    static String fontsForPrinting;

    public static void init() {
    }

    private static native void initDisplay();

    public static void initDisplayWrapper() {
        if (!displayInitialized) {
            displayInitialized = true;
            Win32GraphicsEnvironment.initDisplay();
        }
    }

    protected native int getNumScreens();

    protected native int getDefaultScreen();

    public GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[this.getDefaultScreen()];
    }

    public void displayChanged() {
        WToolkit.resetGC();
        for (GraphicsDevice graphicsDevice : this.getScreenDevices()) {
            if (!(graphicsDevice instanceof DisplayChangedListener)) continue;
            ((DisplayChangedListener)((Object)graphicsDevice)).displayChanged();
        }
        this.displayChanger.notifyListeners();
    }

    public void paletteChanged() {
        this.displayChanger.notifyPaletteChanged();
    }

    public void addDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.displayChanger.add(displayChangedListener);
    }

    public void removeDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.displayChanger.remove(displayChangedListener);
    }

    private static native String getEUDCFontFile();

    protected boolean useAbsoluteFontFileNames() {
        return false;
    }

    protected void registerFontFile(String string, String[] stringArray, int n, boolean bl) {
        int n2;
        if (this.registeredFontFiles.contains(string)) {
            return;
        }
        this.registeredFontFiles.add(string);
        if (ttFilter.accept(null, string)) {
            n2 = 0;
        } else if (t1Filter.accept(null, string)) {
            n2 = 1;
        } else {
            return;
        }
        if (this.fontPath == null) {
            this.fontPath = this.getPlatformFontPath(noType1Font);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.fontPath, File.pathSeparator);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                File file = new File(string2, string);
                if (!file.canRead()) continue;
                String string3 = file.getAbsolutePath();
                if (bl) {
                    FontManager.registerDeferredFont((String)string, (String)string3, (String[])stringArray, (int)n2, (boolean)true, (int)n);
                } else {
                    FontManager.registerFontFile((String)string3, (String[])stringArray, (int)n2, (boolean)true, (int)n);
                }
                break;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println(noSuchElementException);
        }
    }

    protected void registerJREFontsWithPlatform(String string) {
        fontsForPrinting = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerJREFontsForPrinting() {
        String string = null;
        Object object = Win32GraphicsEnvironment.class;
        synchronized (Win32GraphicsEnvironment.class) {
            if (fontsForPrinting == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            string = fontsForPrinting;
            fontsForPrinting = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = new File(string);
            String[] stringArray = ((File)object).list(new SunGraphicsEnvironment.TTFilter());
            if (stringArray == null) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File((File)object, stringArray[i]);
                Win32GraphicsEnvironment.registerFontWithPlatform(file.getAbsolutePath());
            }
            return;
        }
    }

    protected static native void registerFontWithPlatform(String var0);

    protected static native void deRegisterFontWithPlatform(String var0);

    protected GraphicsDevice makeScreenDevice(int n) {
        return new Win32GraphicsDevice(n);
    }

    public PrinterJob getPrinterJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new WPrinterJob();
    }

    protected FontConfiguration createFontConfiguration() {
        return new WFontConfiguration(this);
    }

    public FontConfiguration createFontConfiguration(boolean bl, boolean bl2) {
        return new WFontConfiguration(this, bl, bl2);
    }

    static {
        WToolkit.loadLibraries();
        WindowsFlags.initFlags();
        Win32GraphicsEnvironment.initDisplayWrapper();
        eudcFontFileName = Win32GraphicsEnvironment.getEUDCFontFile();
        fontsForPrinting = null;
    }
}

