/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

public class NativeFontWrapper {
    private static boolean usePlatformFontMetrics = false;
    public static final int FONTFORMAT_NONE = -1;
    public static final int FONTFORMAT_TRUETYPE = 0;
    public static final int FONTFORMAT_TYPE1 = 1;
    public static final int FONTFORMAT_T2K = 2;
    public static final int FONTFORMAT_TTC = 3;
    public static final int FONTFORMAT_COMPOSITE = 4;
    public static final int FONTFORMAT_NATIVE = 5;
    public static final int ROTATE_UNKNOWN = -1;
    public static final int ROTATE_FALSE = 0;
    public static final int ROTATE_TRUE = 1;
    public static final int ROTATE_CHECK_STRING = 2;
    private transient long pFontManager;
    private static final short US_LCID = 1033;
    private static Map lcidMap;

    public static boolean usePlatformFontMetrics() {
        return usePlatformFontMetrics;
    }

    static native boolean getPlatformFontVar();

    public static synchronized native String getFontPath(boolean var0);

    public static synchronized native void setNativeFontPath(String var0);

    public static synchronized native void registerFonts(Vector var0, int var1, Vector var2, int var3, boolean var4);

    public static synchronized native void registerCompositeFont(String var0, String[] var1, int[] var2, int[] var3);

    public static synchronized native boolean isFontRegistered(String var0, int var1);

    public static synchronized native int getNumFonts();

    public static synchronized native String getFamilyNameByIndex(int var0, int var1);

    public static synchronized native String getFullNameByIndex(int var0);

    public static synchronized native String getFullNameByFileName(String var0);

    public static synchronized native String createFont(String var0, int var1);

    public static synchronized native boolean getType1FontVar();

    public static synchronized native void initializeFont(Font var0, String var1, int var2);

    public static synchronized native String getFamilyName(Font var0, short var1);

    public static synchronized native String getFullName(Font var0, short var1);

    public static synchronized native String getPostscriptName(Font var0);

    public static synchronized native int getNumGlyphs(Font var0);

    public static synchronized native int getMissingGlyphCode(Font var0);

    public static byte getBaselineFor(Font font, char c) {
        return 0;
    }

    public static synchronized native boolean canDisplay(Font var0, char var1);

    public static synchronized native boolean doesGlyphShaping(Font var0);

    public static synchronized native boolean isStyleSupported(Font var0, int var1);

    public static synchronized native boolean charsToGlyphs(Font var0, char[] var1, int var2, int[] var3, int var4, int var5);

    public static synchronized native boolean canDisplaySlot(Font var0, int var1, char var2);

    public static synchronized native int getGlyphCode(Font var0, int var1);

    public static synchronized native boolean isKnown(String var0);

    public static synchronized native boolean canUsePlatformFont(Font var0);

    public static synchronized native void setUsePlatformFont(boolean var0);

    public static native boolean testShapingString(String var0);

    public static native boolean testShapingChars(char[] var0, int var1, int var2);

    public static native void setSubstitutes(String[] var0);

    public static native void setSubstitutes2(String[] var0);

    public static void getBaseLineOffsetsFor(Font font, char c, double[] dArray, float[] fArray) {
        float[] fArray2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        NativeFontWrapper.getFontMetrics(font, dArray, false, false, fArray2);
        fArray[0] = 0.0f;
        fArray[1] = (fArray2[0] + fArray2[1]) / 2.0f - fArray2[0];
        fArray[2] = fArray2[1] - fArray2[0];
    }

    public static synchronized native int fontCanRotate(Font var0);

    public static synchronized native boolean fontCanRotateText(Font var0, String var1, double[] var2, boolean var3, boolean var4);

    public static synchronized native boolean fontCanRotateGlyphVector(Font var0, int[] var1, double[] var2, boolean var3, boolean var4);

    public static synchronized native void getFontMetrics(Font var0, double[] var1, boolean var2, boolean var3, float[] var4);

    public static synchronized native float getItalicAngle(Font var0, double[] var1, boolean var2, boolean var3);

    public static synchronized native void getCharMetrics(Font var0, int var1, double[] var2, double[] var3, boolean var4, boolean var5, float[] var6);

    public static synchronized native Shape getGlyphLogicalBounds(Font var0, int var1, int[] var2, float[] var3, double[] var4, int[] var5, double[] var6, boolean var7, boolean var8);

    public static synchronized native Rectangle2D getVisualBounds(Font var0, int[] var1, float[] var2, double[] var3, int[] var4, double[] var5, boolean var6, boolean var7);

    public static synchronized native Rectangle2D getGlyphVisualBounds(Font var0, int var1, int[] var2, float[] var3, double[] var4, int[] var5, double[] var6, boolean var7, boolean var8);

    public static synchronized native void getGlyphMetrics(Font var0, int var1, double[] var2, double[] var3, boolean var4, boolean var5, float[] var6);

    public static synchronized native float[] getGlyphInfo(Font var0, int[] var1, float[] var2, double[] var3, int[] var4, double[] var5, double[] var6, boolean var7, boolean var8);

    public static synchronized native Rectangle getPixelBounds(Font var0, float var1, float var2, int[] var3, float[] var4, double[] var5, int[] var6, double[] var7, double[] var8, boolean var9, boolean var10);

    public static synchronized native Rectangle getGlyphPixelBounds(Font var0, int var1, float var2, float var3, int[] var4, float[] var5, double[] var6, int[] var7, double[] var8, double[] var9, boolean var10, boolean var11);

    public static synchronized native void populateGlyphVector(Font var0, char[] var1, double[] var2, boolean var3, boolean var4, GlyphVector var5);

    public static synchronized native void populateGlyphVector(Font var0, char[] var1, int var2, int var3, double[] var4, boolean var5, boolean var6, GlyphVector var7);

    public static synchronized native void populateAndLayoutGlyphVector(Font var0, char[] var1, int var2, int var3, int var4, double[] var5, double[] var6, boolean var7, boolean var8, GlyphVector var9);

    public static synchronized native void layoutGlyphVector(Font var0, double[] var1, double[] var2, boolean var3, boolean var4, GlyphVector var5);

    public static synchronized native void shapeGlyphVector(GlyphVector var0, Font var1, double[] var2, boolean var3, boolean var4, Object var5, GlyphVector var6);

    public static synchronized native Shape getGlyphVectorOutline(GlyphVector var0, Font var1, double[] var2, double[] var3, boolean var4, boolean var5, float var6, float var7);

    public static synchronized native Shape getGlyphOutline(GlyphVector var0, int var1, Font var2, double[] var3, double[] var4, boolean var5, boolean var6, float var7, float var8);

    public static short getLCIDFromLocale(Locale locale) {
        if (locale.equals(Locale.US)) {
            return 1033;
        }
        if (lcidMap == null) {
            NativeFontWrapper.createLCIDMap();
        }
        String string = locale.toString();
        while (!"".equals(string)) {
            Short s = (Short)lcidMap.get(string);
            if (s != null) {
                return s;
            }
            int n = string.lastIndexOf(95);
            if (n < 1) {
                return 1033;
            }
            string = string.substring(0, n);
        }
        return 1033;
    }

    private static int getLCIDFromLocale() {
        return NativeFontWrapper.getLCIDFromLocale(Locale.getDefault());
    }

    private static synchronized void createLCIDMap() {
        if (lcidMap != null) {
            return;
        }
        HashMap hashMap = new HashMap(200);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ar", (short)1025);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "bg", (short)1026);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ca", (short)1027);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "zh", (short)1028);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "cs", (short)1029);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "da", (short)1030);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "de", (short)1031);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "el", (short)1032);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "es", (short)1034);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "fi", (short)1035);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "fr", (short)1036);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "iw", (short)1037);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "hu", (short)1038);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "is", (short)1039);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "it", (short)1040);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ja", (short)1041);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ko", (short)1042);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "nl", (short)1043);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "no", (short)1044);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "pl", (short)1045);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "pt", (short)1046);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "rm", (short)1047);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ro", (short)1048);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ru", (short)1049);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "hr", (short)1050);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "sk", (short)1051);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "sq", (short)1052);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "sv", (short)1053);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "th", (short)1054);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "tr", (short)1055);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ur", (short)1056);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "in", (short)1057);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "uk", (short)1058);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "be", (short)1059);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "sl", (short)1060);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "et", (short)1061);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "lv", (short)1062);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "lt", (short)1063);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "fa", (short)1065);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "vi", (short)1066);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "hy", (short)1067);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "eu", (short)1069);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "mk", (short)1071);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "tn", (short)1074);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "af", (short)1078);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ka", (short)1079);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "fo", (short)1080);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "hi", (short)1081);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "mt", (short)1082);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "gd", (short)1084);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ms", (short)1086);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "kk", (short)1087);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ky", (short)1088);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "sw", (short)1089);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "pa", (short)1094);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "gu", (short)1095);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ta", (short)1097);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "te", (short)1098);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "kn", (short)1099);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "mr", (short)1102);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "sa", (short)1103);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "mn", (short)1104);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "gl", (short)1110);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ar_IQ", (short)2049);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "zh_CN", (short)2052);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "de_CH", (short)2055);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "en_GB", (short)2057);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "es_MX", (short)2058);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "fr_BE", (short)2060);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "it_CH", (short)2064);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "nl_BE", (short)2067);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "no_NO_NY", (short)2068);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "pt_PT", (short)2070);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ro_MD", (short)2072);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ru_MD", (short)2073);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "sh_YU", (short)2074);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "sv_FI", (short)2077);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "az_AZ", (short)2092);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ga_IE", (short)2108);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ms_BN", (short)2110);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "uz_UZ", (short)2115);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ar_EG", (short)3073);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "zh_HK", (short)3076);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "de_AT", (short)3079);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "en_AU", (short)3081);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "fr_CA", (short)3084);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "sr_YU", (short)3098);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ar_LY", (short)4097);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "zh_SG", (short)4100);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "de_LU", (short)4103);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "en_CA", (short)4105);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "es_GT", (short)4106);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "fr_CH", (short)4108);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ar_DZ", (short)5121);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "zh_MO", (short)5124);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "de_LI", (short)5127);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "en_NZ", (short)5129);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "es_CR", (short)5130);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "fr_LU", (short)5132);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ar_MA", (short)6145);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "en_IE", (short)6153);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "es_PA", (short)6154);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "fr_MC", (short)6156);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ar_TN", (short)7169);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "en_ZA", (short)7177);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "es_DO", (short)7178);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ar_OM", (short)8193);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "en_JM", (short)8201);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "es_VE", (short)8202);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ar_YE", (short)9217);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "es_CO", (short)9226);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ar_SY", (short)10241);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "en_BZ", (short)10249);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "es_PE", (short)10250);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ar_JO", (short)11265);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "en_TT", (short)11273);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "es_AR", (short)11274);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ar_LB", (short)12289);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "en_ZW", (short)12297);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "es_EC", (short)12298);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ar_KW", (short)13313);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "en_PH", (short)13321);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "es_CL", (short)13322);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ar_AE", (short)14337);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "es_UY", (short)14346);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ar_BH", (short)15361);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "es_PY", (short)15370);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "ar_QA", (short)16385);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "es_BO", (short)16394);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "es_SV", (short)17418);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "es_HN", (short)18442);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "es_NI", (short)19466);
        NativeFontWrapper.addLCIDMapEntry(hashMap, "es_PR", (short)20490);
        lcidMap = hashMap;
    }

    private static void addLCIDMapEntry(Map map, String string, short s) {
        map.put(string, new Short(s));
    }

    public static native boolean fontSupportsEncoding(Font var0, String var1);

    public static synchronized native void getGlyphJustificationInfo(Font var0, int var1, GlyphJustificationInfo var2);

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        AccessController.doPrivileged(new LoadLibraryAction("fontmanager"));
        String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        String string2 = AccessController.doPrivileged(new GetPropertyAction("java2d.font.usePlatformFont"));
        if (string != null && string.startsWith("Windows") && ("true".equals(string2) || NativeFontWrapper.getPlatformFontVar())) {
            usePlatformFontMetrics = true;
            System.out.println("Enabling platform font metrics for win32. This is an unsupported option.");
            System.out.println("This yields incorrect composite font metrics as reported by 1.1.x releases.");
            System.out.println("It is appropriate only for use by applications which do not use any Java 2");
            System.out.println("functionality. This property will be removed in a later release.");
        }
    }
}

