/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceArgs;
import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.Util;
import java.io.BufferedWriter;
import java.io.IOException;

public class ServiceSection {
    private String eyecatcher_string;
    private int length;
    private int version;
    private int modification;
    private long level_offset;
    private String serviceString;
    private TraceFile traceFile;

    public ServiceSection(TraceFile traceFile, int n) throws IOException {
        byte by = 0;
        this.traceFile = traceFile;
        traceFile.seek(n);
        this.eyecatcher_string = Util.convertAndCheckEyecatcher(traceFile.readI());
        this.length = traceFile.readI();
        this.version = traceFile.readI();
        this.modification = traceFile.readI();
        this.level_offset = traceFile.getFilePointer();
        this.serviceString = "";
        traceFile.seek(this.level_offset);
        while ((by = traceFile.readByte()) != 0) {
            this.serviceString = this.serviceString + (char)by;
        }
        Util.Debug.println("ServiceSection: eyecatcher:        " + this.eyecatcher_string);
        Util.Debug.println("ServiceSection: length:            " + this.length);
        Util.Debug.println("ServiceSection: version:           " + this.version);
        Util.Debug.println("ServiceSection: modification:      " + this.modification);
        Util.Debug.println("ServiceSection: string:            " + this.serviceString);
    }

    protected void summary(BufferedWriter bufferedWriter) throws IOException {
        Util.Debug.println("ServiceSection: level_offset:        " + this.level_offset);
        bufferedWriter.write("Service Level :");
        bufferedWriter.newLine();
        bufferedWriter.write("        " + this.serviceString);
        bufferedWriter.newLine();
        bufferedWriter.newLine();
    }

    protected String formatFileName() {
        if (this.serviceString.indexOf(" IBM J9 ") != -1 || this.serviceString.indexOf("Unknown version") != -1 || TraceArgs.j9) {
            if (this.serviceString.indexOf("2.3") != -1) {
                Util.Debug.println("ServiceSection: formatFile:        J9TraceFormat23.dat");
                return "J9TraceFormat23.dat";
            }
            Util.Debug.println("ServiceSection: formatFile:        J9TraceFormat.dat");
            return "J9TraceFormat.dat";
        }
        Util.Debug.println("ServiceSection: formatFile:        TraceFormat.dat");
        return "TraceFormat.dat";
    }
}

