/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceFormat;
import com.ibm.jvm.format.Util;
import java.math.BigInteger;

public class TracePoint
implements Comparable {
    private byte[] tracePointRawData = null;
    private String componentName = null;
    private int tracepointID = -1;
    private byte[] parameterData = null;
    private long sequenceNumber = -1L;
    private String formattedParameters = null;
    private BigInteger rawTimeStamp = null;
    private String formattedTime = null;
    private long timestamp = -1L;
    private long threadID = -1L;
    private int tplen = -1;
    private String padding = null;
    private static String compNamePadding = "          ";
    private static String tpIDPadding = "    ";
    private boolean isLongTracePoint = false;
    private int longTracePointLength = 0;
    private boolean isNormalTracepoint = true;
    private boolean isInvalid = false;
    private long offsetInTraceFile = -1L;
    private String nameOfTraceFile = null;
    private boolean isNewTimerUpperWord = false;
    private long newTimerUpperWord = -1L;
    BigInteger upperWord = null;

    public String from() {
        return "from: [" + this.nameOfTraceFile + " offset " + this.offsetInTraceFile + "]";
    }

    public TracePoint() {
        this.isNormalTracepoint = false;
    }

    public TracePoint(byte[] byArray, int n, BigInteger bigInteger, long l, String string, int n2) {
        this.upperWord = bigInteger;
        this.threadID = l;
        this.nameOfTraceFile = string;
        this.offsetInTraceFile = n2;
        this.parseDataIntoTracepoint(byArray, n);
        this.padding = Integer.valueOf(Util.getProperty("POINTER_SIZE")) == 4 ? "00000000" : "0000000000000000";
    }

    private TracePoint parseDataIntoTracepoint(byte[] byArray, int n) {
        if (n == 0) {
            Util.Debug.println("TracePoint passed invalid tracepoint data - length is 0: " + this.from());
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        if (byArray == null) {
            TraceFormat.outStream.println("TracePoint passed null data array - can't extract tracepoint from it. " + this.from());
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        this.tplen = n;
        if (this.tplen == 0) {
            TraceFormat.outStream.println("Tracepoint extracted zero from first byte of trace data - returning without creating tracepoint " + this.from());
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        if (byArray.length < n) {
            Util.Debug.println("Partial buffer passed in - most likely partly overwritten during a buffer wrap");
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        this.tracepointID = Util.constructTraceID(byArray, 1);
        this.tracepointID &= 0x3FFF;
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 1 && byArray[3] == 0 && this.tplen == 8) {
            Util.Debug.println("Lost Record TracePoint detected, should have been handled by TraceRecord50 " + this.from());
            System.err.println("Lost Record TracePoint detected, should have been handled by TraceRecord50 " + this.from());
            this.isNormalTracepoint = false;
            return this;
        }
        if (this.tracepointID == 0) {
            this.isNormalTracepoint = false;
            if (this.tplen != 8) {
                Util.Debug.println("Possible inconsistency in buffer - tracePointID 0 detected but length = " + this.tplen);
                Util.Debug.println("Ignoring this tracepoint for now - inspect tracefile for further details " + this.from());
                this.isInvalid = true;
                return this;
            }
            long l = Util.constructUnsignedInt(byArray, 4);
            this.isNormalTracepoint = false;
            this.isNewTimerUpperWord = true;
            this.newTimerUpperWord = l;
            Util.Debug.println("Sequence wrap found, value = " + l + " " + this.from());
            return this;
        }
        if (this.tplen == 4) {
            if (byArray[1] == 0 && byArray[2] == 0) {
                Util.Debug.println("Long entry data");
                int n2 = Util.constructUnsignedByte(byArray, 3);
                int n3 = Util.constructUnsignedByte(byArray, 0);
                this.longTracePointLength = n3 | n2 << 8;
                Util.Debug.println(" longEntryID = " + n2 + " length = " + this.longTracePointLength + " " + this.from());
                this.isLongTracePoint = true;
                this.componentName = "longtracepoint id";
                this.isNormalTracepoint = false;
                return this;
            }
            TraceFormat.outStream.println("Found a 4 byte length tracepoint that doesn't seem to contain a long tracepoint marker" + this.from());
            Util.Debug.println("Incorrect long tracepoint found - bytes 1 and 2 aren;t zero (as they should be):");
            Util.Debug.println("    byte 1 == " + Byte.toString(byArray[1]) + " byte 2 == " + Byte.toString(byArray[2]));
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return null;
        }
        BigInteger bigInteger = Util.constructUnsignedLong(byArray, 4, 4);
        this.rawTimeStamp = this.upperWord.shiftLeft(32).or(bigInteger);
        long l = Util.constructUnsignedInt(byArray, 8);
        this.componentName = Util.constructString(byArray, 12, (int)l);
        if (this.componentName == "" || this.componentName == null) {
            Util.Debug.println("TracePoint passed an incomplete data array - can't extract tracepoint from it. " + this.from());
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        if (l == 0L) {
            TraceFormat.outStream.println("  zero component name length detected: " + this.from());
            TraceFormat.outStream.println("    - will continue processing but this tracepoint ID " + this.tracepointID + "  will be lost");
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return null;
        }
        if (!this.componentName.equals("INTERNALTRACECOMPONENT")) {
            this.tracepointID -= 257;
        } else {
            this.componentName = "dg";
        }
        Util.Debug.println("Found Tracepoint: " + this.componentName + "." + this.tracepointID);
        int n4 = 12 + (int)l;
        int n5 = this.tplen - n4;
        Util.Debug.println("Tracepoint has " + n5 + " bytes of data");
        if (n5 > 0) {
            this.parameterData = new byte[n5];
            System.arraycopy((Object)byArray, n4, (Object)this.parameterData, 0, n5);
        }
        return this;
    }

    public boolean isLongTracePoint() {
        return this.isLongTracePoint;
    }

    public int longTracePointLength() {
        if (this.isLongTracePoint) {
            return this.longTracePointLength;
        }
        Util.Debug.println("longTracePointLength called on a completed tracepoint");
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Long.toString(this.threadID, 16);
        stringBuffer.append(this.padding.substring(string.length()) + string);
        String string2 = TraceFormat.getUserVMIdentifier();
        if (string2 != null) {
            stringBuffer.append(" " + string2);
        }
        if (this.componentName.length() < compNamePadding.length()) {
            stringBuffer.append(compNamePadding.substring(this.componentName.length()));
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.componentName);
        stringBuffer.append(".");
        stringBuffer.append(this.tracepointID);
        if (Integer.toString(this.tracepointID).length() < tpIDPadding.length()) {
            stringBuffer.append(tpIDPadding.substring(Integer.toString(this.tracepointID).length()));
        }
        return stringBuffer.toString();
    }

    public String getFileName() {
        return this.nameOfTraceFile;
    }

    public long getOffsetInTraceFile() {
        return this.offsetInTraceFile;
    }

    public int getTPID() {
        return this.tracepointID;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public long getThreadID() {
        return this.threadID;
    }

    public String getParameterDataFormatted() {
        return this.formattedParameters;
    }

    public void setParameterDataFormatted(String string) {
        this.formattedParameters = string;
    }

    public byte[] getParmData() {
        return this.parameterData;
    }

    public BigInteger getRawTimeStamp() {
        return this.rawTimeStamp;
    }

    public boolean isTimerUpperWord() {
        return this.isNewTimerUpperWord;
    }

    public long getNewTimerUpperWord() {
        if (this.isNewTimerUpperWord) {
            return this.newTimerUpperWord;
        }
        TraceFormat.outStream.println("an attempt to get a new timer upper word has been made on a tracepoint that doesn't seem to be a timer wrap!");
        TraceFormat.outStream.println(" tracepoint = " + this.tracepointID + "." + this.componentName);
        return -1L;
    }

    public boolean setTracePointsUpperWord(BigInteger bigInteger) {
        BigInteger bigInteger2;
        if (bigInteger == null) {
            TraceFormat.outStream.println(" attempt made to set the upper word of tracepoint to a null - original tracepoint: " + this.from());
            return false;
        }
        if (this.rawTimeStamp == null) {
            TraceFormat.outStream.println(" attempt made to set the upper word on a tracepoint whose timestamp is null - original tracepoint: " + this.from());
            return false;
        }
        this.rawTimeStamp = bigInteger2 = bigInteger.shiftLeft(32).or(this.rawTimeStamp);
        return true;
    }

    public boolean isNormalTracepoint() {
        return this.isNormalTracepoint;
    }

    public int compareTo(Object object) {
        if (this.rawTimeStamp == null) {
            TraceFormat.outStream.println("TracePoint compareTo called on TracePoint with no rawTimeStamp");
            return 0;
        }
        if (((TracePoint)object).getRawTimeStamp() == null) {
            TraceFormat.outStream.println("TracePoint compareTo called with a TracePoint with no rawTimeStamp");
            return 0;
        }
        return this.rawTimeStamp.compareTo(((TracePoint)object).getRawTimeStamp());
    }

    public String getFormattedParameters() {
        return this.formattedParameters;
    }

    public void setFormattedParameterString(String string) {
        this.formattedParameters = string;
    }

    public String getFormattedTime() {
        return this.formattedTime;
    }

    public void setFormattedTime(String string) {
        this.formattedTime = string;
    }
}

