/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassHelper;
import com.ibm.oti.util.Util;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class SharedClassAbstractHelper
implements SharedClassHelper {
    int ROMCLASS_COOKIE_SIZE = 0;
    private Boolean verbose = null;
    private static final int URI_EXCEPTION = 1;
    private static final int FILE_EXIST = 2;
    private static final int FILE_NOT_EXIST = 3;
    private WeakReference loaderRef;
    int id;

    public ClassLoader getClassLoader() {
        return (ClassLoader)this.loaderRef.get();
    }

    public boolean isSharedClassCookie(byte[] byArray) {
        return byArray.length == this.ROMCLASS_COOKIE_SIZE;
    }

    private native int initializeShareableClassloaderImpl(ClassLoader var1);

    private native boolean getIsVerboseImpl();

    private boolean isVerbose() {
        if (this.verbose == null) {
            boolean bl = this.getIsVerboseImpl();
            this.verbose = new Boolean(bl);
            if (bl) {
                this.printVerboseInfo("Verbose output enabled for SharedClassHelper id " + this.id);
            }
        }
        return this.verbose;
    }

    void printVerboseError(String string) {
        if (this.isVerbose()) {
            System.err.println("Error for SharedClassHelper id " + this.id + ": " + string);
        }
    }

    void printVerboseInfo(String string) {
        if (this.isVerbose()) {
            System.err.println("Info for SharedClassHelper id " + this.id + ": " + string);
        }
    }

    void initializeShareableClassloader(ClassLoader classLoader) {
        this.loaderRef = new WeakReference<ClassLoader>(classLoader);
        this.ROMCLASS_COOKIE_SIZE = this.initializeShareableClassloaderImpl(classLoader);
    }

    URL convertJarURL(URL uRL) {
        if (uRL == null) {
            return null;
        }
        if (!uRL.getProtocol().equals("jar")) {
            return uRL;
        }
        String string = this.recursiveJarTrim(uRL.getPath());
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return uRL;
        }
    }

    private String recursiveJarTrim(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf("!/");
        boolean bl = string.startsWith("jar:");
        int n3 = bl ? 4 : 0;
        int n4 = n = n2 >= 0 ? n2 : string.length();
        if (!bl && n2 == -1) {
            return string;
        }
        return this.recursiveJarTrim(string.substring(n3, n));
    }

    boolean validateClassLoader(ClassLoader classLoader, Class clazz) {
        if (classLoader == null) {
            return false;
        }
        if (!classLoader.equals(clazz.getClassLoader())) {
            this.printVerboseError("ClassLoader of SharedClassHelper and ClassLoader of class " + clazz.getName() + " do not match.");
            return false;
        }
        return true;
    }

    boolean validateURL(URL uRL, boolean bl) {
        String string = uRL.getProtocol();
        if (!string.equals("file") && !string.equals("jar")) {
            this.printVerboseInfo("URL " + uRL + " does not have required file or jar protocol.");
            return false;
        }
        if (bl) {
            final URL uRL2 = uRL;
            Integer n = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    File file;
                    try {
                        file = new File(uRL2.toURI());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        try {
                            file = new File(new URI(Util.urlEncode(uRL2.toExternalForm())));
                        }
                        catch (URISyntaxException uRISyntaxException2) {
                            file = new File(uRL2.getPath());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            file = new File(uRL2.getPath());
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        file = new File(uRL2.getPath());
                    }
                    return new Integer(file.exists() ? 2 : 3);
                }
            });
            if (n == 3) {
                this.printVerboseError("URL resource " + uRL + " does not exist.");
                return false;
            }
            if (n == 1) {
                this.printVerboseError("URI could not be created from the URL " + uRL);
                return false;
            }
        }
        return true;
    }
}

