/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassPermissionCollection;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;

public class SharedClassPermission
extends BasicPermission {
    private static final long serialVersionUID = -3867544018716468265L;
    private transient boolean read;
    private transient boolean write;

    public SharedClassPermission(ClassLoader classLoader, String string) {
        this(classLoader.getClass().getName(), string);
    }

    public SharedClassPermission(String string, String string2) {
        super(string);
        this.decodeActions(string2);
    }

    private void decodeActions(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(), " \t\n\r,");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("read")) {
                this.read = true;
                continue;
            }
            if (string2.equals("write")) {
                this.write = true;
                continue;
            }
            throw new IllegalArgumentException();
        }
        if (!this.read && !this.write) {
            throw new IllegalArgumentException();
        }
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            SharedClassPermission sharedClassPermission = (SharedClassPermission)object;
            return this.read == sharedClassPermission.read && this.write == sharedClassPermission.write;
        }
        return false;
    }

    public PermissionCollection newPermissionCollection() {
        return new SharedClassPermissionCollection();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getActions() {
        return this.read ? (this.write ? "read,write" : "read") : "write";
    }

    public boolean implies(Permission permission) {
        if (super.implies(permission)) {
            SharedClassPermission sharedClassPermission = (SharedClassPermission)permission;
            boolean bl = this.read && this.write || this.write && !sharedClassPermission.read || this.read && !sharedClassPermission.write;
            return bl;
        }
        return false;
    }
}

