/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.CannotSetClasspathException;
import com.ibm.oti.shared.SharedClassAbstractHelper;
import com.ibm.oti.shared.SharedClassURLClasspathHelper;
import java.net.URL;

public class SharedClassURLClasspathHelperImpl
extends SharedClassAbstractHelper
implements SharedClassURLClasspathHelper {
    private URL[] urls;
    private URL[] origurls;
    private boolean[] validated;
    private int urlCount;
    private int confirmedCount;
    private boolean canFind;
    private boolean canStore;

    SharedClassURLClasspathHelperImpl(ClassLoader classLoader, URL[] uRLArray, int n, boolean bl, boolean bl2) {
        this.origurls = uRLArray;
        this.urls = new URL[uRLArray.length];
        this.urlCount = uRLArray.length;
        this.id = n;
        this.validated = new boolean[uRLArray.length];
        this.canFind = bl;
        this.canStore = bl2;
        this.confirmedCount = 0;
        this.initializeShareableClassloader(classLoader);
        this.initializeURLs();
        this.printVerboseInfo("Created URLClasspathHelper with id " + n + ", urlCount=" + this.urlCount);
    }

    private void initializeURLs() {
        for (int i = 0; i < this.urlCount; ++i) {
            this.urls[i] = this.convertJarURL(this.origurls[i]);
        }
    }

    private native int findSharedClassImpl(int var1, String var2, String var3, URL[] var4, int var5, int var6, byte[] var7);

    private native boolean storeSharedClassImpl(int var1, String var2, ClassLoader var3, URL[] var4, int var5, int var6, Class var7);

    private native void notifyClasspathChange(int var1);

    public byte[] findSharedClass(String string, SharedClassURLClasspathHelper.IndexHolder indexHolder) {
        return this.findSharedClass(null, string, indexHolder);
    }

    public synchronized byte[] findSharedClass(String string, String string2, SharedClassURLClasspathHelper.IndexHolder indexHolder) {
        if (!this.canFind) {
            return null;
        }
        if (string2 == null) {
            this.printVerboseError("Cannot call findSharedClass with null class name. Returning null.");
            return null;
        }
        if (this.confirmedCount == 0) {
            this.printVerboseInfo("There are no confirmed elements in the classpath. Returning null.");
            return null;
        }
        byte[] byArray = new byte[this.ROMCLASS_COOKIE_SIZE];
        int n = this.findSharedClassImpl(this.id, string, string2, this.urls, this.urlCount, this.confirmedCount, byArray);
        if (n < 0) {
            return null;
        }
        if (indexHolder != null) {
            indexHolder.setIndex(n);
        }
        return byArray;
    }

    public boolean storeSharedClass(Class clazz, int n) {
        return this.storeSharedClass(null, clazz, n);
    }

    public synchronized boolean storeSharedClass(String string, Class clazz, int n) {
        ClassLoader classLoader;
        if (!this.canStore) {
            return false;
        }
        if (clazz == null) {
            this.printVerboseError("Cannot call storeSharedClass with null Class. Returning false.");
            return false;
        }
        if (this.urlCount == 0) {
            this.printVerboseError("Classpath has zero elements. Cannot call storeSharedClass without classpath. Returning false.");
            return false;
        }
        if (n < 0) {
            this.printVerboseError("foundAtIndex cannot be <0 for storeSharedClass. Returning false.");
            return false;
        }
        if (n >= this.urlCount) {
            this.printVerboseError("foundAtIndex cannot be >= urls in classpath for storeSharedClass. Returning false.");
            return false;
        }
        if (!this.validated[n]) {
            if (!this.validateURL(this.urls[n], true)) {
                return false;
            }
            this.validated[n] = true;
        }
        if (!this.validateClassLoader(classLoader = this.getClassLoader(), clazz)) {
            return false;
        }
        if (this.confirmedCount <= n) {
            this.confirmedCount = n + 1;
            this.printVerboseInfo("Number of confirmed entries is now " + this.confirmedCount);
        }
        return this.storeSharedClassImpl(this.id, string, classLoader, this.urls, this.urlCount, n, clazz);
    }

    private synchronized void growURLs(int n) {
        this.printVerboseInfo("Growing URL array to " + n);
        int n2 = (n + 1) * 2;
        URL[] uRLArray = new URL[n2];
        URL[] uRLArray2 = new URL[n2];
        boolean[] blArray = new boolean[n2];
        System.arraycopy((Object)this.origurls, 0, (Object)uRLArray, 0, this.urlCount);
        System.arraycopy((Object)this.urls, 0, (Object)uRLArray2, 0, this.urlCount);
        System.arraycopy((Object)this.validated, 0, (Object)blArray, 0, this.urlCount);
        this.origurls = uRLArray;
        this.urls = uRLArray2;
        this.validated = blArray;
    }

    public synchronized void addClasspathEntry(URL uRL) {
        if (uRL == null) {
            this.printVerboseError("URL is null for addClasspathEntry.");
            return;
        }
        if (this.urls.length < this.urlCount + 1) {
            this.growURLs(this.urlCount + 1);
        }
        this.origurls[this.urlCount] = uRL;
        this.urls[this.urlCount] = this.convertJarURL(uRL);
        ++this.urlCount;
    }

    synchronized URL[] getClasspath() {
        URL[] uRLArray = new URL[this.urlCount];
        System.arraycopy((Object)this.origurls, 0, (Object)uRLArray, 0, this.urlCount);
        return uRLArray;
    }

    public synchronized void confirmAllEntries() {
        this.confirmedCount = this.urlCount;
    }

    public synchronized void setClasspath(URL[] uRLArray) throws CannotSetClasspathException {
        int n;
        boolean bl = false;
        if (uRLArray.length < this.confirmedCount) {
            throw new CannotSetClasspathException("New classpath cannot be shorter than confirmed elements of original");
        }
        for (n = 0; n < this.confirmedCount; ++n) {
            if (uRLArray[n].equals(this.origurls[n])) continue;
            throw new CannotSetClasspathException("Index " + n + " of newClasspath does not match confirmed original");
        }
        if (uRLArray.length > this.origurls.length) {
            this.growURLs(uRLArray.length);
        }
        for (n = this.confirmedCount; n < uRLArray.length; ++n) {
            if (uRLArray[n].equals(this.origurls[n])) continue;
            this.origurls[n] = uRLArray[n];
            this.urls[n] = this.convertJarURL(uRLArray[n]);
            bl = true;
        }
        if (this.urlCount != uRLArray.length) {
            this.urlCount = uRLArray.length;
            bl = true;
        }
        if (bl) {
            this.printVerboseInfo("setClasspath() updated classpath. Now urlCount=" + this.urlCount);
            this.notifyClasspathChange(this.id);
        }
    }
}

