/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassAbstractHelper;
import com.ibm.oti.shared.SharedClassURLHelper;
import java.net.URL;

public class SharedClassURLHelperImpl
extends SharedClassAbstractHelper
implements SharedClassURLHelper {
    private boolean canFind;
    private boolean canStore;

    SharedClassURLHelperImpl(ClassLoader classLoader, int n, boolean bl, boolean bl2) {
        this.id = n;
        this.canFind = bl;
        this.canStore = bl2;
        this.initializeShareableClassloader(classLoader);
        this.printVerboseInfo("Created URLHelper with id " + n);
    }

    private native boolean findSharedClassImpl(int var1, String var2, String var3, URL var4, byte[] var5);

    private native boolean storeSharedClassImpl(int var1, String var2, ClassLoader var3, URL var4, Class var5);

    public byte[] findSharedClass(URL uRL, String string) {
        return this.findSharedClass(null, uRL, string);
    }

    public synchronized byte[] findSharedClass(String string, URL uRL, String string2) {
        if (!this.canFind) {
            return null;
        }
        if (uRL == null) {
            this.printVerboseError("Cannot call findSharedClass with null URL. Returning null.");
            return null;
        }
        if (string2 == null) {
            this.printVerboseError("Cannot call findSharedClass with null class name. Returning null.");
            return null;
        }
        URL uRL2 = this.convertJarURL(uRL);
        if (!this.validateURL(uRL2, false)) {
            return null;
        }
        byte[] byArray = new byte[this.ROMCLASS_COOKIE_SIZE];
        boolean bl = this.findSharedClassImpl(this.id, string, string2, uRL2, byArray);
        if (!bl) {
            return null;
        }
        return byArray;
    }

    public boolean storeSharedClass(URL uRL, Class clazz) {
        return this.storeSharedClass(null, uRL, clazz);
    }

    public synchronized boolean storeSharedClass(String string, URL uRL, Class clazz) {
        if (!this.canStore) {
            return false;
        }
        if (uRL == null) {
            this.printVerboseError("Cannot call storeSharedClass with null URL. Returning false.");
            return false;
        }
        if (clazz == null) {
            this.printVerboseError("Cannot call storeSharedClass with null Class. Returning false.");
            return false;
        }
        URL uRL2 = this.convertJarURL(uRL);
        if (!this.validateURL(uRL2, false)) {
            return false;
        }
        ClassLoader classLoader = this.getClassLoader();
        if (!this.validateClassLoader(classLoader, clazz)) {
            return false;
        }
        return this.storeSharedClassImpl(this.id, string, classLoader, uRL2, clazz);
    }
}

