/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach;

import com.ibm.oti.util.Msg;
import com.ibm.tools.attach.AgentInitializationException;
import com.ibm.tools.attach.AgentLoadException;
import com.ibm.tools.attach.AttachNotSupportedException;
import com.ibm.tools.attach.AttachPermission;
import com.ibm.tools.attach.VirtualMachineDescriptor;
import com.ibm.tools.attach.spi.AttachProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VirtualMachine {
    private final AttachProvider provider;
    private static final AttachPermission attachPerm = new AttachPermission("attachVirtualMachine", null);
    private final String targetId;

    protected VirtualMachine(AttachProvider attachProvider, String string) {
        this.provider = attachProvider;
        this.targetId = string;
    }

    public static List<VirtualMachineDescriptor> list() {
        List<AttachProvider> list = AttachProvider.providers();
        ArrayList<VirtualMachineDescriptor> arrayList = new ArrayList<VirtualMachineDescriptor>();
        Iterator<AttachProvider> iterator = list.iterator();
        while (null != iterator && iterator.hasNext()) {
            AttachProvider attachProvider = iterator.next();
            List<VirtualMachineDescriptor> list2 = attachProvider.listVirtualMachines();
            if (null == list2) continue;
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public static VirtualMachine attach(String string) throws AttachNotSupportedException, IOException {
        VirtualMachine.checkSecurity();
        VirtualMachine virtualMachine = null;
        AttachNotSupportedException attachNotSupportedException = null;
        if (null == string) {
            throw new NullPointerException(Msg.getString("K03bd"));
        }
        List<AttachProvider> list = AttachProvider.providers();
        if (null == list || list.size() == 0) {
            throw new AttachNotSupportedException(Msg.getString("K0534"));
        }
        Iterator<AttachProvider> iterator = list.iterator();
        while (null == virtualMachine && iterator.hasNext()) {
            AttachProvider attachProvider = iterator.next();
            try {
                virtualMachine = attachProvider.attachVirtualMachine(string);
            }
            catch (AttachNotSupportedException attachNotSupportedException2) {
                attachNotSupportedException = attachNotSupportedException2;
            }
        }
        if (null == virtualMachine) {
            throw null == attachNotSupportedException ? new AttachNotSupportedException(Msg.getString("K0542", string)) : attachNotSupportedException;
        }
        return virtualMachine;
    }

    public static VirtualMachine attach(VirtualMachineDescriptor virtualMachineDescriptor) throws AttachNotSupportedException, IOException, SecurityException, NullPointerException {
        VirtualMachine.checkSecurity();
        if (null == virtualMachineDescriptor) {
            throw new NullPointerException(Msg.getString("K03bd"));
        }
        AttachProvider attachProvider = virtualMachineDescriptor.provider();
        VirtualMachine virtualMachine = null;
        virtualMachine = attachProvider.attachVirtualMachine(virtualMachineDescriptor);
        return virtualMachine;
    }

    public abstract void detach() throws IOException;

    public final AttachProvider provider() {
        return this.provider;
    }

    public final String id() {
        return this.targetId;
    }

    public abstract void loadAgentLibrary(String var1, String var2) throws AgentLoadException, AgentInitializationException, IOException;

    public void loadAgentLibrary(String string) throws AgentLoadException, AgentInitializationException, IOException {
        this.loadAgentLibrary(string, "");
    }

    public abstract void loadAgentPath(String var1, String var2) throws AgentLoadException, AgentInitializationException, IOException;

    public void loadAgentPath(String string) throws AgentLoadException, AgentInitializationException, IOException {
        this.loadAgentPath(string, "");
    }

    public abstract Properties getSystemProperties() throws IOException;

    public abstract Properties getAgentProperties() throws IOException;

    public boolean equals(Object object) {
        try {
            VirtualMachine virtualMachine = (VirtualMachine)object;
            return virtualMachine.id().equals(this.id());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + ";" + this.id();
    }

    public int hashCode() {
        int n = this.provider().hashCode() + this.id().hashCode();
        return n;
    }

    private static void checkSecurity() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(attachPerm);
        }
    }
}

