/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.javaSE;

import com.ibm.oti.util.Msg;
import com.ibm.tools.attach.VirtualMachineDescriptor;
import com.ibm.tools.attach.javaSE.AttachProvider;
import com.ibm.tools.attach.javaSE.Attachment;
import com.ibm.tools.attach.javaSE.BlockingFileLockManager;
import com.ibm.tools.attach.javaSE.IPC;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class AttachHandler
extends Thread {
    static final String LOGGING_ENABLE_PROPERTY = "com.ibm.tools.attach.logging";
    static final String LOG_NAME_PROPERTY = "com.ibm.tools.attach.log.name";
    private static final int MAX_ATTACHMENTS = 16;
    static final AttachHandler mainHandler = new AttachHandler();
    private final Attachment[] attachments = new Attachment[16];
    private static String myVmId = "";
    private String displayName;
    private static boolean terminated = false;
    private static boolean initialized = false;
    private static Properties agentProperties;
    private static int notificationCount;
    private static PrintStream logStream;
    static boolean threadStarted;
    private final syncObject ignoreNotification = new syncObject();
    IPC myIPC;
    String semName;
    private Exception lastException;
    public static Exception factoryException;
    private static boolean loggingEnabled;
    private static String nameProperty;
    private static String pidProperty;

    private AttachHandler() {
        this.setDaemon(true);
        this.setName("Attach handler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void teardown() {
        AttachHandler attachHandler = mainHandler;
        synchronized (attachHandler) {
            if (AttachHandler.isAttachApiInitialized()) {
                mainHandler.terminate();
            }
        }
    }

    public static void initializeAttachAPI() throws Throwable {
        boolean bl = false;
        String string = System.getProperty("com.ibm.tools.attach.enable");
        if (null != string) {
            if (string.equalsIgnoreCase("no")) {
                bl = false;
            } else if (string.equalsIgnoreCase("yes")) {
                bl = true;
            }
        }
        if (bl && !threadStarted) {
            mainHandler.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (!this.isTerminated()) {
                this.initialize();
            }
        }
        catch (IOException iOException) {
            factoryException = iOException;
        }
        AttachHandler attachHandler = this;
        synchronized (attachHandler) {
            threadStarted = true;
        }
        while (!this.isTerminated()) {
            try {
                this.waitForNotification();
            }
            catch (IOException iOException) {
                this.setlastException(iOException);
            }
            ++notificationCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attachment waitForNotification() throws IOException {
        Thread thread;
        int n;
        Object object = this.getIgnoreNotification();
        AttachHandler.logMessage("iteration " + notificationCount + " waitForNotification ignoreNotification entering");
        Object object2 = object;
        synchronized (object2) {
            AttachHandler.logMessage("iteration " + notificationCount + " waitForNotification ignoreNotification entered");
        }
        AttachHandler.logMessage("iteration " + notificationCount + " waitForNotification starting wait");
        try {
            n = this.myIPC.waitSemaphore(myVmId);
        }
        catch (IOException iOException) {
            thread = this;
            synchronized (thread) {
                n = !this.isTerminated() ? this.myIPC.reopenSemaphore() : 1;
            }
            if (0 != n) {
                return null;
            }
            n = this.myIPC.waitSemaphore(myVmId);
        }
        AttachHandler.logMessage("iteration " + notificationCount + " waitForNotification ending wait status = " + n);
        if (terminated) {
            return null;
        }
        IPC.ReplyContent replyContent = IPC.readReply(myVmId);
        thread = null;
        if (null != replyContent) {
            int n2 = replyContent.getPortNumber();
            AttachHandler.logMessage(notificationCount + " waitForNotification reply on port " + n2);
            if (n2 >= 0) {
                thread = new Attachment(this, replyContent);
                if (!this.addAttachment((Attachment)thread)) {
                    thread = null;
                } else {
                    thread.start();
                }
            }
        } else {
            AttachHandler.logMessage(notificationCount + " waitForNotification no reply file");
        }
        BlockingFileLockManager blockingFileLockManager = new BlockingFileLockManager(this.myIPC.getNotificationSyncFile());
        AttachHandler.logMessage("iteration " + notificationCount + " waitForNotification obtainLock");
        blockingFileLockManager.obtainLock();
        AttachHandler.logMessage("iteration " + notificationCount + " waitForNotification releaseLock");
        blockingFileLockManager.releaseLock();
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws IOException {
        String string = System.getProperty(LOGGING_ENABLE_PROPERTY);
        String string2 = System.getProperty(LOG_NAME_PROPERTY);
        nameProperty = System.getProperty("com.ibm.tools.attach.displayName");
        pidProperty = System.getProperty("com.ibm.tools.attach.id");
        if (null == pidProperty || 0 == pidProperty.length()) {
            int n = IPC.getProcessId();
            pidProperty = Integer.toString(n);
        }
        if (null == nameProperty) {
            nameProperty = System.getProperty("sun.java.command");
        }
        string2 = null != string2 && !string2.equals("") ? string2 + '_' : "";
        AttachHandler attachHandler = this;
        synchronized (attachHandler) {
            int n;
            FileInputStream fileInputStream;
            Properties properties;
            String string3;
            File file;
            try {
                Runtime.getRuntime().addShutdownHook(new teardownHook());
            }
            catch (IllegalStateException illegalStateException) {
                AttachHandler.logMessage("AttachHandler IllegalStateException: shutting down");
                this.terminate();
            }
            if (null == logStream && null != string && string.equalsIgnoreCase("yes")) {
                file = new File(string2 + pidProperty + ".log");
                logStream = new PrintStream(file);
                loggingEnabled = true;
                AttachHandler.logMessage("AttachHandler initialize");
            }
            this.myIPC = new IPC();
            if (!this.myIPC.prepareIPC(IPC.getCommonDir().getAbsolutePath())) {
                throw new IOException(Msg.getString("K0545"));
            }
            IPC.createCommonIPCDir();
            file = new File(IPC.getAdvertFilename());
            if (file.exists() && null != (string3 = (properties = IPC.readAdvertisementFile(fileInputStream = new FileInputStream(file))).getProperty("processId")) && !IPC.processExists(n = Integer.parseInt(string3))) {
                IPC.deleteAdvertisementDir(pidProperty);
            }
            this.createIpcDir(pidProperty, nameProperty);
            initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createIpcDir(String string, String string2) throws IOException {
        try {
            this.myIPC.obtainMasterLock();
            AttachHandler.logMessage("AttachHandler obtained master lock");
            myVmId = this.myIPC.createTargetIPCDir(string, false);
            this.setDisplayName(string2);
            this.myIPC.setVmId(myVmId);
            agentProperties = new Properties();
            this.semName = this.myIPC.openSemaphore();
            this.myIPC.obtainAttachLock();
            Properties properties = this.myIPC.createAdvertContent(myVmId, string2);
            IPC.createAdvertisementFile(myVmId, properties);
        }
        finally {
            this.myIPC.releaseAttachLock();
            this.myIPC.releaseMasterLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recreateIpcDir() throws IOException {
        AttachHandler.logMessage("recreateIpcDir");
        try {
            this.myIPC.obtainMasterLock();
            AttachHandler.logMessage("AttachHandler obtained master lock");
            this.myIPC.createTargetIPCDir(myVmId, true);
        }
        finally {
            this.myIPC.releaseMasterLock();
        }
        this.myIPC.obtainAttachLock();
        Properties properties = this.myIPC.createAdvertContent(myVmId, this.getDisplayName());
        IPC.createAdvertisementFile(myVmId, properties);
        this.myIPC.releaseAttachLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminate() {
        if (!AttachHandler.isAttachApiInitialized()) {
            return;
        }
        if (!this.isTerminated()) {
            this.setTerminated(true);
            IPC.deleteAdvertisementDir(myVmId);
            for (Attachment attachment : this.attachments) {
                if (null == attachment) continue;
                attachment.teardown();
            }
        }
        if (this.myIPC.tryObtainMasterLock()) {
            try {
                AttachHandler.logMessage("AttachHandler terminate obtained master lock");
                if (0 == IPC.CountTargetDirectories()) {
                    this.myIPC.destroySemaphore();
                    AttachHandler.logMessage("AttachHandler destroyed semaphore");
                }
                this.myIPC.closeSemaphore();
                AttachHandler.logMessage("AttachHandler closed semaphore");
            }
            finally {
                this.myIPC.releaseMasterLock();
            }
        } else {
            this.myIPC.closeSemaphore();
        }
        this.myIPC.releaseAttachLock();
        if (null != logStream) {
            logStream.close();
        }
        initialized = false;
    }

    synchronized boolean addAttachment(Attachment attachment) {
        int n;
        for (n = 0; n < this.attachments.length && null != this.attachments[n]; ++n) {
        }
        if (n < this.attachments.length) {
            this.attachments[n] = attachment;
            return true;
        }
        return false;
    }

    synchronized void removeAttachment(Attachment attachment) {
        int n;
        for (n = 0; n < this.attachments.length && attachment != this.attachments[n]; ++n) {
        }
        if (n < this.attachments.length) {
            this.attachments[n] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Exception getlastException() {
        AttachHandler attachHandler;
        AttachHandler attachHandler2 = attachHandler = AttachHandler.getMainHandler();
        synchronized (attachHandler2) {
            Exception exception = attachHandler.lastException;
            attachHandler.lastException = null;
            return exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setlastException(Exception exception) {
        AttachHandler attachHandler = this;
        synchronized (attachHandler) {
            this.lastException = exception;
        }
    }

    synchronized String getDisplayName() {
        return this.displayName;
    }

    synchronized void setDisplayName(String string) {
        this.displayName = string;
    }

    String getNotifierName() {
        return this.myIPC.getSemaphoreName();
    }

    private synchronized boolean isTerminated() {
        return terminated;
    }

    private synchronized void setTerminated(boolean bl) {
        terminated = bl;
    }

    static Properties getAgentProperties() {
        return agentProperties;
    }

    public static void setAgentProperty(String string, String string2) {
        agentProperties.setProperty(string, string2);
    }

    public static void setAgentProperties(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            agentProperties.setProperty(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAttachApiInitialized() {
        AttachHandler attachHandler = AttachHandler.getMainHandler();
        synchronized (attachHandler) {
            return initialized;
        }
    }

    static void logMessage(String string) {
        if (loggingEnabled) {
            long l = System.currentTimeMillis();
            logStream.println(l + " " + AttachHandler.getMyVmId() + ": " + string);
            logStream.flush();
        }
    }

    static AttachHandler getMainHandler() {
        return mainHandler;
    }

    public static int getProcessId() {
        return IPC.getProcessId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMyVmId() {
        AttachHandler attachHandler = AttachHandler.getMainHandler();
        synchronized (attachHandler) {
            return myVmId;
        }
    }

    Object getIgnoreNotification() {
        return this.ignoreNotification;
    }

    static int getNumberOfTargets() {
        int n = 0;
        List<com.ibm.tools.attach.spi.AttachProvider> list = com.ibm.tools.attach.spi.AttachProvider.providers();
        if (null == list || list.size() == 0) {
            return 0;
        }
        for (com.ibm.tools.attach.spi.AttachProvider attachProvider : list) {
            List<VirtualMachineDescriptor> list2;
            if (!attachProvider.getClass().equals(AttachProvider.class) || null == (list2 = attachProvider.listVirtualMachines())) continue;
            n = list2.size();
        }
        return n;
    }

    static {
        notificationCount = 0;
        threadStarted = false;
        loggingEnabled = false;
    }

    class teardownHook
    extends Thread {
        private static final int HANDLER_JOIN_TIMEOUT = 1000;

        teardownHook() {
        }

        public void run() {
            mainHandler.interrupt();
            AttachHandler.this.terminate();
            try {
                mainHandler.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                AttachHandler.logMessage("teardown join with attach handler timed out");
            }
        }
    }

    private static class syncObject {
        private syncObject() {
        }
    }
}

